/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.mirror.ColumnMirror;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public class EmbeddablePropertyMeta {
    protected final TypeMirror type;
    protected final String typeName;
    protected final String boxedTypeName;
    protected final String boxedClassName;
    protected String name;
    protected ColumnMirror columnMirror;
    protected CtType ctType;

    public EmbeddablePropertyMeta(VariableElement fieldElement, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull((Object)fieldElement, (Object)env);
        this.type = fieldElement.asType();
        this.typeName = TypeMirrorUtil.getTypeName(this.type, env);
        this.boxedTypeName = TypeMirrorUtil.getBoxedTypeName(this.type, env);
        this.boxedClassName = TypeMirrorUtil.getBoxedClassName(this.type, env);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ColumnMirror getColumnMirror() {
        return this.columnMirror;
    }

    public void setColumnMirror(ColumnMirror columnMirror) {
        this.columnMirror = columnMirror;
    }

    public String getColumnName() {
        return this.columnMirror != null ? this.columnMirror.getNameValue() : "";
    }

    public boolean isColumnInsertable() {
        return this.columnMirror != null ? this.columnMirror.getInsertableValue() : true;
    }

    public boolean isColumnUpdatable() {
        return this.columnMirror != null ? this.columnMirror.getUpdatableValue() : true;
    }

    public boolean isColumnQuoteRequired() {
        return this.columnMirror != null ? this.columnMirror.getQuoteValue() : false;
    }

    public CtType getCtType() {
        return this.ctType;
    }

    public void setCtType(CtType ctType) {
        this.ctType = ctType;
    }

    public TypeMirror getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getBoxedTypeName() {
        return this.boxedTypeName;
    }

    public String getBoxedClassName() {
        return this.boxedClassName;
    }
}

