/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.seasar.doma.Embeddable;
import org.seasar.doma.EntityField;
import org.seasar.doma.GeneratedValue;
import org.seasar.doma.Id;
import org.seasar.doma.OriginalStates;
import org.seasar.doma.ParameterName;
import org.seasar.doma.TenantId;
import org.seasar.doma.Transient;
import org.seasar.doma.Version;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.Notifier;
import org.seasar.doma.internal.apt.meta.EmbeddableConstructorMeta;
import org.seasar.doma.internal.apt.meta.EmbeddableMeta;
import org.seasar.doma.internal.apt.meta.EmbeddablePropertyMeta;
import org.seasar.doma.internal.apt.meta.EmbeddablePropertyMetaFactory;
import org.seasar.doma.internal.apt.meta.TypeElementMetaFactory;
import org.seasar.doma.internal.apt.mirror.AllArgsConstructorMirror;
import org.seasar.doma.internal.apt.mirror.EmbeddableMirror;
import org.seasar.doma.internal.apt.mirror.ValueMirror;
import org.seasar.doma.internal.apt.util.ElementUtil;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class EmbeddableMetaFactory
implements TypeElementMetaFactory<EmbeddableMeta> {
    protected final ProcessingEnvironment env;
    protected final EmbeddablePropertyMetaFactory propertyMetaFactory;

    public EmbeddableMetaFactory(ProcessingEnvironment env, EmbeddablePropertyMetaFactory propertyMetaFactory) {
        AssertionUtil.assertNotNull((Object)env, (Object)propertyMetaFactory);
        this.env = env;
        this.propertyMetaFactory = propertyMetaFactory;
    }

    @Override
    public EmbeddableMeta createTypeElementMeta(TypeElement embeddableElement) {
        EmbeddableMirror mirror = EmbeddableMirror.newInstance(embeddableElement, this.env);
        if (mirror == null) {
            throw new AptIllegalStateException("mirror must not be null");
        }
        EmbeddableMeta embeddableMeta = new EmbeddableMeta(mirror, embeddableElement);
        Strategy strategy = this.createStrategy(embeddableElement, embeddableMeta);
        strategy.validateClass(embeddableElement, embeddableMeta);
        strategy.doFieldElements(embeddableElement, embeddableMeta);
        strategy.doConstructor(embeddableElement, embeddableMeta);
        return embeddableMeta;
    }

    protected Strategy createStrategy(TypeElement embeddableElement, EmbeddableMeta embeddableMeta) {
        ValueMirror valueMirror = ValueMirror.newInstance(embeddableElement, this.env);
        if (valueMirror != null) {
            return new ValueStrategy(this.env, this.propertyMetaFactory, valueMirror);
        }
        AllArgsConstructorMirror allArgsConstructorMirror = AllArgsConstructorMirror.newInstance(embeddableElement, this.env);
        if (allArgsConstructorMirror != null) {
            return new AllArgsConstructorStrategy(this.env, this.propertyMetaFactory, allArgsConstructorMirror);
        }
        return new DefaultStrategy(this.env, this.propertyMetaFactory);
    }

    protected static class ValueStrategy
    extends DefaultStrategy {
        protected final ValueMirror valueMirror;

        public ValueStrategy(ProcessingEnvironment env, EmbeddablePropertyMetaFactory propertyMetaFactory, ValueMirror valueMirror) {
            super(env, propertyMetaFactory);
            AssertionUtil.assertNotNull(valueMirror);
            this.valueMirror = valueMirror;
        }

        @Override
        public void doConstructor(TypeElement embeddableElement, EmbeddableMeta embeddableMeta) {
            if (!this.valueMirror.getStaticConstructorValue().isEmpty()) {
                throw new AptException((MessageResource)Message.DOMA4423, this.env, embeddableElement, this.valueMirror.getAnnotationMirror(), this.valueMirror.getStaticConstructor(), new Object[]{embeddableElement.getQualifiedName()});
            }
        }
    }

    protected static class AllArgsConstructorStrategy
    extends DefaultStrategy {
        protected final AllArgsConstructorMirror allArgsConstructorMirror;

        public AllArgsConstructorStrategy(ProcessingEnvironment env, EmbeddablePropertyMetaFactory propertyMetaFactory, AllArgsConstructorMirror allArgsConstructorMirror) {
            super(env, propertyMetaFactory);
            AssertionUtil.assertNotNull(allArgsConstructorMirror);
            this.allArgsConstructorMirror = allArgsConstructorMirror;
        }

        @Override
        public void doConstructor(TypeElement embeddableElement, EmbeddableMeta embeddableMeta) {
            if (!this.allArgsConstructorMirror.getStaticNameValue().isEmpty()) {
                throw new AptException((MessageResource)Message.DOMA4424, this.env, embeddableElement, this.allArgsConstructorMirror.getAnnotationMirror(), this.allArgsConstructorMirror.getStaticName(), new Object[]{embeddableElement.getQualifiedName()});
            }
            if (this.allArgsConstructorMirror.isAccessPrivate()) {
                throw new AptException((MessageResource)Message.DOMA4425, this.env, embeddableElement, this.allArgsConstructorMirror.getAnnotationMirror(), this.allArgsConstructorMirror.getAccess(), new Object[]{embeddableElement.getQualifiedName()});
            }
            if (this.allArgsConstructorMirror.isAccessNone()) {
                throw new AptException((MessageResource)Message.DOMA4427, this.env, embeddableElement, this.allArgsConstructorMirror.getAnnotationMirror(), this.allArgsConstructorMirror.getAccess(), new Object[]{embeddableElement.getQualifiedName()});
            }
        }
    }

    protected static class DefaultStrategy
    implements Strategy {
        protected final ProcessingEnvironment env;
        protected final EmbeddablePropertyMetaFactory propertyMetaFactory;

        public DefaultStrategy(ProcessingEnvironment env, EmbeddablePropertyMetaFactory propertyMetaFactory) {
            AssertionUtil.assertNotNull((Object)env, (Object)propertyMetaFactory);
            this.env = env;
            this.propertyMetaFactory = propertyMetaFactory;
        }

        @Override
        public void validateClass(TypeElement embeddableElement, EmbeddableMeta embeddableMeta) {
            if (embeddableElement.getKind() != ElementKind.CLASS) {
                EmbeddableMirror embeddableMirror = embeddableMeta.getEmbeddableMirror();
                throw new AptException((MessageResource)Message.DOMA4283, this.env, (Element)embeddableElement, embeddableMirror.getAnnotationMirror(), new Object[]{embeddableElement.getQualifiedName()});
            }
            if (!embeddableElement.getTypeParameters().isEmpty()) {
                throw new AptException((MessageResource)Message.DOMA4285, this.env, embeddableElement, new Object[]{embeddableElement.getQualifiedName()});
            }
            this.validateEnclosingElement(embeddableElement);
        }

        protected void validateEnclosingElement(Element element) {
            TypeElement typeElement = ElementUtil.toTypeElement(element, this.env);
            if (typeElement == null) {
                return;
            }
            String simpleName = typeElement.getSimpleName().toString();
            if (simpleName.contains("$") || simpleName.contains("__")) {
                throw new AptException((MessageResource)Message.DOMA4417, this.env, typeElement, new Object[]{typeElement.getQualifiedName()});
            }
            NestingKind nestingKind = typeElement.getNestingKind();
            if (nestingKind == NestingKind.TOP_LEVEL) {
                return;
            }
            if (nestingKind == NestingKind.MEMBER) {
                Set<Modifier> modifiers = typeElement.getModifiers();
                if (!modifiers.containsAll(Arrays.asList(Modifier.STATIC, Modifier.PUBLIC))) {
                    throw new AptException((MessageResource)Message.DOMA4415, this.env, typeElement, new Object[]{typeElement.getQualifiedName()});
                }
            } else {
                throw new AptException((MessageResource)Message.DOMA4416, this.env, typeElement, new Object[]{typeElement.getQualifiedName()});
            }
            this.validateEnclosingElement(typeElement.getEnclosingElement());
        }

        @Override
        public void doFieldElements(TypeElement embeddableElement, EmbeddableMeta embeddableMeta) {
            for (VariableElement fieldElement : this.getFieldElements(embeddableElement)) {
                try {
                    if (fieldElement.getAnnotation(Transient.class) != null || fieldElement.getModifiers().contains((Object)Modifier.STATIC)) continue;
                    if (fieldElement.getAnnotation(OriginalStates.class) != null) {
                        throw new AptException((MessageResource)Message.DOMA4286, this.env, fieldElement, new Object[]{embeddableElement.getQualifiedName(), fieldElement.getSimpleName()});
                    }
                    if (fieldElement.getAnnotation(Id.class) != null) {
                        throw new AptException((MessageResource)Message.DOMA4289, this.env, fieldElement, new Object[]{embeddableElement.getQualifiedName(), fieldElement.getSimpleName()});
                    }
                    if (fieldElement.getAnnotation(Version.class) != null) {
                        throw new AptException((MessageResource)Message.DOMA4290, this.env, fieldElement, new Object[]{embeddableElement.getQualifiedName(), fieldElement.getSimpleName()});
                    }
                    if (fieldElement.getAnnotation(TenantId.class) != null) {
                        throw new AptException((MessageResource)Message.DOMA4443, this.env, fieldElement, new Object[]{embeddableElement.getQualifiedName(), fieldElement.getSimpleName()});
                    }
                    if (fieldElement.getAnnotation(GeneratedValue.class) != null) {
                        throw new AptException((MessageResource)Message.DOMA4291, this.env, fieldElement, new Object[]{embeddableElement.getQualifiedName(), fieldElement.getSimpleName()});
                    }
                    this.doEmbeddablePropertyMeta(fieldElement, embeddableMeta);
                }
                catch (AptException e) {
                    Notifier.notify(this.env, e);
                    embeddableMeta.setError(true);
                }
            }
        }

        protected void doEmbeddablePropertyMeta(VariableElement fieldElement, EmbeddableMeta embeddableMeta) {
            this.validateFieldAnnotation(fieldElement, embeddableMeta);
            EmbeddablePropertyMeta propertyMeta = this.propertyMetaFactory.createEmbeddablePropertyMeta(fieldElement, embeddableMeta);
            embeddableMeta.addEmbeddablePropertyMeta(propertyMeta);
        }

        protected List<VariableElement> getFieldElements(TypeElement embeddableElement) {
            LinkedList<VariableElement> results = new LinkedList<VariableElement>();
            TypeElement t = embeddableElement;
            while (t != null && t.asType().getKind() != TypeKind.NONE) {
                if (t.getAnnotation(Embeddable.class) != null) {
                    LinkedList<VariableElement> fields = new LinkedList<VariableElement>();
                    for (VariableElement field : ElementFilter.fieldsIn(t.getEnclosedElements())) {
                        fields.add(field);
                    }
                    Collections.reverse(fields);
                    results.addAll(fields);
                }
                t = TypeMirrorUtil.toTypeElement(t.getSuperclass(), this.env);
            }
            Collections.reverse(results);
            LinkedList hiderFields = new LinkedList(results);
            Iterator it = results.iterator();
            while (it.hasNext()) {
                VariableElement hidden = (VariableElement)it.next();
                for (VariableElement hider : hiderFields) {
                    if (!this.env.getElementUtils().hides(hider, hidden)) continue;
                    it.remove();
                }
            }
            return results;
        }

        protected void validateFieldAnnotation(VariableElement fieldElement, EmbeddableMeta embeddableMeta) {
            TypeElement foundAnnotationTypeElement = null;
            for (AnnotationMirror annotationMirror : fieldElement.getAnnotationMirrors()) {
                DeclaredType declaredType = annotationMirror.getAnnotationType();
                TypeElement typeElement = TypeMirrorUtil.toTypeElement(declaredType, this.env);
                if (typeElement.getAnnotation(EntityField.class) == null) continue;
                if (foundAnnotationTypeElement != null) {
                    throw new AptException((MessageResource)Message.DOMA4288, this.env, fieldElement, new Object[]{foundAnnotationTypeElement.getQualifiedName(), typeElement.getQualifiedName(), embeddableMeta.getEmbeddableElement().getQualifiedName(), fieldElement.getSimpleName()});
                }
                foundAnnotationTypeElement = typeElement;
            }
        }

        @Override
        public void doConstructor(TypeElement embeddableElement, EmbeddableMeta embeddableMeta) {
            if (embeddableMeta.isAbstract()) {
                return;
            }
            EmbeddableConstructorMeta constructorMeta = this.getConstructorMeta(embeddableElement, embeddableMeta);
            if (constructorMeta == null) {
                throw new AptException((MessageResource)Message.DOMA4293, this.env, embeddableElement, new Object[]{embeddableElement.getQualifiedName()});
            }
            if (constructorMeta.getConstructorElement().getModifiers().contains((Object)Modifier.PRIVATE)) {
                throw new AptException((MessageResource)Message.DOMA4294, this.env, embeddableElement, new Object[]{embeddableElement.getQualifiedName()});
            }
            embeddableMeta.setConstructorMeta(constructorMeta);
        }

        protected EmbeddableConstructorMeta getConstructorMeta(TypeElement embeddapleElement, EmbeddableMeta embeddableMeta) {
            HashMap<String, EmbeddablePropertyMeta> propertyMetaMap = new HashMap<String, EmbeddablePropertyMeta>();
            for (EmbeddablePropertyMeta propertyMeta : embeddableMeta.getEmbeddablePropertyMetas()) {
                propertyMetaMap.put(propertyMeta.getName(), propertyMeta);
            }
            block1: for (ExecutableElement constructor : ElementFilter.constructorsIn(embeddapleElement.getEnclosedElements())) {
                ArrayList<EmbeddablePropertyMeta> propertyMetaList = new ArrayList<EmbeddablePropertyMeta>();
                for (VariableElement variableElement : constructor.getParameters()) {
                    TypeMirror propertyType;
                    String name = variableElement.getSimpleName().toString();
                    ParameterName parameterName = variableElement.getAnnotation(ParameterName.class);
                    if (parameterName != null) {
                        name = parameterName.value();
                    }
                    TypeMirror paramType = variableElement.asType();
                    EmbeddablePropertyMeta propertyMeta = (EmbeddablePropertyMeta)propertyMetaMap.get(name);
                    if (propertyMeta == null || !TypeMirrorUtil.isSameType(paramType, propertyType = propertyMeta.getType(), this.env)) continue block1;
                    propertyMetaList.add(propertyMeta);
                }
                if (propertyMetaMap.size() != propertyMetaList.size()) continue;
                return new EmbeddableConstructorMeta(constructor, propertyMetaList);
            }
            return null;
        }
    }

    protected static interface Strategy {
        public void validateClass(TypeElement var1, EmbeddableMeta var2);

        public void doFieldElements(TypeElement var1, EmbeddableMeta var2);

        public void doConstructor(TypeElement var1, EmbeddableMeta var2);
    }
}

