/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.ElementFilter;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.cttype.BasicCtType;
import org.seasar.doma.internal.apt.meta.DomainMeta;
import org.seasar.doma.internal.apt.meta.TypeElementMetaFactory;
import org.seasar.doma.internal.apt.mirror.DomainMirror;
import org.seasar.doma.internal.apt.mirror.ValueMirror;
import org.seasar.doma.internal.apt.util.ElementUtil;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.internal.util.StringUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class DomainMetaFactory
implements TypeElementMetaFactory<DomainMeta> {
    private final ProcessingEnvironment env;

    public DomainMetaFactory(ProcessingEnvironment env) {
        AssertionUtil.assertNotNull(env);
        this.env = env;
    }

    @Override
    public DomainMeta createTypeElementMeta(TypeElement classElement) {
        AssertionUtil.assertNotNull(classElement);
        DomainMirror domainMirror = DomainMirror.newInstance(classElement, this.env);
        if (domainMirror == null) {
            throw new AptIllegalStateException("domainMirror");
        }
        DomainMeta domainMeta = new DomainMeta(classElement, classElement.asType());
        domainMeta.setDomainMirror(domainMirror);
        Strategy strategy = this.createStrategy(classElement, domainMeta);
        strategy.doWrapperCtType(classElement, domainMeta);
        strategy.validateAcceptNull(classElement, domainMeta);
        strategy.validateClass(classElement, domainMeta);
        strategy.validateInitializer(classElement, domainMeta);
        strategy.validateAccessorMethod(classElement, domainMeta);
        return domainMeta;
    }

    protected Strategy createStrategy(TypeElement classElement, DomainMeta domainMeta) {
        ValueMirror valueMirror = ValueMirror.newInstance(classElement, this.env);
        if (valueMirror != null) {
            return new ValueStragety(this.env, valueMirror);
        }
        return new DefaultStrategy(this.env);
    }

    protected static class ValueStragety
    extends DefaultStrategy {
        protected final ValueMirror valueMirror;

        public ValueStragety(ProcessingEnvironment env, ValueMirror valueMirror) {
            super(env);
            AssertionUtil.assertNotNull(valueMirror);
            this.valueMirror = valueMirror;
        }

        @Override
        public void validateInitializer(TypeElement classElement, DomainMeta domainMeta) {
            if (!this.valueMirror.getStaticConstructorValue().isEmpty()) {
                throw new AptException((MessageResource)Message.DOMA4428, this.env, classElement, this.valueMirror.getAnnotationMirror(), this.valueMirror.getStaticConstructor(), new Object[]{classElement.getQualifiedName()});
            }
        }

        @Override
        public void validateAccessorMethod(TypeElement classElement, DomainMeta domainMeta) {
            VariableElement field = this.findSingleField(classElement, domainMeta);
            String accessorMethod = this.inferAccessorMethod(field);
            if (!accessorMethod.equals(domainMeta.getAccessorMethod())) {
                DomainMirror domainMirror = domainMeta.getDomainMirror();
                throw new AptException((MessageResource)Message.DOMA4429, this.env, classElement, domainMirror.getAnnotationMirror(), domainMirror.getAccessorMethod(), new Object[]{accessorMethod, domainMeta.getAccessorMethod(), classElement.getQualifiedName()});
            }
        }

        protected String inferAccessorMethod(VariableElement field) {
            String name = field.getSimpleName().toString();
            String capitalizedName = StringUtil.capitalize(name);
            if (field.asType().getKind() == TypeKind.BOOLEAN) {
                if (name.startsWith("is") && name.length() > 2 && Character.isUpperCase(name.charAt(2))) {
                    return name;
                }
                return "is" + capitalizedName;
            }
            return "get" + capitalizedName;
        }

        protected VariableElement findSingleField(TypeElement classElement, DomainMeta domainMeta) {
            List fields = ElementFilter.fieldsIn(classElement.getEnclosedElements()).stream().filter(field -> !field.getModifiers().contains((Object)Modifier.STATIC)).collect(Collectors.toList());
            if (fields.size() == 0) {
                throw new AptException((MessageResource)Message.DOMA4430, this.env, classElement, new Object[]{classElement.getQualifiedName()});
            }
            if (fields.size() > 1) {
                throw new AptException((MessageResource)Message.DOMA4431, this.env, classElement, new Object[]{classElement.getQualifiedName()});
            }
            VariableElement field2 = (VariableElement)fields.get(0);
            if (!TypeMirrorUtil.isAssignable(field2.asType(), domainMeta.getValueType(), this.env)) {
                throw new AptException((MessageResource)Message.DOMA4432, this.env, field2, new Object[]{field2.asType(), domainMeta.getValueType(), classElement.getQualifiedName(), field2.getSimpleName()});
            }
            return field2;
        }
    }

    protected static class DefaultStrategy
    implements Strategy {
        protected final ProcessingEnvironment env;

        public DefaultStrategy(ProcessingEnvironment env) {
            AssertionUtil.assertNotNull(env);
            this.env = env;
        }

        @Override
        public void doWrapperCtType(TypeElement classElement, DomainMeta domainMeta) {
            BasicCtType basicCtType = BasicCtType.newInstance(domainMeta.getValueType(), this.env);
            if (basicCtType == null) {
                DomainMirror domainMirror = domainMeta.getDomainMirror();
                throw new AptException((MessageResource)Message.DOMA4102, this.env, classElement, domainMirror.getAnnotationMirror(), domainMirror.getValueType(), new Object[]{domainMirror.getValueTypeValue(), classElement.getQualifiedName()});
            }
            domainMeta.setBasicCtType(basicCtType);
            domainMeta.setWrapperCtType(basicCtType.getWrapperCtType());
        }

        @Override
        public void validateAcceptNull(TypeElement classElement, DomainMeta domainMeta) {
            if (domainMeta.getBasicCtType().isPrimitive() && domainMeta.getAcceptNull()) {
                DomainMirror domainMirror = domainMeta.getDomainMirror();
                throw new AptException((MessageResource)Message.DOMA4251, this.env, classElement, domainMirror.getAnnotationMirror(), domainMirror.getAcceptNull(), new Object[]{classElement.getQualifiedName()});
            }
        }

        @Override
        public void validateClass(TypeElement classElement, DomainMeta domainMeta) {
            if (classElement.getKind() == ElementKind.CLASS) {
                if (domainMeta.providesConstructor() && classElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                    throw new AptException((MessageResource)Message.DOMA4132, this.env, classElement, new Object[]{classElement.getQualifiedName()});
                }
                if (classElement.getNestingKind().isNested()) {
                    this.validateEnclosingElement(classElement);
                }
            } else if (classElement.getKind() == ElementKind.ENUM) {
                if (domainMeta.providesConstructor()) {
                    DomainMirror domainMirror = domainMeta.getDomainMirror();
                    throw new AptException((MessageResource)Message.DOMA4184, this.env, classElement, domainMirror.getAnnotationMirror(), domainMirror.getFactoryMethod(), new Object[]{classElement.getQualifiedName()});
                }
                if (classElement.getNestingKind().isNested()) {
                    this.validateEnclosingElement(classElement);
                }
            } else if (classElement.getKind() == ElementKind.INTERFACE) {
                if (domainMeta.providesConstructor()) {
                    throw new AptException((MessageResource)Message.DOMA4268, this.env, classElement, new Object[]{classElement.getQualifiedName()});
                }
                if (classElement.getNestingKind().isNested()) {
                    this.validateEnclosingElement(classElement);
                }
            } else {
                DomainMirror domainMirror = domainMeta.getDomainMirror();
                throw new AptException((MessageResource)Message.DOMA4105, this.env, (Element)classElement, domainMirror.getAnnotationMirror(), new Object[]{classElement.getQualifiedName()});
            }
        }

        protected void validateEnclosingElement(Element element) {
            TypeElement typeElement = ElementUtil.toTypeElement(element, this.env);
            if (typeElement == null) {
                return;
            }
            String simpleName = typeElement.getSimpleName().toString();
            if (simpleName.contains("$") || simpleName.contains("__")) {
                throw new AptException((MessageResource)Message.DOMA4277, this.env, typeElement, new Object[]{typeElement.getQualifiedName()});
            }
            NestingKind nestingKind = typeElement.getNestingKind();
            if (nestingKind == NestingKind.TOP_LEVEL) {
                return;
            }
            if (nestingKind == NestingKind.MEMBER) {
                Set<Modifier> modifiers = typeElement.getModifiers();
                if (!modifiers.containsAll(Arrays.asList(Modifier.STATIC, Modifier.PUBLIC))) {
                    throw new AptException((MessageResource)Message.DOMA4275, this.env, typeElement, new Object[]{typeElement.getQualifiedName()});
                }
            } else {
                throw new AptException((MessageResource)Message.DOMA4276, this.env, typeElement, new Object[]{typeElement.getQualifiedName()});
            }
            this.validateEnclosingElement(typeElement.getEnclosingElement());
        }

        @Override
        public void validateInitializer(TypeElement classElement, DomainMeta domainMeta) {
            if (domainMeta.providesConstructor()) {
                this.validateConstructor(classElement, domainMeta);
            } else {
                this.validateFactoryMethod(classElement, domainMeta);
            }
        }

        protected void validateConstructor(TypeElement classElement, DomainMeta domainMeta) {
            for (ExecutableElement constructor : ElementFilter.constructorsIn(classElement.getEnclosedElements())) {
                List<? extends VariableElement> parameters;
                if (constructor.getModifiers().contains((Object)Modifier.PRIVATE) || (parameters = constructor.getParameters()).size() != 1) continue;
                TypeMirror parameterType = this.env.getTypeUtils().erasure(parameters.get(0).asType());
                if (!this.env.getTypeUtils().isSameType(parameterType, domainMeta.getValueType())) continue;
                return;
            }
            throw new AptException((MessageResource)Message.DOMA4103, this.env, classElement, new Object[]{domainMeta.getValueType(), classElement.getQualifiedName()});
        }

        protected void validateFactoryMethod(TypeElement classElement, DomainMeta domainMeta) {
            block0: for (ExecutableElement method : ElementFilter.methodsIn(classElement.getEnclosedElements())) {
                if (!method.getSimpleName().contentEquals(domainMeta.getFactoryMethod()) || method.getModifiers().contains((Object)Modifier.PRIVATE) || !method.getModifiers().contains((Object)Modifier.STATIC) || method.getParameters().size() != 1) continue;
                TypeMirror parameterType = method.getParameters().get(0).asType();
                if (!this.env.getTypeUtils().isAssignable(domainMeta.getValueType(), parameterType)) continue;
                TypeMirror returnType = this.env.getTypeUtils().erasure(method.getReturnType());
                if (!this.env.getTypeUtils().isAssignable(returnType, domainMeta.getType())) continue;
                List<? extends TypeParameterElement> classTypeParams = classElement.getTypeParameters();
                List<? extends TypeParameterElement> methodTypeParams = method.getTypeParameters();
                if (classTypeParams.size() != methodTypeParams.size()) continue;
                Iterator<? extends TypeParameterElement> cit = classTypeParams.iterator();
                Iterator<? extends TypeParameterElement> mit = methodTypeParams.iterator();
                while (cit.hasNext() && mit.hasNext()) {
                    TypeParameterElement classTypeParam = cit.next();
                    TypeParameterElement methodTypeParam = mit.next();
                    if (TypeMirrorUtil.isSameType(classTypeParam.asType(), methodTypeParam.asType(), this.env)) continue;
                    continue block0;
                }
                return;
            }
            throw new AptException((MessageResource)Message.DOMA4106, this.env, classElement, new Object[]{domainMeta.getFactoryMethod(), classElement.asType(), domainMeta.getValueType(), domainMeta.getFactoryMethod(), classElement.getQualifiedName()});
        }

        @Override
        public void validateAccessorMethod(TypeElement classElement, DomainMeta domainMeta) {
            TypeElement typeElement = classElement;
            TypeMirror typeMirror = classElement.asType();
            while (typeElement != null && typeMirror.getKind() != TypeKind.NONE) {
                for (ExecutableElement method : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                    TypeMirror inferredReturnType;
                    if (!method.getSimpleName().contentEquals(domainMeta.getAccessorMethod()) || method.getModifiers().contains((Object)Modifier.PRIVATE) || !method.getParameters().isEmpty()) continue;
                    TypeMirror returnType = method.getReturnType();
                    if (this.env.getTypeUtils().isAssignable(this.env.getTypeUtils().erasure(returnType), domainMeta.getValueType())) {
                        return;
                    }
                    TypeVariable typeVariable = TypeMirrorUtil.toTypeVariable(returnType, this.env);
                    if (typeVariable == null || (inferredReturnType = this.inferType(typeVariable, typeElement, typeMirror)) == null || !this.env.getTypeUtils().isAssignable(inferredReturnType, domainMeta.getValueType())) continue;
                    return;
                }
                typeMirror = typeElement.getSuperclass();
                typeElement = TypeMirrorUtil.toTypeElement(typeMirror, this.env);
            }
            throw new AptException((MessageResource)Message.DOMA4104, this.env, classElement, new Object[]{domainMeta.getAccessorMethod(), domainMeta.getValueType(), classElement.getQualifiedName()});
        }

        protected TypeMirror inferType(TypeVariable typeVariable, TypeElement classElement, TypeMirror classMirror) {
            DeclaredType declaredType = TypeMirrorUtil.toDeclaredType(classMirror, this.env);
            if (declaredType == null) {
                return null;
            }
            List<? extends TypeMirror> args = declaredType.getTypeArguments();
            if (args.isEmpty()) {
                return null;
            }
            int argsSize = args.size();
            int index = 0;
            for (TypeParameterElement typeParameterElement : classElement.getTypeParameters()) {
                if (index >= argsSize) break;
                if (TypeMirrorUtil.isSameType((TypeMirror)typeVariable, typeParameterElement.asType(), this.env)) {
                    return args.get(index);
                }
                ++index;
            }
            return null;
        }
    }

    protected static interface Strategy {
        public void doWrapperCtType(TypeElement var1, DomainMeta var2);

        public void validateAcceptNull(TypeElement var1, DomainMeta var2);

        public void validateClass(TypeElement var1, DomainMeta var2);

        public void validateInitializer(TypeElement var1, DomainMeta var2);

        public void validateAccessorMethod(TypeElement var1, DomainMeta var2);
    }
}

