/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.seasar.doma.internal.apt.meta.AbstractQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.DaoMeta;
import org.seasar.doma.internal.apt.meta.DefaultQueryMeta;
import org.seasar.doma.internal.apt.meta.QueryKind;
import org.seasar.doma.internal.apt.meta.QueryMeta;
import org.seasar.doma.internal.apt.meta.QueryParameterMeta;
import org.seasar.doma.internal.apt.meta.QueryReturnMeta;
import org.seasar.doma.internal.util.AssertionUtil;

public class DefaultQueryMetaFactory
extends AbstractQueryMetaFactory<DefaultQueryMeta> {
    public DefaultQueryMetaFactory(ProcessingEnvironment env) {
        super(env);
    }

    @Override
    public QueryMeta createQueryMeta(ExecutableElement method, DaoMeta daoMeta) {
        AssertionUtil.assertNotNull((Object)method, (Object)daoMeta);
        if (!method.isDefault()) {
            return null;
        }
        DefaultQueryMeta queryMeta = new DefaultQueryMeta(method, daoMeta.getDaoElement());
        queryMeta.setQueryKind(QueryKind.DEFAULT);
        this.doTypeParameters(queryMeta, method, daoMeta);
        this.doParameters(queryMeta, method, daoMeta);
        this.doReturnType(queryMeta, method, daoMeta);
        this.doThrowTypes(queryMeta, method, daoMeta);
        return queryMeta;
    }

    @Override
    protected void doParameters(DefaultQueryMeta queryMeta, ExecutableElement method, DaoMeta daoMeta) {
        for (VariableElement variableElement : method.getParameters()) {
            QueryParameterMeta parameterMeta = this.createParameterMeta(variableElement, queryMeta);
            queryMeta.addParameterMeta(parameterMeta);
            if (!parameterMeta.isBindable()) continue;
            queryMeta.addBindableParameterCtType(parameterMeta.getName(), parameterMeta.getCtType());
        }
    }

    @Override
    protected void doReturnType(DefaultQueryMeta queryMeta, ExecutableElement method, DaoMeta daoMeta) {
        QueryReturnMeta resultMeta = this.createReturnMeta(queryMeta);
        queryMeta.setReturnMeta(resultMeta);
    }
}

