/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import org.seasar.doma.DaoMethod;
import org.seasar.doma.SingletonConfig;
import org.seasar.doma.Suppress;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.Notifier;
import org.seasar.doma.internal.apt.Options;
import org.seasar.doma.internal.apt.meta.DaoMeta;
import org.seasar.doma.internal.apt.meta.ParentDaoMeta;
import org.seasar.doma.internal.apt.meta.QueryMeta;
import org.seasar.doma.internal.apt.meta.QueryMetaFactory;
import org.seasar.doma.internal.apt.meta.TypeElementMetaFactory;
import org.seasar.doma.internal.apt.mirror.AnnotateWithMirror;
import org.seasar.doma.internal.apt.mirror.DaoMirror;
import org.seasar.doma.internal.apt.util.ElementUtil;
import org.seasar.doma.internal.apt.util.ResourceUtil;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.jdbc.util.SqlFileUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class DaoMetaFactory
implements TypeElementMetaFactory<DaoMeta> {
    protected static final String SINGLETON_CONFIG_FIELD_NAME = "INSTANCE";
    protected final ProcessingEnvironment env;
    protected final List<QueryMetaFactory> queryMetaFactories = new ArrayList<QueryMetaFactory>();

    public DaoMetaFactory(ProcessingEnvironment env, List<QueryMetaFactory> commandMetaFactories) {
        AssertionUtil.assertNotNull((Object)env, commandMetaFactories);
        this.env = env;
        this.queryMetaFactories.addAll(commandMetaFactories);
    }

    @Override
    public DaoMeta createTypeElementMeta(TypeElement interfaceElement) {
        AssertionUtil.assertNotNull(interfaceElement);
        DaoMirror daoMirror = DaoMirror.newInstance(interfaceElement, this.env);
        if (daoMirror == null) {
            throw new AptIllegalStateException("daoMirror");
        }
        DaoMeta daoMeta = new DaoMeta(daoMirror);
        this.doDaoElement(interfaceElement, daoMeta);
        this.doMethodElements(interfaceElement, daoMeta);
        this.validateFiles(interfaceElement, daoMeta);
        return daoMeta;
    }

    protected void doDaoElement(TypeElement interfaceElement, DaoMeta daoMeta) {
        this.validateInterface(interfaceElement, daoMeta);
        String name = interfaceElement.getSimpleName().toString();
        String suffix = Options.getDaoSuffix(this.env);
        if (name.endsWith(suffix)) {
            Notifier.notify(this.env, Diagnostic.Kind.WARNING, Message.DOMA4026, interfaceElement, new Object[]{suffix, interfaceElement.getQualifiedName()});
        }
        daoMeta.setName(name);
        daoMeta.setDaoElement(interfaceElement);
        daoMeta.setDaoType(interfaceElement.asType());
        this.doAnnotateWith(daoMeta);
        this.doParentDao(daoMeta);
        DaoMirror daoMirror = daoMeta.getDaoMirror();
        if (daoMirror.hasUserDefinedConfig()) {
            TypeElement configElement = TypeMirrorUtil.toTypeElement(daoMirror.getConfigValue(), this.env);
            if (configElement == null) {
                throw new AptIllegalStateException("failed to convert to TypeElement.");
            }
            this.validateUserDefinedConfig(configElement, daoMeta, daoMirror);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validateUserDefinedConfig(TypeElement configElement, DaoMeta daoMeta, DaoMirror daoMirror) {
        SingletonConfig singletonConfig = configElement.getAnnotation(SingletonConfig.class);
        if (singletonConfig == null) {
            if (configElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                throw new AptException((MessageResource)Message.DOMA4163, this.env, daoMeta.getDaoElement(), daoMirror.getAnnotationMirror(), daoMirror.getConfig(), new Object[]{configElement.getQualifiedName()});
            }
            ExecutableElement constructor = ElementUtil.getNoArgConstructor(configElement, this.env);
            if (constructor != null && constructor.getModifiers().contains((Object)Modifier.PUBLIC)) return;
            Optional<VariableElement> field = ElementFilter.fieldsIn(configElement.getEnclosedElements()).stream().filter(e -> e.getSimpleName().contentEquals(SINGLETON_CONFIG_FIELD_NAME)).filter(e -> e.getModifiers().containsAll(EnumSet.of(Modifier.STATIC, Modifier.PUBLIC, Modifier.FINAL))).filter(e -> TypeMirrorUtil.isAssignable(e.asType(), Config.class, this.env)).findFirst();
            if (!field.isPresent()) throw new AptException((MessageResource)Message.DOMA4164, this.env, daoMeta.getDaoElement(), daoMirror.getAnnotationMirror(), daoMirror.getConfig(), new Object[]{configElement.getQualifiedName()});
            daoMeta.setSingletonFieldName(SINGLETON_CONFIG_FIELD_NAME);
            return;
        } else {
            String methodName = singletonConfig.method();
            boolean present = ElementFilter.methodsIn(configElement.getEnclosedElements()).stream().filter(m -> m.getModifiers().containsAll(EnumSet.of(Modifier.STATIC, Modifier.PUBLIC))).filter(m -> TypeMirrorUtil.isAssignable(m.getReturnType(), Config.class, this.env)).filter(m -> m.getParameters().isEmpty()).filter(m -> m.getSimpleName().toString().equals(methodName)).findAny().isPresent();
            if (!present) throw new AptException((MessageResource)Message.DOMA4255, this.env, daoMeta.getDaoElement(), daoMirror.getAnnotationMirror(), daoMirror.getConfig(), new Object[]{configElement.getQualifiedName(), methodName});
            daoMeta.setSingletonMethodName(methodName);
        }
    }

    protected void validateInterface(TypeElement interfaceElement, DaoMeta daoMeta) {
        if (!interfaceElement.getKind().isInterface()) {
            DaoMirror daoMirror = daoMeta.getDaoMirror();
            throw new AptException((MessageResource)Message.DOMA4014, this.env, (Element)interfaceElement, daoMirror.getAnnotationMirror(), new Object[]{interfaceElement.getQualifiedName()});
        }
        if (interfaceElement.getNestingKind().isNested()) {
            throw new AptException((MessageResource)Message.DOMA4017, this.env, interfaceElement, new Object[]{interfaceElement.getQualifiedName()});
        }
        if (!interfaceElement.getTypeParameters().isEmpty()) {
            throw new AptException((MessageResource)Message.DOMA4059, this.env, interfaceElement, new Object[]{interfaceElement.getQualifiedName()});
        }
    }

    protected void doAnnotateWith(DaoMeta daoMeta) {
        AnnotateWithMirror annotateWithMirror = AnnotateWithMirror.newInstance(daoMeta.getDaoElement(), this.env);
        if (annotateWithMirror != null) {
            daoMeta.setAnnotateWithMirror(annotateWithMirror);
        }
    }

    protected void doParentDao(DaoMeta daoMeta) {
        List interfaces = daoMeta.getDaoElement().getInterfaces().stream().map(type -> TypeMirrorUtil.toTypeElement(type, this.env)).peek(element -> {
            if (element == null) {
                throw new AptIllegalStateException("failed to convert to TypeElement.");
            }
        }).collect(Collectors.toList());
        for (TypeElement typeElement : interfaces) {
            DaoMirror daoMirror = DaoMirror.newInstance(typeElement, this.env);
            if (daoMirror == null) {
                ExecutableElement nonDefaultMethod = this.findNonDefaultMethod(typeElement);
                if (nonDefaultMethod == null) continue;
                throw new AptException((MessageResource)Message.DOMA4440, this.env, daoMeta.getDaoElement(), new Object[]{nonDefaultMethod.getSimpleName(), daoMeta.getDaoElement().getQualifiedName()});
            }
            if (daoMeta.getParentDaoMeta() != null) {
                throw new AptException((MessageResource)Message.DOMA4188, this.env, daoMeta.getDaoElement(), new Object[]{daoMeta.getDaoElement().getQualifiedName()});
            }
            ParentDaoMeta parentDaoMeta = new ParentDaoMeta(daoMirror);
            parentDaoMeta.setDaoType(typeElement.asType());
            parentDaoMeta.setDaoElement(typeElement);
            daoMeta.setParentDaoMeta(parentDaoMeta);
        }
    }

    protected ExecutableElement findNonDefaultMethod(TypeElement interfaceElement) {
        Optional<ExecutableElement> method = ElementFilter.methodsIn(interfaceElement.getEnclosedElements()).stream().filter(m -> !m.isDefault()).findAny();
        if (method.isPresent()) {
            return method.get();
        }
        for (TypeMirror typeMirror : interfaceElement.getInterfaces()) {
            TypeElement i = TypeMirrorUtil.toTypeElement(typeMirror, this.env);
            if (i == null) {
                throw new AptIllegalStateException("failed to convert to TypeElement.");
            }
            ExecutableElement m2 = this.findNonDefaultMethod(i);
            if (m2 == null) continue;
            return m2;
        }
        return null;
    }

    protected void doMethodElements(TypeElement interfaceElement, DaoMeta daoMeta) {
        for (ExecutableElement methodElement : ElementFilter.methodsIn(interfaceElement.getEnclosedElements())) {
            try {
                this.doMethodElement(methodElement, daoMeta);
            }
            catch (AptException e) {
                Notifier.notify(this.env, e);
                daoMeta.setError(true);
            }
        }
    }

    protected void doMethodElement(ExecutableElement methodElement, DaoMeta daoMeta) {
        Set<Modifier> modifiers = methodElement.getModifiers();
        if (modifiers.contains((Object)Modifier.STATIC) || modifiers.contains((Object)Modifier.PRIVATE)) {
            return;
        }
        this.validateMethod(methodElement, daoMeta);
        QueryMeta queryMeta = this.createQueryMeta(methodElement, daoMeta);
        daoMeta.addQueryMeta(queryMeta);
    }

    protected void validateMethod(ExecutableElement methodElement, DaoMeta daoMeta) {
        TypeElement foundAnnotationTypeElement = null;
        for (AnnotationMirror annotationMirror : methodElement.getAnnotationMirrors()) {
            DeclaredType declaredType = annotationMirror.getAnnotationType();
            TypeElement typeElement = TypeMirrorUtil.toTypeElement(declaredType, this.env);
            if (typeElement.getAnnotation(DaoMethod.class) == null) continue;
            if (foundAnnotationTypeElement != null) {
                throw new AptException((MessageResource)Message.DOMA4087, this.env, methodElement, new Object[]{foundAnnotationTypeElement.getQualifiedName(), typeElement.getQualifiedName(), daoMeta.getDaoElement().getQualifiedName(), methodElement.getSimpleName()});
            }
            if (methodElement.isDefault()) {
                throw new AptException((MessageResource)Message.DOMA4252, this.env, methodElement, new Object[]{typeElement.getQualifiedName(), daoMeta.getDaoElement().getQualifiedName(), methodElement.getSimpleName()});
            }
            foundAnnotationTypeElement = typeElement;
        }
    }

    protected QueryMeta createQueryMeta(ExecutableElement method, DaoMeta daoMeta) {
        for (QueryMetaFactory factory : this.queryMetaFactories) {
            QueryMeta queryMeta = factory.createQueryMeta(method, daoMeta);
            if (queryMeta == null) continue;
            return queryMeta;
        }
        throw new AptException((MessageResource)Message.DOMA4005, this.env, method, new Object[]{daoMeta.getDaoElement().getQualifiedName(), method.getSimpleName()});
    }

    protected void validateFiles(TypeElement interfaceElement, DaoMeta daoMeta) {
        Message message;
        if (daoMeta.isError()) {
            return;
        }
        if (!Options.getSqlValidation(this.env)) {
            return;
        }
        String dirPath = SqlFileUtil.buildPath(interfaceElement.getQualifiedName().toString());
        Set<String> fileNames = this.getFileNames(dirPath);
        for (QueryMeta queryMeta : daoMeta.getQueryMetas()) {
            for (String fileName : queryMeta.getFileNames()) {
                fileNames.remove(fileName);
            }
        }
        Suppress suppress = interfaceElement.getAnnotation(Suppress.class);
        if (!this.isSuppressed(suppress, message = Message.DOMA4220)) {
            for (String fileName : fileNames) {
                Notifier.notify(this.env, Diagnostic.Kind.WARNING, message, interfaceElement, new Object[]{dirPath + "/" + fileName});
            }
        }
    }

    protected Set<String> getFileNames(String dirPath) {
        File dir = this.getDir(dirPath);
        if (dir == null) {
            return Collections.emptySet();
        }
        String[] fileNames = dir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".sql") || name.endsWith(".script");
            }
        });
        return new HashSet<String>(Arrays.asList(fileNames));
    }

    protected File getDir(String dirPath) {
        File dir;
        FileObject fileObject = this.getFileObject(dirPath);
        if (fileObject == null) {
            return null;
        }
        URI uri = fileObject.toUri();
        if (!uri.isAbsolute()) {
            uri = new File(".").toURI().resolve(uri);
        }
        if ((dir = new File(uri)).exists() && dir.isDirectory()) {
            return dir;
        }
        return null;
    }

    protected FileObject getFileObject(String path) {
        try {
            return ResourceUtil.getResource(path, this.env);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    protected boolean isSuppressed(Suppress suppress, Message message) {
        if (suppress != null) {
            for (Message suppressMessage : suppress.messages()) {
                if (suppressMessage != message) continue;
                return true;
            }
        }
        return false;
    }
}

