/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.AccessLevel;
import org.seasar.doma.AnnotationTarget;
import org.seasar.doma.internal.apt.meta.ParentDaoMeta;
import org.seasar.doma.internal.apt.meta.QueryMeta;
import org.seasar.doma.internal.apt.meta.TypeElementMeta;
import org.seasar.doma.internal.apt.mirror.AnnotateWithMirror;
import org.seasar.doma.internal.apt.mirror.AnnotationMirror;
import org.seasar.doma.internal.apt.mirror.DaoMirror;
import org.seasar.doma.internal.util.AssertionUtil;

public class DaoMeta
implements TypeElementMeta {
    protected final List<QueryMeta> queryMetas = new ArrayList<QueryMeta>();
    protected final DaoMirror daoMirror;
    protected AnnotateWithMirror annotateWithMirror;
    protected TypeMirror daoType;
    protected TypeElement daoElement;
    protected String name;
    protected boolean error;
    protected ParentDaoMeta parentDaoMeta;
    protected String singletonMethodName;
    protected String singletonFieldName;

    public DaoMeta(DaoMirror daoMirror) {
        AssertionUtil.assertNotNull(daoMirror);
        this.daoMirror = daoMirror;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TypeMirror getDaoType() {
        return this.daoType;
    }

    public void setDaoType(TypeMirror daoType) {
        this.daoType = daoType;
    }

    public TypeElement getDaoElement() {
        return this.daoElement;
    }

    public void setDaoElement(TypeElement daoElement) {
        this.daoElement = daoElement;
    }

    public void addQueryMeta(QueryMeta queryMeta) {
        this.queryMetas.add(queryMeta);
    }

    public List<QueryMeta> getQueryMetas() {
        return this.queryMetas;
    }

    public boolean hasUserDefinedConfig() {
        return this.daoMirror.hasUserDefinedConfig();
    }

    DaoMirror getDaoMirror() {
        return this.daoMirror;
    }

    public TypeMirror getConfigType() {
        return this.daoMirror.getConfigValue();
    }

    public AccessLevel getAccessLevel() {
        return this.daoMirror.getAccessLevelValue();
    }

    public AnnotateWithMirror getAnnotateWithMirror() {
        return this.annotateWithMirror;
    }

    public void setAnnotateWithMirror(AnnotateWithMirror annotateWithMirror) {
        this.annotateWithMirror = annotateWithMirror;
    }

    public List<AnnotationMirror> getAnnotationMirrors(AnnotationTarget target) {
        AssertionUtil.assertNotNull((Object)target);
        if (this.annotateWithMirror == null || this.annotateWithMirror.getAnnotationsValue() == null) {
            return Collections.emptyList();
        }
        ArrayList<AnnotationMirror> results = new ArrayList<AnnotationMirror>();
        for (AnnotationMirror annotationMirror : this.annotateWithMirror.getAnnotationsValue()) {
            if (!target.name().contentEquals(annotationMirror.getTargetValue().getSimpleName())) continue;
            results.add(annotationMirror);
        }
        return results;
    }

    @Override
    public boolean isError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public ParentDaoMeta getParentDaoMeta() {
        return this.parentDaoMeta;
    }

    public void setParentDaoMeta(ParentDaoMeta parentDaoMeta) {
        this.parentDaoMeta = parentDaoMeta;
    }

    public String getSingletonMethodName() {
        return this.singletonMethodName;
    }

    public void setSingletonMethodName(String singletonMethodName) {
        this.singletonMethodName = singletonMethodName;
    }

    public String getSingletonFieldName() {
        return this.singletonFieldName;
    }

    public void setSingletonFieldName(String singletonFieldName) {
        this.singletonFieldName = singletonFieldName;
    }
}

