/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.meta.AutoModuleQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.AutoProcedureQueryMeta;
import org.seasar.doma.internal.apt.meta.DaoMeta;
import org.seasar.doma.internal.apt.meta.QueryKind;
import org.seasar.doma.internal.apt.meta.QueryMeta;
import org.seasar.doma.internal.apt.meta.QueryReturnMeta;
import org.seasar.doma.internal.apt.mirror.ProcedureMirror;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class AutoProcedureQueryMetaFactory
extends AutoModuleQueryMetaFactory<AutoProcedureQueryMeta> {
    public AutoProcedureQueryMetaFactory(ProcessingEnvironment env) {
        super(env);
    }

    @Override
    public QueryMeta createQueryMeta(ExecutableElement method, DaoMeta daoMeta) {
        AssertionUtil.assertNotNull((Object)method, (Object)daoMeta);
        ProcedureMirror procedureMirror = ProcedureMirror.newInstance(method, this.env);
        if (procedureMirror == null) {
            return null;
        }
        AutoProcedureQueryMeta queryMeta = new AutoProcedureQueryMeta(method, daoMeta.getDaoElement());
        queryMeta.setQueryKind(QueryKind.AUTO_PROCEDURE);
        queryMeta.setProcedureMirror(procedureMirror);
        this.doTypeParameters(queryMeta, method, daoMeta);
        this.doReturnType(queryMeta, method, daoMeta);
        this.doParameters(queryMeta, method, daoMeta);
        this.doThrowTypes(queryMeta, method, daoMeta);
        return queryMeta;
    }

    @Override
    protected void doReturnType(AutoProcedureQueryMeta queryMeta, ExecutableElement method, DaoMeta daoMeta) {
        QueryReturnMeta resultMeta = this.createReturnMeta(queryMeta);
        if (!resultMeta.isPrimitiveVoid()) {
            throw new AptException((MessageResource)Message.DOMA4064, this.env, resultMeta.getMethodElement(), new Object[]{queryMeta.getDaoElement().getQualifiedName(), queryMeta.getMethodElement().getSimpleName()});
        }
        queryMeta.setReturnMeta(resultMeta);
    }
}

