/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.cttype.BasicCtType;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.DomainCtType;
import org.seasar.doma.internal.apt.cttype.EntityCtType;
import org.seasar.doma.internal.apt.cttype.IterableCtType;
import org.seasar.doma.internal.apt.cttype.MapCtType;
import org.seasar.doma.internal.apt.cttype.OptionalCtType;
import org.seasar.doma.internal.apt.cttype.OptionalDoubleCtType;
import org.seasar.doma.internal.apt.cttype.OptionalIntCtType;
import org.seasar.doma.internal.apt.cttype.OptionalLongCtType;
import org.seasar.doma.internal.apt.cttype.SimpleCtTypeVisitor;
import org.seasar.doma.internal.apt.meta.AutoFunctionQueryMeta;
import org.seasar.doma.internal.apt.meta.AutoModuleQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.BasicResultListParameterMeta;
import org.seasar.doma.internal.apt.meta.BasicSingleResultParameterMeta;
import org.seasar.doma.internal.apt.meta.DaoMeta;
import org.seasar.doma.internal.apt.meta.DomainResultListParameterMeta;
import org.seasar.doma.internal.apt.meta.DomainSingleResultParameterMeta;
import org.seasar.doma.internal.apt.meta.EntityResultListParameterMeta;
import org.seasar.doma.internal.apt.meta.MapResultListParameterMeta;
import org.seasar.doma.internal.apt.meta.OptionalBasicResultListParameterMeta;
import org.seasar.doma.internal.apt.meta.OptionalBasicSingleResultParameterMeta;
import org.seasar.doma.internal.apt.meta.OptionalDomainResultListParameterMeta;
import org.seasar.doma.internal.apt.meta.OptionalDomainSingleResultParameterMeta;
import org.seasar.doma.internal.apt.meta.OptionalDoubleResultListParameterMeta;
import org.seasar.doma.internal.apt.meta.OptionalDoubleSingleResultParameterMeta;
import org.seasar.doma.internal.apt.meta.OptionalIntResultListParameterMeta;
import org.seasar.doma.internal.apt.meta.OptionalIntSingleResultParameterMeta;
import org.seasar.doma.internal.apt.meta.OptionalLongResultListParameterMeta;
import org.seasar.doma.internal.apt.meta.OptionalLongSingleResultParameterMeta;
import org.seasar.doma.internal.apt.meta.QueryKind;
import org.seasar.doma.internal.apt.meta.QueryMeta;
import org.seasar.doma.internal.apt.meta.QueryReturnMeta;
import org.seasar.doma.internal.apt.meta.ResultParameterMeta;
import org.seasar.doma.internal.apt.mirror.FunctionMirror;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class AutoFunctionQueryMetaFactory
extends AutoModuleQueryMetaFactory<AutoFunctionQueryMeta> {
    public AutoFunctionQueryMetaFactory(ProcessingEnvironment env) {
        super(env);
    }

    @Override
    public QueryMeta createQueryMeta(ExecutableElement method, DaoMeta daoMeta) {
        AssertionUtil.assertNotNull((Object)method, (Object)daoMeta);
        FunctionMirror functionMirror = FunctionMirror.newInstance(method, this.env);
        if (functionMirror == null) {
            return null;
        }
        AutoFunctionQueryMeta queryMeta = new AutoFunctionQueryMeta(method, daoMeta.getDaoElement());
        queryMeta.setFunctionMirror(functionMirror);
        queryMeta.setQueryKind(QueryKind.AUTO_FUNCTION);
        this.doTypeParameters(queryMeta, method, daoMeta);
        this.doReturnType(queryMeta, method, daoMeta);
        this.doParameters(queryMeta, method, daoMeta);
        this.doThrowTypes(queryMeta, method, daoMeta);
        return queryMeta;
    }

    @Override
    protected void doReturnType(AutoFunctionQueryMeta queryMeta, ExecutableElement method, DaoMeta daoMeta) {
        QueryReturnMeta returnMeta = this.createReturnMeta(queryMeta);
        queryMeta.setReturnMeta(returnMeta);
        ResultParameterMeta resultParameterMeta = this.createResultParameterMeta(queryMeta, returnMeta);
        queryMeta.setResultParameterMeta(resultParameterMeta);
    }

    protected ResultParameterMeta createResultParameterMeta(AutoFunctionQueryMeta queryMeta, QueryReturnMeta returnMeta) {
        return returnMeta.getCtType().accept(new ReturnCtTypeVisitor(queryMeta, returnMeta), false);
    }

    protected class IterableElementCtTypeVisitor
    extends SimpleCtTypeVisitor<ResultParameterMeta, Boolean, RuntimeException> {
        protected final AutoFunctionQueryMeta queryMeta;
        protected final QueryReturnMeta returnMeta;

        public IterableElementCtTypeVisitor(AutoFunctionQueryMeta queryMeta, QueryReturnMeta returnMeta) {
            this.queryMeta = queryMeta;
            this.returnMeta = returnMeta;
        }

        @Override
        protected ResultParameterMeta defaultAction(CtType ctType, Boolean p) throws RuntimeException {
            throw new AptException((MessageResource)Message.DOMA4065, AutoFunctionQueryMetaFactory.this.env, this.returnMeta.getMethodElement(), new Object[]{ctType.getTypeName(), this.queryMeta.getDaoElement().getQualifiedName(), this.queryMeta.getMethodElement().getSimpleName()});
        }

        @Override
        public ResultParameterMeta visitBasicCtType(BasicCtType ctType, Boolean optional) throws RuntimeException {
            if (Boolean.TRUE == optional) {
                return new OptionalBasicResultListParameterMeta(ctType);
            }
            return new BasicResultListParameterMeta(ctType);
        }

        @Override
        public ResultParameterMeta visitDomainCtType(DomainCtType ctType, Boolean optional) throws RuntimeException {
            if (Boolean.TRUE == optional) {
                return new OptionalDomainResultListParameterMeta(ctType);
            }
            return new DomainResultListParameterMeta(ctType);
        }

        @Override
        public ResultParameterMeta visitEntityCtType(EntityCtType ctType, Boolean p) throws RuntimeException {
            if (ctType.isAbstract()) {
                throw new AptException((MessageResource)Message.DOMA4156, AutoFunctionQueryMetaFactory.this.env, this.returnMeta.getMethodElement(), new Object[]{ctType.getTypeName(), this.returnMeta.getDaoElement().getQualifiedName(), this.returnMeta.getMethodElement().getSimpleName()});
            }
            return new EntityResultListParameterMeta(ctType, this.queryMeta.getEnsureResultMapping());
        }

        @Override
        public ResultParameterMeta visitMapCtType(MapCtType ctType, Boolean p) throws RuntimeException {
            return new MapResultListParameterMeta(ctType);
        }

        @Override
        public ResultParameterMeta visitOptionalCtType(OptionalCtType ctType, Boolean p) throws RuntimeException {
            return ctType.getElementCtType().accept(this, true);
        }

        @Override
        public ResultParameterMeta visitOptionalIntCtType(OptionalIntCtType ctType, Boolean p) throws RuntimeException {
            return new OptionalIntResultListParameterMeta();
        }

        @Override
        public ResultParameterMeta visitOptionalLongCtType(OptionalLongCtType ctType, Boolean p) throws RuntimeException {
            return new OptionalLongResultListParameterMeta();
        }

        @Override
        public ResultParameterMeta visitOptionalDoubleCtType(OptionalDoubleCtType ctType, Boolean p) throws RuntimeException {
            return new OptionalDoubleResultListParameterMeta();
        }
    }

    protected class ReturnCtTypeVisitor
    extends SimpleCtTypeVisitor<ResultParameterMeta, Boolean, RuntimeException> {
        protected final AutoFunctionQueryMeta queryMeta;
        protected final QueryReturnMeta returnMeta;

        public ReturnCtTypeVisitor(AutoFunctionQueryMeta queryMeta, QueryReturnMeta returnMeta) {
            this.queryMeta = queryMeta;
            this.returnMeta = returnMeta;
        }

        @Override
        protected ResultParameterMeta defaultAction(CtType type, Boolean p) throws RuntimeException {
            throw new AptException((MessageResource)Message.DOMA4063, AutoFunctionQueryMetaFactory.this.env, this.returnMeta.getMethodElement(), new Object[]{this.returnMeta.getType(), this.queryMeta.getDaoElement().getQualifiedName(), this.queryMeta.getMethodElement().getSimpleName()});
        }

        @Override
        public ResultParameterMeta visitBasicCtType(BasicCtType ctType, Boolean optional) throws RuntimeException {
            if (Boolean.TRUE == optional) {
                return new OptionalBasicSingleResultParameterMeta(ctType);
            }
            return new BasicSingleResultParameterMeta(ctType);
        }

        @Override
        public ResultParameterMeta visitDomainCtType(DomainCtType ctType, Boolean optional) throws RuntimeException {
            if (Boolean.TRUE == optional) {
                return new OptionalDomainSingleResultParameterMeta(ctType);
            }
            return new DomainSingleResultParameterMeta(ctType);
        }

        @Override
        public ResultParameterMeta visitIterableCtType(IterableCtType ctType, Boolean p) throws RuntimeException {
            if (!ctType.isList()) {
                this.defaultAction((CtType)ctType, p);
            }
            return ctType.getElementCtType().accept(new IterableElementCtTypeVisitor(this.queryMeta, this.returnMeta), false);
        }

        @Override
        public ResultParameterMeta visitOptionalCtType(OptionalCtType ctType, Boolean p) throws RuntimeException {
            return ctType.getElementCtType().accept(this, true);
        }

        @Override
        public ResultParameterMeta visitOptionalIntCtType(OptionalIntCtType ctType, Boolean p) throws RuntimeException {
            return new OptionalIntSingleResultParameterMeta();
        }

        @Override
        public ResultParameterMeta visitOptionalLongCtType(OptionalLongCtType ctType, Boolean p) throws RuntimeException {
            return new OptionalLongSingleResultParameterMeta();
        }

        @Override
        public ResultParameterMeta visitOptionalDoubleCtType(OptionalDoubleCtType ctType, Boolean p) throws RuntimeException {
            return new OptionalDoubleSingleResultParameterMeta();
        }
    }
}

