/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import java.sql.Array;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.meta.AbstractCreateQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.ArrayCreateQueryMeta;
import org.seasar.doma.internal.apt.meta.DaoMeta;
import org.seasar.doma.internal.apt.meta.QueryKind;
import org.seasar.doma.internal.apt.meta.QueryMeta;
import org.seasar.doma.internal.apt.meta.QueryParameterMeta;
import org.seasar.doma.internal.apt.mirror.ArrayFactoryMirror;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class ArrayCreateQueryMetaFactory
extends AbstractCreateQueryMetaFactory<ArrayCreateQueryMeta> {
    public ArrayCreateQueryMetaFactory(ProcessingEnvironment env) {
        super(env, Array.class);
    }

    @Override
    public QueryMeta createQueryMeta(ExecutableElement method, DaoMeta daoMeta) {
        AssertionUtil.assertNotNull((Object)method, (Object)daoMeta);
        ArrayFactoryMirror arrayFactoryMirror = ArrayFactoryMirror.newInstance(method, this.env);
        if (arrayFactoryMirror == null) {
            return null;
        }
        ArrayCreateQueryMeta queryMeta = new ArrayCreateQueryMeta(method, daoMeta.getDaoElement());
        queryMeta.setArrayFactoryMirror(arrayFactoryMirror);
        queryMeta.setQueryKind(QueryKind.ARRAY_FACTORY);
        this.doTypeParameters(queryMeta, method, daoMeta);
        this.doReturnType(queryMeta, method, daoMeta);
        this.doParameters(queryMeta, method, daoMeta);
        this.doThrowTypes(queryMeta, method, daoMeta);
        return queryMeta;
    }

    @Override
    protected void doParameters(ArrayCreateQueryMeta queryMeta, ExecutableElement method, DaoMeta daoMeta) {
        List<? extends VariableElement> parameters = method.getParameters();
        int size = parameters.size();
        if (size != 1) {
            throw new AptException((MessageResource)Message.DOMA4002, this.env, method, new Object[]{daoMeta.getDaoElement().getQualifiedName(), method.getSimpleName()});
        }
        QueryParameterMeta parameterMeta = this.createParameterMeta(parameters.get(0), queryMeta);
        if (parameterMeta.getType().getKind() != TypeKind.ARRAY) {
            throw new AptException((MessageResource)Message.DOMA4076, this.env, parameterMeta.getElement(), new Object[]{daoMeta.getDaoElement().getQualifiedName(), method.getSimpleName()});
        }
        queryMeta.setElementsParameterName(parameterMeta.getName());
        queryMeta.addParameterMeta(parameterMeta);
        if (parameterMeta.isBindable()) {
            queryMeta.addBindableParameterCtType(parameterMeta.getName(), parameterMeta.getCtType());
        }
    }
}

