/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.OptionalCtType;
import org.seasar.doma.internal.apt.cttype.OptionalDoubleCtType;
import org.seasar.doma.internal.apt.cttype.OptionalIntCtType;
import org.seasar.doma.internal.apt.cttype.OptionalLongCtType;
import org.seasar.doma.internal.apt.cttype.SimpleCtTypeVisitor;
import org.seasar.doma.internal.apt.meta.QueryKind;
import org.seasar.doma.internal.apt.meta.QueryMeta;
import org.seasar.doma.internal.apt.meta.QueryParameterMeta;
import org.seasar.doma.internal.apt.meta.QueryReturnMeta;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.query.Query;

public abstract class AbstractQueryMeta
implements QueryMeta {
    protected final String name;
    protected final ExecutableElement executableElement;
    protected final TypeElement daoElement;
    protected List<String> typeParameterNames = new ArrayList<String>();
    protected List<String> thrownTypeNames = new ArrayList<String>();
    protected QueryKind queryKind;
    protected LinkedHashMap<String, TypeMirror> bindableParameterTypeMap = new LinkedHashMap();
    protected QueryReturnMeta returnMeta;
    protected List<QueryParameterMeta> parameterMetas = new ArrayList<QueryParameterMeta>();
    protected List<String> fileNames = new ArrayList<String>();

    protected AbstractQueryMeta(ExecutableElement method, TypeElement dao) {
        AssertionUtil.assertNotNull(method);
        this.name = method.getSimpleName().toString();
        this.executableElement = method;
        this.daoElement = dao;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ExecutableElement getMethodElement() {
        return this.executableElement;
    }

    @Override
    public TypeElement getDaoElement() {
        return this.daoElement;
    }

    public void addTypeParameterName(String typeParameterName) {
        this.typeParameterNames.add(typeParameterName);
    }

    @Override
    public List<String> getTypeParameterNames() {
        return this.typeParameterNames;
    }

    public void addThrownTypeName(String thrownTypeName) {
        this.thrownTypeNames.add(thrownTypeName);
    }

    @Override
    public List<String> getThrownTypeNames() {
        return this.thrownTypeNames;
    }

    public Class<? extends Query> getQueryClass() {
        if (this.queryKind == null) {
            return null;
        }
        return this.queryKind.getQueryClass();
    }

    public Class<?> getCommandClass() {
        if (this.queryKind == null) {
            return null;
        }
        return this.queryKind.getCommandClass();
    }

    @Override
    public QueryKind getQueryKind() {
        return this.queryKind;
    }

    public void setQueryKind(QueryKind queryKind) {
        this.queryKind = queryKind;
    }

    public LinkedHashMap<String, TypeMirror> getBindableParameterTypeMap() {
        return this.bindableParameterTypeMap;
    }

    public void addBindableParameterCtType(String parameterName, CtType bindableParameterCtType) {
        bindableParameterCtType.accept(new BindableParameterCtTypeVisitor(parameterName), null);
    }

    @Override
    public QueryReturnMeta getReturnMeta() {
        return this.returnMeta;
    }

    public void setReturnMeta(QueryReturnMeta returnMeta) {
        this.returnMeta = returnMeta;
    }

    @Override
    public List<QueryParameterMeta> getParameterMetas() {
        return this.parameterMetas;
    }

    public void addParameterMeta(QueryParameterMeta queryParameterMeta) {
        this.parameterMetas.add(queryParameterMeta);
    }

    @Override
    public List<String> getFileNames() {
        return this.fileNames;
    }

    public void addFileName(String fileName) {
        this.fileNames.add(fileName);
    }

    @Override
    public boolean isVarArgs() {
        return this.executableElement.isVarArgs();
    }

    protected class BindableParameterCtTypeVisitor
    extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
        protected final String parameterName;

        protected BindableParameterCtTypeVisitor(String parameterName) {
            this.parameterName = parameterName;
        }

        @Override
        protected Void defaultAction(CtType ctType, Void p) throws RuntimeException {
            AbstractQueryMeta.this.bindableParameterTypeMap.put(this.parameterName, ctType.getTypeMirror());
            return null;
        }

        @Override
        public Void visitOptionalCtType(OptionalCtType ctType, Void p) throws RuntimeException {
            return ctType.getElementCtType().accept(this, p);
        }

        @Override
        public Void visitOptionalIntCtType(OptionalIntCtType ctType, Void p) throws RuntimeException {
            return ctType.getElementCtType().accept(this, p);
        }

        @Override
        public Void visitOptionalLongCtType(OptionalLongCtType ctType, Void p) throws RuntimeException {
            return ctType.getElementCtType().accept(this, p);
        }

        @Override
        public Void visitOptionalDoubleCtType(OptionalDoubleCtType ctType, Void p) throws RuntimeException {
            return ctType.getElementCtType().accept(this, p);
        }
    }
}

