/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.meta.AbstractCreateQueryMeta;
import org.seasar.doma.internal.apt.meta.AbstractQueryMeta;
import org.seasar.doma.internal.apt.meta.AbstractQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.DaoMeta;
import org.seasar.doma.internal.apt.meta.QueryMeta;
import org.seasar.doma.internal.apt.meta.QueryReturnMeta;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public abstract class AbstractCreateQueryMetaFactory<M extends AbstractCreateQueryMeta>
extends AbstractQueryMetaFactory<M> {
    protected final Class<?> returnClass;

    protected AbstractCreateQueryMetaFactory(ProcessingEnvironment env, Class<?> returnClass) {
        super(env);
        AssertionUtil.assertNotNull(returnClass);
        this.returnClass = returnClass;
    }

    @Override
    protected void doReturnType(M queryMeta, ExecutableElement method, DaoMeta daoMeta) {
        QueryReturnMeta resultMeta = this.createReturnMeta((QueryMeta)queryMeta);
        ((AbstractQueryMeta)queryMeta).setReturnMeta(resultMeta);
        if (!this.returnClass.getName().equals(resultMeta.getCtType().getQualifiedName())) {
            throw new AptException((MessageResource)Message.DOMA4097, this.env, method, new Object[]{this.returnClass.getName(), daoMeta.getDaoElement().getQualifiedName(), method.getSimpleName()});
        }
    }

    @Override
    protected void doParameters(M queryMeta, ExecutableElement method, DaoMeta daoMeta) {
        List<? extends VariableElement> params = method.getParameters();
        int size = params.size();
        if (size != 0) {
            throw new AptException((MessageResource)Message.DOMA4078, this.env, method, new Object[]{daoMeta.getDaoElement().getQualifiedName(), method.getSimpleName()});
        }
    }
}

