/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.cttype;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor8;
import org.seasar.doma.internal.apt.cttype.AbstractCtType;
import org.seasar.doma.internal.apt.cttype.BasicCtType;
import org.seasar.doma.internal.apt.cttype.CtTypeVisitor;
import org.seasar.doma.internal.apt.cttype.EnumWrapperCtType;
import org.seasar.doma.internal.apt.util.ElementUtil;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.wrapper.ArrayWrapper;
import org.seasar.doma.wrapper.BigDecimalWrapper;
import org.seasar.doma.wrapper.BigIntegerWrapper;
import org.seasar.doma.wrapper.BlobWrapper;
import org.seasar.doma.wrapper.BooleanWrapper;
import org.seasar.doma.wrapper.ByteWrapper;
import org.seasar.doma.wrapper.BytesWrapper;
import org.seasar.doma.wrapper.ClobWrapper;
import org.seasar.doma.wrapper.DateWrapper;
import org.seasar.doma.wrapper.DoubleWrapper;
import org.seasar.doma.wrapper.EnumWrapper;
import org.seasar.doma.wrapper.FloatWrapper;
import org.seasar.doma.wrapper.IntegerWrapper;
import org.seasar.doma.wrapper.LocalDateTimeWrapper;
import org.seasar.doma.wrapper.LocalDateWrapper;
import org.seasar.doma.wrapper.LocalTimeWrapper;
import org.seasar.doma.wrapper.LongWrapper;
import org.seasar.doma.wrapper.NClobWrapper;
import org.seasar.doma.wrapper.ObjectWrapper;
import org.seasar.doma.wrapper.SQLXMLWrapper;
import org.seasar.doma.wrapper.ShortWrapper;
import org.seasar.doma.wrapper.StringWrapper;
import org.seasar.doma.wrapper.TimeWrapper;
import org.seasar.doma.wrapper.TimestampWrapper;
import org.seasar.doma.wrapper.UtilDateWrapper;

public class WrapperCtType
extends AbstractCtType {
    protected BasicCtType basicCtType;

    public WrapperCtType(TypeMirror type, ProcessingEnvironment env) {
        super(type, env);
    }

    public BasicCtType getBasicCtType() {
        return this.basicCtType;
    }

    public static WrapperCtType newInstance(BasicCtType basicCtType, ProcessingEnvironment env) {
        WrapperCtType wrapperCtType;
        AssertionUtil.assertNotNull((Object)basicCtType, (Object)env);
        Class wrapperClass = (Class)basicCtType.getTypeMirror().accept(new WrapperTypeMappingVisitor(env), null);
        if (wrapperClass == null) {
            return null;
        }
        TypeElement wrapperTypeElement = ElementUtil.getTypeElement(wrapperClass, env);
        if (wrapperTypeElement == null) {
            return null;
        }
        if (wrapperClass == EnumWrapper.class) {
            DeclaredType declaredType = env.getTypeUtils().getDeclaredType(wrapperTypeElement, basicCtType.getTypeMirror());
            wrapperCtType = new EnumWrapperCtType(declaredType, env);
        } else {
            wrapperCtType = new WrapperCtType(wrapperTypeElement.asType(), env);
        }
        wrapperCtType.basicCtType = basicCtType;
        return wrapperCtType;
    }

    @Override
    public <R, P, TH extends Throwable> R accept(CtTypeVisitor<R, P, TH> visitor, P p) throws TH {
        return visitor.visitWrapperCtType(this, p);
    }

    protected static class WrapperTypeMappingVisitor
    extends SimpleTypeVisitor8<Class<?>, Void> {
        protected final ProcessingEnvironment env;

        protected WrapperTypeMappingVisitor(ProcessingEnvironment env) {
            this.env = env;
        }

        @Override
        public Class<?> visitArray(ArrayType t, Void p) {
            if (t.getComponentType().getKind() == TypeKind.BYTE) {
                return BytesWrapper.class;
            }
            return null;
        }

        @Override
        public Class<?> visitDeclared(DeclaredType t, Void p) {
            TypeElement typeElement = TypeMirrorUtil.toTypeElement(t, this.env);
            if (typeElement == null) {
                return null;
            }
            if (typeElement.getKind() == ElementKind.ENUM) {
                return EnumWrapper.class;
            }
            String name = typeElement.getQualifiedName().toString();
            if (String.class.getName().equals(name)) {
                return StringWrapper.class;
            }
            if (Boolean.class.getName().equals(name)) {
                return BooleanWrapper.class;
            }
            if (Byte.class.getName().equals(name)) {
                return ByteWrapper.class;
            }
            if (Short.class.getName().equals(name)) {
                return ShortWrapper.class;
            }
            if (Integer.class.getName().equals(name)) {
                return IntegerWrapper.class;
            }
            if (Long.class.getName().equals(name)) {
                return LongWrapper.class;
            }
            if (Float.class.getName().equals(name)) {
                return FloatWrapper.class;
            }
            if (Double.class.getName().equals(name)) {
                return DoubleWrapper.class;
            }
            if (Object.class.getName().equals(name)) {
                return ObjectWrapper.class;
            }
            if (TypeMirrorUtil.isAssignable((TypeMirror)t, BigDecimal.class, this.env)) {
                return BigDecimalWrapper.class;
            }
            if (TypeMirrorUtil.isAssignable((TypeMirror)t, BigInteger.class, this.env)) {
                return BigIntegerWrapper.class;
            }
            if (TypeMirrorUtil.isAssignable((TypeMirror)t, Time.class, this.env)) {
                return TimeWrapper.class;
            }
            if (TypeMirrorUtil.isAssignable((TypeMirror)t, Timestamp.class, this.env)) {
                return TimestampWrapper.class;
            }
            if (TypeMirrorUtil.isAssignable((TypeMirror)t, Date.class, this.env)) {
                return DateWrapper.class;
            }
            if (TypeMirrorUtil.isAssignable((TypeMirror)t, java.util.Date.class, this.env)) {
                return UtilDateWrapper.class;
            }
            if (TypeMirrorUtil.isAssignable((TypeMirror)t, LocalTime.class, this.env)) {
                return LocalTimeWrapper.class;
            }
            if (TypeMirrorUtil.isAssignable((TypeMirror)t, LocalDateTime.class, this.env)) {
                return LocalDateTimeWrapper.class;
            }
            if (TypeMirrorUtil.isAssignable((TypeMirror)t, LocalDate.class, this.env)) {
                return LocalDateWrapper.class;
            }
            if (TypeMirrorUtil.isAssignable((TypeMirror)t, Array.class, this.env)) {
                return ArrayWrapper.class;
            }
            if (TypeMirrorUtil.isAssignable((TypeMirror)t, Blob.class, this.env)) {
                return BlobWrapper.class;
            }
            if (TypeMirrorUtil.isAssignable((TypeMirror)t, NClob.class, this.env)) {
                return NClobWrapper.class;
            }
            if (TypeMirrorUtil.isAssignable((TypeMirror)t, Clob.class, this.env)) {
                return ClobWrapper.class;
            }
            if (TypeMirrorUtil.isAssignable((TypeMirror)t, SQLXML.class, this.env)) {
                return SQLXMLWrapper.class;
            }
            return null;
        }

        @Override
        public Class<?> visitPrimitive(PrimitiveType t, Void p) {
            switch (t.getKind()) {
                case BOOLEAN: {
                    return BooleanWrapper.class;
                }
                case BYTE: {
                    return ByteWrapper.class;
                }
                case SHORT: {
                    return ShortWrapper.class;
                }
                case INT: {
                    return IntegerWrapper.class;
                }
                case LONG: {
                    return LongWrapper.class;
                }
                case FLOAT: {
                    return FloatWrapper.class;
                }
                case DOUBLE: {
                    return DoubleWrapper.class;
                }
                case CHAR: {
                    return null;
                }
            }
            return (Class)AssertionUtil.assertUnreachable();
        }
    }
}

