/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.cttype;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.cttype.AbstractCtType;
import org.seasar.doma.internal.apt.cttype.AnyCtType;
import org.seasar.doma.internal.apt.cttype.BasicCtType;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.CtTypeVisitor;
import org.seasar.doma.internal.apt.cttype.DomainCtType;
import org.seasar.doma.internal.apt.cttype.OptionalCtType;
import org.seasar.doma.internal.apt.cttype.OptionalDoubleCtType;
import org.seasar.doma.internal.apt.cttype.OptionalIntCtType;
import org.seasar.doma.internal.apt.cttype.OptionalLongCtType;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Reference;

public class ReferenceCtType
extends AbstractCtType {
    protected TypeMirror referentTypeMirror;
    protected CtType referentType;

    public ReferenceCtType(TypeMirror type, ProcessingEnvironment env) {
        super(type, env);
    }

    public CtType getReferentCtType() {
        return this.referentType;
    }

    public TypeMirror getReferentTypeMirror() {
        return this.referentTypeMirror;
    }

    public boolean isRaw() {
        return this.referentTypeMirror == null;
    }

    public boolean isWildcardType() {
        return this.referentTypeMirror != null && this.referentTypeMirror.getKind() == TypeKind.WILDCARD;
    }

    public static ReferenceCtType newInstance(TypeMirror type, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull((Object)type, (Object)env);
        DeclaredType referenceDeclaredType = ReferenceCtType.getReferenceDeclaredType(type, env);
        if (referenceDeclaredType == null) {
            return null;
        }
        ReferenceCtType referenceCtType = new ReferenceCtType(type, env);
        List<? extends TypeMirror> typeArguments = referenceDeclaredType.getTypeArguments();
        if (typeArguments.size() == 1) {
            referenceCtType.referentTypeMirror = typeArguments.get(0);
            referenceCtType.referentType = ReferenceCtType.buildCtTypeSuppliers(referenceCtType.referentTypeMirror, env).stream().map(Supplier::get).filter(Objects::nonNull).findFirst().get();
        }
        return referenceCtType;
    }

    protected static List<Supplier<CtType>> buildCtTypeSuppliers(TypeMirror typeMirror, ProcessingEnvironment env) {
        return Arrays.asList(() -> OptionalCtType.newInstance(typeMirror, env), () -> OptionalIntCtType.newInstance(typeMirror, env), () -> OptionalLongCtType.newInstance(typeMirror, env), () -> OptionalDoubleCtType.newInstance(typeMirror, env), () -> DomainCtType.newInstance(typeMirror, env), () -> BasicCtType.newInstance(typeMirror, env), () -> AnyCtType.newInstance(typeMirror, env));
    }

    protected static DeclaredType getReferenceDeclaredType(TypeMirror type, ProcessingEnvironment env) {
        if (TypeMirrorUtil.isSameType(type, Reference.class, env)) {
            return TypeMirrorUtil.toDeclaredType(type, env);
        }
        for (TypeMirror typeMirror : env.getTypeUtils().directSupertypes(type)) {
            if (TypeMirrorUtil.isSameType(typeMirror, Reference.class, env)) {
                return TypeMirrorUtil.toDeclaredType(typeMirror, env);
            }
            ReferenceCtType.getReferenceDeclaredType(typeMirror, env);
        }
        return null;
    }

    @Override
    public <R, P, TH extends Throwable> R accept(CtTypeVisitor<R, P, TH> visitor, P p) throws TH {
        return visitor.visitReferenceCtType(this, p);
    }
}

