/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.cttype;

import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.cttype.AbstractCtType;
import org.seasar.doma.internal.apt.cttype.AnyCtType;
import org.seasar.doma.internal.apt.cttype.BasicCtType;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.CtTypeVisitor;
import org.seasar.doma.internal.apt.cttype.DomainCtType;
import org.seasar.doma.internal.apt.cttype.EntityCtType;
import org.seasar.doma.internal.apt.cttype.MapCtType;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public class OptionalCtType
extends AbstractCtType {
    private final CtType elementCtType;
    private boolean isRawType;
    private boolean isWildcardType;

    public OptionalCtType(TypeMirror optionalType, ProcessingEnvironment env) {
        super(optionalType, env);
        DeclaredType declaredType = TypeMirrorUtil.toDeclaredType(this.getTypeMirror(), env);
        if (declaredType == null) {
            throw new AptIllegalStateException(this.getTypeName());
        }
        if (declaredType.getTypeArguments().isEmpty()) {
            this.isRawType = true;
            this.elementCtType = null;
        } else {
            TypeMirror typeArg = declaredType.getTypeArguments().get(0);
            if (typeArg.getKind() == TypeKind.WILDCARD || typeArg.getKind() == TypeKind.TYPEVAR) {
                this.isWildcardType = true;
                this.elementCtType = null;
            } else {
                MapCtType mapCtType;
                BasicCtType basicCtType;
                DomainCtType domainCtType;
                EntityCtType entityCtType = EntityCtType.newInstance(typeArg, env);
                this.elementCtType = entityCtType != null ? entityCtType : ((domainCtType = DomainCtType.newInstance(typeArg, env)) != null ? domainCtType : ((basicCtType = BasicCtType.newInstance(typeArg, env)) != null ? basicCtType : ((mapCtType = MapCtType.newInstance(typeArg, env)) != null ? mapCtType : AnyCtType.newInstance(typeArg, env))));
            }
        }
    }

    public CtType getElementCtType() {
        return this.elementCtType;
    }

    public boolean isRawType() {
        return this.isRawType;
    }

    public boolean isWildcardType() {
        return this.isWildcardType;
    }

    public static OptionalCtType newInstance(TypeMirror type, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull((Object)type, (Object)env);
        if (!TypeMirrorUtil.isSameType(type, Optional.class, env)) {
            return null;
        }
        DeclaredType declaredType = TypeMirrorUtil.toDeclaredType(type, env);
        if (declaredType == null) {
            return null;
        }
        return new OptionalCtType(type, env);
    }

    @Override
    public <R, P, TH extends Throwable> R accept(CtTypeVisitor<R, P, TH> visitor, P p) throws TH {
        return visitor.visitOptionalCtType(this, p);
    }
}

