/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.cttype;

import java.util.List;
import java.util.function.Function;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.cttype.AbstractCtType;
import org.seasar.doma.internal.apt.cttype.AnyCtType;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.CtTypeVisitor;
import org.seasar.doma.internal.apt.cttype.PreparedSqlCtType;
import org.seasar.doma.internal.apt.cttype.StreamCtType;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public class FunctionCtType
extends AbstractCtType {
    protected CtType targetCtType;
    protected AnyCtType returnCtType;

    public FunctionCtType(TypeMirror type, ProcessingEnvironment env) {
        super(type, env);
    }

    public CtType getTargetCtType() {
        return this.targetCtType;
    }

    public AnyCtType getReturnCtType() {
        return this.returnCtType;
    }

    public boolean isRawType() {
        return this.returnCtType.getTypeMirror() == null || this.targetCtType.getTypeMirror() == null;
    }

    public boolean isWildcardType() {
        return this.returnCtType.getTypeMirror() != null && this.returnCtType.getTypeMirror().getKind() == TypeKind.WILDCARD || this.targetCtType.getTypeMirror() != null && this.targetCtType.getTypeMirror().getKind() == TypeKind.WILDCARD;
    }

    public static FunctionCtType newInstance(TypeMirror type, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull((Object)type, (Object)env);
        DeclaredType functionDeclaredType = FunctionCtType.getFunctionDeclaredType(type, env);
        if (functionDeclaredType == null) {
            return null;
        }
        FunctionCtType functionCtType = new FunctionCtType(type, env);
        List<? extends TypeMirror> typeArguments = functionDeclaredType.getTypeArguments();
        if (typeArguments.size() == 2) {
            TypeMirror targetTypeMirror = typeArguments.get(0);
            TypeMirror returnTypeMirror = typeArguments.get(1);
            functionCtType.targetCtType = StreamCtType.newInstance(targetTypeMirror, env);
            if (functionCtType.targetCtType == null) {
                functionCtType.targetCtType = PreparedSqlCtType.newInstance(targetTypeMirror, env);
                if (functionCtType.targetCtType == null) {
                    functionCtType.targetCtType = AnyCtType.newInstance(targetTypeMirror, env);
                }
            }
            functionCtType.returnCtType = AnyCtType.newInstance(returnTypeMirror, env);
        }
        return functionCtType;
    }

    protected static DeclaredType getFunctionDeclaredType(TypeMirror type, ProcessingEnvironment env) {
        if (TypeMirrorUtil.isSameType(type, Function.class, env)) {
            return TypeMirrorUtil.toDeclaredType(type, env);
        }
        for (TypeMirror typeMirror : env.getTypeUtils().directSupertypes(type)) {
            if (TypeMirrorUtil.isSameType(typeMirror, Function.class, env)) {
                return TypeMirrorUtil.toDeclaredType(typeMirror, env);
            }
            DeclaredType result = FunctionCtType.getFunctionDeclaredType(typeMirror, env);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public <R, P, TH extends Throwable> R accept(CtTypeVisitor<R, P, TH> visitor, P p) throws TH {
        return visitor.visitFunctionCtType(this, p);
    }
}

