/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.cttype;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collector;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.cttype.AbstractCtType;
import org.seasar.doma.internal.apt.cttype.AnyCtType;
import org.seasar.doma.internal.apt.cttype.BasicCtType;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.CtTypeVisitor;
import org.seasar.doma.internal.apt.cttype.DomainCtType;
import org.seasar.doma.internal.apt.cttype.EntityCtType;
import org.seasar.doma.internal.apt.cttype.MapCtType;
import org.seasar.doma.internal.apt.cttype.OptionalCtType;
import org.seasar.doma.internal.apt.cttype.OptionalDoubleCtType;
import org.seasar.doma.internal.apt.cttype.OptionalIntCtType;
import org.seasar.doma.internal.apt.cttype.OptionalLongCtType;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public class CollectorCtType
extends AbstractCtType {
    protected CtType targetCtType;
    protected AnyCtType returnCtType;

    public CollectorCtType(TypeMirror type, ProcessingEnvironment env) {
        super(type, env);
    }

    public CtType getTargetCtType() {
        return this.targetCtType;
    }

    public AnyCtType getReturnCtType() {
        return this.returnCtType;
    }

    public boolean isRawType() {
        return this.returnCtType.getTypeMirror() == null || this.targetCtType.getTypeMirror() == null;
    }

    public boolean isWildcardType() {
        return this.returnCtType.getTypeMirror() != null && this.returnCtType.getTypeMirror().getKind() == TypeKind.WILDCARD || this.targetCtType.getTypeMirror() != null && this.targetCtType.getTypeMirror().getKind() == TypeKind.WILDCARD;
    }

    public static CollectorCtType newInstance(TypeMirror type, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull((Object)type, (Object)env);
        DeclaredType collectorDeclaredType = CollectorCtType.getCollectorDeclaredType(type, env);
        if (collectorDeclaredType == null) {
            return null;
        }
        CollectorCtType collectorCtType = new CollectorCtType(type, env);
        List<? extends TypeMirror> typeArguments = collectorDeclaredType.getTypeArguments();
        if (typeArguments.size() == 3) {
            TypeMirror targetTypeMirror = typeArguments.get(0);
            TypeMirror returnTypeMirror = typeArguments.get(2);
            collectorCtType.targetCtType = CollectorCtType.buildCtTypeSuppliers(targetTypeMirror, env).stream().map(Supplier::get).filter(Objects::nonNull).findFirst().get();
            collectorCtType.returnCtType = AnyCtType.newInstance(returnTypeMirror, env);
        }
        return collectorCtType;
    }

    protected static DeclaredType getCollectorDeclaredType(TypeMirror type, ProcessingEnvironment env) {
        if (TypeMirrorUtil.isSameType(type, Collector.class, env)) {
            return TypeMirrorUtil.toDeclaredType(type, env);
        }
        for (TypeMirror typeMirror : env.getTypeUtils().directSupertypes(type)) {
            if (TypeMirrorUtil.isSameType(typeMirror, Collector.class, env)) {
                return TypeMirrorUtil.toDeclaredType(typeMirror, env);
            }
            DeclaredType result = CollectorCtType.getCollectorDeclaredType(typeMirror, env);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected static List<Supplier<CtType>> buildCtTypeSuppliers(TypeMirror typeMirror, ProcessingEnvironment env) {
        return Arrays.asList(() -> EntityCtType.newInstance(typeMirror, env), () -> OptionalCtType.newInstance(typeMirror, env), () -> OptionalIntCtType.newInstance(typeMirror, env), () -> OptionalLongCtType.newInstance(typeMirror, env), () -> OptionalDoubleCtType.newInstance(typeMirror, env), () -> DomainCtType.newInstance(typeMirror, env), () -> BasicCtType.newInstance(typeMirror, env), () -> MapCtType.newInstance(typeMirror, env), () -> AnyCtType.newInstance(typeMirror, env));
    }

    @Override
    public <R, P, TH extends Throwable> R accept(CtTypeVisitor<R, P, TH> visitor, P p) throws TH {
        return visitor.visitCollectorCtType(this, p);
    }
}

