/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.cttype;

import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.cttype.AbstractCtType;
import org.seasar.doma.internal.apt.cttype.AnyCtType;
import org.seasar.doma.internal.apt.cttype.ConfigCtType;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.CtTypeVisitor;
import org.seasar.doma.internal.apt.cttype.PreparedSqlCtType;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public class BiFunctionCtType
extends AbstractCtType {
    protected final boolean isRawType;
    protected CtType firstArgCtType;
    protected CtType secondArgCtType;
    protected AnyCtType resultCtType;

    public BiFunctionCtType(TypeMirror type, ProcessingEnvironment env, boolean isRawType) {
        super(type, env);
        this.isRawType = isRawType;
    }

    public CtType getFirstArgCtType() {
        return this.firstArgCtType;
    }

    public CtType getSecondArgCtType() {
        return this.secondArgCtType;
    }

    public AnyCtType getResultCtType() {
        return this.resultCtType;
    }

    public boolean isRawType() {
        return this.isRawType;
    }

    public boolean isWildcardType() {
        return this.resultCtType.getTypeMirror() != null && this.resultCtType.getTypeMirror().getKind() == TypeKind.WILDCARD || this.firstArgCtType.getTypeMirror() != null && this.firstArgCtType.getTypeMirror().getKind() == TypeKind.WILDCARD || this.secondArgCtType.getTypeMirror() != null && this.secondArgCtType.getTypeMirror().getKind() == TypeKind.WILDCARD;
    }

    public static BiFunctionCtType newInstance(TypeMirror type, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull((Object)type, (Object)env);
        DeclaredType biFunctionDeclaredType = BiFunctionCtType.getBiFunctionDeclaredType(type, env);
        if (biFunctionDeclaredType == null) {
            return null;
        }
        List<? extends TypeMirror> typeArguments = biFunctionDeclaredType.getTypeArguments();
        boolean isRawType = typeArguments.size() != 3;
        BiFunctionCtType biFunctionCtType = new BiFunctionCtType(type, env, isRawType);
        if (!isRawType) {
            TypeMirror firstArgTypeMirror = typeArguments.get(0);
            TypeMirror secondArgTypeMirror = typeArguments.get(1);
            TypeMirror resultTypeMirror = typeArguments.get(2);
            biFunctionCtType.firstArgCtType = ConfigCtType.newInstance(firstArgTypeMirror, env);
            if (biFunctionCtType.firstArgCtType == null) {
                biFunctionCtType.firstArgCtType = AnyCtType.newInstance(firstArgTypeMirror, env);
            }
            biFunctionCtType.secondArgCtType = PreparedSqlCtType.newInstance(secondArgTypeMirror, env);
            if (biFunctionCtType.secondArgCtType == null) {
                biFunctionCtType.secondArgCtType = AnyCtType.newInstance(secondArgTypeMirror, env);
            }
            biFunctionCtType.resultCtType = AnyCtType.newInstance(resultTypeMirror, env);
        }
        return biFunctionCtType;
    }

    protected static DeclaredType getBiFunctionDeclaredType(TypeMirror type, ProcessingEnvironment env) {
        if (TypeMirrorUtil.isSameType(type, BiFunction.class, env)) {
            return TypeMirrorUtil.toDeclaredType(type, env);
        }
        for (TypeMirror typeMirror : env.getTypeUtils().directSupertypes(type)) {
            if (TypeMirrorUtil.isSameType(typeMirror, BiFunction.class, env)) {
                return TypeMirrorUtil.toDeclaredType(typeMirror, env);
            }
            DeclaredType result = BiFunctionCtType.getBiFunctionDeclaredType(typeMirror, env);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public <R, P, TH extends Throwable> R accept(CtTypeVisitor<R, P, TH> visitor, P p) throws TH {
        return visitor.visitBiFunctionCtType(this, p);
    }
}

