/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.cttype;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.cttype.AbstractCtType;
import org.seasar.doma.internal.apt.cttype.CtTypeVisitor;
import org.seasar.doma.internal.apt.cttype.WrapperCtType;
import org.seasar.doma.internal.util.AssertionUtil;

public class BasicCtType
extends AbstractCtType {
    protected WrapperCtType wrapperCtType;

    public BasicCtType(TypeMirror type, ProcessingEnvironment env) {
        super(type, env);
    }

    public WrapperCtType getWrapperCtType() {
        return this.wrapperCtType;
    }

    public String getDefaultValue() {
        switch (this.typeMirror.getKind()) {
            case BOOLEAN: {
                return String.valueOf(false);
            }
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case CHAR: {
                return "0";
            }
        }
        return "null";
    }

    public static BasicCtType newInstance(TypeMirror type, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull((Object)type, (Object)env);
        BasicCtType basicCtType = new BasicCtType(type, env);
        WrapperCtType wrapperCtType = WrapperCtType.newInstance(basicCtType, env);
        if (wrapperCtType == null) {
            return null;
        }
        basicCtType.wrapperCtType = wrapperCtType;
        return basicCtType;
    }

    @Override
    public <R, P, TH extends Throwable> R accept(CtTypeVisitor<R, P, TH> visitor, P p) throws TH {
        return visitor.visitBasicCtType(this, p);
    }
}

