/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.cttype;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.util.ElementUtil;
import org.seasar.doma.internal.apt.util.MetaUtil;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public abstract class AbstractCtType
implements CtType {
    protected final TypeMirror typeMirror;
    protected final ProcessingEnvironment env;
    protected final String typeName;
    protected final String boxedTypeName;
    protected final String metaTypeName;
    protected final TypeElement typeElement;
    protected final String packageName;
    protected final String packageExcludedBinaryName;
    protected final String qualifiedName;

    protected AbstractCtType(TypeMirror typeMirror, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull((Object)typeMirror, (Object)env);
        this.typeMirror = typeMirror;
        this.env = env;
        this.typeName = TypeMirrorUtil.getTypeName(typeMirror, env);
        this.boxedTypeName = TypeMirrorUtil.getBoxedTypeName(typeMirror, env);
        this.metaTypeName = AbstractCtType.getMetaTypeName(typeMirror, env);
        this.typeElement = TypeMirrorUtil.toTypeElement(typeMirror, env);
        if (this.typeElement != null) {
            this.qualifiedName = this.typeElement.getQualifiedName().toString();
            this.packageName = ElementUtil.getPackageName(this.typeElement, env);
            this.packageExcludedBinaryName = ElementUtil.getPackageExcludedBinaryName(this.typeElement, env);
        } else {
            this.qualifiedName = this.typeName;
            this.packageName = "";
            this.packageExcludedBinaryName = this.typeName;
        }
    }

    private static String getMetaTypeName(TypeMirror typeMirror, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull((Object)typeMirror, (Object)env);
        String typeName = TypeMirrorUtil.getTypeName(typeMirror, env);
        TypeElement typeElement = TypeMirrorUtil.toTypeElement(typeMirror, env);
        if (typeElement == null) {
            return typeName;
        }
        return MetaUtil.toFullMetaName(typeElement, env) + AbstractCtType.makeTypeParamDecl(typeName);
    }

    private static String makeTypeParamDecl(String typeName) {
        int pos = typeName.indexOf("<");
        if (pos == -1) {
            return "";
        }
        return typeName.substring(pos);
    }

    @Override
    public TypeMirror getTypeMirror() {
        return this.typeMirror;
    }

    @Override
    public TypeElement getTypeElement() {
        return this.typeElement;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public String getBoxedTypeName() {
        return this.boxedTypeName;
    }

    @Override
    public String getMetaTypeName() {
        return this.metaTypeName;
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public String getPackageExcludedBinaryName() {
        return this.packageExcludedBinaryName;
    }

    @Override
    public boolean isEnum() {
        return this.typeElement != null && this.typeElement.getKind() == ElementKind.ENUM;
    }

    @Override
    public boolean isPrimitive() {
        return this.typeMirror.getKind().isPrimitive();
    }
}

