/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.ExpressionValidator;
import org.seasar.doma.internal.apt.Notifier;
import org.seasar.doma.internal.apt.cttype.BasicCtType;
import org.seasar.doma.internal.apt.cttype.DomainCtType;
import org.seasar.doma.internal.apt.cttype.IterableCtType;
import org.seasar.doma.internal.apt.cttype.SimpleCtTypeVisitor;
import org.seasar.doma.internal.apt.decl.TypeDeclaration;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.expr.ExpressionException;
import org.seasar.doma.internal.expr.ExpressionParser;
import org.seasar.doma.internal.expr.node.ExpressionNode;
import org.seasar.doma.internal.jdbc.sql.SimpleSqlNodeVisitor;
import org.seasar.doma.internal.jdbc.sql.node.BindVariableNode;
import org.seasar.doma.internal.jdbc.sql.node.ElseifNode;
import org.seasar.doma.internal.jdbc.sql.node.EmbeddedVariableNode;
import org.seasar.doma.internal.jdbc.sql.node.ExpandNode;
import org.seasar.doma.internal.jdbc.sql.node.ForNode;
import org.seasar.doma.internal.jdbc.sql.node.IfNode;
import org.seasar.doma.internal.jdbc.sql.node.LiteralVariableNode;
import org.seasar.doma.internal.jdbc.sql.node.PopulateNode;
import org.seasar.doma.internal.jdbc.sql.node.SqlLocation;
import org.seasar.doma.internal.jdbc.sql.node.ValueNode;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class SqlValidator
extends SimpleSqlNodeVisitor<Void, Void> {
    protected static final int SQL_MAX_LENGTH = 5000;
    protected final ProcessingEnvironment env;
    protected final ExecutableElement methodElement;
    protected final LinkedHashMap<String, TypeMirror> parameterTypeMap;
    protected final String path;
    protected final boolean expandable;
    protected final boolean populatable;
    protected final ExpressionValidator expressionValidator;

    public SqlValidator(ProcessingEnvironment env, ExecutableElement methodElement, LinkedHashMap<String, TypeMirror> parameterTypeMap, String path, boolean expandable, boolean populatable) {
        AssertionUtil.assertNotNull((Object)env, (Object)methodElement, parameterTypeMap, (Object)path);
        this.env = env;
        this.methodElement = methodElement;
        this.parameterTypeMap = parameterTypeMap;
        this.path = path;
        this.expandable = expandable;
        this.populatable = populatable;
        this.expressionValidator = new ExpressionValidator(env, methodElement, parameterTypeMap);
    }

    public void validate(SqlNode sqlNode) {
        try {
            sqlNode.accept(this, null);
            Set<String> validatedParameterNames = this.expressionValidator.getValidatedParameterNames();
            for (String parameterName : this.parameterTypeMap.keySet()) {
                if (validatedParameterNames.contains(parameterName)) continue;
                for (VariableElement variableElement : this.methodElement.getParameters()) {
                    if (!variableElement.getSimpleName().contentEquals(parameterName)) continue;
                    Notifier.notify(this.env, Diagnostic.Kind.ERROR, Message.DOMA4122, variableElement, new Object[]{this.path, parameterName});
                }
            }
        }
        catch (AptIllegalStateException e) {
            throw e;
        }
        catch (AptException e) {
            Notifier.notify(this.env, e);
        }
    }

    @Override
    public Void visitBindVariableNode(BindVariableNode node, Void p) {
        return this.visitValueNode(node, p);
    }

    @Override
    public Void visitLiteralVariableNode(LiteralVariableNode node, Void p) {
        return this.visitValueNode(node, p);
    }

    protected Void visitValueNode(ValueNode node, Void p) {
        SqlLocation location = node.getLocation();
        String variableName = node.getVariableName();
        TypeDeclaration typeDeclaration = this.validateExpressionVariable(location, variableName);
        if (node.getWordNode() != null) {
            if (!this.isScalar(typeDeclaration)) {
                String sql = this.getSql(location);
                throw new AptException((MessageResource)Message.DOMA4153, this.env, this.methodElement, new Object[]{this.path, sql, location.getLineNumber(), location.getPosition(), variableName, typeDeclaration.getBinaryName()});
            }
        } else if (!this.isScalarIterable(typeDeclaration)) {
            String sql = this.getSql(location);
            this.env.getMessager().printMessage(Diagnostic.Kind.NOTE, this.parameterTypeMap.toString());
            throw new AptException((MessageResource)Message.DOMA4161, this.env, this.methodElement, new Object[]{this.path, sql, location.getLineNumber(), location.getPosition(), variableName, typeDeclaration.getBinaryName()});
        }
        this.visitNode(node, p);
        return null;
    }

    protected boolean isScalar(TypeDeclaration typeDeclaration) {
        TypeMirror typeMirror = typeDeclaration.getType();
        return BasicCtType.newInstance(typeMirror, this.env) != null || DomainCtType.newInstance(typeMirror, this.env) != null;
    }

    protected boolean isScalarIterable(TypeDeclaration typeDeclaration) {
        TypeMirror typeMirror = typeDeclaration.getType();
        IterableCtType iterableCtType = IterableCtType.newInstance(typeMirror, this.env);
        if (iterableCtType != null) {
            return iterableCtType.getElementCtType().accept(new SimpleCtTypeVisitor<Boolean, Void, RuntimeException>(Boolean.valueOf(false)){

                @Override
                public Boolean visitBasicCtType(BasicCtType ctType, Void p) throws RuntimeException {
                    return true;
                }

                @Override
                public Boolean visitDomainCtType(DomainCtType ctType, Void p) throws RuntimeException {
                    return true;
                }
            }, null);
        }
        return false;
    }

    @Override
    public Void visitEmbeddedVariableNode(EmbeddedVariableNode node, Void p) {
        SqlLocation location = node.getLocation();
        String variableName = node.getVariableName();
        this.validateExpressionVariable(location, variableName);
        this.visitNode(node, p);
        return null;
    }

    @Override
    public Void visitIfNode(IfNode node, Void p) {
        String expression;
        SqlLocation location = node.getLocation();
        TypeDeclaration typeDeclaration = this.validateExpressionVariable(location, expression = node.getExpression());
        if (!typeDeclaration.isBooleanType()) {
            String sql = this.getSql(location);
            throw new AptException((MessageResource)Message.DOMA4140, this.env, this.methodElement, new Object[]{this.path, sql, location.getLineNumber(), location.getPosition(), expression, typeDeclaration.getBinaryName()});
        }
        this.visitNode(node, p);
        return null;
    }

    @Override
    public Void visitElseifNode(ElseifNode node, Void p) {
        String expression;
        SqlLocation location = node.getLocation();
        TypeDeclaration typeDeclaration = this.validateExpressionVariable(location, expression = node.getExpression());
        if (!typeDeclaration.isBooleanType()) {
            String sql = this.getSql(location);
            throw new AptException((MessageResource)Message.DOMA4141, this.env, this.methodElement, new Object[]{this.path, sql, location.getLineNumber(), location.getPosition(), expression, typeDeclaration.getBinaryName()});
        }
        this.visitNode(node, p);
        return null;
    }

    @Override
    public Void visitForNode(ForNode node, Void p) {
        SqlLocation location = node.getLocation();
        String identifier = node.getIdentifier();
        String expression = node.getExpression();
        TypeDeclaration typeDeclaration = this.validateExpressionVariable(location, expression);
        TypeMirror typeMirror = typeDeclaration.getType();
        if (!TypeMirrorUtil.isAssignable(typeMirror, Iterable.class, this.env)) {
            String sql = this.getSql(location);
            throw new AptException((MessageResource)Message.DOMA4149, this.env, this.methodElement, new Object[]{this.path, sql, location.getLineNumber(), location.getPosition(), expression, typeDeclaration.getBinaryName()});
        }
        DeclaredType declaredType = TypeMirrorUtil.toDeclaredType(typeMirror, this.env);
        List<? extends TypeMirror> typeArgs = declaredType.getTypeArguments();
        if (typeArgs.isEmpty()) {
            String sql = this.getSql(location);
            throw new AptException((MessageResource)Message.DOMA4150, this.env, this.methodElement, new Object[]{this.path, sql, location.getLineNumber(), location.getPosition(), expression, typeDeclaration.getBinaryName()});
        }
        TypeMirror originalIdentifierType = this.expressionValidator.removeParameterType(identifier);
        this.expressionValidator.putParameterType(identifier, typeArgs.get(0));
        String hasNextVariable = identifier + "_has_next";
        TypeMirror originalHasNextType = this.expressionValidator.removeParameterType(hasNextVariable);
        this.expressionValidator.putParameterType(hasNextVariable, TypeMirrorUtil.getTypeMirror(Boolean.TYPE, this.env));
        String indexVariable = identifier + "_index";
        TypeMirror originalIndexType = this.expressionValidator.removeParameterType(indexVariable);
        this.expressionValidator.putParameterType(indexVariable, TypeMirrorUtil.getTypeMirror(Integer.TYPE, this.env));
        this.visitNode(node, p);
        if (originalIdentifierType == null) {
            this.expressionValidator.removeParameterType(identifier);
        } else {
            this.expressionValidator.putParameterType(identifier, originalIdentifierType);
        }
        if (originalHasNextType == null) {
            this.expressionValidator.removeParameterType(hasNextVariable);
        } else {
            this.expressionValidator.putParameterType(hasNextVariable, originalHasNextType);
        }
        if (originalIndexType == null) {
            this.expressionValidator.removeParameterType(indexVariable);
        } else {
            this.expressionValidator.putParameterType(indexVariable, originalIndexType);
        }
        return null;
    }

    @Override
    public Void visitExpandNode(ExpandNode node, Void p) {
        if (!this.expandable) {
            SqlLocation location = node.getLocation();
            String sql = this.getSql(location);
            throw new AptException((MessageResource)Message.DOMA4257, this.env, this.methodElement, new Object[]{this.path, sql, location.getLineNumber(), location.getPosition()});
        }
        return this.visitNode(node, p);
    }

    @Override
    public Void visitPopulateNode(PopulateNode node, Void p) {
        if (!this.populatable) {
            SqlLocation location = node.getLocation();
            String sql = this.getSql(location);
            throw new AptException((MessageResource)Message.DOMA4270, this.env, this.methodElement, new Object[]{this.path, sql, location.getLineNumber(), location.getPosition()});
        }
        Iterator<String> it = this.parameterTypeMap.keySet().iterator();
        if (it.hasNext()) {
            this.expressionValidator.addValidatedParameterName(it.next());
        }
        return this.visitNode(node, p);
    }

    @Override
    protected Void defaultAction(SqlNode node, Void p) {
        return this.visitNode(node, p);
    }

    protected Void visitNode(SqlNode node, Void p) {
        for (SqlNode child : node.getChildren()) {
            child.accept(this, p);
        }
        return null;
    }

    protected TypeDeclaration validateExpressionVariable(SqlLocation location, String expression) {
        ExpressionNode expressionNode = this.parseExpression(location, expression);
        try {
            return this.expressionValidator.validate(expressionNode);
        }
        catch (AptIllegalStateException e) {
            throw e;
        }
        catch (AptException e) {
            String sql = this.getSql(location);
            throw new AptException((MessageResource)Message.DOMA4092, this.env, this.methodElement, new Object[]{this.path, sql, location.getLineNumber(), location.getPosition(), e.getMessage()});
        }
    }

    protected ExpressionNode parseExpression(SqlLocation location, String expression) {
        try {
            ExpressionParser parser = new ExpressionParser(expression);
            return parser.parse();
        }
        catch (ExpressionException e) {
            String sql = this.getSql(location);
            throw new AptException((MessageResource)Message.DOMA4092, this.env, this.methodElement, new Object[]{this.path, sql, location.getLineNumber(), location.getPosition(), e.getMessage()});
        }
    }

    protected String getSql(SqlLocation location) {
        String sql = location.getSql();
        if (sql != null && sql.length() > 5000) {
            sql = sql.substring(0, 5000);
            sql = sql + Message.DOMA4185.getSimpleMessage(5000);
        }
        return sql;
    }
}

