/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.seasar.doma.SingletonConfig;
import org.seasar.doma.internal.apt.AbstractProcessor;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.mirror.SingletonConfigMirror;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

@SupportedAnnotationTypes(value={"org.seasar.doma.SingletonConfig"})
@SupportedOptions(value={"doma.resources.dir", "doma.test", "doma.debug"})
public class SingletonConfigProcessor
extends AbstractProcessor {
    public SingletonConfigProcessor() {
        super(SingletonConfig.class);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return true;
        }
        for (TypeElement typeElement : annotations) {
            for (TypeElement typeElement2 : ElementFilter.typesIn(roundEnv.getElementsAnnotatedWith(typeElement))) {
                this.handleTypeElement(typeElement2, this::validate);
            }
        }
        return true;
    }

    protected void validate(TypeElement typeElement) {
        SingletonConfigMirror mirror = SingletonConfigMirror.newInstance(typeElement, this.processingEnv);
        if (mirror == null) {
            throw new AptIllegalStateException("mirror must not be null");
        }
        this.validateClass(typeElement, mirror);
        this.validateConstructors(typeElement);
        this.validateMethod(typeElement, mirror.getMethodValue());
    }

    protected void validateClass(TypeElement typeElement, SingletonConfigMirror mirror) {
        if (!TypeMirrorUtil.isAssignable(typeElement.asType(), Config.class, this.processingEnv)) {
            throw new AptException((MessageResource)Message.DOMA4253, this.processingEnv, (Element)typeElement, mirror.getAnnotationMirror(), new Object[]{typeElement.getQualifiedName()});
        }
    }

    protected void validateConstructors(TypeElement typeElement) {
        ElementFilter.constructorsIn(typeElement.getEnclosedElements()).stream().filter(c -> !c.getModifiers().contains((Object)Modifier.PRIVATE)).findAny().ifPresent(c -> {
            throw new AptException((MessageResource)Message.DOMA4256, this.processingEnv, (Element)c, new Object[]{typeElement.getQualifiedName()});
        });
    }

    protected void validateMethod(TypeElement typeElement, String methodName) {
        Optional<ExecutableElement> method = ElementFilter.methodsIn(typeElement.getEnclosedElements()).stream().filter(m -> m.getModifiers().containsAll(EnumSet.of(Modifier.STATIC, Modifier.PUBLIC))).filter(m -> TypeMirrorUtil.isAssignable(m.getReturnType(), Config.class, this.processingEnv)).filter(m -> m.getParameters().isEmpty()).filter(m -> m.getSimpleName().toString().equals(methodName)).findAny();
        if (!method.isPresent()) {
            throw new AptException((MessageResource)Message.DOMA4254, this.processingEnv, typeElement, new Object[]{methodName, typeElement.getQualifiedName()});
        }
    }
}

