/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.processing.ProcessingEnvironment;
import javax.tools.FileObject;
import org.seasar.doma.internal.Artifact;
import org.seasar.doma.internal.apt.util.ResourceUtil;

public final class Options {
    public static final String TEST = "doma.test";
    public static final String DEBUG = "doma.debug";
    public static final String DAO_PACKAGE = "doma.dao.package";
    public static final String DAO_SUBPACKAGE = "doma.dao.subpackage";
    public static final String DAO_SUFFIX = "doma.dao.suffix";
    public static final String ENTITY_FIELD_PREFIX = "doma.entity.field.prefix";
    public static final String EXPR_FUNCTIONS = "doma.expr.functions";
    public static final String DOMAIN_CONVERTERS = "doma.domain.converters";
    public static final String SQL_VALIDATION = "doma.sql.validation";
    public static final String VERSION_VALIDATION = "doma.version.validation";
    public static final String CONFIG_PATH = "doma.config.path";
    public static final String RESOURCES_DIR = "doma.resources.dir";
    public static final String LOMBOK_ALL_ARGS_CONSTRUCTOR = "doma.lombok.AllArgsConstructor";
    public static final String LOMBOK_VALUE = "doma.lombok.Value";
    private static Map<String, Map<String, String>> configCache = new ConcurrentHashMap<String, Map<String, String>>();

    public static boolean isTestEnabled(ProcessingEnvironment env) {
        String test = Options.getOption(env, TEST);
        return Boolean.valueOf(test);
    }

    public static String getVersion(ProcessingEnvironment env) {
        if (Options.isTestEnabled(env)) {
            return "@VERSION@";
        }
        return Artifact.getVersion();
    }

    public static Date getDate(ProcessingEnvironment env) {
        if (Options.isTestEnabled(env)) {
            return new Date(0L);
        }
        return new Date();
    }

    public static boolean isDebugEnabled(ProcessingEnvironment env) {
        String debug = Options.getOption(env, DEBUG);
        return Boolean.valueOf(debug);
    }

    public static String getDaoPackage(ProcessingEnvironment env) {
        String pkg = Options.getOption(env, DAO_PACKAGE);
        return pkg != null ? pkg : null;
    }

    public static String getDaoSubpackage(ProcessingEnvironment env) {
        String subpackage = Options.getOption(env, DAO_SUBPACKAGE);
        return subpackage != null ? subpackage : null;
    }

    public static String getDaoSuffix(ProcessingEnvironment env) {
        String suffix = Options.getOption(env, DAO_SUFFIX);
        return suffix != null ? suffix : "Impl";
    }

    public static String getEntityFieldPrefix(ProcessingEnvironment env) {
        String prefix = Options.getOption(env, ENTITY_FIELD_PREFIX);
        if ("none".equalsIgnoreCase(prefix)) {
            return "";
        }
        return prefix != null ? prefix : "$";
    }

    public static String getExprFunctions(ProcessingEnvironment env) {
        String name = Options.getOption(env, EXPR_FUNCTIONS);
        return name != null ? name : null;
    }

    public static String getDomainConverters(ProcessingEnvironment env) {
        String converters = Options.getOption(env, DOMAIN_CONVERTERS);
        return converters != null ? converters : null;
    }

    public static boolean getSqlValidation(ProcessingEnvironment env) {
        String v = Options.getOption(env, SQL_VALIDATION);
        return v != null ? Boolean.valueOf(v) : true;
    }

    public static boolean getVersionValidation(ProcessingEnvironment env) {
        String v = Options.getOption(env, VERSION_VALIDATION);
        return v != null ? Boolean.valueOf(v) : true;
    }

    public static String getConfigPath(ProcessingEnvironment env) {
        String configPath = env.getOptions().get(CONFIG_PATH);
        return configPath != null ? configPath : "doma.compile.config";
    }

    public static String getLombokAllArgsConstructor(ProcessingEnvironment env) {
        String name = Options.getOption(env, LOMBOK_ALL_ARGS_CONSTRUCTOR);
        return name != null ? name : "lombok.AllArgsConstructor";
    }

    public static String getLombokValue(ProcessingEnvironment env) {
        String name = Options.getOption(env, LOMBOK_VALUE);
        return name != null ? name : "lombok.Value";
    }

    private static String getOption(ProcessingEnvironment env, String key) {
        String v = env.getOptions().get(key);
        if (v != null) {
            return v;
        }
        return Options.getConfig(env).get(key);
    }

    private static Map<String, String> getConfig(ProcessingEnvironment env) {
        FileObject config = Options.getFileObject(env, Options.getConfigPath(env));
        if (config == null) {
            return Collections.emptyMap();
        }
        return configCache.computeIfAbsent(config.toUri().getPath(), configPath -> {
            try {
                return Options.loadProperties(config);
            }
            catch (IOException e) {
                return Collections.emptyMap();
            }
        });
    }

    private static FileObject getFileObject(ProcessingEnvironment env, String path) {
        try {
            return ResourceUtil.getResource(path, env);
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    private static Map<String, String> loadProperties(FileObject config) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected static class Constants {
        public static final String DEFAULT_DAO_SUFFIX = "Impl";
        public static final String DEFAULT_ENTITY_FIELD_PREFIX = "$";
        public static final String DEFAULT_CONFIG_PATH = "doma.compile.config";
        public static final String DEFAULT_LOMBOK_ALL_ARGS_CONSTRUCTOR = "lombok.AllArgsConstructor";
        public static final String DEFAULT_LOMBOK_VALUE = "lombok.Value";

        protected Constants() {
        }
    }
}

