/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import java.io.IOException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import org.seasar.doma.internal.apt.AbstractGenerator;
import org.seasar.doma.internal.apt.meta.ExternalDomainMeta;
import org.seasar.doma.internal.apt.util.ElementUtil;
import org.seasar.doma.internal.apt.util.MetaUtil;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.domain.AbstractDomainType;

public class ExternalDomainTypeGenerator
extends AbstractGenerator {
    protected final ExternalDomainMeta domainMeta;
    protected final String domainTypeName;
    protected final String simpleMetaClassName;
    protected final String typeParamDecl;
    protected final boolean parametarized;

    public ExternalDomainTypeGenerator(ProcessingEnvironment env, TypeElement typeElement, ExternalDomainMeta domainMeta) throws IOException {
        super(env, typeElement, "__." + ElementUtil.getPackageName(typeElement, env), null, "_", "");
        AssertionUtil.assertNotNull(domainMeta);
        this.domainMeta = domainMeta;
        this.domainTypeName = TypeMirrorUtil.getTypeName(domainMeta.getDomainElement().asType(), env);
        this.simpleMetaClassName = MetaUtil.toSimpleMetaName(typeElement, env);
        this.typeParamDecl = this.makeTypeParamDecl(this.domainTypeName);
        this.parametarized = !domainMeta.getDomainElement().getTypeParameters().isEmpty();
    }

    private String makeTypeParamDecl(String typeName) {
        int pos = typeName.indexOf("<");
        if (pos == -1) {
            return "";
        }
        return typeName.substring(pos);
    }

    @Override
    public void generate() {
        this.printPackage();
        this.printClass();
    }

    protected void printPackage() {
        if (!this.packageName.isEmpty()) {
            this.iprint("package %1$s;%n", this.packageName);
            this.iprint("%n", new Object[0]);
        }
    }

    protected void printClass() {
        if (this.domainMeta.getDomainElement().getTypeParameters().isEmpty()) {
            this.iprint("/** */%n", new Object[0]);
        } else {
            this.iprint("/**%n", new Object[0]);
            for (TypeParameterElement typeParameterElement : this.domainMeta.getDomainElement().getTypeParameters()) {
                this.iprint(" * @param <%1$s> %1$s%n", typeParameterElement.getSimpleName());
            }
            this.iprint(" */%n", new Object[0]);
        }
        this.printGenerated();
        this.iprint("public final class %1$s%5$s extends %2$s<%3$s, %4$s> {%n", this.simpleMetaClassName, AbstractDomainType.class.getName(), this.domainMeta.getValueTypeName(), this.domainTypeName, this.typeParamDecl);
        this.print("%n", new Object[0]);
        this.indent();
        this.printValidateVersionStaticInitializer();
        this.printFields();
        this.printConstructors();
        this.printMethods();
        this.unindent();
        this.unindent();
        this.iprint("}%n", new Object[0]);
    }

    protected void printFields() {
        if (this.parametarized) {
            this.iprint("@SuppressWarnings(\"rawtypes\")%n", new Object[0]);
        }
        this.iprint("private static final %1$s singleton = new %1$s();%n", this.simpleName);
        this.print("%n", new Object[0]);
        this.iprint("private static final %1$s converter = new %1$s();%n", this.domainMeta.getTypeElement().getQualifiedName());
        this.print("%n", new Object[0]);
    }

    protected void printConstructors() {
        this.iprint("private %1$s() {%n", this.simpleName);
        if (this.domainMeta.getWrapperCtType().getBasicCtType().isEnum()) {
            this.iprint("    super(() -> new %1$s(%2$s.class));%n", this.domainMeta.getWrapperCtType().getTypeName(), this.domainMeta.getValueTypeName());
            this.iprint("}%n", new Object[0]);
        } else {
            this.iprint("    super(() -> new %1$s());%n", this.domainMeta.getWrapperCtType().getTypeName());
            this.iprint("}%n", new Object[0]);
        }
        this.print("%n", new Object[0]);
    }

    protected void printMethods() {
        this.printNewDomainMethod();
        this.printGetBasicValueMethod();
        this.printGetBasicClassMethod();
        this.printGetDomainClassMethod();
        this.printGetSingletonInternalMethod();
    }

    protected void printNewDomainMethod() {
        if (this.parametarized) {
            this.iprint("@SuppressWarnings(\"unchecked\")%n", new Object[0]);
        }
        this.iprint("@Override%n", new Object[0]);
        this.iprint("protected %1$s newDomain(%2$s value) {%n", this.domainTypeName, this.domainMeta.getValueTypeName());
        if (this.parametarized) {
            this.iprint("    return (%1$s) converter.fromValueToDomain(value);%n", this.domainTypeName);
        } else {
            this.iprint("    return converter.fromValueToDomain(value);%n", new Object[0]);
        }
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printGetBasicValueMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("protected %1$s getBasicValue(%2$s domain) {%n", this.domainMeta.getValueTypeName(), this.domainTypeName);
        this.iprint("    if (domain == null) {%n", new Object[0]);
        this.iprint("        return null;%n", new Object[0]);
        this.iprint("    }%n", new Object[0]);
        this.iprint("    return converter.fromDomainToValue(domain);%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printGetBasicClassMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public Class<?> getBasicClass() {%n", new Object[0]);
        this.iprint("    return %1$s.class;%n", this.domainMeta.getValueTypeName());
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printGetDomainClassMethod() {
        if (this.parametarized) {
            this.iprint("@SuppressWarnings(\"unchecked\")%n", new Object[0]);
        }
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public Class<%1$s> getDomainClass() {%n", this.domainTypeName);
        if (this.parametarized) {
            this.iprint("    Class<?> clazz = %1$s.class;%n", this.domainMeta.getDomainElement().getQualifiedName());
            this.iprint("    return (Class<%1$s>) clazz;%n", this.domainTypeName);
        } else {
            this.iprint("    return %1$s.class;%n", this.domainMeta.getDomainElement().getQualifiedName());
        }
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printGetSingletonInternalMethod() {
        this.iprint("/**%n", new Object[0]);
        this.iprint(" * @return the singleton%n", new Object[0]);
        this.iprint(" */%n", new Object[0]);
        if (this.parametarized) {
            this.iprint("@SuppressWarnings(\"unchecked\")%n", new Object[0]);
            this.iprint("public static %1$s %2$s%1$s getSingletonInternal() {%n", this.typeParamDecl, this.simpleMetaClassName);
            this.iprint("    return (%2$s%1$s) singleton;%n", this.typeParamDecl, this.simpleMetaClassName);
        } else {
            this.iprint("public static %1$s getSingletonInternal() {%n", this.simpleMetaClassName);
            this.iprint("    return singleton;%n", new Object[0]);
        }
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }
}

