/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.expr.ExpressionFunctions;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.Options;
import org.seasar.doma.internal.apt.decl.ConstructorDeclaration;
import org.seasar.doma.internal.apt.decl.FieldDeclaration;
import org.seasar.doma.internal.apt.decl.MethodDeclaration;
import org.seasar.doma.internal.apt.decl.TypeDeclaration;
import org.seasar.doma.internal.apt.decl.TypeParameterDeclaration;
import org.seasar.doma.internal.apt.util.ElementUtil;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.expr.node.AddOperatorNode;
import org.seasar.doma.internal.expr.node.AndOperatorNode;
import org.seasar.doma.internal.expr.node.ArithmeticOperatorNode;
import org.seasar.doma.internal.expr.node.CommaOperatorNode;
import org.seasar.doma.internal.expr.node.ComparisonOperatorNode;
import org.seasar.doma.internal.expr.node.DivideOperatorNode;
import org.seasar.doma.internal.expr.node.EmptyNode;
import org.seasar.doma.internal.expr.node.EqOperatorNode;
import org.seasar.doma.internal.expr.node.ExpressionLocation;
import org.seasar.doma.internal.expr.node.ExpressionNode;
import org.seasar.doma.internal.expr.node.ExpressionNodeVisitor;
import org.seasar.doma.internal.expr.node.FieldOperatorNode;
import org.seasar.doma.internal.expr.node.FunctionOperatorNode;
import org.seasar.doma.internal.expr.node.GeOperatorNode;
import org.seasar.doma.internal.expr.node.GtOperatorNode;
import org.seasar.doma.internal.expr.node.LeOperatorNode;
import org.seasar.doma.internal.expr.node.LiteralNode;
import org.seasar.doma.internal.expr.node.LogicalBinaryOperatorNode;
import org.seasar.doma.internal.expr.node.LtOperatorNode;
import org.seasar.doma.internal.expr.node.MethodOperatorNode;
import org.seasar.doma.internal.expr.node.ModOperatorNode;
import org.seasar.doma.internal.expr.node.MultiplyOperatorNode;
import org.seasar.doma.internal.expr.node.NeOperatorNode;
import org.seasar.doma.internal.expr.node.NewOperatorNode;
import org.seasar.doma.internal.expr.node.NotOperatorNode;
import org.seasar.doma.internal.expr.node.OrOperatorNode;
import org.seasar.doma.internal.expr.node.ParensNode;
import org.seasar.doma.internal.expr.node.StaticFieldOperatorNode;
import org.seasar.doma.internal.expr.node.StaticMethodOperatorNode;
import org.seasar.doma.internal.expr.node.SubtractOperatorNode;
import org.seasar.doma.internal.expr.node.VariableNode;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class ExpressionValidator
implements ExpressionNodeVisitor<TypeDeclaration, Void> {
    protected final ProcessingEnvironment env;
    protected final ExecutableElement methodElement;
    protected final Map<String, TypeMirror> parameterTypeMap;
    protected final Set<String> validatedParameterNames;
    protected final TypeDeclaration unknownTypeDeclaration;
    protected final String exprFunctionsClassName;

    public ExpressionValidator(ProcessingEnvironment env, ExecutableElement methodElement, Map<String, TypeMirror> parameterTypeMap) {
        this(env, methodElement, parameterTypeMap, Options.getExprFunctions(env));
    }

    public ExpressionValidator(ProcessingEnvironment env, ExecutableElement methodElement, Map<String, TypeMirror> parameterTypeMap, String exprFunctionsClassName) {
        AssertionUtil.assertNotNull((Object)env, (Object)methodElement, parameterTypeMap);
        this.env = env;
        this.methodElement = methodElement;
        this.parameterTypeMap = new HashMap<String, TypeMirror>(parameterTypeMap);
        this.validatedParameterNames = new HashSet<String>();
        this.unknownTypeDeclaration = TypeDeclaration.newUnknownTypeDeclaration(env);
        this.exprFunctionsClassName = exprFunctionsClassName;
    }

    public TypeMirror removeParameterType(String parameterName) {
        return this.parameterTypeMap.remove(parameterName);
    }

    public void putParameterType(String parameterName, TypeMirror parameterType) {
        this.parameterTypeMap.put(parameterName, parameterType);
    }

    public void addValidatedParameterName(String name) {
        this.validatedParameterNames.add(name);
    }

    public Set<String> getValidatedParameterNames() {
        return this.validatedParameterNames;
    }

    public TypeDeclaration validate(ExpressionNode node) {
        return this.validateInternal(node);
    }

    protected TypeDeclaration validateInternal(ExpressionNode node) {
        return node.accept(this, null);
    }

    @Override
    public TypeDeclaration visitEqOperatorNode(EqOperatorNode node, Void p) {
        return this.handleNullAvailableComparisonOperation(node, p);
    }

    @Override
    public TypeDeclaration visitNeOperatorNode(NeOperatorNode node, Void p) {
        return this.handleNullAvailableComparisonOperation(node, p);
    }

    @Override
    public TypeDeclaration visitGeOperatorNode(GeOperatorNode node, Void p) {
        return this.handleNullUnavailableComparisonOperation(node, p);
    }

    @Override
    public TypeDeclaration visitGtOperatorNode(GtOperatorNode node, Void p) {
        return this.handleNullUnavailableComparisonOperation(node, p);
    }

    @Override
    public TypeDeclaration visitLeOperatorNode(LeOperatorNode node, Void p) {
        return this.handleNullUnavailableComparisonOperation(node, p);
    }

    @Override
    public TypeDeclaration visitLtOperatorNode(LtOperatorNode node, Void p) {
        return this.handleNullUnavailableComparisonOperation(node, p);
    }

    protected TypeDeclaration handleNullAvailableComparisonOperation(ComparisonOperatorNode node, Void p) {
        TypeDeclaration left = node.getLeftNode().accept(this, p);
        TypeDeclaration right = node.getRightNode().accept(this, p);
        if (left.isNullType() || right.isNullType() || left.isSameType(right)) {
            return TypeDeclaration.newBooleanTypeDeclaration(this.env);
        }
        ExpressionLocation location = node.getLocation();
        throw new AptException((MessageResource)Message.DOMA4116, this.env, this.methodElement, new Object[]{location.getExpression(), location.getPosition(), node.getExpression(), node.getLeftNode().toString(), left.getBinaryName(), node.getRightNode().toString(), right.getBinaryName()});
    }

    protected TypeDeclaration handleNullUnavailableComparisonOperation(ComparisonOperatorNode node, Void p) {
        TypeDeclaration left = node.getLeftNode().accept(this, p);
        TypeDeclaration right = node.getRightNode().accept(this, p);
        if (left.isNullType() || right.isNullType()) {
            ExpressionLocation location = node.getLocation();
            throw new AptException((MessageResource)Message.DOMA4139, this.env, this.methodElement, new Object[]{location.getExpression(), location.getPosition(), node.getExpression()});
        }
        if (left.isSameType(right)) {
            return TypeDeclaration.newBooleanTypeDeclaration(this.env);
        }
        ExpressionLocation location = node.getLocation();
        throw new AptException((MessageResource)Message.DOMA4116, this.env, this.methodElement, new Object[]{location.getExpression(), location.getPosition(), node.getExpression(), node.getLeftNode().toString(), left.getBinaryName(), node.getRightNode().toString(), right.getBinaryName()});
    }

    @Override
    public TypeDeclaration visitAndOperatorNode(AndOperatorNode node, Void p) {
        return this.handleLogicalBinaryOperatorNode(node, p);
    }

    @Override
    public TypeDeclaration visitOrOperatorNode(OrOperatorNode node, Void p) {
        return this.handleLogicalBinaryOperatorNode(node, p);
    }

    protected TypeDeclaration handleLogicalBinaryOperatorNode(LogicalBinaryOperatorNode node, Void p) {
        TypeDeclaration left = node.getLeftNode().accept(this, p);
        TypeDeclaration right = node.getRightNode().accept(this, p);
        if (!left.isBooleanType()) {
            ExpressionLocation location = node.getLocation();
            throw new AptException((MessageResource)Message.DOMA4117, this.env, this.methodElement, new Object[]{location.getExpression(), location.getPosition(), node.getExpression(), node.getLeftNode().toString(), left.getBinaryName()});
        }
        if (!right.isBooleanType()) {
            ExpressionLocation location = node.getLocation();
            throw new AptException((MessageResource)Message.DOMA4118, this.env, this.methodElement, new Object[]{location.getExpression(), location.getPosition(), node.getExpression(), node.getRightNode().toString(), right.getBinaryName()});
        }
        return TypeDeclaration.newBooleanTypeDeclaration(this.env);
    }

    @Override
    public TypeDeclaration visitNotOperatorNode(NotOperatorNode node, Void p) {
        TypeDeclaration result = node.getNode().accept(this, p);
        if (result.isBooleanType()) {
            return TypeDeclaration.newBooleanTypeDeclaration(this.env);
        }
        ExpressionLocation location = node.getLocation();
        throw new AptException((MessageResource)Message.DOMA4119, this.env, this.methodElement, new Object[]{location.getExpression(), location.getPosition(), node.getExpression(), node.getNode().toString(), result.getBinaryName()});
    }

    @Override
    public TypeDeclaration visitAddOperatorNode(AddOperatorNode node, Void p) {
        TypeDeclaration left = node.getLeftNode().accept(this, p);
        TypeDeclaration right = node.getRightNode().accept(this, p);
        if (left.isTextType()) {
            if (right.isTextType()) {
                return left.emulateConcatOperation(right);
            }
            ExpressionLocation location = node.getLocation();
            throw new AptException((MessageResource)Message.DOMA4126, this.env, this.methodElement, new Object[]{location.getExpression(), location.getPosition(), node.getExpression(), node.getLeftNode().toString(), left.getBinaryName()});
        }
        return this.handleArithmeticOperatorNode(node, left, right, p);
    }

    @Override
    public TypeDeclaration visitSubtractOperatorNode(SubtractOperatorNode node, Void p) {
        TypeDeclaration left = node.getLeftNode().accept(this, p);
        TypeDeclaration right = node.getRightNode().accept(this, p);
        return this.handleArithmeticOperatorNode(node, left, right, p);
    }

    @Override
    public TypeDeclaration visitMultiplyOperatorNode(MultiplyOperatorNode node, Void p) {
        TypeDeclaration left = node.getLeftNode().accept(this, p);
        TypeDeclaration right = node.getRightNode().accept(this, p);
        return this.handleArithmeticOperatorNode(node, left, right, p);
    }

    @Override
    public TypeDeclaration visitDivideOperatorNode(DivideOperatorNode node, Void p) {
        TypeDeclaration left = node.getLeftNode().accept(this, p);
        TypeDeclaration right = node.getRightNode().accept(this, p);
        return this.handleArithmeticOperatorNode(node, left, right, p);
    }

    @Override
    public TypeDeclaration visitModOperatorNode(ModOperatorNode node, Void p) {
        TypeDeclaration left = node.getLeftNode().accept(this, p);
        TypeDeclaration right = node.getRightNode().accept(this, p);
        return this.handleArithmeticOperatorNode(node, left, right, p);
    }

    protected TypeDeclaration handleArithmeticOperatorNode(ArithmeticOperatorNode node, TypeDeclaration left, TypeDeclaration right, Void p) {
        if (!left.isNumberType()) {
            ExpressionLocation location = node.getLocation();
            throw new AptException((MessageResource)Message.DOMA4120, this.env, this.methodElement, new Object[]{location.getExpression(), location.getPosition(), node.getExpression(), node.getLeftNode().toString(), left.getBinaryName()});
        }
        if (!right.isNumberType()) {
            ExpressionLocation location = node.getLocation();
            throw new AptException((MessageResource)Message.DOMA4121, this.env, this.methodElement, new Object[]{location.getExpression(), location.getPosition(), node.getExpression(), node.getRightNode().toString(), right.getBinaryName()});
        }
        return left.emulateArithmeticOperation(right);
    }

    @Override
    public TypeDeclaration visitLiteralNode(LiteralNode node, Void p) {
        TypeMirror type = node.getValueClass() == Void.TYPE ? this.env.getTypeUtils().getNullType() : TypeMirrorUtil.getTypeMirror(node.getValueClass(), this.env);
        return TypeDeclaration.newTypeDeclaration(type, this.env);
    }

    @Override
    public TypeDeclaration visitParensNode(ParensNode node, Void p) {
        return node.getNode().accept(this, p);
    }

    @Override
    public TypeDeclaration visitNewOperatorNode(NewOperatorNode node, Void p) {
        node.getParametersNode().accept(this, p);
        List<TypeDeclaration> parameterTypeDeclarations = new ParameterCollector().collect(node.getParametersNode());
        String className = node.getClassName();
        TypeElement typeElement = ElementUtil.getTypeElement(className, this.env);
        if (typeElement == null) {
            ExpressionLocation location = node.getLocation();
            throw new AptException((MessageResource)Message.DOMA4138, this.env, this.methodElement, new Object[]{location.getExpression(), location.getPosition(), className});
        }
        TypeDeclaration typeDeclaration = TypeDeclaration.newTypeDeclaration(typeElement.asType(), this.env);
        List<ConstructorDeclaration> constructorDeclarations = typeDeclaration.getConstructorDeclarations(parameterTypeDeclarations);
        if (constructorDeclarations.size() == 0) {
            ExpressionLocation location = node.getLocation();
            String signature = this.createConstructorSignature(className, parameterTypeDeclarations);
            throw new AptException((MessageResource)Message.DOMA4115, this.env, this.methodElement, new Object[]{location.getExpression(), location.getPosition(), signature});
        }
        if (constructorDeclarations.size() == 1) {
            return typeDeclaration;
        }
        ExpressionLocation location = node.getLocation();
        String signature = this.createConstructorSignature(className, parameterTypeDeclarations);
        throw new AptException((MessageResource)Message.DOMA4127, this.env, this.methodElement, new Object[]{location.getExpression(), location.getPosition(), signature});
    }

    protected String createConstructorSignature(String className, List<TypeDeclaration> parameterTypeDeclarations) {
        StringBuilder buf = new StringBuilder();
        buf.append(className);
        buf.append("(");
        if (parameterTypeDeclarations.size() > 0) {
            for (TypeDeclaration declaration : parameterTypeDeclarations) {
                buf.append(declaration.getType());
                buf.append(", ");
            }
            buf.setLength(buf.length() - 2);
        }
        buf.append(")");
        return buf.toString();
    }

    @Override
    public TypeDeclaration visitCommaOperatorNode(CommaOperatorNode node, Void p) {
        return this.unknownTypeDeclaration;
    }

    @Override
    public TypeDeclaration visitEmptyNode(EmptyNode node, Void p) {
        return this.unknownTypeDeclaration;
    }

    @Override
    public TypeDeclaration visitMethodOperatorNode(MethodOperatorNode node, Void p) {
        MethodDeclaration methodDeclaration;
        TypeDeclaration returnTypeDeclaration;
        TypeDeclaration typeDeclaration = node.getTargetObjectNode().accept(this, p);
        List<TypeDeclaration> parameterTypeDeclarations = new ParameterCollector().collect(node.getParametersNode());
        String methodName = node.getMethodName();
        List<MethodDeclaration> methodDeclarations = typeDeclaration.getMethodDeclarations(methodName, parameterTypeDeclarations);
        if (methodDeclarations.size() == 0) {
            ExpressionLocation location = node.getLocation();
            String methodSignature = this.createMethodSignature(methodName, parameterTypeDeclarations);
            throw new AptException((MessageResource)Message.DOMA4071, this.env, this.methodElement, new Object[]{location.getExpression(), location.getPosition(), node.getTargetObjectNode().getExpression(), typeDeclaration.getBinaryName(), methodSignature});
        }
        if (methodDeclarations.size() == 1 && (returnTypeDeclaration = (methodDeclaration = methodDeclarations.get(0)).getReturnTypeDeclaration()) != null) {
            return this.convertIfOptional(returnTypeDeclaration);
        }
        ExpressionLocation location = node.getLocation();
        String methodSignature = this.createMethodSignature(methodName, parameterTypeDeclarations);
        throw new AptException((MessageResource)Message.DOMA4073, this.env, this.methodElement, new Object[]{location.getExpression(), location.getPosition(), node.getTargetObjectNode().getExpression(), typeDeclaration.getBinaryName(), methodSignature});
    }

    @Override
    public TypeDeclaration visitStaticMethodOperatorNode(StaticMethodOperatorNode node, Void p) {
        MethodDeclaration methodDeclaration;
        TypeDeclaration returnTypeDeclaration;
        String className = node.getClassName();
        TypeElement typeElement = ElementUtil.getTypeElement(node.getClassName(), this.env);
        if (typeElement == null) {
            ExpressionLocation location = node.getLocation();
            throw new AptException((MessageResource)Message.DOMA4145, this.env, this.methodElement, new Object[]{location.getExpression(), location.getPosition(), className});
        }
        TypeDeclaration typeDeclaration = TypeDeclaration.newTypeDeclaration(typeElement.asType(), this.env);
        List<TypeDeclaration> parameterTypeDeclarations = new ParameterCollector().collect(node.getParametersNode());
        String methodName = node.getMethodName();
        List<MethodDeclaration> methodDeclarations = typeDeclaration.getStaticMethodDeclarations(methodName, parameterTypeDeclarations);
        if (methodDeclarations.size() == 0) {
            ExpressionLocation location = node.getLocation();
            String methodSignature = this.createMethodSignature(methodName, parameterTypeDeclarations);
            throw new AptException((MessageResource)Message.DOMA4146, this.env, this.methodElement, new Object[]{location.getExpression(), location.getPosition(), className, methodSignature});
        }
        if (methodDeclarations.size() == 1 && (returnTypeDeclaration = (methodDeclaration = methodDeclarations.get(0)).getReturnTypeDeclaration()) != null) {
            return this.convertIfOptional(returnTypeDeclaration);
        }
        ExpressionLocation location = node.getLocation();
        String methodSignature = this.createMethodSignature(methodName, parameterTypeDeclarations);
        throw new AptException((MessageResource)Message.DOMA4147, this.env, this.methodElement, new Object[]{location.getExpression(), location.getPosition(), className, methodSignature});
    }

    @Override
    public TypeDeclaration visitFunctionOperatorNode(FunctionOperatorNode node, Void p) {
        MethodDeclaration methodDeclaration;
        TypeDeclaration returnTypeDeclaration;
        TypeDeclaration typeDeclaration = this.getExpressionFunctionsDeclaration(node);
        List<TypeDeclaration> parameterTypeDeclarations = new ParameterCollector().collect(node.getParametersNode());
        String methodName = node.getMethodName();
        List<MethodDeclaration> methodDeclarations = typeDeclaration.getMethodDeclarations(methodName, parameterTypeDeclarations);
        if (methodDeclarations.size() == 0) {
            ExpressionLocation location = node.getLocation();
            String methodSignature = this.createMethodSignature(methodName, parameterTypeDeclarations);
            throw new AptException((MessageResource)Message.DOMA4072, this.env, this.methodElement, new Object[]{location.getExpression(), location.getPosition(), methodSignature});
        }
        if (methodDeclarations.size() == 1 && (returnTypeDeclaration = (methodDeclaration = methodDeclarations.get(0)).getReturnTypeDeclaration()) != null) {
            return returnTypeDeclaration;
        }
        throw new AptIllegalStateException(methodName);
    }

    protected TypeDeclaration getExpressionFunctionsDeclaration(FunctionOperatorNode node) {
        if (this.exprFunctionsClassName == null) {
            return TypeDeclaration.newTypeDeclaration(ExpressionFunctions.class, this.env);
        }
        TypeElement element = ElementUtil.getTypeElement(this.exprFunctionsClassName, this.env);
        if (element == null) {
            ExpressionLocation location = node.getLocation();
            throw new AptException((MessageResource)Message.DOMA4189, this.env, this.methodElement, new Object[]{location.getExpression(), location.getPosition(), node.getMethodName(), this.exprFunctionsClassName});
        }
        TypeMirror type = element.asType();
        if (!TypeMirrorUtil.isAssignable(type, ExpressionFunctions.class, this.env)) {
            ExpressionLocation location = node.getLocation();
            throw new AptException((MessageResource)Message.DOMA4190, this.env, this.methodElement, new Object[]{location.getExpression(), location.getPosition(), node.getMethodName(), this.exprFunctionsClassName});
        }
        return TypeDeclaration.newTypeDeclaration(type, this.env);
    }

    protected String createMethodSignature(String methodName, List<TypeDeclaration> parameterTypeDeclarations) {
        StringBuilder buf = new StringBuilder();
        buf.append(methodName);
        buf.append("(");
        if (parameterTypeDeclarations.size() > 0) {
            for (TypeDeclaration declaration : parameterTypeDeclarations) {
                buf.append(declaration.getType());
                buf.append(", ");
            }
            buf.setLength(buf.length() - 2);
        }
        buf.append(")");
        return buf.toString();
    }

    @Override
    public TypeDeclaration visitFieldOperatorNode(FieldOperatorNode node, Void p) {
        TypeDeclaration fieldTypeDeclaration;
        String fieldName;
        TypeDeclaration typeDeclaration = node.getTargetObjectNode().accept(this, p);
        FieldDeclaration fieldDeclaration = typeDeclaration.getFieldDeclaration(fieldName = node.getFieldName());
        if (fieldDeclaration != null && (fieldTypeDeclaration = fieldDeclaration.getTypeDeclaration()) != null) {
            return this.convertIfOptional(fieldTypeDeclaration);
        }
        ExpressionLocation location = node.getLocation();
        throw new AptException((MessageResource)Message.DOMA4114, this.env, this.methodElement, new Object[]{location.getExpression(), location.getPosition(), node.getTargetObjectNode().getExpression(), typeDeclaration.getBinaryName(), fieldName});
    }

    @Override
    public TypeDeclaration visitStaticFieldOperatorNode(StaticFieldOperatorNode node, Void p) {
        TypeDeclaration fieldTypeDeclaration;
        String fieldName;
        String className = node.getClassName();
        TypeElement typeElement = ElementUtil.getTypeElement(node.getClassName(), this.env);
        if (typeElement == null) {
            ExpressionLocation location = node.getLocation();
            throw new AptException((MessageResource)Message.DOMA4145, this.env, this.methodElement, new Object[]{location.getExpression(), location.getPosition(), className});
        }
        TypeDeclaration typeDeclaration = TypeDeclaration.newTypeDeclaration(typeElement.asType(), this.env);
        FieldDeclaration fieldDeclaration = typeDeclaration.getStaticFieldDeclaration(fieldName = node.getFieldName());
        if (fieldDeclaration != null && (fieldTypeDeclaration = fieldDeclaration.getTypeDeclaration()) != null) {
            return this.convertIfOptional(fieldTypeDeclaration);
        }
        ExpressionLocation location = node.getLocation();
        throw new AptException((MessageResource)Message.DOMA4148, this.env, this.methodElement, new Object[]{location.getExpression(), location.getPosition(), className, fieldName});
    }

    protected TypeDeclaration convertIfOptional(TypeDeclaration typeDeclaration) {
        if (typeDeclaration.is(Optional.class)) {
            TypeParameterDeclaration typeParameterDeclaration = (TypeParameterDeclaration)typeDeclaration.getTypeParameterDeclarations().stream().findFirst().orElseThrow(() -> new AptIllegalStateException(typeDeclaration.toString()));
            return TypeDeclaration.newTypeDeclaration(typeParameterDeclaration.getActualType(), this.env);
        }
        if (typeDeclaration.is(OptionalInt.class)) {
            return TypeDeclaration.newTypeDeclaration(Integer.class, this.env);
        }
        if (typeDeclaration.is(OptionalLong.class)) {
            return TypeDeclaration.newTypeDeclaration(Long.class, this.env);
        }
        if (typeDeclaration.is(OptionalDouble.class)) {
            return TypeDeclaration.newTypeDeclaration(Double.class, this.env);
        }
        return typeDeclaration;
    }

    @Override
    public TypeDeclaration visitVariableNode(VariableNode node, Void p) {
        String variableName = node.getExpression();
        TypeMirror type = this.parameterTypeMap.get(variableName);
        if (type == null) {
            ExpressionLocation location = node.getLocation();
            throw new AptException((MessageResource)Message.DOMA4067, this.env, this.methodElement, new Object[]{variableName, location.getPosition()});
        }
        this.validatedParameterNames.add(variableName);
        return TypeDeclaration.newTypeDeclaration(type, this.env);
    }

    protected class ParameterCollector
    implements ExpressionNodeVisitor<Void, List<TypeDeclaration>> {
        protected ParameterCollector() {
        }

        public List<TypeDeclaration> collect(ExpressionNode node) {
            ArrayList<TypeDeclaration> results = new ArrayList<TypeDeclaration>();
            node.accept(this, results);
            return results;
        }

        @Override
        public Void visitEqOperatorNode(EqOperatorNode node, List<TypeDeclaration> p) {
            this.validate(node, p);
            return null;
        }

        @Override
        public Void visitNeOperatorNode(NeOperatorNode node, List<TypeDeclaration> p) {
            this.validate(node, p);
            return null;
        }

        @Override
        public Void visitGeOperatorNode(GeOperatorNode node, List<TypeDeclaration> p) {
            this.validate(node, p);
            return null;
        }

        @Override
        public Void visitGtOperatorNode(GtOperatorNode node, List<TypeDeclaration> p) {
            this.validate(node, p);
            return null;
        }

        @Override
        public Void visitLeOperatorNode(LeOperatorNode node, List<TypeDeclaration> p) {
            this.validate(node, p);
            return null;
        }

        @Override
        public Void visitLtOperatorNode(LtOperatorNode node, List<TypeDeclaration> p) {
            this.validate(node, p);
            return null;
        }

        @Override
        public Void visitCommaOperatorNode(CommaOperatorNode node, List<TypeDeclaration> p) {
            for (ExpressionNode expressionNode : node.getNodes()) {
                expressionNode.accept(this, p);
            }
            return null;
        }

        @Override
        public Void visitLiteralNode(LiteralNode node, List<TypeDeclaration> p) {
            this.validate(node, p);
            return null;
        }

        @Override
        public Void visitVariableNode(VariableNode node, List<TypeDeclaration> p) {
            this.validate(node, p);
            return null;
        }

        @Override
        public Void visitOrOperatorNode(OrOperatorNode node, List<TypeDeclaration> p) {
            this.validate(node, p);
            return null;
        }

        @Override
        public Void visitAndOperatorNode(AndOperatorNode node, List<TypeDeclaration> p) {
            this.validate(node, p);
            return null;
        }

        @Override
        public Void visitNotOperatorNode(NotOperatorNode node, List<TypeDeclaration> p) {
            this.validate(node, p);
            return null;
        }

        @Override
        public Void visitAddOperatorNode(AddOperatorNode node, List<TypeDeclaration> p) {
            this.validate(node, p);
            return null;
        }

        @Override
        public Void visitSubtractOperatorNode(SubtractOperatorNode node, List<TypeDeclaration> p) {
            this.validate(node, p);
            return null;
        }

        @Override
        public Void visitMultiplyOperatorNode(MultiplyOperatorNode node, List<TypeDeclaration> p) {
            this.validate(node, p);
            return null;
        }

        @Override
        public Void visitDivideOperatorNode(DivideOperatorNode node, List<TypeDeclaration> p) {
            this.validate(node, p);
            return null;
        }

        @Override
        public Void visitModOperatorNode(ModOperatorNode node, List<TypeDeclaration> p) {
            this.validate(node, p);
            return null;
        }

        @Override
        public Void visitNewOperatorNode(NewOperatorNode node, List<TypeDeclaration> p) {
            this.validate(node, p);
            return null;
        }

        @Override
        public Void visitMethodOperatorNode(MethodOperatorNode node, List<TypeDeclaration> p) {
            this.validate(node, p);
            return null;
        }

        @Override
        public Void visitStaticMethodOperatorNode(StaticMethodOperatorNode node, List<TypeDeclaration> p) {
            this.validate(node, p);
            return null;
        }

        @Override
        public Void visitFunctionOperatorNode(FunctionOperatorNode node, List<TypeDeclaration> p) {
            this.validate(node, p);
            return null;
        }

        @Override
        public Void visitFieldOperatorNode(FieldOperatorNode node, List<TypeDeclaration> p) {
            this.validate(node, p);
            return null;
        }

        @Override
        public Void visitStaticFieldOperatorNode(StaticFieldOperatorNode node, List<TypeDeclaration> p) {
            this.validate(node, p);
            return null;
        }

        @Override
        public Void visitParensNode(ParensNode node, List<TypeDeclaration> p) {
            node.getNode().accept(this, p);
            return null;
        }

        @Override
        public Void visitEmptyNode(EmptyNode node, List<TypeDeclaration> p) {
            return null;
        }

        protected void validate(ExpressionNode node, List<TypeDeclaration> p) {
            TypeDeclaration result = ExpressionValidator.this.validateInternal(node);
            p.add(result);
        }
    }
}

