/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import org.seasar.doma.internal.apt.AbstractGenerator;
import org.seasar.doma.internal.apt.cttype.BasicCtType;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.DomainCtType;
import org.seasar.doma.internal.apt.cttype.OptionalCtType;
import org.seasar.doma.internal.apt.cttype.OptionalDoubleCtType;
import org.seasar.doma.internal.apt.cttype.OptionalIntCtType;
import org.seasar.doma.internal.apt.cttype.OptionalLongCtType;
import org.seasar.doma.internal.apt.cttype.SimpleCtTypeVisitor;
import org.seasar.doma.internal.apt.cttype.WrapperCtType;
import org.seasar.doma.internal.apt.meta.EntityMeta;
import org.seasar.doma.internal.apt.meta.EntityPropertyMeta;
import org.seasar.doma.internal.apt.meta.IdGeneratorMeta;
import org.seasar.doma.internal.apt.meta.IdGeneratorMetaVisitor;
import org.seasar.doma.internal.apt.meta.IdentityIdGeneratorMeta;
import org.seasar.doma.internal.apt.meta.OriginalStatesMeta;
import org.seasar.doma.internal.apt.meta.SequenceIdGeneratorMeta;
import org.seasar.doma.internal.apt.meta.TableIdGeneratorMeta;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Naming;
import org.seasar.doma.jdbc.entity.AbstractEntityType;
import org.seasar.doma.jdbc.entity.AssignedIdPropertyType;
import org.seasar.doma.jdbc.entity.DefaultPropertyType;
import org.seasar.doma.jdbc.entity.EmbeddedPropertyType;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.GeneratedIdPropertyType;
import org.seasar.doma.jdbc.entity.NamingType;
import org.seasar.doma.jdbc.entity.OriginalStatesAccessor;
import org.seasar.doma.jdbc.entity.PostDeleteContext;
import org.seasar.doma.jdbc.entity.PostInsertContext;
import org.seasar.doma.jdbc.entity.PostUpdateContext;
import org.seasar.doma.jdbc.entity.PreDeleteContext;
import org.seasar.doma.jdbc.entity.PreInsertContext;
import org.seasar.doma.jdbc.entity.PreUpdateContext;
import org.seasar.doma.jdbc.entity.Property;
import org.seasar.doma.jdbc.entity.TenantIdPropertyType;
import org.seasar.doma.jdbc.entity.VersionPropertyType;

public class EntityTypeGenerator
extends AbstractGenerator {
    protected static final String NULL = "null";
    protected final EntityMeta entityMeta;

    public EntityTypeGenerator(ProcessingEnvironment env, TypeElement entityElement, EntityMeta entityMeta) throws IOException {
        super(env, entityElement, null, null, "_", "");
        AssertionUtil.assertNotNull(entityMeta);
        this.entityMeta = entityMeta;
    }

    @Override
    public void generate() {
        this.printPackage();
        this.printClass();
    }

    protected void printPackage() {
        if (!this.packageName.isEmpty()) {
            this.iprint("package %1$s;%n", this.packageName);
            this.iprint("%n", new Object[0]);
        }
    }

    protected void printClass() {
        this.iprint("/** */%n", new Object[0]);
        this.printGenerated();
        this.iprint("public final class %1$s extends %2$s<%3$s> {%n", this.simpleName, AbstractEntityType.class.getName(), this.entityMeta.getEntityTypeName());
        this.print("%n", new Object[0]);
        this.indent();
        this.printValidateVersionStaticInitializer();
        this.printFields();
        this.printConstructor();
        this.printMethods();
        this.printListenerHolder();
        this.unindent();
        this.iprint("}%n", new Object[0]);
    }

    protected void printFields() {
        this.printSingletonField();
        this.printOriginalStatesAccessorField();
        this.printNamingTypeField();
        this.printIdGeneratorField();
        this.printPropertyTypeFields();
        this.printListenerSupplierField();
        this.printImmutableField();
        this.printCatalogNameField();
        this.printSchemaNameField();
        this.printTableNameField();
        this.printIsQuoteRequiredField();
        this.printNameField();
        this.printIdPropertyTypesField();
        this.printEntityPropertyTypesField();
        this.printEntityPropertyTypeMapField();
    }

    protected void printSingletonField() {
        this.iprint("private static final %1$s __singleton = new %1$s();%n", this.simpleName);
        this.print("%n", new Object[0]);
    }

    protected void printOriginalStatesAccessorField() {
        if (!this.entityMeta.isAbstract() && this.entityMeta.hasOriginalStatesMeta()) {
            OriginalStatesMeta osm = this.entityMeta.getOriginalStatesMeta();
            this.iprint("private static final %1$s<%2$s> __originalStatesAccessor = new %1$s<>(%3$s.class, \"%4$s\");%n", OriginalStatesAccessor.class.getName(), osm.getTypeElement().getQualifiedName(), osm.getFieldEnclosingElement().getQualifiedName(), osm.getFieldElement().getSimpleName());
            this.print("%n", new Object[0]);
        }
    }

    protected void printIdGeneratorField() {
        if (this.entityMeta.hasGeneratedIdPropertyMeta()) {
            EntityPropertyMeta propertyMeta = this.entityMeta.getGeneratedIdPropertyMeta();
            IdGeneratorMeta idGeneratorMeta = propertyMeta.getIdGeneratorMeta();
            idGeneratorMeta.accept(new IdGeneratorGenerator(), null);
            this.print("%n", new Object[0]);
        }
    }

    protected void printPropertyTypeFields() {
        for (EntityPropertyMeta pm : this.entityMeta.getAllPropertyMetas()) {
            this.iprint("/** the %1$s */%n", pm.getName());
            if (pm.isEmbedded()) {
                this.iprint("public final %1$s<%2$s, %3$s> %4$s = new %1$s<>(\"%5$s\", %2$s.class, %6$s.getSingletonInternal().getEmbeddablePropertyTypes(\"%7$s\", %2$s.class, __namingType));%n", EmbeddedPropertyType.class.getName(), this.entityMeta.getEntityTypeName(), pm.getTypeName(), pm.getFieldName(), pm.getName(), pm.getEmbeddableMetaTypeName(), pm.getName());
            } else {
                EntityPropertyCtTypeVisitor visitor = new EntityPropertyCtTypeVisitor();
                pm.getCtType().accept(visitor, null);
                BasicCtType basicCtType = visitor.basicCtType;
                WrapperCtType wrapperCtType = visitor.wrapperCtType;
                DomainCtType domainCtType = visitor.domainCtType;
                String newWrapperExpr = basicCtType.isEnum() ? String.format("new %s(%s.class)", wrapperCtType.getTypeName(), basicCtType.getBoxedTypeName()) : String.format("new %s()", wrapperCtType.getTypeName());
                String domainType = NULL;
                String domainTypeName = "Object";
                if (domainCtType != null) {
                    domainType = domainCtType.getInstantiationCommand();
                    domainTypeName = domainCtType.getTypeName();
                }
                if (pm.isId()) {
                    if (pm.getIdGeneratorMeta() != null) {
                        this.iprint("public final %1$s<%11$s, %2$s, %3$s, %14$s> %12$s = new %1$s<>(%6$s.class, %13$s.class, %3$s.class, () -> %7$s, %10$s, %8$s, \"%4$s\", \"%5$s\", __namingType, %15$s, __idGenerator);%n", GeneratedIdPropertyType.class.getName(), this.entityMeta.getEntityTypeName(), basicCtType.getBoxedTypeName(), pm.getName(), pm.getColumnName(), this.entityMeta.getEntityTypeName(), newWrapperExpr, domainType, pm.getBoxedTypeName(), NULL, Object.class.getName(), pm.getFieldName(), pm.getBoxedClassName(), domainTypeName, pm.isColumnQuoteRequired());
                    } else {
                        this.iprint("public final %1$s<%11$s, %2$s, %3$s, %14$s> %12$s = new %1$s<>(%6$s.class, %13$s.class, %3$s.class, () -> %7$s, %10$s, %8$s, \"%4$s\", \"%5$s\", __namingType, %15$s);%n", AssignedIdPropertyType.class.getName(), this.entityMeta.getEntityTypeName(), basicCtType.getBoxedTypeName(), pm.getName(), pm.getColumnName(), this.entityMeta.getEntityTypeName(), newWrapperExpr, domainType, pm.getBoxedTypeName(), NULL, Object.class.getName(), pm.getFieldName(), pm.getBoxedClassName(), domainTypeName, pm.isColumnQuoteRequired());
                    }
                } else if (pm.isVersion()) {
                    this.iprint("public final %1$s<%11$s, %2$s, %3$s, %14$s> %12$s = new %1$s<>(%6$s.class,  %13$s.class, %3$s.class, () -> %7$s, %10$s, %8$s, \"%4$s\", \"%5$s\", __namingType, %15$s);%n", VersionPropertyType.class.getName(), this.entityMeta.getEntityTypeName(), basicCtType.getBoxedTypeName(), pm.getName(), pm.getColumnName(), this.entityMeta.getEntityTypeName(), newWrapperExpr, domainType, pm.getBoxedTypeName(), NULL, Object.class.getName(), pm.getFieldName(), pm.getBoxedClassName(), domainTypeName, pm.isColumnQuoteRequired());
                } else if (pm.isTenantId()) {
                    this.iprint("public final %1$s<%11$s, %2$s, %3$s, %14$s> %12$s = new %1$s<>(%6$s.class,  %13$s.class, %3$s.class, () -> %7$s, %10$s, %8$s, \"%4$s\", \"%5$s\", __namingType, %15$s);%n", TenantIdPropertyType.class.getName(), this.entityMeta.getEntityTypeName(), basicCtType.getBoxedTypeName(), pm.getName(), pm.getColumnName(), this.entityMeta.getEntityTypeName(), newWrapperExpr, domainType, pm.getBoxedTypeName(), NULL, Object.class.getName(), pm.getFieldName(), pm.getBoxedClassName(), domainTypeName, pm.isColumnQuoteRequired());
                } else {
                    this.iprint("public final %1$s<%13$s, %2$s, %3$s, %16$s> %14$s = new %1$s<>(%8$s.class, %15$s.class, %3$s.class, () -> %9$s, %12$s, %10$s, \"%4$s\", \"%5$s\", __namingType, %6$s, %7$s, %17$s);%n", DefaultPropertyType.class.getName(), this.entityMeta.getEntityTypeName(), basicCtType.getBoxedTypeName(), pm.getName(), pm.getColumnName(), pm.isColumnInsertable(), pm.isColumnUpdatable(), this.entityMeta.getEntityTypeName(), newWrapperExpr, domainType, pm.getBoxedTypeName(), NULL, Object.class.getName(), pm.getFieldName(), pm.getBoxedClassName(), domainTypeName, pm.isColumnQuoteRequired());
                }
            }
            this.print("%n", new Object[0]);
        }
    }

    protected String getNamingTypeExpression(boolean defined) {
        if (defined) {
            return NamingType.class.getName() + "." + (Object)((Object)NamingType.NONE);
        }
        return "__namingType";
    }

    protected void printListenerSupplierField() {
        if (this.entityMeta.isGenericEntityListener()) {
            this.iprint("private final java.util.function.Supplier<%1$s<%2$s>> __listenerSupplier;%n", this.entityMeta.getEntityListenerElement().getQualifiedName(), this.entityMeta.getEntityTypeName());
        } else {
            this.iprint("private final java.util.function.Supplier<%1$s> __listenerSupplier;%n", this.entityMeta.getEntityListenerElement().getQualifiedName());
        }
        this.print("%n", new Object[0]);
    }

    protected void printNamingTypeField() {
        NamingType namingType = this.entityMeta.getNamingType();
        if (namingType == null) {
            this.iprint("private final %1$s __namingType = null;%n", NamingType.class.getName());
        } else {
            this.iprint("private final %1$s __namingType = %1$s.%2$s;%n", NamingType.class.getName(), namingType.name());
        }
        this.print("%n", new Object[0]);
    }

    protected void printImmutableField() {
        this.iprint("private final boolean __immutable;%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printCatalogNameField() {
        this.iprint("private final String __catalogName;%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printSchemaNameField() {
        this.iprint("private final String __schemaName;%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printTableNameField() {
        this.iprint("private final String __tableName;%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printIsQuoteRequiredField() {
        this.iprint("private final boolean __isQuoteRequired;%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printNameField() {
        this.iprint("private final String __name;%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printIdPropertyTypesField() {
        this.iprint("private final java.util.List<%1$s<%2$s, ?>> __idPropertyTypes;%n", EntityPropertyType.class.getName(), this.entityMeta.getEntityTypeName());
        this.print("%n", new Object[0]);
    }

    protected void printEntityPropertyTypesField() {
        this.iprint("private final java.util.List<%1$s<%2$s, ?>> __entityPropertyTypes;%n", EntityPropertyType.class.getName(), this.entityMeta.getEntityTypeName());
        this.print("%n", new Object[0]);
    }

    protected void printEntityPropertyTypeMapField() {
        this.iprint("private final java.util.Map<String, %1$s<%2$s, ?>> __entityPropertyTypeMap;%n", EntityPropertyType.class.getName(), this.entityMeta.getEntityTypeName());
        this.print("%n", new Object[0]);
    }

    protected void printConstructor() {
        this.iprint("private %1$s() {%n", this.simpleName);
        this.iprint("    __listenerSupplier = () -> ListenerHolder.listener;%n", new Object[0]);
        this.iprint("    __immutable = %1$s;%n", this.entityMeta.isImmutable());
        this.iprint("    __name = \"%1$s\";%n", this.entityMeta.getEntityName());
        this.iprint("    __catalogName = \"%1$s\";%n", this.entityMeta.getCatalogName());
        this.iprint("    __schemaName = \"%1$s\";%n", this.entityMeta.getSchemaName());
        this.iprint("    __tableName = \"%1$s\";%n", this.entityMeta.getTableName());
        this.iprint("    __isQuoteRequired = %1$s;%n", this.entityMeta.isQuoteRequired());
        this.iprint("    java.util.List<%1$s<%2$s, ?>> __idList = new java.util.ArrayList<>();%n", EntityPropertyType.class.getName(), this.entityMeta.getEntityTypeName());
        this.iprint("    java.util.List<%1$s<%2$s, ?>> __list = new java.util.ArrayList<>(%3$s);%n", EntityPropertyType.class.getName(), this.entityMeta.getEntityTypeName(), this.entityMeta.getAllPropertyMetas().size());
        this.iprint("    java.util.Map<String, %1$s<%2$s, ?>> __map = new java.util.HashMap<>(%3$s);%n", EntityPropertyType.class.getName(), this.entityMeta.getEntityTypeName(), this.entityMeta.getAllPropertyMetas().size());
        for (EntityPropertyMeta pm : this.entityMeta.getAllPropertyMetas()) {
            if (pm.isEmbedded()) {
                this.iprint("    __list.addAll(%1$s.getEmbeddablePropertyTypes());%n", pm.getFieldName());
                this.iprint("    __map.putAll(%1$s.getEmbeddablePropertyTypeMap());%n", pm.getFieldName());
                continue;
            }
            if (pm.isId()) {
                this.iprint("    __idList.add(%1$s);%n", pm.getFieldName());
            }
            this.iprint("    __list.add(%1$s);%n", pm.getFieldName());
            this.iprint("    __map.put(\"%1$s\", %2$s);%n", pm.getName(), pm.getFieldName());
        }
        this.iprint("    __idPropertyTypes = java.util.Collections.unmodifiableList(__idList);%n", new Object[0]);
        this.iprint("    __entityPropertyTypes = java.util.Collections.unmodifiableList(__list);%n", new Object[0]);
        this.iprint("    __entityPropertyTypeMap = java.util.Collections.unmodifiableMap(__map);%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printMethods() {
        this.printGetNamingTypeMethod();
        this.printIsImmutableMethod();
        this.printGetNameMethod();
        this.printGetCatalogNameMethod();
        this.printGetSchemaNameMethod();
        this.printGetTableNameMethod();
        this.printIsQuoteRequiredMethod();
        this.printPreInsertMethod();
        this.printPreUpdateMethod();
        this.printPreDeleteMethod();
        this.printPostInsertMethod();
        this.printPostUpdateMethod();
        this.printPostDeleteMethod();
        this.printGetEntityPropertyTypesMethod();
        this.printGetEntityPropertyTypeMethod();
        this.printGetIdPropertyTypesMethod();
        this.printGetGeneratedIdPropertyTypeMethod();
        this.printGetVersionPropertyTypeMethod();
        this.printGetTenantIdPropertyTypeMethod();
        this.printNewEntityMethod();
        this.printGetEntityClassMethod();
        this.printGetOriginalStatesMethod();
        this.printSaveCurrentStatesMethod();
        this.printGetSingletonInternalMethod();
        this.printNewInstanceMethod();
    }

    protected void printGetNamingTypeMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public %1$s getNamingType() {%n", NamingType.class.getName());
        this.iprint("    return __namingType;%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printIsImmutableMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public boolean isImmutable() {%n", new Object[0]);
        this.iprint("    return __immutable;%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printGetNameMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public String getName() {%n", new Object[0]);
        this.iprint("    return __name;%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printGetCatalogNameMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public String getCatalogName() {%n", new Object[0]);
        this.iprint("    return __catalogName;%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printGetSchemaNameMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public String getSchemaName() {%n", new Object[0]);
        this.iprint("    return __schemaName;%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printGetTableNameMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public String getTableName() {%n", new Object[0]);
        this.iprint("    return getTableName(%1$s.DEFAULT::apply);%n", Naming.class.getName());
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public String getTableName(%1$s<%2$s, String, String> namingFunction) {%n", BiFunction.class.getName(), NamingType.class.getName());
        this.iprint("    if (__tableName.isEmpty()) {%n", new Object[0]);
        this.iprint("        return namingFunction.apply(__namingType, __name);%n", new Object[0]);
        this.iprint("    }%n", new Object[0]);
        this.iprint("    return __tableName;%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printIsQuoteRequiredMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public boolean isQuoteRequired() {%n", new Object[0]);
        this.iprint("    return __isQuoteRequired;%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printPreInsertMethod() {
        this.iprint("@SuppressWarnings({\"rawtypes\", \"unchecked\"})%n", new Object[0]);
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public void preInsert(%1$s entity, %2$s<%1$s> context) {%n", this.entityMeta.getEntityTypeName(), PreInsertContext.class.getName());
        this.printDeclareListener();
        this.iprint("    __listener.preInsert(entity, context);%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printPreUpdateMethod() {
        this.iprint("@SuppressWarnings({\"rawtypes\", \"unchecked\"})%n", new Object[0]);
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public void preUpdate(%1$s entity, %2$s<%1$s> context) {%n", this.entityMeta.getEntityTypeName(), PreUpdateContext.class.getName());
        this.printDeclareListener();
        this.iprint("    __listener.preUpdate(entity, context);%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printPreDeleteMethod() {
        this.iprint("@SuppressWarnings({\"rawtypes\", \"unchecked\"})%n", new Object[0]);
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public void preDelete(%1$s entity, %2$s<%1$s> context) {%n", this.entityMeta.getEntityTypeName(), PreDeleteContext.class.getName());
        this.printDeclareListener();
        this.iprint("    __listener.preDelete(entity, context);%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printPostInsertMethod() {
        this.iprint("@SuppressWarnings({\"rawtypes\", \"unchecked\"})%n", new Object[0]);
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public void postInsert(%1$s entity, %2$s<%1$s> context) {%n", this.entityMeta.getEntityTypeName(), PostInsertContext.class.getName());
        this.printDeclareListener();
        this.iprint("    __listener.postInsert(entity, context);%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printPostUpdateMethod() {
        this.iprint("@SuppressWarnings({\"rawtypes\", \"unchecked\"})%n", new Object[0]);
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public void postUpdate(%1$s entity, %2$s<%1$s> context) {%n", this.entityMeta.getEntityTypeName(), PostUpdateContext.class.getName());
        this.printDeclareListener();
        this.iprint("    __listener.postUpdate(entity, context);%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printPostDeleteMethod() {
        this.iprint("@SuppressWarnings({\"rawtypes\", \"unchecked\"})%n", new Object[0]);
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public void postDelete(%1$s entity, %2$s<%1$s> context) {%n", this.entityMeta.getEntityTypeName(), PostDeleteContext.class.getName());
        this.printDeclareListener();
        this.iprint("    __listener.postDelete(entity, context);%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printGetEntityPropertyTypesMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public java.util.List<%1$s<%2$s, ?>> getEntityPropertyTypes() {%n", EntityPropertyType.class.getName(), this.entityMeta.getEntityTypeName());
        this.iprint("    return __entityPropertyTypes;%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printGetEntityPropertyTypeMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public %1$s<%2$s, ?> getEntityPropertyType(String __name) {%n", EntityPropertyType.class.getName(), this.entityMeta.getEntityTypeName());
        this.iprint("    return __entityPropertyTypeMap.get(__name);%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printGetIdPropertyTypesMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public java.util.List<%1$s<%2$s, ?>> getIdPropertyTypes() {%n", EntityPropertyType.class.getName(), this.entityMeta.getEntityTypeName());
        this.iprint("    return __idPropertyTypes;%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printGetGeneratedIdPropertyTypeMethod() {
        String idName = NULL;
        if (this.entityMeta.hasGeneratedIdPropertyMeta()) {
            EntityPropertyMeta pm = this.entityMeta.getGeneratedIdPropertyMeta();
            idName = pm.getFieldName();
        }
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public %1$s<%3$s, %2$s, ?, ?> getGeneratedIdPropertyType() {%n", GeneratedIdPropertyType.class.getName(), this.entityMeta.getEntityTypeName(), Object.class.getName());
        this.iprint("    return %1$s;%n", idName);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printGetVersionPropertyTypeMethod() {
        String versionName = NULL;
        if (this.entityMeta.hasVersionPropertyMeta()) {
            EntityPropertyMeta pm = this.entityMeta.getVersionPropertyMeta();
            versionName = pm.getFieldName();
        }
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public %1$s<%3$s, %2$s, ?, ?> getVersionPropertyType() {%n", VersionPropertyType.class.getName(), this.entityMeta.getEntityTypeName(), Object.class.getName());
        this.iprint("    return %1$s;%n", versionName);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printGetTenantIdPropertyTypeMethod() {
        String tenantIdName = NULL;
        if (this.entityMeta.hasTenantIdPropertyMeta()) {
            EntityPropertyMeta pm = this.entityMeta.getTenanatIdPropertyMeta();
            tenantIdName = pm.getFieldName();
        }
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public %1$s<%3$s, %2$s, ?, ?> getTenantIdPropertyType() {%n", TenantIdPropertyType.class.getName(), this.entityMeta.getEntityTypeName(), Object.class.getName());
        this.iprint("    return %1$s;%n", tenantIdName);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printNewEntityMethod() {
        if (this.hasGenericTypeProperty()) {
            this.iprint("@SuppressWarnings(\"unchecked\")%n", new Object[0]);
        }
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public %1$s newEntity(%2$s<String, %3$s<%1$s, ?>> __args) {%n", this.entityMeta.getEntityTypeName(), Map.class.getName(), Property.class.getName());
        if (this.entityMeta.isAbstract()) {
            this.iprint("    return null;%n", new Object[0]);
        } else if (this.entityMeta.isImmutable()) {
            this.iprint("    return new %1$s(%n", this.entityMeta.getEntityTypeName());
            Iterator<EntityPropertyMeta> it = this.entityMeta.getAllPropertyMetas().iterator();
            while (it.hasNext()) {
                EntityPropertyMeta propertyMeta = it.next();
                if (propertyMeta.isEmbedded()) {
                    this.iprint("        %1$s.getSingletonInternal().newEmbeddable(\"%2$s\", __args)", propertyMeta.getEmbeddableMetaTypeName(), propertyMeta.getName());
                } else {
                    this.iprint("        (%1$s)(__args.get(\"%2$s\") != null ? __args.get(\"%2$s\").get() : null)", TypeMirrorUtil.boxIfPrimitive(propertyMeta.getType(), this.env), propertyMeta.getName());
                }
                if (!it.hasNext()) continue;
                this.print(",%n", new Object[0]);
            }
            this.print(");%n", new Object[0]);
        } else {
            this.iprint("    %1$s entity = new %1$s();%n", this.entityMeta.getEntityTypeName());
            for (EntityPropertyMeta propertyMeta : this.entityMeta.getAllPropertyMetas()) {
                if (propertyMeta.isEmbedded()) {
                    this.iprint("    %1$s.save(entity, %2$s.getSingletonInternal().newEmbeddable(\"%3$s\", __args));%n", propertyMeta.getFieldName(), propertyMeta.getEmbeddableMetaTypeName(), propertyMeta.getName());
                    continue;
                }
                this.iprint("    if (__args.get(\"%1$s\") != null) __args.get(\"%1$s\").save(entity);%n", propertyMeta.getName());
            }
            this.iprint("    return entity;%n", new Object[0]);
        }
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected boolean hasGenericTypeProperty() {
        if (this.entityMeta.isImmutable()) {
            for (EntityPropertyMeta propertyMeta : this.entityMeta.getAllPropertyMetas()) {
                TypeElement element = TypeMirrorUtil.toTypeElement(propertyMeta.getType(), this.env);
                if (element == null || element.getTypeParameters().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    protected void printGetEntityClassMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public Class<%1$s> getEntityClass() {%n", this.entityMeta.getEntityTypeName());
        this.iprint("    return %1$s.class;%n", this.entityMeta.getEntityTypeName());
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printGetOriginalStatesMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public %1$s getOriginalStates(%1$s __entity) {%n", this.entityMeta.getEntityTypeName());
        if (!this.entityMeta.isAbstract() && this.entityMeta.hasOriginalStatesMeta()) {
            this.iprint("    return __originalStatesAccessor.get(__entity);%n", new Object[0]);
        } else {
            this.iprint("    return null;%n", new Object[0]);
        }
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printSaveCurrentStatesMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public void saveCurrentStates(%1$s __entity) {%n", this.entityMeta.getEntityTypeName());
        if (!this.entityMeta.isAbstract() && this.entityMeta.hasOriginalStatesMeta()) {
            this.iprint("    %1$s __currentStates = new %1$s();%n", this.entityMeta.getEntityTypeName());
            for (EntityPropertyMeta pm : this.entityMeta.getAllPropertyMetas()) {
                this.iprint("    %1$s.copy(__currentStates, __entity);%n", pm.getFieldName());
            }
            this.iprint("    __originalStatesAccessor.set(__entity, __currentStates);%n", new Object[0]);
        }
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printGetSingletonInternalMethod() {
        this.iprint("/**%n", new Object[0]);
        this.iprint(" * @return the singleton%n", new Object[0]);
        this.iprint(" */%n", new Object[0]);
        this.iprint("public static %1$s getSingletonInternal() {%n", this.simpleName);
        this.iprint("    return __singleton;%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printNewInstanceMethod() {
        this.iprint("/**%n", new Object[0]);
        this.iprint(" * @return the new instance%n", new Object[0]);
        this.iprint(" */%n", new Object[0]);
        this.iprint("public static %1$s newInstance() {%n", this.simpleName);
        this.iprint("    return new %1$s();%n", this.simpleName);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printListenerHolder() {
        this.iprint("private static class ListenerHolder {%n", new Object[0]);
        if (this.entityMeta.isGenericEntityListener()) {
            this.iprint("    private static %1$s<%2$s> listener = new %1$s<>();%n", this.entityMeta.getEntityListenerElement().getQualifiedName(), this.entityMeta.getEntityTypeName());
        } else {
            this.iprint("    private static %1$s listener = new %1$s();%n", this.entityMeta.getEntityListenerElement().getQualifiedName());
        }
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printDeclareListener() {
        this.iprint("    Class __listenerClass = %1$s.class;%n", this.entityMeta.getEntityListenerElement().getQualifiedName());
        this.iprint("    %1$s __listener = context.getConfig().getEntityListenerProvider().get(__listenerClass, __listenerSupplier);%n", this.entityMeta.getEntityListenerElement().getQualifiedName());
    }

    protected class EntityPropertyCtTypeVisitor
    extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
        protected BasicCtType basicCtType;
        protected WrapperCtType wrapperCtType;
        protected DomainCtType domainCtType;

        protected EntityPropertyCtTypeVisitor() {
        }

        @Override
        protected Void defaultAction(CtType ctType, Void p) throws RuntimeException {
            AssertionUtil.assertNotNull(this.basicCtType);
            AssertionUtil.assertNotNull(this.wrapperCtType);
            return null;
        }

        @Override
        public Void visitOptionalCtType(OptionalCtType ctType, Void p) throws RuntimeException {
            return ctType.getElementCtType().accept(this, p);
        }

        @Override
        public Void visitOptionalIntCtType(OptionalIntCtType ctType, Void p) throws RuntimeException {
            return ctType.getElementCtType().accept(this, p);
        }

        @Override
        public Void visitOptionalLongCtType(OptionalLongCtType ctType, Void p) throws RuntimeException {
            return ctType.getElementCtType().accept(this, p);
        }

        @Override
        public Void visitOptionalDoubleCtType(OptionalDoubleCtType ctType, Void p) throws RuntimeException {
            return ctType.getElementCtType().accept(this, p);
        }

        @Override
        public Void visitBasicCtType(BasicCtType basicCtType, Void p) throws RuntimeException {
            this.basicCtType = basicCtType;
            this.wrapperCtType = basicCtType.getWrapperCtType();
            return this.defaultAction((CtType)basicCtType, p);
        }

        @Override
        public Void visitDomainCtType(DomainCtType domainCtType, Void p) throws RuntimeException {
            this.domainCtType = domainCtType;
            return this.visitBasicCtType(domainCtType.getBasicCtType(), p);
        }
    }

    protected class IdGeneratorGenerator
    implements IdGeneratorMetaVisitor<Void, Void> {
        protected IdGeneratorGenerator() {
        }

        @Override
        public Void visistIdentityIdGeneratorMeta(IdentityIdGeneratorMeta m, Void p) {
            EntityTypeGenerator.this.iprint("private final %1$s __idGenerator = new %1$s();%n", m.getIdGeneratorClassName());
            return null;
        }

        @Override
        public Void visistSequenceIdGeneratorMeta(SequenceIdGeneratorMeta m, Void p) {
            EntityTypeGenerator.this.iprint("private final %1$s __idGenerator = new %1$s();%n", m.getIdGeneratorClassName());
            EntityTypeGenerator.this.iprint("{%n", new Object[0]);
            EntityTypeGenerator.this.iprint("    __idGenerator.setQualifiedSequenceName(\"%1$s\");%n", m.getQualifiedSequenceName());
            EntityTypeGenerator.this.iprint("    __idGenerator.setInitialValue(%1$s);%n", m.getInitialValue());
            EntityTypeGenerator.this.iprint("    __idGenerator.setAllocationSize(%1$s);%n", m.getAllocationSize());
            EntityTypeGenerator.this.iprint("    __idGenerator.initialize();%n", new Object[0]);
            EntityTypeGenerator.this.iprint("}%n", new Object[0]);
            return null;
        }

        @Override
        public Void visistTableIdGeneratorMeta(TableIdGeneratorMeta m, Void p) {
            EntityTypeGenerator.this.iprint("private final %1$s __idGenerator = new %1$s();%n", m.getIdGeneratorClassName());
            EntityTypeGenerator.this.iprint("{%n", new Object[0]);
            EntityTypeGenerator.this.iprint("    __idGenerator.setQualifiedTableName(\"%1$s\");%n", m.getQualifiedTableName());
            EntityTypeGenerator.this.iprint("    __idGenerator.setInitialValue(%1$s);%n", m.getInitialValue());
            EntityTypeGenerator.this.iprint("    __idGenerator.setAllocationSize(%1$s);%n", m.getAllocationSize());
            EntityTypeGenerator.this.iprint("    __idGenerator.setPkColumnName(\"%1$s\");%n", m.getPkColumnName());
            EntityTypeGenerator.this.iprint("    __idGenerator.setPkColumnValue(\"%1$s\");%n", m.getPkColumnValue());
            EntityTypeGenerator.this.iprint("    __idGenerator.setValueColumnName(\"%1$s\");%n", m.getValueColumnName());
            EntityTypeGenerator.this.iprint("    __idGenerator.initialize();%n", new Object[0]);
            EntityTypeGenerator.this.iprint("}%n", new Object[0]);
            return null;
        }
    }
}

