/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import java.io.IOException;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.TypeElement;
import org.seasar.doma.Entity;
import org.seasar.doma.internal.apt.AbstractGeneratingProcessor;
import org.seasar.doma.internal.apt.EntityTypeGenerator;
import org.seasar.doma.internal.apt.Generator;
import org.seasar.doma.internal.apt.meta.EntityMeta;
import org.seasar.doma.internal.apt.meta.EntityMetaFactory;
import org.seasar.doma.internal.apt.meta.EntityPropertyMetaFactory;
import org.seasar.doma.internal.util.AssertionUtil;

@SupportedAnnotationTypes(value={"org.seasar.doma.Entity"})
@SupportedOptions(value={"doma.entity.field.prefix", "doma.domain.converters", "doma.version.validation", "doma.resources.dir", "doma.lombok.Value", "doma.lombok.AllArgsConstructor", "doma.test", "doma.debug"})
public class EntityProcessor
extends AbstractGeneratingProcessor<EntityMeta> {
    public EntityProcessor() {
        super(Entity.class);
    }

    protected EntityMetaFactory createTypeElementMetaFactory() {
        EntityPropertyMetaFactory propertyMetaFactory = this.createEntityPropertyMetaFactory();
        return new EntityMetaFactory(this.processingEnv, propertyMetaFactory);
    }

    protected EntityPropertyMetaFactory createEntityPropertyMetaFactory() {
        return new EntityPropertyMetaFactory(this.processingEnv);
    }

    @Override
    protected Generator createGenerator(TypeElement typeElement, EntityMeta meta) throws IOException {
        AssertionUtil.assertNotNull((Object)typeElement, (Object)meta);
        return new EntityTypeGenerator(this.processingEnv, typeElement, meta);
    }
}

