/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import org.seasar.doma.internal.apt.AbstractGenerator;
import org.seasar.doma.internal.apt.cttype.BasicCtType;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.DomainCtType;
import org.seasar.doma.internal.apt.cttype.OptionalCtType;
import org.seasar.doma.internal.apt.cttype.OptionalDoubleCtType;
import org.seasar.doma.internal.apt.cttype.OptionalIntCtType;
import org.seasar.doma.internal.apt.cttype.OptionalLongCtType;
import org.seasar.doma.internal.apt.cttype.SimpleCtTypeVisitor;
import org.seasar.doma.internal.apt.cttype.WrapperCtType;
import org.seasar.doma.internal.apt.meta.EmbeddableMeta;
import org.seasar.doma.internal.apt.meta.EmbeddablePropertyMeta;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.entity.DefaultPropertyType;
import org.seasar.doma.jdbc.entity.EmbeddableType;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.NamingType;
import org.seasar.doma.jdbc.entity.Property;

public class EmbeddableTypeGenerator
extends AbstractGenerator {
    protected final EmbeddableMeta embeddableMeta;

    public EmbeddableTypeGenerator(ProcessingEnvironment env, TypeElement entityElement, EmbeddableMeta embeddableMeta) throws IOException {
        super(env, entityElement, null, null, "_", "");
        AssertionUtil.assertNotNull(embeddableMeta);
        this.embeddableMeta = embeddableMeta;
    }

    @Override
    public void generate() {
        this.printPackage();
        this.printClass();
    }

    protected void printPackage() {
        if (!this.packageName.isEmpty()) {
            this.iprint("package %1$s;%n", this.packageName);
            this.iprint("%n", new Object[0]);
        }
    }

    protected void printClass() {
        this.iprint("/** */%n", new Object[0]);
        this.printGenerated();
        this.iprint("public final class %1$s implements %2$s<%3$s> {%n", this.simpleName, EmbeddableType.class.getName(), this.embeddableMeta.getEmbeddableElement().getQualifiedName());
        this.print("%n", new Object[0]);
        this.indent();
        this.printValidateVersionStaticInitializer();
        this.printFields();
        this.printMethods();
        this.unindent();
        this.iprint("}%n", new Object[0]);
    }

    protected void printFields() {
        this.printSingletonField();
    }

    protected void printSingletonField() {
        this.iprint("private static final %1$s __singleton = new %1$s();%n", this.simpleName);
        this.print("%n", new Object[0]);
    }

    protected void printMethods() {
        this.printGetEmbeddablePropertyTypesMethod();
        this.printNewEmbeddableMethod();
        this.printGetSingletonInternalMethod();
    }

    protected void printGetEmbeddablePropertyTypesMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public <ENTITY> %1$s<%2$s<ENTITY, ?>> getEmbeddablePropertyTypes(String embeddedPropertyName, Class<ENTITY> entityClass, %3$s namingType) {%n", List.class.getName(), EntityPropertyType.class.getName(), NamingType.class.getName());
        this.iprint("    return %1$s.asList(%n", Arrays.class.getName());
        Iterator<EmbeddablePropertyMeta> it = this.embeddableMeta.getEmbeddablePropertyMetas().iterator();
        while (it.hasNext()) {
            EmbeddablePropertyMeta pm = it.next();
            EmbeddablePropertyCtTypeVisitor visitor = new EmbeddablePropertyCtTypeVisitor();
            pm.getCtType().accept(visitor, null);
            BasicCtType basicCtType = visitor.basicCtType;
            WrapperCtType wrapperCtType = visitor.wrapperCtType;
            DomainCtType domainCtType = visitor.domainCtType;
            String newWrapperExpr = basicCtType.isEnum() ? String.format("new %s(%s.class)", wrapperCtType.getTypeName(), basicCtType.getBoxedTypeName()) : String.format("new %s()", wrapperCtType.getTypeName());
            String parentEntityPropertyType = "null";
            String parentEntityBoxedTypeName = Object.class.getName();
            String domainType = "null";
            String domainTypeName = "Object";
            if (domainCtType != null) {
                domainType = domainCtType.getInstantiationCommand();
                domainTypeName = domainCtType.getTypeName();
            }
            this.iprint("        new %1$s<Object, ENTITY, %3$s, %16$s>(entityClass, %15$s.class, %3$s.class, () -> %9$s, null, %10$s, embeddedPropertyName + \".%4$s\", \"%5$s\", namingType, %6$s, %7$s, %17$s)", DefaultPropertyType.class.getName(), null, basicCtType.getBoxedTypeName(), pm.getName(), pm.getColumnName(), pm.isColumnInsertable(), pm.isColumnUpdatable(), null, newWrapperExpr, domainType, pm.getBoxedTypeName(), parentEntityPropertyType, parentEntityBoxedTypeName, null, pm.getBoxedClassName(), domainTypeName, pm.isColumnQuoteRequired());
            this.print(it.hasNext() ? ",%n" : "", new Object[0]);
        }
        this.print(");%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printNewEmbeddableMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public <ENTITY> %1$s newEmbeddable(String embeddedPropertyName, %2$s<String, %3$s<ENTITY, ?>> __args) {%n", this.embeddableMeta.getEmbeddableElement().getQualifiedName(), Map.class.getName(), Property.class.getName());
        if (this.embeddableMeta.isAbstract()) {
            this.iprint("    return null;%n", new Object[0]);
        } else {
            this.iprint("    return new %1$s(%n", this.embeddableMeta.getEmbeddableElement().getQualifiedName());
            Iterator<EmbeddablePropertyMeta> it = this.embeddableMeta.getEmbeddablePropertyMetas().iterator();
            while (it.hasNext()) {
                EmbeddablePropertyMeta propertyMeta = it.next();
                this.iprint("        (%1$s)(__args.get(embeddedPropertyName + \".%2$s\") != null ? __args.get(embeddedPropertyName + \".%2$s\").get() : null)", TypeMirrorUtil.boxIfPrimitive(propertyMeta.getType(), this.env), propertyMeta.getName());
                if (!it.hasNext()) continue;
                this.print(",%n", new Object[0]);
            }
            this.print(");%n", new Object[0]);
        }
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printGetSingletonInternalMethod() {
        this.iprint("/**%n", new Object[0]);
        this.iprint(" * @return the singleton%n", new Object[0]);
        this.iprint(" */%n", new Object[0]);
        this.iprint("public static %1$s getSingletonInternal() {%n", this.simpleName);
        this.iprint("    return __singleton;%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected class EmbeddablePropertyCtTypeVisitor
    extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
        protected BasicCtType basicCtType;
        protected WrapperCtType wrapperCtType;
        protected DomainCtType domainCtType;

        protected EmbeddablePropertyCtTypeVisitor() {
        }

        @Override
        protected Void defaultAction(CtType ctType, Void p) throws RuntimeException {
            AssertionUtil.assertNotNull(this.basicCtType);
            AssertionUtil.assertNotNull(this.wrapperCtType);
            return null;
        }

        @Override
        public Void visitOptionalCtType(OptionalCtType ctType, Void p) throws RuntimeException {
            return ctType.getElementCtType().accept(this, p);
        }

        @Override
        public Void visitOptionalIntCtType(OptionalIntCtType ctType, Void p) throws RuntimeException {
            return ctType.getElementCtType().accept(this, p);
        }

        @Override
        public Void visitOptionalLongCtType(OptionalLongCtType ctType, Void p) throws RuntimeException {
            return ctType.getElementCtType().accept(this, p);
        }

        @Override
        public Void visitOptionalDoubleCtType(OptionalDoubleCtType ctType, Void p) throws RuntimeException {
            return ctType.getElementCtType().accept(this, p);
        }

        @Override
        public Void visitBasicCtType(BasicCtType basicCtType, Void p) throws RuntimeException {
            this.basicCtType = basicCtType;
            this.wrapperCtType = basicCtType.getWrapperCtType();
            return this.defaultAction((CtType)basicCtType, p);
        }

        @Override
        public Void visitDomainCtType(DomainCtType domainCtType, Void p) throws RuntimeException {
            this.domainCtType = domainCtType;
            return this.visitBasicCtType(domainCtType.getBasicCtType(), p);
        }
    }
}

