/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import java.io.IOException;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.TypeElement;
import org.seasar.doma.Embeddable;
import org.seasar.doma.internal.apt.AbstractGeneratingProcessor;
import org.seasar.doma.internal.apt.EmbeddableTypeGenerator;
import org.seasar.doma.internal.apt.Generator;
import org.seasar.doma.internal.apt.meta.EmbeddableMeta;
import org.seasar.doma.internal.apt.meta.EmbeddableMetaFactory;
import org.seasar.doma.internal.apt.meta.EmbeddablePropertyMetaFactory;
import org.seasar.doma.internal.util.AssertionUtil;

@SupportedAnnotationTypes(value={"org.seasar.doma.Embeddable"})
@SupportedOptions(value={"doma.version.validation", "doma.resources.dir", "doma.lombok.Value", "doma.lombok.AllArgsConstructor", "doma.test", "doma.debug"})
public class EmbeddableProcessor
extends AbstractGeneratingProcessor<EmbeddableMeta> {
    public EmbeddableProcessor() {
        super(Embeddable.class);
    }

    protected EmbeddableMetaFactory createTypeElementMetaFactory() {
        EmbeddablePropertyMetaFactory propertyMetaFactory = this.createEmbeddablePropertyMetaFactory();
        return new EmbeddableMetaFactory(this.processingEnv, propertyMetaFactory);
    }

    protected EmbeddablePropertyMetaFactory createEmbeddablePropertyMetaFactory() {
        return new EmbeddablePropertyMetaFactory(this.processingEnv);
    }

    @Override
    protected Generator createGenerator(TypeElement typeElement, EmbeddableMeta meta) throws IOException {
        AssertionUtil.assertNotNull((Object)typeElement, (Object)meta);
        return new EmbeddableTypeGenerator(this.processingEnv, typeElement, meta);
    }
}

