/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import java.io.IOException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import org.seasar.doma.internal.apt.AbstractGenerator;
import org.seasar.doma.internal.apt.meta.DomainMeta;
import org.seasar.doma.internal.apt.util.MetaUtil;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.internal.util.BoxedPrimitiveUtil;
import org.seasar.doma.jdbc.domain.AbstractDomainType;

public class DomainTypeGenerator
extends AbstractGenerator {
    protected final DomainMeta domainMeta;
    protected final String typeName;
    protected final String simpleMetaClassName;
    protected final String typeParamDecl;

    public DomainTypeGenerator(ProcessingEnvironment env, TypeElement domainElement, DomainMeta domainMeta) throws IOException {
        super(env, domainElement, null, null, "_", "");
        AssertionUtil.assertNotNull(domainMeta);
        this.domainMeta = domainMeta;
        this.typeName = TypeMirrorUtil.getTypeName(domainMeta.getType(), env);
        this.simpleMetaClassName = MetaUtil.toSimpleMetaName(domainElement, env);
        this.typeParamDecl = this.makeTypeParamDecl(this.typeName);
    }

    private String makeTypeParamDecl(String typeName) {
        int pos = typeName.indexOf("<");
        if (pos == -1) {
            return "";
        }
        return typeName.substring(pos);
    }

    @Override
    public void generate() {
        this.printPackage();
        this.printClass();
    }

    protected void printPackage() {
        if (!this.packageName.isEmpty()) {
            this.iprint("package %1$s;%n", this.packageName);
            this.iprint("%n", new Object[0]);
        }
    }

    protected void printClass() {
        if (this.typeElement.getTypeParameters().isEmpty()) {
            this.iprint("/** */%n", new Object[0]);
        } else {
            this.iprint("/**%n", new Object[0]);
            for (TypeParameterElement typeParameterElement : this.typeElement.getTypeParameters()) {
                this.iprint(" * @param <%1$s> %1$s%n", typeParameterElement.getSimpleName());
            }
            this.iprint(" */%n", new Object[0]);
        }
        this.printGenerated();
        this.iprint("public final class %1$s%5$s extends %2$s<%3$s, %4$s> {%n", this.simpleMetaClassName, AbstractDomainType.class.getName(), TypeMirrorUtil.boxIfPrimitive(this.domainMeta.getValueType(), this.env), this.typeName, this.typeParamDecl);
        this.print("%n", new Object[0]);
        this.indent();
        this.printValidateVersionStaticInitializer();
        this.printFields();
        this.printConstructors();
        this.printMethods();
        this.unindent();
        this.unindent();
        this.iprint("}%n", new Object[0]);
    }

    protected void printFields() {
        if (this.domainMeta.isParametarized()) {
            this.iprint("@SuppressWarnings(\"rawtypes\")%n", new Object[0]);
        }
        this.iprint("private static final %1$s singleton = new %1$s();%n", this.simpleName);
        this.print("%n", new Object[0]);
    }

    protected void printConstructors() {
        this.iprint("private %1$s() {%n", this.simpleName);
        if (this.domainMeta.getBasicCtType().isEnum()) {
            this.iprint("    super(() -> new %1$s(%2$s.class));%n", this.domainMeta.getWrapperCtType().getTypeName(), TypeMirrorUtil.boxIfPrimitive(this.domainMeta.getValueType(), this.env));
        } else {
            this.iprint("    super(() -> new %1$s());%n", this.domainMeta.getWrapperCtType().getTypeName());
        }
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printMethods() {
        this.printNewDomainMethod();
        this.printGetBasicValueMethod();
        this.printGetBasicClassMethod();
        this.printGetDomainClassMethod();
        this.printGetSingletonInternalMethod();
    }

    protected void printNewDomainMethod() {
        boolean primitive = this.domainMeta.getBasicCtType().isPrimitive();
        this.iprint("@Override%n", new Object[0]);
        this.iprint("protected %1$s newDomain(%2$s value) {%n", this.typeName, TypeMirrorUtil.boxIfPrimitive(this.domainMeta.getValueType(), this.env));
        if (!primitive && !this.domainMeta.getAcceptNull()) {
            this.iprint("    if (value == null) {%n", new Object[0]);
            this.iprint("        return null;%n", new Object[0]);
            this.iprint("    }%n", new Object[0]);
        }
        if (this.domainMeta.providesConstructor()) {
            if (primitive) {
                this.iprint("    return new %1$s(%2$s.unbox(value));%n", this.typeName, BoxedPrimitiveUtil.class.getName());
            } else {
                this.iprint("    return new %1$s(value);%n", this.typeName);
            }
        } else if (primitive) {
            this.iprint("    return %1$s.%2$s(%3$s.unbox(value));%n", this.domainMeta.getTypeElement().getQualifiedName(), this.domainMeta.getFactoryMethod(), BoxedPrimitiveUtil.class.getName());
        } else {
            this.iprint("    return %1$s.%2$s(value);%n", this.domainMeta.getTypeElement().getQualifiedName(), this.domainMeta.getFactoryMethod());
        }
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printGetBasicValueMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("protected %1$s getBasicValue(%2$s domain) {%n", TypeMirrorUtil.boxIfPrimitive(this.domainMeta.getValueType(), this.env), this.typeName);
        this.iprint("    if (domain == null) {%n", new Object[0]);
        this.iprint("        return null;%n", new Object[0]);
        this.iprint("    }%n", new Object[0]);
        this.iprint("    return domain.%1$s();%n", this.domainMeta.getAccessorMethod());
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printGetBasicClassMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public Class<?> getBasicClass() {%n", new Object[0]);
        this.iprint("    return %1$s.class;%n", this.domainMeta.getValueType());
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printGetDomainClassMethod() {
        if (this.domainMeta.isParametarized()) {
            this.iprint("@SuppressWarnings(\"unchecked\")%n", new Object[0]);
        }
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public Class<%1$s> getDomainClass() {%n", this.typeName);
        if (this.domainMeta.isParametarized()) {
            this.iprint("    Class<?> clazz = %1$s.class;%n", this.domainMeta.getTypeElement().getQualifiedName());
            this.iprint("    return (Class<%1$s>) clazz;%n", this.typeName);
        } else {
            this.iprint("    return %1$s.class;%n", this.domainMeta.getTypeElement().getQualifiedName());
        }
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printGetSingletonInternalMethod() {
        this.iprint("/**%n", new Object[0]);
        this.iprint(" * @return the singleton%n", new Object[0]);
        this.iprint(" */%n", new Object[0]);
        if (this.domainMeta.isParametarized()) {
            this.iprint("@SuppressWarnings(\"unchecked\")%n", new Object[0]);
            this.iprint("public static %1$s %2$s%1$s getSingletonInternal() {%n", this.typeParamDecl, this.simpleMetaClassName);
            this.iprint("    return (%2$s%1$s) singleton;%n", this.typeParamDecl, this.simpleMetaClassName);
        } else {
            this.iprint("public static %1$s getSingletonInternal() {%n", this.simpleMetaClassName);
            this.iprint("    return singleton;%n", new Object[0]);
        }
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }
}

