/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.TypeElement;
import org.seasar.doma.Dao;
import org.seasar.doma.internal.apt.AbstractGeneratingProcessor;
import org.seasar.doma.internal.apt.DaoGenerator;
import org.seasar.doma.internal.apt.Generator;
import org.seasar.doma.internal.apt.meta.ArrayCreateQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.AutoBatchModifyQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.AutoFunctionQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.AutoModifyQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.AutoProcedureQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.BlobCreateQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.ClobCreateQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.DaoMeta;
import org.seasar.doma.internal.apt.meta.DaoMetaFactory;
import org.seasar.doma.internal.apt.meta.DefaultQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.NClobCreateQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.QueryMetaFactory;
import org.seasar.doma.internal.apt.meta.SQLXMLCreateQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.SqlFileBatchModifyQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.SqlFileModifyQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.SqlFileScriptQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.SqlFileSelectQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.SqlProcessorQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.TypeElementMetaFactory;
import org.seasar.doma.internal.util.AssertionUtil;

@SupportedAnnotationTypes(value={"org.seasar.doma.Dao"})
@SupportedOptions(value={"doma.test", "doma.debug", "doma.dao.package", "doma.dao.subpackage", "doma.dao.suffix", "doma.expr.functions", "doma.sql.validation", "doma.version.validation", "doma.resources.dir"})
public class DaoProcessor
extends AbstractGeneratingProcessor<DaoMeta> {
    public DaoProcessor() {
        super(Dao.class);
    }

    @Override
    protected TypeElementMetaFactory<DaoMeta> createTypeElementMetaFactory() {
        List<QueryMetaFactory> queryMetaFactories = this.createQueryMetaFactory();
        return new DaoMetaFactory(this.processingEnv, queryMetaFactories);
    }

    protected List<QueryMetaFactory> createQueryMetaFactory() {
        ArrayList<QueryMetaFactory> factories = new ArrayList<QueryMetaFactory>();
        factories.add(new SqlFileSelectQueryMetaFactory(this.processingEnv));
        factories.add(new AutoModifyQueryMetaFactory(this.processingEnv));
        factories.add(new AutoBatchModifyQueryMetaFactory(this.processingEnv));
        factories.add(new AutoFunctionQueryMetaFactory(this.processingEnv));
        factories.add(new AutoProcedureQueryMetaFactory(this.processingEnv));
        factories.add(new SqlFileModifyQueryMetaFactory(this.processingEnv));
        factories.add(new SqlFileBatchModifyQueryMetaFactory(this.processingEnv));
        factories.add(new SqlFileScriptQueryMetaFactory(this.processingEnv));
        factories.add(new DefaultQueryMetaFactory(this.processingEnv));
        factories.add(new ArrayCreateQueryMetaFactory(this.processingEnv));
        factories.add(new BlobCreateQueryMetaFactory(this.processingEnv));
        factories.add(new ClobCreateQueryMetaFactory(this.processingEnv));
        factories.add(new NClobCreateQueryMetaFactory(this.processingEnv));
        factories.add(new SQLXMLCreateQueryMetaFactory(this.processingEnv));
        factories.add(new SqlProcessorQueryMetaFactory(this.processingEnv));
        return factories;
    }

    @Override
    protected Generator createGenerator(TypeElement typeElement, DaoMeta meta) throws IOException {
        AssertionUtil.assertNotNull((Object)typeElement, (Object)meta);
        return new DaoGenerator(this.processingEnv, typeElement, meta);
    }
}

