/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.sql.DataSource;
import org.seasar.doma.AnnotationTarget;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.FetchType;
import org.seasar.doma.MapKeyNamingType;
import org.seasar.doma.SelectType;
import org.seasar.doma.internal.apt.AbstractGenerator;
import org.seasar.doma.internal.apt.Options;
import org.seasar.doma.internal.apt.cttype.BasicCtType;
import org.seasar.doma.internal.apt.cttype.CollectorCtType;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.DomainCtType;
import org.seasar.doma.internal.apt.cttype.EntityCtType;
import org.seasar.doma.internal.apt.cttype.EnumWrapperCtType;
import org.seasar.doma.internal.apt.cttype.FunctionCtType;
import org.seasar.doma.internal.apt.cttype.IterableCtType;
import org.seasar.doma.internal.apt.cttype.MapCtType;
import org.seasar.doma.internal.apt.cttype.OptionalCtType;
import org.seasar.doma.internal.apt.cttype.OptionalDoubleCtType;
import org.seasar.doma.internal.apt.cttype.OptionalIntCtType;
import org.seasar.doma.internal.apt.cttype.OptionalLongCtType;
import org.seasar.doma.internal.apt.cttype.SimpleCtTypeVisitor;
import org.seasar.doma.internal.apt.cttype.StreamCtType;
import org.seasar.doma.internal.apt.cttype.WrapperCtType;
import org.seasar.doma.internal.apt.meta.AbstractCreateQueryMeta;
import org.seasar.doma.internal.apt.meta.ArrayCreateQueryMeta;
import org.seasar.doma.internal.apt.meta.AutoBatchModifyQueryMeta;
import org.seasar.doma.internal.apt.meta.AutoFunctionQueryMeta;
import org.seasar.doma.internal.apt.meta.AutoModifyQueryMeta;
import org.seasar.doma.internal.apt.meta.AutoModuleQueryMeta;
import org.seasar.doma.internal.apt.meta.AutoProcedureQueryMeta;
import org.seasar.doma.internal.apt.meta.BasicInOutParameterMeta;
import org.seasar.doma.internal.apt.meta.BasicInParameterMeta;
import org.seasar.doma.internal.apt.meta.BasicListParameterMeta;
import org.seasar.doma.internal.apt.meta.BasicOutParameterMeta;
import org.seasar.doma.internal.apt.meta.BasicResultListParameterMeta;
import org.seasar.doma.internal.apt.meta.BasicSingleResultParameterMeta;
import org.seasar.doma.internal.apt.meta.CallableSqlParameterMeta;
import org.seasar.doma.internal.apt.meta.CallableSqlParameterMetaVisitor;
import org.seasar.doma.internal.apt.meta.DaoMeta;
import org.seasar.doma.internal.apt.meta.DefaultQueryMeta;
import org.seasar.doma.internal.apt.meta.DomainInOutParameterMeta;
import org.seasar.doma.internal.apt.meta.DomainInParameterMeta;
import org.seasar.doma.internal.apt.meta.DomainListParameterMeta;
import org.seasar.doma.internal.apt.meta.DomainOutParameterMeta;
import org.seasar.doma.internal.apt.meta.DomainResultListParameterMeta;
import org.seasar.doma.internal.apt.meta.DomainSingleResultParameterMeta;
import org.seasar.doma.internal.apt.meta.EntityListParameterMeta;
import org.seasar.doma.internal.apt.meta.EntityResultListParameterMeta;
import org.seasar.doma.internal.apt.meta.MapListParameterMeta;
import org.seasar.doma.internal.apt.meta.MapResultListParameterMeta;
import org.seasar.doma.internal.apt.meta.OptionalBasicInOutParameterMeta;
import org.seasar.doma.internal.apt.meta.OptionalBasicInParameterMeta;
import org.seasar.doma.internal.apt.meta.OptionalBasicListParameterMeta;
import org.seasar.doma.internal.apt.meta.OptionalBasicOutParameterMeta;
import org.seasar.doma.internal.apt.meta.OptionalBasicResultListParameterMeta;
import org.seasar.doma.internal.apt.meta.OptionalBasicSingleResultParameterMeta;
import org.seasar.doma.internal.apt.meta.OptionalDomainInOutParameterMeta;
import org.seasar.doma.internal.apt.meta.OptionalDomainInParameterMeta;
import org.seasar.doma.internal.apt.meta.OptionalDomainListParameterMeta;
import org.seasar.doma.internal.apt.meta.OptionalDomainOutParameterMeta;
import org.seasar.doma.internal.apt.meta.OptionalDomainResultListParameterMeta;
import org.seasar.doma.internal.apt.meta.OptionalDomainSingleResultParameterMeta;
import org.seasar.doma.internal.apt.meta.OptionalDoubleInOutParameterMeta;
import org.seasar.doma.internal.apt.meta.OptionalDoubleInParameterMeta;
import org.seasar.doma.internal.apt.meta.OptionalDoubleListParameterMeta;
import org.seasar.doma.internal.apt.meta.OptionalDoubleOutParameterMeta;
import org.seasar.doma.internal.apt.meta.OptionalDoubleResultListParameterMeta;
import org.seasar.doma.internal.apt.meta.OptionalDoubleSingleResultParameterMeta;
import org.seasar.doma.internal.apt.meta.OptionalIntInOutParameterMeta;
import org.seasar.doma.internal.apt.meta.OptionalIntInParameterMeta;
import org.seasar.doma.internal.apt.meta.OptionalIntListParameterMeta;
import org.seasar.doma.internal.apt.meta.OptionalIntOutParameterMeta;
import org.seasar.doma.internal.apt.meta.OptionalIntResultListParameterMeta;
import org.seasar.doma.internal.apt.meta.OptionalIntSingleResultParameterMeta;
import org.seasar.doma.internal.apt.meta.OptionalLongInOutParameterMeta;
import org.seasar.doma.internal.apt.meta.OptionalLongInParameterMeta;
import org.seasar.doma.internal.apt.meta.OptionalLongListParameterMeta;
import org.seasar.doma.internal.apt.meta.OptionalLongOutParameterMeta;
import org.seasar.doma.internal.apt.meta.OptionalLongResultListParameterMeta;
import org.seasar.doma.internal.apt.meta.OptionalLongSingleResultParameterMeta;
import org.seasar.doma.internal.apt.meta.ParentDaoMeta;
import org.seasar.doma.internal.apt.meta.QueryKind;
import org.seasar.doma.internal.apt.meta.QueryMeta;
import org.seasar.doma.internal.apt.meta.QueryMetaVisitor;
import org.seasar.doma.internal.apt.meta.QueryParameterMeta;
import org.seasar.doma.internal.apt.meta.QueryReturnMeta;
import org.seasar.doma.internal.apt.meta.SqlFileBatchModifyQueryMeta;
import org.seasar.doma.internal.apt.meta.SqlFileModifyQueryMeta;
import org.seasar.doma.internal.apt.meta.SqlFileScriptQueryMeta;
import org.seasar.doma.internal.apt.meta.SqlFileSelectQueryMeta;
import org.seasar.doma.internal.apt.meta.SqlProcessorQueryMeta;
import org.seasar.doma.internal.apt.mirror.AnnotationMirror;
import org.seasar.doma.internal.jdbc.command.BasicCollectorHandler;
import org.seasar.doma.internal.jdbc.command.BasicResultListHandler;
import org.seasar.doma.internal.jdbc.command.BasicSingleResultHandler;
import org.seasar.doma.internal.jdbc.command.BasicStreamHandler;
import org.seasar.doma.internal.jdbc.command.DomainCollectorHandler;
import org.seasar.doma.internal.jdbc.command.DomainResultListHandler;
import org.seasar.doma.internal.jdbc.command.DomainSingleResultHandler;
import org.seasar.doma.internal.jdbc.command.DomainStreamHandler;
import org.seasar.doma.internal.jdbc.command.EntityCollectorHandler;
import org.seasar.doma.internal.jdbc.command.EntityResultListHandler;
import org.seasar.doma.internal.jdbc.command.EntitySingleResultHandler;
import org.seasar.doma.internal.jdbc.command.EntityStreamHandler;
import org.seasar.doma.internal.jdbc.command.MapCollectorHandler;
import org.seasar.doma.internal.jdbc.command.MapResultListHandler;
import org.seasar.doma.internal.jdbc.command.MapSingleResultHandler;
import org.seasar.doma.internal.jdbc.command.MapStreamHandler;
import org.seasar.doma.internal.jdbc.command.OptionalBasicCollectorHandler;
import org.seasar.doma.internal.jdbc.command.OptionalBasicResultListHandler;
import org.seasar.doma.internal.jdbc.command.OptionalBasicSingleResultHandler;
import org.seasar.doma.internal.jdbc.command.OptionalBasicStreamHandler;
import org.seasar.doma.internal.jdbc.command.OptionalDomainCollectorHandler;
import org.seasar.doma.internal.jdbc.command.OptionalDomainResultListHandler;
import org.seasar.doma.internal.jdbc.command.OptionalDomainSingleResultHandler;
import org.seasar.doma.internal.jdbc.command.OptionalDomainStreamHandler;
import org.seasar.doma.internal.jdbc.command.OptionalDoubleCollectorHandler;
import org.seasar.doma.internal.jdbc.command.OptionalDoubleResultListHandler;
import org.seasar.doma.internal.jdbc.command.OptionalDoubleSingleResultHandler;
import org.seasar.doma.internal.jdbc.command.OptionalDoubleStreamHandler;
import org.seasar.doma.internal.jdbc.command.OptionalEntitySingleResultHandler;
import org.seasar.doma.internal.jdbc.command.OptionalIntCollectorHandler;
import org.seasar.doma.internal.jdbc.command.OptionalIntResultListHandler;
import org.seasar.doma.internal.jdbc.command.OptionalIntSingleResultHandler;
import org.seasar.doma.internal.jdbc.command.OptionalIntStreamHandler;
import org.seasar.doma.internal.jdbc.command.OptionalLongCollectorHandler;
import org.seasar.doma.internal.jdbc.command.OptionalLongResultListHandler;
import org.seasar.doma.internal.jdbc.command.OptionalLongSingleResultHandler;
import org.seasar.doma.internal.jdbc.command.OptionalLongStreamHandler;
import org.seasar.doma.internal.jdbc.command.OptionalMapSingleResultHandler;
import org.seasar.doma.internal.jdbc.dao.AbstractDao;
import org.seasar.doma.internal.jdbc.sql.BasicInOutParameter;
import org.seasar.doma.internal.jdbc.sql.BasicInParameter;
import org.seasar.doma.internal.jdbc.sql.BasicListParameter;
import org.seasar.doma.internal.jdbc.sql.BasicOutParameter;
import org.seasar.doma.internal.jdbc.sql.BasicResultListParameter;
import org.seasar.doma.internal.jdbc.sql.BasicSingleResultParameter;
import org.seasar.doma.internal.jdbc.sql.DomainInOutParameter;
import org.seasar.doma.internal.jdbc.sql.DomainInParameter;
import org.seasar.doma.internal.jdbc.sql.DomainListParameter;
import org.seasar.doma.internal.jdbc.sql.DomainOutParameter;
import org.seasar.doma.internal.jdbc.sql.DomainResultListParameter;
import org.seasar.doma.internal.jdbc.sql.DomainSingleResultParameter;
import org.seasar.doma.internal.jdbc.sql.EntityListParameter;
import org.seasar.doma.internal.jdbc.sql.EntityResultListParameter;
import org.seasar.doma.internal.jdbc.sql.MapListParameter;
import org.seasar.doma.internal.jdbc.sql.MapResultListParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalBasicInOutParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalBasicInParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalBasicListParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalBasicOutParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalBasicResultListParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalBasicSingleResultParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalDomainInOutParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalDomainInParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalDomainListParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalDomainOutParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalDomainResultListParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalDomainSingleResultParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalDoubleInOutParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalDoubleInParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalDoubleListParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalDoubleOutParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalDoubleResultListParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalDoubleSingleResultParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalIntInOutParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalIntInParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalIntListParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalIntOutParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalIntResultListParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalIntSingleResultParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalLongInOutParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalLongInParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalLongListParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalLongOutParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalLongResultListParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalLongSingleResultParameter;
import org.seasar.doma.internal.jdbc.util.ScriptFileUtil;
import org.seasar.doma.internal.jdbc.util.SqlFileUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Config;

public class DaoGenerator
extends AbstractGenerator {
    protected final DaoMeta daoMeta;

    public DaoGenerator(ProcessingEnvironment env, TypeElement daoElement, DaoMeta daoMeta) throws IOException {
        super(env, daoElement, Options.getDaoPackage(env), Options.getDaoSubpackage(env), "", Options.getDaoSuffix(env));
        AssertionUtil.assertNotNull(daoMeta);
        this.daoMeta = daoMeta;
    }

    @Override
    public void generate() {
        this.printPackage();
        this.printClass();
    }

    protected void printPackage() {
        if (!this.packageName.isEmpty()) {
            this.iprint("package %1$s;%n", this.packageName);
            this.iprint("%n", new Object[0]);
        }
    }

    protected void printClass() {
        this.iprint("/** */%n", new Object[0]);
        for (AnnotationMirror annotation : this.daoMeta.getAnnotationMirrors(AnnotationTarget.CLASS)) {
            this.iprint("@%1$s(%2$s)%n", annotation.getTypeValue(), annotation.getElementsValue());
        }
        this.printGenerated();
        String parentClassName = AbstractDao.class.getName();
        ParentDaoMeta parentDaoMeta = this.daoMeta.getParentDaoMeta();
        if (parentDaoMeta != null) {
            TypeElement parentDaotElement = parentDaoMeta.getDaoElement();
            parentClassName = this.createCanonicalName(this.env, parentDaotElement, this.fullpackage, this.subpackage, this.prefix, this.suffix);
        }
        this.iprint("%4$s class %1$s extends %2$s implements %3$s {%n", this.simpleName, parentClassName, this.daoMeta.getDaoType(), this.daoMeta.getAccessLevel().getModifier());
        this.print("%n", new Object[0]);
        this.indent();
        this.printValidateVersionStaticInitializer();
        this.printStaticFields();
        this.printConstructors();
        this.printMethods();
        this.unindent();
        this.print("}%n", new Object[0]);
    }

    protected void printStaticFields() {
        int i = 0;
        for (QueryMeta queryMeta : this.daoMeta.getQueryMetas()) {
            QueryKind kind = queryMeta.getQueryKind();
            if (kind != QueryKind.DEFAULT) {
                this.iprint("private static final %1$s __method%2$s = %3$s.getDeclaredMethod(%4$s.class, \"%5$s\"", Method.class.getName(), i, AbstractDao.class.getName(), this.daoMeta.getDaoType(), queryMeta.getName());
                for (QueryParameterMeta parameterMeta : queryMeta.getParameterMetas()) {
                    this.print(", %1$s.class", parameterMeta.getQualifiedName());
                }
                this.print(");%n", new Object[0]);
                this.print("%n", new Object[0]);
            }
            ++i;
        }
    }

    protected void printConstructors() {
        if (this.daoMeta.hasUserDefinedConfig()) {
            String singletonMethodName = this.daoMeta.getSingletonMethodName();
            String singletonFieldName = this.daoMeta.getSingletonFieldName();
            this.iprint("/** */%n", new Object[0]);
            this.iprint("public %1$s() {%n", this.simpleName);
            this.indent();
            if (singletonMethodName == null) {
                if (singletonFieldName == null) {
                    this.iprint("super(new %1$s());%n", this.daoMeta.getConfigType());
                } else {
                    this.iprint("super(%1$s.%2$s);%n", this.daoMeta.getConfigType(), singletonFieldName);
                }
            } else {
                this.iprint("super(%1$s.%2$s());%n", this.daoMeta.getConfigType(), singletonMethodName);
            }
            this.unindent();
            this.iprint("}%n", new Object[0]);
            this.print("%n", new Object[0]);
            if (this.daoMeta.getAnnotateWithMirror() == null) {
                boolean jdbcConstructorsNecessary;
                ParentDaoMeta parentDaoMeta = this.daoMeta.getParentDaoMeta();
                boolean bl = jdbcConstructorsNecessary = parentDaoMeta == null || parentDaoMeta.hasUserDefinedConfig();
                if (jdbcConstructorsNecessary) {
                    this.iprint("/**%n", new Object[0]);
                    this.iprint(" * @param connection the connection%n", new Object[0]);
                    this.iprint(" */%n", new Object[0]);
                    this.iprint("public %1$s(%2$s connection) {%n", this.simpleName, Connection.class.getName());
                    this.indent();
                    if (singletonMethodName == null) {
                        if (singletonFieldName == null) {
                            this.iprint("super(new %1$s(), connection);%n", this.daoMeta.getConfigType());
                        } else {
                            this.iprint("super(%1$s.%2$s, connection);%n", this.daoMeta.getConfigType(), singletonFieldName);
                        }
                    } else {
                        this.iprint("super(%1$s.%2$s(), connection);%n", this.daoMeta.getConfigType(), singletonMethodName);
                    }
                    this.unindent();
                    this.iprint("}%n", new Object[0]);
                    this.print("%n", new Object[0]);
                    this.iprint("/**%n", new Object[0]);
                    this.iprint(" * @param dataSource the dataSource%n", new Object[0]);
                    this.iprint(" */%n", new Object[0]);
                    this.iprint("public %1$s(%2$s dataSource) {%n", this.simpleName, DataSource.class.getName());
                    this.indent();
                    if (singletonMethodName == null) {
                        if (singletonFieldName == null) {
                            this.iprint("super(new %1$s(), dataSource);%n", this.daoMeta.getConfigType());
                        } else {
                            this.iprint("super(%1$s.%2$s, dataSource);%n", this.daoMeta.getConfigType(), singletonFieldName);
                        }
                    } else {
                        this.iprint("super(%1$s.%2$s(), dataSource);%n", this.daoMeta.getConfigType(), singletonMethodName);
                    }
                    this.unindent();
                    this.iprint("}%n", new Object[0]);
                    this.print("%n", new Object[0]);
                }
                this.iprint("/**%n", new Object[0]);
                this.iprint(" * @param config the configuration%n", new Object[0]);
                this.iprint(" */%n", new Object[0]);
                this.iprint("protected %1$s(%2$s config) {%n", this.simpleName, Config.class.getName());
                this.indent();
                this.iprint("super(config);%n", new Object[0]);
                this.unindent();
                this.iprint("}%n", new Object[0]);
                this.print("%n", new Object[0]);
                if (jdbcConstructorsNecessary) {
                    this.iprint("/**%n", new Object[0]);
                    this.iprint(" * @param config the configuration%n", new Object[0]);
                    this.iprint(" * @param connection the connection%n", new Object[0]);
                    this.iprint(" */%n", new Object[0]);
                    this.iprint("protected %1$s(%2$s config, %3$s connection) {%n", this.simpleName, Config.class.getName(), Connection.class.getName());
                    this.indent();
                    this.iprint("super(config, connection);%n", new Object[0]);
                    this.unindent();
                    this.iprint("}%n", new Object[0]);
                    this.print("%n", new Object[0]);
                    this.iprint("/**%n", new Object[0]);
                    this.iprint(" * @param config the configuration%n", new Object[0]);
                    this.iprint(" * @param dataSource the dataSource%n", new Object[0]);
                    this.iprint(" */%n", new Object[0]);
                    this.iprint("protected %1$s(%2$s config, %3$s dataSource) {%n", this.simpleName, Config.class.getName(), DataSource.class.getName());
                    this.indent();
                    this.iprint("super(config, dataSource);%n", new Object[0]);
                    this.unindent();
                    this.iprint("}%n", new Object[0]);
                    this.print("%n", new Object[0]);
                }
            }
        }
        if (!this.daoMeta.hasUserDefinedConfig() || this.daoMeta.getAnnotateWithMirror() != null) {
            this.iprint("/**%n", new Object[0]);
            this.iprint(" * @param config the config%n", new Object[0]);
            this.iprint(" */%n", new Object[0]);
            for (AnnotationMirror annotation : this.daoMeta.getAnnotationMirrors(AnnotationTarget.CONSTRUCTOR)) {
                this.iprint("@%1$s(%2$s)%n", annotation.getTypeValue(), annotation.getElementsValue());
            }
            this.iprint("public %1$s(", this.simpleName);
            for (AnnotationMirror annotation : this.daoMeta.getAnnotationMirrors(AnnotationTarget.CONSTRUCTOR_PARAMETER)) {
                this.print("@%1$s(%2$s) ", annotation.getTypeValue(), annotation.getElementsValue());
            }
            this.print("%1$s config) {%n", Config.class.getName());
            this.indent();
            this.iprint("super(config);%n", new Object[0]);
            this.unindent();
            this.iprint("}%n", new Object[0]);
            this.print("%n", new Object[0]);
        }
    }

    protected boolean isJdbcConstructoNecessary() {
        ParentDaoMeta parentDaoMeta = this.daoMeta.getParentDaoMeta();
        return parentDaoMeta == null || parentDaoMeta.hasUserDefinedConfig();
    }

    protected String toCSVFormat(List<String> values) {
        StringBuilder buf = new StringBuilder();
        if (values.size() > 0) {
            for (String value : values) {
                buf.append("\"");
                buf.append(value);
                buf.append("\", ");
            }
            buf.setLength(buf.length() - 2);
        }
        return buf.toString();
    }

    protected void printMethods() {
        MethodBodyGenerator generator = new MethodBodyGenerator();
        int i = 0;
        for (QueryMeta queryMeta : this.daoMeta.getQueryMetas()) {
            this.printMethod(generator, queryMeta, i);
            ++i;
        }
    }

    protected void printMethod(MethodBodyGenerator generator, QueryMeta m, int index) {
        Iterator<Object> it;
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public ", new Object[0]);
        if (!m.getTypeParameterNames().isEmpty()) {
            this.print("<", new Object[0]);
            it = m.getTypeParameterNames().iterator();
            while (it.hasNext()) {
                this.print("%1$s", it.next());
                if (!it.hasNext()) continue;
                this.print(", ", new Object[0]);
            }
            this.print("> ", new Object[0]);
        }
        this.print("%1$s %2$s(", m.getReturnMeta().getTypeName(), m.getName());
        it = m.getParameterMetas().iterator();
        while (it.hasNext()) {
            QueryParameterMeta parameterMeta = (QueryParameterMeta)it.next();
            String parameterTypeName = parameterMeta.getTypeName();
            if (!it.hasNext() && m.isVarArgs()) {
                parameterTypeName = parameterTypeName.replace("[]", "...");
            }
            this.print("%1$s %2$s", parameterTypeName, parameterMeta.getName());
            if (!it.hasNext()) continue;
            this.print(", ", new Object[0]);
        }
        this.print(") ", new Object[0]);
        if (!m.getThrownTypeNames().isEmpty()) {
            this.print("throws ", new Object[0]);
            it = m.getThrownTypeNames().iterator();
            while (it.hasNext()) {
                this.print("%1$s", it.next());
                if (!it.hasNext()) continue;
                this.print(", ", new Object[0]);
            }
            this.print(" ", new Object[0]);
        }
        this.print("{%n", new Object[0]);
        this.indent();
        m.accept(generator, "__method" + index);
        this.unindent();
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected class SqlFileSelectQueryReturnCtTypeVisitor
    extends SimpleCtTypeVisitor<Void, Boolean, RuntimeException> {
        protected final SqlFileSelectQueryMeta m;
        protected final String methodName;
        protected final String resultBoxedTypeName;
        protected final String commandClassName;
        protected final String commandName;

        protected SqlFileSelectQueryReturnCtTypeVisitor(SqlFileSelectQueryMeta m, String methodName) {
            this.m = m;
            this.methodName = methodName;
            this.resultBoxedTypeName = this.m.getReturnMeta().getBoxedTypeName();
            this.commandClassName = m.getCommandClass().getName();
            this.commandName = m.getCommandClass().getSimpleName();
        }

        @Override
        public Void visitBasicCtType(final BasicCtType basicCtType, final Boolean optional) throws RuntimeException {
            basicCtType.getWrapperCtType().accept(new SimpleCtTypeVisitor<Void, Void, RuntimeException>(){

                @Override
                public Void visitEnumWrapperCtType(EnumWrapperCtType ctType, Void p) throws RuntimeException {
                    DaoGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%7$s(%8$s, __query, new %3$s<%6$s>(() -> new %4$s(%5$s.class), false));%n", SqlFileSelectQueryReturnCtTypeVisitor.this.commandClassName, SqlFileSelectQueryReturnCtTypeVisitor.this.resultBoxedTypeName, SqlFileSelectQueryReturnCtTypeVisitor.this.getBasicSingleResultHandlerName(optional), ctType.getTypeName(), ctType.getBasicCtType().getQualifiedName(), ctType.getBasicCtType().getBoxedTypeName(), SqlFileSelectQueryReturnCtTypeVisitor.this.commandName, SqlFileSelectQueryReturnCtTypeVisitor.this.methodName);
                    return null;
                }

                @Override
                public Void visitWrapperCtType(WrapperCtType ctType, Void p) throws RuntimeException {
                    DaoGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%7$s(%8$s, __query, new %3$s<%6$s>(%4$s::new, %5$s));%n", SqlFileSelectQueryReturnCtTypeVisitor.this.commandClassName, SqlFileSelectQueryReturnCtTypeVisitor.this.resultBoxedTypeName, SqlFileSelectQueryReturnCtTypeVisitor.this.getBasicSingleResultHandlerName(optional), ctType.getTypeName(), basicCtType.isPrimitive(), ctType.getBasicCtType().getBoxedTypeName(), SqlFileSelectQueryReturnCtTypeVisitor.this.commandName, SqlFileSelectQueryReturnCtTypeVisitor.this.methodName);
                    return null;
                }
            }, null);
            return null;
        }

        @Override
        public Void visitDomainCtType(DomainCtType ctType, Boolean optional) throws RuntimeException {
            DaoGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%6$s(%7$s, __query, new %3$s<%8$s, %5$s>(%4$s));%n", this.commandClassName, this.resultBoxedTypeName, this.getDomainSingleResultHandlerName(optional), ctType.getInstantiationCommand(), ctType.getBoxedTypeName(), this.commandName, this.methodName, ctType.getBasicCtType().getBoxedTypeName());
            return null;
        }

        @Override
        public Void visitMapCtType(MapCtType ctType, Boolean optional) throws RuntimeException {
            MapKeyNamingType namingType = this.m.getMapKeyNamingType();
            DaoGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%6$s(%7$s, __query, new %3$s(%4$s.%5$s));%n", this.commandClassName, this.resultBoxedTypeName, this.getMapSingleResultHandlerName(optional), namingType.getDeclaringClass().getName(), namingType.name(), this.commandName, this.methodName);
            return null;
        }

        @Override
        public Void visitEntityCtType(EntityCtType ctType, Boolean optional) throws RuntimeException {
            DaoGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%6$s(%7$s, __query, new %3$s<%5$s>(%4$s.getSingletonInternal()));%n", this.commandClassName, this.resultBoxedTypeName, this.getEntitySingleResultHandlerName(optional), ctType.getMetaTypeName(), ctType.getTypeName(), this.commandName, this.methodName);
            return null;
        }

        @Override
        public Void visitOptionalCtType(OptionalCtType ctType, Boolean optional) throws RuntimeException {
            return ctType.getElementCtType().accept(this, true);
        }

        @Override
        public Void visitOptionalIntCtType(OptionalIntCtType ctType, Boolean p) throws RuntimeException {
            DaoGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%4$s(%5$s, __query, new %3$s());%n", this.commandClassName, this.resultBoxedTypeName, OptionalIntSingleResultHandler.class.getName(), this.commandName, this.methodName);
            return null;
        }

        @Override
        public Void visitOptionalLongCtType(OptionalLongCtType ctType, Boolean p) throws RuntimeException {
            DaoGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%4$s(%5$s, __query, new %3$s());%n", this.commandClassName, this.resultBoxedTypeName, OptionalLongSingleResultHandler.class.getName(), this.commandName, this.methodName);
            return null;
        }

        @Override
        public Void visitOptionalDoubleCtType(OptionalDoubleCtType ctType, Boolean p) throws RuntimeException {
            DaoGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%4$s(%5$s, __query, new %3$s());%n", this.commandClassName, this.resultBoxedTypeName, OptionalDoubleSingleResultHandler.class.getName(), this.commandName, this.methodName);
            return null;
        }

        @Override
        public Void visitIterableCtType(IterableCtType iterableCtType, Boolean __) throws RuntimeException {
            iterableCtType.getElementCtType().accept(new SimpleCtTypeVisitor<Void, Boolean, RuntimeException>(){

                @Override
                public Void visitBasicCtType(BasicCtType ctType, final Boolean optional) throws RuntimeException {
                    ctType.getWrapperCtType().accept(new SimpleCtTypeVisitor<Void, Void, RuntimeException>(){

                        @Override
                        public Void visitEnumWrapperCtType(EnumWrapperCtType ctType, Void p) throws RuntimeException {
                            DaoGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%7$s(%8$s, __query, new %3$s<%4$s>(() -> new %5$s(%6$s.class)));%n", SqlFileSelectQueryReturnCtTypeVisitor.this.commandClassName, SqlFileSelectQueryReturnCtTypeVisitor.this.resultBoxedTypeName, SqlFileSelectQueryReturnCtTypeVisitor.this.getBasicResultListHandlerName(optional), ctType.getBasicCtType().getBoxedTypeName(), ctType.getTypeName(), ctType.getBasicCtType().getQualifiedName(), SqlFileSelectQueryReturnCtTypeVisitor.this.commandName, SqlFileSelectQueryReturnCtTypeVisitor.this.methodName);
                            return null;
                        }

                        @Override
                        public Void visitWrapperCtType(WrapperCtType ctType, Void p) throws RuntimeException {
                            DaoGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%6$s(%7$s, __query, new %3$s<%4$s>(%5$s::new));%n", SqlFileSelectQueryReturnCtTypeVisitor.this.commandClassName, SqlFileSelectQueryReturnCtTypeVisitor.this.resultBoxedTypeName, SqlFileSelectQueryReturnCtTypeVisitor.this.getBasicResultListHandlerName(optional), ctType.getBasicCtType().getBoxedTypeName(), ctType.getTypeName(), SqlFileSelectQueryReturnCtTypeVisitor.this.commandName, SqlFileSelectQueryReturnCtTypeVisitor.this.methodName);
                            return null;
                        }
                    }, null);
                    return null;
                }

                @Override
                public Void visitDomainCtType(DomainCtType ctType, Boolean optional) throws RuntimeException {
                    DaoGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%6$s(%7$s, __query, new %3$s<%8$s, %4$s>(%5$s));%n", SqlFileSelectQueryReturnCtTypeVisitor.this.commandClassName, SqlFileSelectQueryReturnCtTypeVisitor.this.resultBoxedTypeName, SqlFileSelectQueryReturnCtTypeVisitor.this.getDomainResultListHandlerName(optional), ctType.getBoxedTypeName(), ctType.getInstantiationCommand(), SqlFileSelectQueryReturnCtTypeVisitor.this.commandName, SqlFileSelectQueryReturnCtTypeVisitor.this.methodName, ctType.getBasicCtType().getBoxedTypeName());
                    return null;
                }

                @Override
                public Void visitMapCtType(MapCtType ctType, Boolean optional) throws RuntimeException {
                    MapKeyNamingType namingType = SqlFileSelectQueryReturnCtTypeVisitor.this.m.getMapKeyNamingType();
                    DaoGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%6$s(%7$s, __query, new %3$s(%4$s.%5$s));%n", SqlFileSelectQueryReturnCtTypeVisitor.this.commandClassName, SqlFileSelectQueryReturnCtTypeVisitor.this.resultBoxedTypeName, SqlFileSelectQueryReturnCtTypeVisitor.this.getMapResultListHandlerName(optional), namingType.getDeclaringClass().getName(), namingType.name(), SqlFileSelectQueryReturnCtTypeVisitor.this.commandName, SqlFileSelectQueryReturnCtTypeVisitor.this.methodName);
                    return null;
                }

                @Override
                public Void visitEntityCtType(EntityCtType ctType, Boolean optional) throws RuntimeException {
                    DaoGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%6$s(%7$s, __query, new %3$s<%4$s>(%5$s.getSingletonInternal()));%n", SqlFileSelectQueryReturnCtTypeVisitor.this.commandClassName, SqlFileSelectQueryReturnCtTypeVisitor.this.resultBoxedTypeName, SqlFileSelectQueryReturnCtTypeVisitor.this.getEntityResultListHandlerName(optional), ctType.getTypeName(), ctType.getMetaTypeName(), SqlFileSelectQueryReturnCtTypeVisitor.this.commandName, SqlFileSelectQueryReturnCtTypeVisitor.this.methodName);
                    return null;
                }

                @Override
                public Void visitOptionalCtType(OptionalCtType ctType, Boolean __) throws RuntimeException {
                    return ctType.getElementCtType().accept(this, true);
                }

                @Override
                public Void visitOptionalIntCtType(OptionalIntCtType ctType, Boolean p) throws RuntimeException {
                    DaoGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%4$s(%5$s, __query, new %3$s());%n", SqlFileSelectQueryReturnCtTypeVisitor.this.commandClassName, SqlFileSelectQueryReturnCtTypeVisitor.this.resultBoxedTypeName, OptionalIntResultListHandler.class.getName(), SqlFileSelectQueryReturnCtTypeVisitor.this.commandName, SqlFileSelectQueryReturnCtTypeVisitor.this.methodName);
                    return null;
                }

                @Override
                public Void visitOptionalLongCtType(OptionalLongCtType ctType, Boolean p) throws RuntimeException {
                    DaoGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%4$s(%5$s, __query, new %3$s());%n", SqlFileSelectQueryReturnCtTypeVisitor.this.commandClassName, SqlFileSelectQueryReturnCtTypeVisitor.this.resultBoxedTypeName, OptionalLongResultListHandler.class.getName(), SqlFileSelectQueryReturnCtTypeVisitor.this.commandName, SqlFileSelectQueryReturnCtTypeVisitor.this.methodName);
                    return null;
                }

                @Override
                public Void visitOptionalDoubleCtType(OptionalDoubleCtType ctType, Boolean p) throws RuntimeException {
                    DaoGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%4$s(%5$s, __query, new %3$s());%n", SqlFileSelectQueryReturnCtTypeVisitor.this.commandClassName, SqlFileSelectQueryReturnCtTypeVisitor.this.resultBoxedTypeName, OptionalDoubleResultListHandler.class.getName(), SqlFileSelectQueryReturnCtTypeVisitor.this.commandName, SqlFileSelectQueryReturnCtTypeVisitor.this.methodName);
                    return null;
                }
            }, false);
            return null;
        }

        @Override
        public Void visitStreamCtType(StreamCtType ctType, Boolean __) throws RuntimeException {
            ctType.getElementCtType().accept(new StreamElementCtTypeVisitor(this.m, this.methodName, this.resultBoxedTypeName, this.commandClassName, this.commandName, Function.class.getName() + ".identity()"), false);
            return null;
        }

        protected String getBasicSingleResultHandlerName(Boolean optional) {
            if (Boolean.TRUE == optional) {
                return OptionalBasicSingleResultHandler.class.getName();
            }
            return BasicSingleResultHandler.class.getName();
        }

        protected String getBasicResultListHandlerName(Boolean optional) {
            if (Boolean.TRUE == optional) {
                return OptionalBasicResultListHandler.class.getName();
            }
            return BasicResultListHandler.class.getName();
        }

        protected String getDomainSingleResultHandlerName(Boolean optional) {
            if (Boolean.TRUE == optional) {
                return OptionalDomainSingleResultHandler.class.getName();
            }
            return DomainSingleResultHandler.class.getName();
        }

        protected String getDomainResultListHandlerName(Boolean optional) {
            if (Boolean.TRUE == optional) {
                return OptionalDomainResultListHandler.class.getName();
            }
            return DomainResultListHandler.class.getName();
        }

        protected String getMapSingleResultHandlerName(Boolean optional) {
            if (Boolean.TRUE == optional) {
                return OptionalMapSingleResultHandler.class.getName();
            }
            return MapSingleResultHandler.class.getName();
        }

        protected String getMapResultListHandlerName(Boolean optional) {
            return MapResultListHandler.class.getName();
        }

        protected String getEntitySingleResultHandlerName(Boolean optional) {
            if (Boolean.TRUE == optional) {
                return OptionalEntitySingleResultHandler.class.getName();
            }
            return EntitySingleResultHandler.class.getName();
        }

        protected String getEntityResultListHandlerName(Boolean optional) {
            return EntityResultListHandler.class.getName();
        }
    }

    protected class SqlFileSelectQueryCollectorCtTypeVisitor
    extends SimpleCtTypeVisitor<Void, Boolean, RuntimeException> {
        protected final SqlFileSelectQueryMeta m;
        protected final String methodName;
        protected final QueryReturnMeta resultMeta;
        protected final String commandClassName;
        protected final String commandName;
        protected final String collectorParamName;

        public SqlFileSelectQueryCollectorCtTypeVisitor(SqlFileSelectQueryMeta m, String methodName) {
            this.m = m;
            this.methodName = methodName;
            this.resultMeta = m.getReturnMeta();
            this.commandClassName = m.getCommandClass().getName();
            this.commandName = m.getCommandClass().getSimpleName();
            this.collectorParamName = m.getCollectorParameterName();
        }

        @Override
        public Void visitBasicCtType(BasicCtType ctType, final Boolean optional) throws RuntimeException {
            ctType.getWrapperCtType().accept(new SimpleCtTypeVisitor<Void, Void, RuntimeException>(){

                @Override
                public Void visitEnumWrapperCtType(EnumWrapperCtType ctType, Void p) throws RuntimeException {
                    DaoGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%8$s(%9$s, __query, new %3$s<%4$s, %2$s>(() -> new %5$s(%6$s.class), %7$s));%n", SqlFileSelectQueryCollectorCtTypeVisitor.this.commandClassName, SqlFileSelectQueryCollectorCtTypeVisitor.this.resultMeta.getBoxedTypeName(), SqlFileSelectQueryCollectorCtTypeVisitor.this.getBasicCollectorHandlerName(optional), ctType.getBasicCtType().getBoxedTypeName(), ctType.getTypeName(), ctType.getBasicCtType().getQualifiedName(), SqlFileSelectQueryCollectorCtTypeVisitor.this.collectorParamName, SqlFileSelectQueryCollectorCtTypeVisitor.this.commandName, SqlFileSelectQueryCollectorCtTypeVisitor.this.methodName);
                    return null;
                }

                @Override
                public Void visitWrapperCtType(WrapperCtType ctType, Void p) throws RuntimeException {
                    DaoGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%7$s(%8$s, __query, new %3$s<%4$s, %2$s>(%5$s::new, %6$s));%n", SqlFileSelectQueryCollectorCtTypeVisitor.this.commandClassName, SqlFileSelectQueryCollectorCtTypeVisitor.this.resultMeta.getBoxedTypeName(), SqlFileSelectQueryCollectorCtTypeVisitor.this.getBasicCollectorHandlerName(optional), ctType.getBasicCtType().getBoxedTypeName(), ctType.getTypeName(), SqlFileSelectQueryCollectorCtTypeVisitor.this.collectorParamName, SqlFileSelectQueryCollectorCtTypeVisitor.this.commandName, SqlFileSelectQueryCollectorCtTypeVisitor.this.methodName);
                    return null;
                }
            }, null);
            return null;
        }

        @Override
        public Void visitDomainCtType(DomainCtType ctType, Boolean optional) throws RuntimeException {
            DaoGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%7$s(%8$s, __query, new %3$s<%9$s, %4$s, %2$s>(%5$s, %6$s));%n", this.commandClassName, this.resultMeta.getBoxedTypeName(), this.getDomainCollectorHandlerName(optional), ctType.getBoxedTypeName(), ctType.getInstantiationCommand(), this.collectorParamName, this.commandName, this.methodName, ctType.getBasicCtType().getBoxedTypeName());
            return null;
        }

        @Override
        public Void visitMapCtType(MapCtType ctType, Boolean optional) throws RuntimeException {
            MapKeyNamingType namingType = this.m.getMapKeyNamingType();
            DaoGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%7$s(%8$s, __query, new %3$s<%2$s>(%4$s.%5$s, %6$s));%n", this.commandClassName, this.resultMeta.getBoxedTypeName(), this.getMapCollectorHandlerName(optional), namingType.getDeclaringClass().getName(), namingType.name(), this.collectorParamName, this.commandName, this.methodName);
            return null;
        }

        @Override
        public Void visitEntityCtType(EntityCtType ctType, Boolean optional) throws RuntimeException {
            DaoGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%7$s(%8$s, __query, new %3$s<%4$s, %2$s>(%5$s.getSingletonInternal(), %6$s));%n", this.commandClassName, this.resultMeta.getBoxedTypeName(), this.getEntityCollectorHandlerName(optional), ctType.getTypeName(), ctType.getMetaTypeName(), this.collectorParamName, this.commandName, this.methodName);
            return null;
        }

        @Override
        public Void visitOptionalCtType(OptionalCtType ctType, Boolean optional) throws RuntimeException {
            return ctType.getElementCtType().accept(this, true);
        }

        @Override
        public Void visitOptionalIntCtType(OptionalIntCtType ctType, Boolean p) throws RuntimeException {
            DaoGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%5$s(%6$s, __query, new %3$s<%2$s>(%4$s));%n", this.commandClassName, this.resultMeta.getBoxedTypeName(), OptionalIntCollectorHandler.class.getName(), this.collectorParamName, this.commandName, this.methodName);
            return null;
        }

        @Override
        public Void visitOptionalLongCtType(OptionalLongCtType ctType, Boolean p) throws RuntimeException {
            DaoGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%5$s(%6$s, __query, new %3$s<%2$s>(%4$s));%n", this.commandClassName, this.resultMeta.getBoxedTypeName(), OptionalLongCollectorHandler.class.getName(), this.collectorParamName, this.commandName, this.methodName);
            return null;
        }

        @Override
        public Void visitOptionalDoubleCtType(OptionalDoubleCtType ctType, Boolean p) throws RuntimeException {
            DaoGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%5$s(%6$s, __query, new %3$s<%2$s>(%4$s));%n", this.commandClassName, this.resultMeta.getBoxedTypeName(), OptionalDoubleCollectorHandler.class.getName(), this.collectorParamName, this.commandName, this.methodName);
            return null;
        }

        protected String getBasicCollectorHandlerName(Boolean optional) {
            if (Boolean.TRUE == optional) {
                return OptionalBasicCollectorHandler.class.getName();
            }
            return BasicCollectorHandler.class.getName();
        }

        protected String getDomainCollectorHandlerName(Boolean optional) {
            if (Boolean.TRUE == optional) {
                return OptionalDomainCollectorHandler.class.getName();
            }
            return DomainCollectorHandler.class.getName();
        }

        protected String getMapCollectorHandlerName(Boolean optional) {
            return MapCollectorHandler.class.getName();
        }

        protected String getEntityCollectorHandlerName(Boolean optional) {
            return EntityCollectorHandler.class.getName();
        }
    }

    protected class StreamElementCtTypeVisitor
    extends SimpleCtTypeVisitor<Void, Boolean, RuntimeException> {
        protected final SqlFileSelectQueryMeta m;
        protected final String methodName;
        protected final String resultBoxedTypeName;
        protected final String commandClassName;
        protected final String commandName;
        protected final String functionParamName;

        public StreamElementCtTypeVisitor(SqlFileSelectQueryMeta m, String methodName, String resultBoxedTypeName, String commandClassName, String commandName, String functionParamName) {
            this.m = m;
            this.methodName = methodName;
            this.resultBoxedTypeName = resultBoxedTypeName;
            this.commandClassName = commandClassName;
            this.commandName = commandName;
            this.functionParamName = functionParamName;
        }

        @Override
        public Void visitBasicCtType(BasicCtType ctType, final Boolean optional) throws RuntimeException {
            ctType.getWrapperCtType().accept(new SimpleCtTypeVisitor<Void, Void, RuntimeException>(){

                @Override
                public Void visitEnumWrapperCtType(EnumWrapperCtType ctType, Void p) throws RuntimeException {
                    DaoGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%8$s(%9$s, __query, new %3$s<%4$s, %2$s>(() -> new %5$s(%6$s.class), %7$s));%n", StreamElementCtTypeVisitor.this.commandClassName, StreamElementCtTypeVisitor.this.resultBoxedTypeName, StreamElementCtTypeVisitor.this.getBasicStreamHandlerName(optional), ctType.getBasicCtType().getBoxedTypeName(), ctType.getTypeName(), ctType.getBasicCtType().getQualifiedName(), StreamElementCtTypeVisitor.this.functionParamName, StreamElementCtTypeVisitor.this.commandName, StreamElementCtTypeVisitor.this.methodName);
                    return null;
                }

                @Override
                public Void visitWrapperCtType(WrapperCtType ctType, Void p) throws RuntimeException {
                    DaoGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%7$s(%8$s, __query, new %3$s<%4$s, %2$s>(%5$s::new, %6$s));%n", StreamElementCtTypeVisitor.this.commandClassName, StreamElementCtTypeVisitor.this.resultBoxedTypeName, StreamElementCtTypeVisitor.this.getBasicStreamHandlerName(optional), ctType.getBasicCtType().getBoxedTypeName(), ctType.getTypeName(), StreamElementCtTypeVisitor.this.functionParamName, StreamElementCtTypeVisitor.this.commandName, StreamElementCtTypeVisitor.this.methodName);
                    return null;
                }
            }, null);
            return null;
        }

        @Override
        public Void visitDomainCtType(DomainCtType ctType, Boolean optional) throws RuntimeException {
            DaoGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%7$s(%8$s, __query, new %3$s<%9$s, %4$s, %2$s>(%5$s, %6$s));%n", this.commandClassName, this.resultBoxedTypeName, this.getDomainStreamHandlerName(optional), ctType.getBoxedTypeName(), ctType.getInstantiationCommand(), this.functionParamName, this.commandName, this.methodName, ctType.getBasicCtType().getBoxedTypeName());
            return null;
        }

        @Override
        public Void visitMapCtType(MapCtType ctType, Boolean optional) throws RuntimeException {
            MapKeyNamingType namingType = this.m.getMapKeyNamingType();
            DaoGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%7$s(%8$s, __query, new %3$s<%2$s>(%4$s.%5$s, %6$s));%n", this.commandClassName, this.resultBoxedTypeName, this.getMapStreamHandlerName(optional), namingType.getDeclaringClass().getName(), namingType.name(), this.functionParamName, this.commandName, this.methodName);
            return null;
        }

        @Override
        public Void visitEntityCtType(EntityCtType ctType, Boolean optional) throws RuntimeException {
            DaoGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%7$s(%8$s, __query, new %3$s<%4$s, %2$s>(%5$s.getSingletonInternal(), %6$s));%n", this.commandClassName, this.resultBoxedTypeName, this.getEntityStreamHandlerName(optional), ctType.getTypeName(), ctType.getMetaTypeName(), this.functionParamName, this.commandName, this.methodName);
            return null;
        }

        @Override
        public Void visitOptionalCtType(OptionalCtType ctType, Boolean optional) throws RuntimeException {
            return ctType.getElementCtType().accept(this, true);
        }

        @Override
        public Void visitOptionalIntCtType(OptionalIntCtType ctType, Boolean p) throws RuntimeException {
            DaoGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%5$s(%6$s, __query, new %3$s<%2$s>(%4$s));%n", this.commandClassName, this.resultBoxedTypeName, OptionalIntStreamHandler.class.getName(), this.functionParamName, this.commandName, this.methodName);
            return null;
        }

        @Override
        public Void visitOptionalLongCtType(OptionalLongCtType ctType, Boolean p) throws RuntimeException {
            DaoGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%5$s(%6$s, __query, new %3$s<%2$s>(%4$s));%n", this.commandClassName, this.resultBoxedTypeName, OptionalLongStreamHandler.class.getName(), this.functionParamName, this.commandName, this.methodName);
            return null;
        }

        @Override
        public Void visitOptionalDoubleCtType(OptionalDoubleCtType ctType, Boolean p) throws RuntimeException {
            DaoGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%5$s(%6$s, __query, new %3$s<%2$s>(%4$s));%n", this.commandClassName, this.resultBoxedTypeName, OptionalDoubleStreamHandler.class.getName(), this.functionParamName, this.commandName, this.methodName);
            return null;
        }

        protected String getBasicStreamHandlerName(Boolean optional) {
            if (Boolean.TRUE == optional) {
                return OptionalBasicStreamHandler.class.getName();
            }
            return BasicStreamHandler.class.getName();
        }

        protected String getDomainStreamHandlerName(Boolean optional) {
            if (Boolean.TRUE == optional) {
                return OptionalDomainStreamHandler.class.getName();
            }
            return DomainStreamHandler.class.getName();
        }

        protected String getMapStreamHandlerName(Boolean optional) {
            return MapStreamHandler.class.getName();
        }

        protected String getEntityStreamHandlerName(Boolean optional) {
            return EntityStreamHandler.class.getName();
        }
    }

    protected class SqlFileSelectQueryFunctionCtTypeVisitor
    extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
        protected final SqlFileSelectQueryMeta m;
        protected final String methodName;
        protected final QueryReturnMeta resultMeta;
        protected final String commandClassName;
        protected final String commandName;
        protected final String functionParamName;

        public SqlFileSelectQueryFunctionCtTypeVisitor(SqlFileSelectQueryMeta m, String methodName) {
            this.m = m;
            this.methodName = methodName;
            this.resultMeta = m.getReturnMeta();
            this.commandClassName = m.getCommandClass().getName();
            this.commandName = m.getCommandClass().getSimpleName();
            this.functionParamName = m.getFunctionParameterName();
        }

        @Override
        public Void visitStreamCtType(StreamCtType ctType, Void p) throws RuntimeException {
            ctType.getElementCtType().accept(new StreamElementCtTypeVisitor(this.m, this.methodName, this.resultMeta.getBoxedTypeName(), this.commandClassName, this.commandName, this.functionParamName), false);
            return null;
        }
    }

    protected class CallableSqlParameterStatementGenerator
    implements CallableSqlParameterMetaVisitor<Void, AutoModuleQueryMeta> {
        protected CallableSqlParameterStatementGenerator() {
        }

        @Override
        public Void visitBasicListParameterMeta(final BasicListParameterMeta m, AutoModuleQueryMeta p) {
            BasicCtType basicCtType = m.getBasicCtType();
            basicCtType.getWrapperCtType().accept(new SimpleCtTypeVisitor<Void, Void, RuntimeException>(){

                @Override
                public Void visitEnumWrapperCtType(EnumWrapperCtType ctType, Void p) throws RuntimeException {
                    DaoGenerator.this.iprint("__query.addParameter(new %1$s<%2$s>(() -> new %3$s(%4$s.class), %5$s, \"%5$s\"));%n", BasicListParameter.class.getName(), ctType.getBasicCtType().getBoxedTypeName(), ctType.getTypeName(), ctType.getBasicCtType().getQualifiedName(), m.getName());
                    return null;
                }

                @Override
                public Void visitWrapperCtType(WrapperCtType ctType, Void p) throws RuntimeException {
                    DaoGenerator.this.iprint("__query.addParameter(new %1$s<%2$s>(%3$s::new, %4$s, \"%4$s\"));%n", BasicListParameter.class.getName(), ctType.getBasicCtType().getBoxedTypeName(), ctType.getTypeName(), m.getName());
                    return null;
                }
            }, null);
            return null;
        }

        @Override
        public Void visitDomainListParameterMeta(DomainListParameterMeta m, AutoModuleQueryMeta p) {
            DomainCtType domainCtType = m.getDomainCtType();
            BasicCtType basicCtType = domainCtType.getBasicCtType();
            DaoGenerator.this.iprint("__query.addParameter(new %1$s<%2$s, %3$s>(%4$s, %5$s, \"%5$s\"));%n", DomainListParameter.class.getName(), basicCtType.getTypeName(), domainCtType.getTypeName(), domainCtType.getInstantiationCommand(), m.getName());
            return null;
        }

        @Override
        public Void visitEntityListParameterMeta(EntityListParameterMeta m, AutoModuleQueryMeta p) {
            EntityCtType entityCtType = m.getEntityCtType();
            DaoGenerator.this.iprint("__query.addParameter(new %1$s<%2$s>(%3$s.getSingletonInternal(), %4$s, \"%4$s\", %5$s));%n", EntityListParameter.class.getName(), entityCtType.getTypeName(), entityCtType.getMetaTypeName(), m.getName(), m.getEnsureResultMapping());
            return null;
        }

        @Override
        public Void visitMapListParameterMeta(MapListParameterMeta m, AutoModuleQueryMeta p) {
            MapKeyNamingType namingType = p.getMapKeyNamingType();
            DaoGenerator.this.iprint("__query.addParameter(new %1$s(%2$s.%3$s, %4$s, \"%4$s\"));%n", MapListParameter.class.getName(), namingType.getDeclaringClass().getName(), namingType.name(), m.getName());
            return null;
        }

        @Override
        public Void visitBasicInOutParameterMeta(final BasicInOutParameterMeta m, AutoModuleQueryMeta p) {
            BasicCtType basicCtType = m.getBasicCtType();
            basicCtType.getWrapperCtType().accept(new SimpleCtTypeVisitor<Void, Void, RuntimeException>(){

                @Override
                public Void visitEnumWrapperCtType(EnumWrapperCtType ctType, Void p) throws RuntimeException {
                    DaoGenerator.this.iprint("__query.addParameter(new %1$s<%2$s>(() -> new %3$s(%4$s.class), %5$s));%n", BasicInOutParameter.class.getName(), ctType.getBasicCtType().getBoxedTypeName(), ctType.getTypeName(), ctType.getBasicCtType().getQualifiedName(), m.getName());
                    return null;
                }

                @Override
                public Void visitWrapperCtType(WrapperCtType ctType, Void p) throws RuntimeException {
                    DaoGenerator.this.iprint("__query.addParameter(new %1$s<%2$s>(%3$s::new, %4$s));%n", BasicInOutParameter.class.getName(), ctType.getBasicCtType().getBoxedTypeName(), ctType.getTypeName(), m.getName());
                    return null;
                }
            }, null);
            return null;
        }

        @Override
        public Void visitDomainInOutParameterMeta(DomainInOutParameterMeta m, AutoModuleQueryMeta p) {
            DomainCtType domainCtType = m.getDomainCtType();
            BasicCtType basicCtType = domainCtType.getBasicCtType();
            DaoGenerator.this.iprint("__query.addParameter(new %1$s<%2$s, %3$s>(%4$s, %5$s));%n", DomainInOutParameter.class.getName(), basicCtType.getBoxedTypeName(), domainCtType.getTypeName(), domainCtType.getInstantiationCommand(), m.getName());
            return null;
        }

        @Override
        public Void visitBasicOutParameterMeta(final BasicOutParameterMeta m, AutoModuleQueryMeta p) {
            BasicCtType basicCtType = m.getBasicCtType();
            basicCtType.getWrapperCtType().accept(new SimpleCtTypeVisitor<Void, Void, RuntimeException>(){

                @Override
                public Void visitEnumWrapperCtType(EnumWrapperCtType ctType, Void p) throws RuntimeException {
                    DaoGenerator.this.iprint("__query.addParameter(new %1$s<%2$s>(() -> new %3$s(%4$s.class), %5$s));%n", BasicOutParameter.class.getName(), ctType.getBasicCtType().getBoxedTypeName(), ctType.getTypeName(), ctType.getBasicCtType().getQualifiedName(), m.getName());
                    return null;
                }

                @Override
                public Void visitWrapperCtType(WrapperCtType ctType, Void p) throws RuntimeException {
                    DaoGenerator.this.iprint("__query.addParameter(new %1$s<%2$s>(%3$s::new, %4$s));%n", BasicOutParameter.class.getName(), ctType.getBasicCtType().getBoxedTypeName(), ctType.getTypeName(), m.getName());
                    return null;
                }
            }, null);
            return null;
        }

        @Override
        public Void visitDomainOutParameterMeta(DomainOutParameterMeta m, AutoModuleQueryMeta p) {
            DomainCtType domainCtType = m.getDomainCtType();
            BasicCtType basicCtType = domainCtType.getBasicCtType();
            DaoGenerator.this.iprint("__query.addParameter(new %1$s<%2$s, %3$s>(%4$s, %5$s));%n", DomainOutParameter.class.getName(), basicCtType.getTypeName(), domainCtType.getTypeName(), domainCtType.getInstantiationCommand(), m.getName());
            return null;
        }

        @Override
        public Void visitBasicInParameterMeta(final BasicInParameterMeta m, AutoModuleQueryMeta p) {
            BasicCtType basicCtType = m.getBasicCtType();
            basicCtType.getWrapperCtType().accept(new SimpleCtTypeVisitor<Void, Void, RuntimeException>(){

                @Override
                public Void visitEnumWrapperCtType(EnumWrapperCtType ctType, Void p) throws RuntimeException {
                    DaoGenerator.this.iprint("__query.addParameter(new %1$s<%5$s>(() -> new %2$s(%3$s.class, %4$s)));%n", BasicInParameter.class.getName(), ctType.getTypeName(), ctType.getBasicCtType().getQualifiedName(), m.getName(), ctType.getBasicCtType().getBoxedTypeName());
                    return null;
                }

                @Override
                public Void visitWrapperCtType(WrapperCtType ctType, Void p) throws RuntimeException {
                    DaoGenerator.this.iprint("__query.addParameter(new %1$s<%4$s>(%2$s::new, %3$s));%n", BasicInParameter.class.getName(), ctType.getTypeName(), m.getName(), ctType.getBasicCtType().getBoxedTypeName());
                    return null;
                }
            }, null);
            return null;
        }

        @Override
        public Void visitDomainInParameterMeta(DomainInParameterMeta m, AutoModuleQueryMeta p) {
            DomainCtType domainCtType = m.getDomainCtType();
            BasicCtType basicCtType = domainCtType.getBasicCtType();
            DaoGenerator.this.iprint("__query.addParameter(new %1$s<%2$s, %3$s>(%4$s, %5$s));%n", DomainInParameter.class.getName(), basicCtType.getTypeName(), domainCtType.getTypeName(), domainCtType.getInstantiationCommand(), m.getName());
            return null;
        }

        @Override
        public Void visitBasicResultListParameterMeta(BasicResultListParameterMeta m, AutoModuleQueryMeta p) {
            BasicCtType basicCtType = m.getBasicCtType();
            basicCtType.getWrapperCtType().accept(new SimpleCtTypeVisitor<Void, Void, RuntimeException>(){

                @Override
                public Void visitEnumWrapperCtType(EnumWrapperCtType ctType, Void p) throws RuntimeException {
                    DaoGenerator.this.iprint("__query.setResultParameter(new %1$s<%2$s>(() -> new %3$s(%4$s.class)));%n", BasicResultListParameter.class.getName(), ctType.getBasicCtType().getBoxedTypeName(), ctType.getTypeName(), ctType.getBasicCtType().getQualifiedName());
                    return null;
                }

                @Override
                public Void visitWrapperCtType(WrapperCtType ctType, Void p) throws RuntimeException {
                    DaoGenerator.this.iprint("__query.setResultParameter(new %1$s<%2$s>(%3$s::new));%n", BasicResultListParameter.class.getName(), ctType.getBasicCtType().getBoxedTypeName(), ctType.getTypeName());
                    return null;
                }
            }, null);
            return null;
        }

        @Override
        public Void visitDomainResultListParameterMeta(DomainResultListParameterMeta m, AutoModuleQueryMeta p) {
            DomainCtType domainCtType = m.getDomainCtType();
            BasicCtType basicCtType = domainCtType.getBasicCtType();
            DaoGenerator.this.iprint("__query.setResultParameter(new %1$s<%2$s, %3$s>(%4$s));%n", DomainResultListParameter.class.getName(), basicCtType.getTypeName(), domainCtType.getTypeName(), domainCtType.getInstantiationCommand());
            return null;
        }

        @Override
        public Void visitEntityResultListParameterMeta(EntityResultListParameterMeta m, AutoModuleQueryMeta p) {
            EntityCtType entityCtType = m.getEntityCtType();
            DaoGenerator.this.iprint("__query.setResultParameter(new %1$s<%2$s>(%3$s.getSingletonInternal(), %4$s));%n", EntityResultListParameter.class.getName(), entityCtType.getTypeName(), entityCtType.getMetaTypeName(), m.getEnsureResultMapping());
            return null;
        }

        @Override
        public Void visitMapResultListParameterMeta(MapResultListParameterMeta m, AutoModuleQueryMeta p) {
            MapKeyNamingType namingType = p.getMapKeyNamingType();
            DaoGenerator.this.iprint("__query.setResultParameter(new %1$s(%2$s.%3$s));%n", MapResultListParameter.class.getName(), namingType.getDeclaringClass().getName(), namingType.name());
            return null;
        }

        @Override
        public Void visitBasicSingleResultParameterMeta(BasicSingleResultParameterMeta m, AutoModuleQueryMeta p) {
            final BasicCtType basicCtType = m.getBasicCtType();
            basicCtType.getWrapperCtType().accept(new SimpleCtTypeVisitor<Void, Void, RuntimeException>(){

                @Override
                public Void visitEnumWrapperCtType(EnumWrapperCtType ctType, Void p) throws RuntimeException {
                    DaoGenerator.this.iprint("__query.setResultParameter(new %1$s<%2$s>(() -> new %3$s(%4$s.class), false));%n", BasicSingleResultParameter.class.getName(), ctType.getBasicCtType().getBoxedTypeName(), ctType.getTypeName(), ctType.getBasicCtType().getQualifiedName());
                    return null;
                }

                @Override
                public Void visitWrapperCtType(WrapperCtType ctType, Void p) throws RuntimeException {
                    DaoGenerator.this.iprint("__query.setResultParameter(new %1$s<%2$s>(%3$s::new, %4$s));%n", BasicSingleResultParameter.class.getName(), ctType.getBasicCtType().getBoxedTypeName(), ctType.getTypeName(), basicCtType.isPrimitive());
                    return null;
                }
            }, null);
            return null;
        }

        @Override
        public Void visitDomainSingleResultParameterMeta(DomainSingleResultParameterMeta m, AutoModuleQueryMeta p) {
            DomainCtType domainCtType = m.getDomainCtType();
            BasicCtType basicCtType = domainCtType.getBasicCtType();
            DaoGenerator.this.iprint("__query.setResultParameter(new %1$s<%2$s, %3$s>(%4$s));%n", DomainSingleResultParameter.class.getName(), basicCtType.getTypeName(), domainCtType.getTypeName(), domainCtType.getInstantiationCommand());
            return null;
        }

        @Override
        public Void visitOptionalBasicInParameterMeta(final OptionalBasicInParameterMeta m, AutoModuleQueryMeta p) {
            BasicCtType basicCtType = m.getBasicCtType();
            basicCtType.getWrapperCtType().accept(new SimpleCtTypeVisitor<Void, Void, RuntimeException>(){

                @Override
                public Void visitEnumWrapperCtType(EnumWrapperCtType ctType, Void p) throws RuntimeException {
                    DaoGenerator.this.iprint("__query.addParameter(new %1$s<%5$s>(() -> new %2$s(%3$s.class), %4$s));%n", OptionalBasicInParameter.class.getName(), ctType.getTypeName(), ctType.getBasicCtType().getQualifiedName(), m.getName(), ctType.getBasicCtType().getBoxedTypeName());
                    return null;
                }

                @Override
                public Void visitWrapperCtType(WrapperCtType ctType, Void p) throws RuntimeException {
                    DaoGenerator.this.iprint("__query.addParameter(new %1$s<%4$s>(%2$s::new, %3$s));%n", OptionalBasicInParameter.class.getName(), ctType.getTypeName(), m.getName(), ctType.getBasicCtType().getBoxedTypeName());
                    return null;
                }
            }, null);
            return null;
        }

        @Override
        public Void visitOptionalBasicOutParameterMeta(final OptionalBasicOutParameterMeta m, AutoModuleQueryMeta p) {
            BasicCtType basicCtType = m.getBasicCtType();
            basicCtType.getWrapperCtType().accept(new SimpleCtTypeVisitor<Void, Void, RuntimeException>(){

                @Override
                public Void visitEnumWrapperCtType(EnumWrapperCtType ctType, Void p) throws RuntimeException {
                    DaoGenerator.this.iprint("__query.addParameter(new %1$s<%2$s>(() -> new %3$s(%4$s.class), %5$s));%n", OptionalBasicOutParameter.class.getName(), ctType.getBasicCtType().getBoxedTypeName(), ctType.getTypeName(), ctType.getBasicCtType().getQualifiedName(), m.getName());
                    return null;
                }

                @Override
                public Void visitWrapperCtType(WrapperCtType ctType, Void p) throws RuntimeException {
                    DaoGenerator.this.iprint("__query.addParameter(new %1$s<%2$s>(() -> new %3$s(), %4$s));%n", OptionalBasicOutParameter.class.getName(), ctType.getBasicCtType().getBoxedTypeName(), ctType.getTypeName(), m.getName());
                    return null;
                }
            }, null);
            return null;
        }

        @Override
        public Void visitOptionalBasicInOutParameterMeta(final OptionalBasicInOutParameterMeta m, AutoModuleQueryMeta p) {
            BasicCtType basicCtType = m.getBasicCtType();
            basicCtType.getWrapperCtType().accept(new SimpleCtTypeVisitor<Void, Void, RuntimeException>(){

                @Override
                public Void visitEnumWrapperCtType(EnumWrapperCtType ctType, Void p) throws RuntimeException {
                    DaoGenerator.this.iprint("__query.addParameter(new %1$s<%2$s>(() -> new %3$s(%4$s.class), %5$s));%n", OptionalBasicInOutParameter.class.getName(), ctType.getBasicCtType().getBoxedTypeName(), ctType.getTypeName(), ctType.getBasicCtType().getQualifiedName(), m.getName());
                    return null;
                }

                @Override
                public Void visitWrapperCtType(WrapperCtType ctType, Void p) throws RuntimeException {
                    DaoGenerator.this.iprint("__query.addParameter(new %1$s<%2$s>(() -> new %3$s(), %4$s));%n", OptionalBasicInOutParameter.class.getName(), ctType.getBasicCtType().getBoxedTypeName(), ctType.getTypeName(), m.getName());
                    return null;
                }
            }, null);
            return null;
        }

        @Override
        public Void visitOptionalBasicListParameterMeta(final OptionalBasicListParameterMeta m, AutoModuleQueryMeta p) {
            BasicCtType basicCtType = m.getBasicCtType();
            basicCtType.getWrapperCtType().accept(new SimpleCtTypeVisitor<Void, Void, RuntimeException>(){

                @Override
                public Void visitEnumWrapperCtType(EnumWrapperCtType ctType, Void p) throws RuntimeException {
                    DaoGenerator.this.iprint("__query.addParameter(new %1$s<%2$s>(() -> new %3$s(%4$s.class), %5$s, \"%5$s\"));%n", OptionalBasicListParameter.class.getName(), ctType.getBasicCtType().getBoxedTypeName(), ctType.getTypeName(), ctType.getBasicCtType().getQualifiedName(), m.getName());
                    return null;
                }

                @Override
                public Void visitWrapperCtType(WrapperCtType ctType, Void p) throws RuntimeException {
                    DaoGenerator.this.iprint("__query.addParameter(new %1$s<%2$s>(() -> new %3$s(), %4$s, \"%4$s\"));%n", OptionalBasicListParameter.class.getName(), ctType.getBasicCtType().getBoxedTypeName(), ctType.getTypeName(), m.getName());
                    return null;
                }
            }, null);
            return null;
        }

        @Override
        public Void visitOptionalBasicSingleResultParameterMeta(OptionalBasicSingleResultParameterMeta m, AutoModuleQueryMeta p) {
            BasicCtType basicCtType = m.getBasicCtType();
            basicCtType.getWrapperCtType().accept(new SimpleCtTypeVisitor<Void, Void, RuntimeException>(){

                @Override
                public Void visitEnumWrapperCtType(EnumWrapperCtType ctType, Void p) throws RuntimeException {
                    DaoGenerator.this.iprint("__query.setResultParameter(new %1$s<%2$s>(() -> new %3$s(%4$s.class)));%n", OptionalBasicSingleResultParameter.class.getName(), ctType.getBasicCtType().getBoxedTypeName(), ctType.getTypeName(), ctType.getBasicCtType().getQualifiedName());
                    return null;
                }

                @Override
                public Void visitWrapperCtType(WrapperCtType ctType, Void p) throws RuntimeException {
                    DaoGenerator.this.iprint("__query.setResultParameter(new %1$s<%2$s>(() -> new %3$s()));%n", OptionalBasicSingleResultParameter.class.getName(), ctType.getBasicCtType().getBoxedTypeName(), ctType.getTypeName());
                    return null;
                }
            }, null);
            return null;
        }

        @Override
        public Void visitOptionalBasicResultListParameterMeta(OptionalBasicResultListParameterMeta m, AutoModuleQueryMeta p) {
            BasicCtType basicCtType = m.getBasicCtType();
            basicCtType.getWrapperCtType().accept(new SimpleCtTypeVisitor<Void, Void, RuntimeException>(){

                @Override
                public Void visitEnumWrapperCtType(EnumWrapperCtType ctType, Void p) throws RuntimeException {
                    DaoGenerator.this.iprint("__query.setResultParameter(new %1$s<%2$s>(() -> new %3$s(%4$s.class)));%n", OptionalBasicResultListParameter.class.getName(), ctType.getBasicCtType().getBoxedTypeName(), ctType.getTypeName(), ctType.getBasicCtType().getQualifiedName());
                    return null;
                }

                @Override
                public Void visitWrapperCtType(WrapperCtType ctType, Void p) throws RuntimeException {
                    DaoGenerator.this.iprint("__query.setResultParameter(new %1$s<%2$s>(() -> new %3$s()));%n", OptionalBasicResultListParameter.class.getName(), ctType.getBasicCtType().getBoxedTypeName(), ctType.getTypeName());
                    return null;
                }
            }, null);
            return null;
        }

        @Override
        public Void visitOptionalDomainInParameterMeta(OptionalDomainInParameterMeta m, AutoModuleQueryMeta p) {
            DomainCtType domainCtType = m.getDomainCtType();
            BasicCtType basicCtType = domainCtType.getBasicCtType();
            DaoGenerator.this.iprint("__query.addParameter(new %1$s<%2$s, %3$s>(%4$s, %5$s));%n", OptionalDomainInParameter.class.getName(), basicCtType.getTypeName(), domainCtType.getTypeName(), domainCtType.getInstantiationCommand(), m.getName());
            return null;
        }

        @Override
        public Void visitOptionalDomainOutParameterMeta(OptionalDomainOutParameterMeta m, AutoModuleQueryMeta p) {
            DomainCtType domainCtType = m.getDomainCtType();
            BasicCtType basicCtType = domainCtType.getBasicCtType();
            DaoGenerator.this.iprint("__query.addParameter(new %1$s<%2$s, %3$s>(%4$s, %5$s));%n", OptionalDomainOutParameter.class.getName(), basicCtType.getTypeName(), domainCtType.getTypeName(), domainCtType.getInstantiationCommand(), m.getName());
            return null;
        }

        @Override
        public Void visitOptionalDomainInOutParameterMeta(OptionalDomainInOutParameterMeta m, AutoModuleQueryMeta p) {
            DomainCtType domainCtType = m.getDomainCtType();
            BasicCtType basicCtType = domainCtType.getBasicCtType();
            DaoGenerator.this.iprint("__query.addParameter(new %1$s<%2$s, %3$s>(%4$s, %5$s));%n", OptionalDomainInOutParameter.class.getName(), basicCtType.getBoxedTypeName(), domainCtType.getTypeName(), domainCtType.getInstantiationCommand(), m.getName());
            return null;
        }

        @Override
        public Void visitOptionalDomainListParameterMeta(OptionalDomainListParameterMeta m, AutoModuleQueryMeta p) {
            DomainCtType domainCtType = m.getDomainCtType();
            BasicCtType basicCtType = domainCtType.getBasicCtType();
            DaoGenerator.this.iprint("__query.addParameter(new %1$s<%2$s, %3$s>(%4$s, %5$s, \"%5$s\"));%n", OptionalDomainListParameter.class.getName(), basicCtType.getTypeName(), domainCtType.getTypeName(), domainCtType.getInstantiationCommand(), m.getName());
            return null;
        }

        @Override
        public Void visitOptionalDomainSingleResultParameterMeta(OptionalDomainSingleResultParameterMeta m, AutoModuleQueryMeta p) {
            DomainCtType domainCtType = m.getDomainCtType();
            BasicCtType basicCtType = domainCtType.getBasicCtType();
            DaoGenerator.this.iprint("__query.setResultParameter(new %1$s<%2$s, %3$s>(%4$s));%n", OptionalDomainSingleResultParameter.class.getName(), basicCtType.getTypeName(), domainCtType.getTypeName(), domainCtType.getInstantiationCommand());
            return null;
        }

        @Override
        public Void visitOptionalDomainResultListParameterMeta(OptionalDomainResultListParameterMeta m, AutoModuleQueryMeta p) {
            DomainCtType domainCtType = m.getDomainCtType();
            BasicCtType basicCtType = domainCtType.getBasicCtType();
            DaoGenerator.this.iprint("__query.setResultParameter(new %1$s<%2$s, %3$s>(%4$s));%n", OptionalDomainResultListParameter.class.getName(), basicCtType.getTypeName(), domainCtType.getTypeName(), domainCtType.getInstantiationCommand());
            return null;
        }

        @Override
        public Void visitOptionalIntInOutParameterMeta(OptionalIntInOutParameterMeta m, AutoModuleQueryMeta p) {
            DaoGenerator.this.iprint("__query.addParameter(new %1$s(%2$s));%n", OptionalIntInOutParameter.class.getName(), m.getName());
            return null;
        }

        @Override
        public Void visitOptionalIntInParameterMeta(OptionalIntInParameterMeta m, AutoModuleQueryMeta p) {
            DaoGenerator.this.iprint("__query.addParameter(new %1$s(%2$s));%n", OptionalIntInParameter.class.getName(), m.getName());
            return null;
        }

        @Override
        public Void visitOptionalIntListParameterMeta(OptionalIntListParameterMeta m, AutoModuleQueryMeta p) {
            DaoGenerator.this.iprint("__query.addParameter(new %1$s(%2$s, \"%2$s\"));%n", OptionalIntListParameter.class.getName(), m.getName());
            return null;
        }

        @Override
        public Void visitOptionalIntOutParameterMeta(OptionalIntOutParameterMeta m, AutoModuleQueryMeta p) {
            DaoGenerator.this.iprint("__query.addParameter(new %1$s(%2$s));%n", OptionalIntOutParameter.class.getName(), m.getName());
            return null;
        }

        @Override
        public Void visitOptionalIntSingleResultParameterMeta(OptionalIntSingleResultParameterMeta m, AutoModuleQueryMeta p) {
            DaoGenerator.this.iprint("__query.setResultParameter(new %1$s());%n", OptionalIntSingleResultParameter.class.getName());
            return null;
        }

        @Override
        public Void visitOptionalIntResultListParameterMeta(OptionalIntResultListParameterMeta m, AutoModuleQueryMeta p) {
            DaoGenerator.this.iprint("__query.setResultParameter(new %1$s());%n", OptionalIntResultListParameter.class.getName());
            return null;
        }

        @Override
        public Void visitOptionalLongOutParameterMeta(OptionalLongOutParameterMeta m, AutoModuleQueryMeta p) {
            DaoGenerator.this.iprint("__query.addParameter(new %1$s(%2$s));%n", OptionalLongOutParameter.class.getName(), m.getName());
            return null;
        }

        @Override
        public Void visitOptionalLongSingleResultParameterMeta(OptionalLongSingleResultParameterMeta m, AutoModuleQueryMeta p) {
            DaoGenerator.this.iprint("__query.setResultParameter(new %1$s());%n", OptionalLongSingleResultParameter.class.getName());
            return null;
        }

        @Override
        public Void visitOptionalLongResultListParameterMeta(OptionalLongResultListParameterMeta m, AutoModuleQueryMeta p) {
            DaoGenerator.this.iprint("__query.setResultParameter(new %1$s());%n", OptionalLongResultListParameter.class.getName());
            return null;
        }

        @Override
        public Void visitOptionalLongInOutParameterMeta(OptionalLongInOutParameterMeta m, AutoModuleQueryMeta p) {
            DaoGenerator.this.iprint("__query.addParameter(new %1$s(%2$s));%n", OptionalLongInOutParameter.class.getName(), m.getName());
            return null;
        }

        @Override
        public Void visitOptionalLongInParameterMeta(OptionalLongInParameterMeta m, AutoModuleQueryMeta p) {
            DaoGenerator.this.iprint("__query.addParameter(new %1$s(%2$s));%n", OptionalLongInParameter.class.getName(), m.getName());
            return null;
        }

        @Override
        public Void visitOptionalLongListParameterMeta(OptionalLongListParameterMeta m, AutoModuleQueryMeta p) {
            DaoGenerator.this.iprint("__query.addParameter(new %1$s(%2$s, \"%2$s\"));%n", OptionalLongListParameter.class.getName(), m.getName());
            return null;
        }

        @Override
        public Void visitOptionalDoubleOutParameterMeta(OptionalDoubleOutParameterMeta m, AutoModuleQueryMeta p) {
            DaoGenerator.this.iprint("__query.addParameter(new %1$s(%2$s));%n", OptionalDoubleOutParameter.class.getName(), m.getName());
            return null;
        }

        @Override
        public Void visitOptionalDoubleSingleResultParameterMeta(OptionalDoubleSingleResultParameterMeta m, AutoModuleQueryMeta p) {
            DaoGenerator.this.iprint("__query.setResultParameter(new %1$s());%n", OptionalDoubleSingleResultParameter.class.getName());
            return null;
        }

        @Override
        public Void visitOptionalDoubleResultListParameterMeta(OptionalDoubleResultListParameterMeta m, AutoModuleQueryMeta p) {
            DaoGenerator.this.iprint("__query.setResultParameter(new %1$s());%n", OptionalDoubleResultListParameter.class.getName());
            return null;
        }

        @Override
        public Void visitOptionalDoubleInOutParameterMeta(OptionalDoubleInOutParameterMeta m, AutoModuleQueryMeta p) {
            DaoGenerator.this.iprint("__query.addParameter(new %1$s(%2$s));%n", OptionalDoubleInOutParameter.class.getName(), m.getName());
            return null;
        }

        @Override
        public Void visitOptionalDoubleInParameterMeta(OptionalDoubleInParameterMeta m, AutoModuleQueryMeta p) {
            DaoGenerator.this.iprint("__query.addParameter(new %1$s(%2$s));%n", OptionalDoubleInParameter.class.getName(), m.getName());
            return null;
        }

        @Override
        public Void visitOptionalDoubleListParameterMeta(OptionalDoubleListParameterMeta m, AutoModuleQueryMeta p) {
            DaoGenerator.this.iprint("__query.addParameter(new %1$s(%2$s, \"%2$s\"));%n", OptionalDoubleListParameter.class.getName(), m.getName());
            return null;
        }
    }

    protected class MethodBodyGenerator
    implements QueryMetaVisitor<Void, String> {
        protected MethodBodyGenerator() {
        }

        @Override
        public Void visitSqlFileSelectQueryMeta(SqlFileSelectQueryMeta m, String methodName) {
            this.printEnteringStatements(m);
            this.printPrerequisiteStatements(m);
            DaoGenerator.this.iprint("%1$s __query = getQueryImplementors().create%2$s(%3$s);%n", m.getQueryClass().getName(), m.getQueryClass().getSimpleName(), methodName);
            DaoGenerator.this.iprint("__query.setMethod(%1$s);%n", methodName);
            DaoGenerator.this.iprint("__query.setConfig(__config);%n", new Object[0]);
            DaoGenerator.this.iprint("__query.setSqlFilePath(\"%1$s\");%n", SqlFileUtil.buildPath(DaoGenerator.this.daoMeta.getDaoElement().getQualifiedName().toString(), m.getName()));
            if (m.getSelectOptionsCtType() != null) {
                DaoGenerator.this.iprint("__query.setOptions(%1$s);%n", m.getSelectOptionsParameterName());
            }
            if (m.getEntityCtType() != null) {
                DaoGenerator.this.iprint("__query.setEntityType(%1$s.getSingletonInternal());%n", m.getEntityCtType().getMetaTypeName());
            }
            this.printAddParameterStatements(m.getParameterMetas());
            DaoGenerator.this.iprint("__query.setCallerClassName(\"%1$s\");%n", DaoGenerator.this.canonicalName);
            DaoGenerator.this.iprint("__query.setCallerMethodName(\"%1$s\");%n", m.getName());
            DaoGenerator.this.iprint("__query.setResultEnsured(%1$s);%n", m.getEnsureResult());
            DaoGenerator.this.iprint("__query.setResultMappingEnsured(%1$s);%n", m.getEnsureResultMapping());
            if (m.getSelectStrategyType() == SelectType.RETURN) {
                DaoGenerator.this.iprint("__query.setFetchType(%1$s.%2$s);%n", new Object[]{FetchType.class.getName(), FetchType.LAZY});
            } else {
                DaoGenerator.this.iprint("__query.setFetchType(%1$s.%2$s);%n", new Object[]{FetchType.class.getName(), m.getFetchType()});
            }
            DaoGenerator.this.iprint("__query.setQueryTimeout(%1$s);%n", m.getQueryTimeout());
            DaoGenerator.this.iprint("__query.setMaxRows(%1$s);%n", m.getMaxRows());
            DaoGenerator.this.iprint("__query.setFetchSize(%1$s);%n", m.getFetchSize());
            DaoGenerator.this.iprint("__query.setSqlLogType(%1$s.%2$s);%n", new Object[]{((Object)((Object)m.getSqlLogType())).getClass().getName(), m.getSqlLogType()});
            if (m.isResultStream()) {
                DaoGenerator.this.iprint("__query.setResultStream(true);%n", new Object[0]);
            }
            DaoGenerator.this.iprint("__query.prepare();%n", new Object[0]);
            QueryReturnMeta returnMeta = m.getReturnMeta();
            if (m.getSelectStrategyType() == SelectType.RETURN) {
                CtType returnCtType = returnMeta.getCtType();
                returnCtType.accept(new SqlFileSelectQueryReturnCtTypeVisitor(m, methodName), false);
                DaoGenerator.this.iprint("%1$s __result = __command.execute();%n", returnMeta.getTypeName());
                DaoGenerator.this.iprint("__query.complete();%n", new Object[0]);
                DaoGenerator.this.iprint("exiting(\"%1$s\", \"%2$s\", __result);%n", DaoGenerator.this.canonicalName, m.getName());
                DaoGenerator.this.iprint("return __result;%n", new Object[0]);
            } else {
                if (m.getSelectStrategyType() == SelectType.STREAM) {
                    FunctionCtType functionCtType = m.getFunctionCtType();
                    functionCtType.getTargetCtType().accept(new SqlFileSelectQueryFunctionCtTypeVisitor(m, methodName), null);
                } else if (m.getSelectStrategyType() == SelectType.COLLECT) {
                    CollectorCtType collectorCtType = m.getCollectorCtType();
                    collectorCtType.getTargetCtType().accept(new SqlFileSelectQueryCollectorCtTypeVisitor(m, methodName), false);
                }
                if ("void".equals(returnMeta.getTypeName())) {
                    DaoGenerator.this.iprint("__command.execute();%n", new Object[0]);
                    DaoGenerator.this.iprint("__query.complete();%n", new Object[0]);
                    DaoGenerator.this.iprint("exiting(\"%1$s\", \"%2$s\", null);%n", DaoGenerator.this.canonicalName, m.getName());
                } else {
                    DaoGenerator.this.iprint("%1$s __result = __command.execute();%n", returnMeta.getTypeName());
                    DaoGenerator.this.iprint("__query.complete();%n", new Object[0]);
                    DaoGenerator.this.iprint("exiting(\"%1$s\", \"%2$s\", __result);%n", DaoGenerator.this.canonicalName, m.getName());
                    DaoGenerator.this.iprint("return __result;%n", new Object[0]);
                }
            }
            this.printThrowingStatements(m);
            return null;
        }

        @Override
        public Void visitSqlFileScriptQueryMeta(SqlFileScriptQueryMeta m, String methodName) {
            this.printEnteringStatements(m);
            this.printPrerequisiteStatements(m);
            DaoGenerator.this.iprint("%1$s __query = getQueryImplementors().create%2$s(%3$s);%n", m.getQueryClass().getName(), m.getQueryClass().getSimpleName(), methodName);
            DaoGenerator.this.iprint("__query.setMethod(%1$s);%n", methodName);
            DaoGenerator.this.iprint("__query.setConfig(__config);%n", new Object[0]);
            DaoGenerator.this.iprint("__query.setScriptFilePath(\"%1$s\");%n", ScriptFileUtil.buildPath(DaoGenerator.this.daoMeta.getDaoElement().getQualifiedName().toString(), m.getName()));
            DaoGenerator.this.iprint("__query.setCallerClassName(\"%1$s\");%n", DaoGenerator.this.canonicalName);
            DaoGenerator.this.iprint("__query.setCallerMethodName(\"%1$s\");%n", m.getName());
            DaoGenerator.this.iprint("__query.setBlockDelimiter(\"%1$s\");%n", m.getBlockDelimiter());
            DaoGenerator.this.iprint("__query.setHaltOnError(%1$s);%n", m.getHaltOnError());
            DaoGenerator.this.iprint("__query.setSqlLogType(%1$s.%2$s);%n", new Object[]{((Object)((Object)m.getSqlLogType())).getClass().getName(), m.getSqlLogType()});
            DaoGenerator.this.iprint("__query.prepare();%n", new Object[0]);
            DaoGenerator.this.iprint("%1$s __command = getCommandImplementors().create%2$s(%3$s, __query);%n", m.getCommandClass().getName(), m.getCommandClass().getSimpleName(), methodName);
            DaoGenerator.this.iprint("__command.execute();%n", new Object[0]);
            DaoGenerator.this.iprint("__query.complete();%n", new Object[0]);
            DaoGenerator.this.iprint("exiting(\"%1$s\", \"%2$s\", null);%n", DaoGenerator.this.canonicalName, m.getName());
            this.printThrowingStatements(m);
            return null;
        }

        @Override
        public Void visitAutoModifyQueryMeta(AutoModifyQueryMeta m, String methodName) {
            Boolean suppressOptimisticLockException;
            Boolean includeUnchanged;
            List<String> exclude;
            List<String> include;
            Boolean ignoreVersion;
            this.printEnteringStatements(m);
            this.printPrerequisiteStatements(m);
            DaoGenerator.this.iprint("%1$s<%2$s> __query = getQueryImplementors().create%4$s(%5$s, %3$s.getSingletonInternal());%n", m.getQueryClass().getName(), m.getEntityCtType().getTypeName(), m.getEntityCtType().getMetaTypeName(), m.getQueryClass().getSimpleName(), methodName);
            DaoGenerator.this.iprint("__query.setMethod(%1$s);%n", methodName);
            DaoGenerator.this.iprint("__query.setConfig(__config);%n", new Object[0]);
            DaoGenerator.this.iprint("__query.setEntity(%1$s);%n", m.getEntityParameterName());
            DaoGenerator.this.iprint("__query.setCallerClassName(\"%1$s\");%n", DaoGenerator.this.canonicalName);
            DaoGenerator.this.iprint("__query.setCallerMethodName(\"%1$s\");%n", m.getName());
            DaoGenerator.this.iprint("__query.setQueryTimeout(%1$s);%n", m.getQueryTimeout());
            DaoGenerator.this.iprint("__query.setSqlLogType(%1$s.%2$s);%n", new Object[]{((Object)((Object)m.getSqlLogType())).getClass().getName(), m.getSqlLogType()});
            Boolean excludeNull = m.getExcludeNull();
            if (excludeNull != null) {
                DaoGenerator.this.iprint("__query.setNullExcluded(%1$s);%n", excludeNull);
            }
            if ((ignoreVersion = m.getIgnoreVersion()) != null) {
                DaoGenerator.this.iprint("__query.setVersionIgnored(%1$s);%n", ignoreVersion);
            }
            if ((include = m.getInclude()) != null) {
                DaoGenerator.this.iprint("__query.setIncludedPropertyNames(%1$s);%n", DaoGenerator.this.toCSVFormat(include));
            }
            if ((exclude = m.getExclude()) != null) {
                DaoGenerator.this.iprint("__query.setExcludedPropertyNames(%1$s);%n", DaoGenerator.this.toCSVFormat(m.getExclude()));
            }
            if ((includeUnchanged = m.getIncludeUnchanged()) != null) {
                DaoGenerator.this.iprint("__query.setUnchangedPropertyIncluded(%1$s);%n", includeUnchanged);
            }
            if ((suppressOptimisticLockException = m.getSuppressOptimisticLockException()) != null) {
                DaoGenerator.this.iprint("__query.setOptimisticLockExceptionSuppressed(%1$s);%n", suppressOptimisticLockException);
            }
            DaoGenerator.this.iprint("__query.prepare();%n", new Object[0]);
            DaoGenerator.this.iprint("%1$s __command = getCommandImplementors().create%2$s(%3$s, __query);%n", m.getCommandClass().getName(), m.getCommandClass().getSimpleName(), methodName);
            EntityCtType entityCtType = m.getEntityCtType();
            if (entityCtType != null && entityCtType.isImmutable()) {
                DaoGenerator.this.iprint("int __count = __command.execute();%n", new Object[0]);
                DaoGenerator.this.iprint("__query.complete();%n", new Object[0]);
                DaoGenerator.this.iprint("%1$s __result = new %1$s(__count, __query.getEntity());%n", m.getReturnMeta().getTypeName());
            } else {
                DaoGenerator.this.iprint("%1$s __result = __command.execute();%n", m.getReturnMeta().getTypeName());
                DaoGenerator.this.iprint("__query.complete();%n", new Object[0]);
            }
            DaoGenerator.this.iprint("exiting(\"%1$s\", \"%2$s\", __result);%n", DaoGenerator.this.canonicalName, m.getName());
            DaoGenerator.this.iprint("return __result;%n", new Object[0]);
            this.printThrowingStatements(m);
            return null;
        }

        @Override
        public Void visitSqlFileModifyQueryMeta(SqlFileModifyQueryMeta m, String methodName) {
            Boolean suppressOptimisticLockException;
            Boolean includeUnchanged;
            List<String> exclude;
            List<String> include;
            Boolean ignoreVersion;
            Boolean excludeNull;
            this.printEnteringStatements(m);
            this.printPrerequisiteStatements(m);
            DaoGenerator.this.iprint("%1$s __query = getQueryImplementors().create%2$s(%3$s);%n", m.getQueryClass().getName(), m.getQueryClass().getSimpleName(), methodName);
            DaoGenerator.this.iprint("__query.setMethod(%1$s);%n", methodName);
            DaoGenerator.this.iprint("__query.setConfig(__config);%n", new Object[0]);
            DaoGenerator.this.iprint("__query.setSqlFilePath(\"%1$s\");%n", SqlFileUtil.buildPath(DaoGenerator.this.daoMeta.getDaoElement().getQualifiedName().toString(), m.getName()));
            this.printAddParameterStatements(m.getParameterMetas());
            DaoGenerator.this.iprint("__query.setCallerClassName(\"%1$s\");%n", DaoGenerator.this.canonicalName);
            DaoGenerator.this.iprint("__query.setCallerMethodName(\"%1$s\");%n", m.getName());
            DaoGenerator.this.iprint("__query.setQueryTimeout(%1$s);%n", m.getQueryTimeout());
            DaoGenerator.this.iprint("__query.setSqlLogType(%1$s.%2$s);%n", new Object[]{((Object)((Object)m.getSqlLogType())).getClass().getName(), m.getSqlLogType()});
            if (m.getEntityParameterName() != null && m.getEntityCtType() != null) {
                DaoGenerator.this.iprint("__query.setEntityAndEntityType(\"%1$s\", %2$s, %3$s.getSingletonInternal());%n", m.getEntityParameterName(), m.getEntityParameterName(), m.getEntityCtType().getMetaTypeName());
            }
            if ((excludeNull = m.getExcludeNull()) != null) {
                DaoGenerator.this.iprint("__query.setNullExcluded(%1$s);%n", excludeNull);
            }
            if ((ignoreVersion = m.getIgnoreVersion()) != null) {
                DaoGenerator.this.iprint("__query.setVersionIgnored(%1$s);%n", ignoreVersion);
            }
            if ((include = m.getInclude()) != null) {
                DaoGenerator.this.iprint("__query.setIncludedPropertyNames(%1$s);%n", DaoGenerator.this.toCSVFormat(include));
            }
            if ((exclude = m.getExclude()) != null) {
                DaoGenerator.this.iprint("__query.setExcludedPropertyNames(%1$s);%n", DaoGenerator.this.toCSVFormat(m.getExclude()));
            }
            if ((includeUnchanged = m.getIncludeUnchanged()) != null) {
                DaoGenerator.this.iprint("__query.setUnchangedPropertyIncluded(%1$s);%n", includeUnchanged);
            }
            if ((suppressOptimisticLockException = m.getSuppressOptimisticLockException()) != null) {
                DaoGenerator.this.iprint("__query.setOptimisticLockExceptionSuppressed(%1$s);%n", suppressOptimisticLockException);
            }
            DaoGenerator.this.iprint("__query.prepare();%n", new Object[0]);
            DaoGenerator.this.iprint("%1$s __command = getCommandImplementors().create%2$s(%3$s, __query);%n", m.getCommandClass().getName(), m.getCommandClass().getSimpleName(), methodName);
            EntityCtType entityCtType = m.getEntityCtType();
            if (entityCtType != null && entityCtType.isImmutable()) {
                DaoGenerator.this.iprint("int __count = __command.execute();%n", new Object[0]);
                DaoGenerator.this.iprint("__query.complete();%n", new Object[0]);
                DaoGenerator.this.iprint("%1$s __result = new %1$s(__count, __query.getEntity(%2$s.class));%n", m.getReturnMeta().getTypeName(), entityCtType.getBoxedTypeName());
            } else {
                DaoGenerator.this.iprint("%1$s __result = __command.execute();%n", m.getReturnMeta().getTypeName());
                DaoGenerator.this.iprint("__query.complete();%n", new Object[0]);
            }
            DaoGenerator.this.iprint("exiting(\"%1$s\", \"%2$s\", __result);%n", DaoGenerator.this.canonicalName, m.getName());
            DaoGenerator.this.iprint("return __result;%n", new Object[0]);
            this.printThrowingStatements(m);
            return null;
        }

        @Override
        public Void visitAutoBatchModifyQueryMeta(AutoBatchModifyQueryMeta m, String methodName) {
            Boolean suppressOptimisticLockException;
            List<String> exclude;
            List<String> include;
            this.printEnteringStatements(m);
            this.printPrerequisiteStatements(m);
            DaoGenerator.this.iprint("%1$s<%2$s> __query = getQueryImplementors().create%4$s(%5$s, %3$s.getSingletonInternal());%n", m.getQueryClass().getName(), m.getEntityCtType().getTypeName(), m.getEntityCtType().getMetaTypeName(), m.getQueryClass().getSimpleName(), methodName);
            DaoGenerator.this.iprint("__query.setMethod(%1$s);%n", methodName);
            DaoGenerator.this.iprint("__query.setConfig(__config);%n", new Object[0]);
            DaoGenerator.this.iprint("__query.setEntities(%1$s);%n", m.getEntitiesParameterName());
            DaoGenerator.this.iprint("__query.setCallerClassName(\"%1$s\");%n", DaoGenerator.this.canonicalName);
            DaoGenerator.this.iprint("__query.setCallerMethodName(\"%1$s\");%n", m.getName());
            DaoGenerator.this.iprint("__query.setQueryTimeout(%1$s);%n", m.getQueryTimeout());
            DaoGenerator.this.iprint("__query.setBatchSize(%1$s);%n", m.getBatchSize());
            DaoGenerator.this.iprint("__query.setSqlLogType(%1$s.%2$s);%n", new Object[]{((Object)((Object)m.getSqlLogType())).getClass().getName(), m.getSqlLogType()});
            Boolean ignoreVersion = m.getIgnoreVersion();
            if (ignoreVersion != null) {
                DaoGenerator.this.iprint("__query.setVersionIgnored(%1$s);%n", ignoreVersion);
            }
            if ((include = m.getInclude()) != null) {
                DaoGenerator.this.iprint("__query.setIncludedPropertyNames(%1$s);%n", DaoGenerator.this.toCSVFormat(include));
            }
            if ((exclude = m.getExclude()) != null) {
                DaoGenerator.this.iprint("__query.setExcludedPropertyNames(%1$s);%n", DaoGenerator.this.toCSVFormat(exclude));
            }
            if ((suppressOptimisticLockException = m.getSuppressOptimisticLockException()) != null) {
                DaoGenerator.this.iprint("__query.setOptimisticLockExceptionSuppressed(%1$s);%n", suppressOptimisticLockException);
            }
            DaoGenerator.this.iprint("__query.prepare();%n", new Object[0]);
            DaoGenerator.this.iprint("%1$s __command = getCommandImplementors().create%2$s(%3$s, __query);%n", m.getCommandClass().getName(), m.getCommandClass().getSimpleName(), methodName);
            EntityCtType entityCtType = m.getEntityCtType();
            if (entityCtType != null && entityCtType.isImmutable()) {
                DaoGenerator.this.iprint("int[] __counts = __command.execute();%n", new Object[0]);
                DaoGenerator.this.iprint("__query.complete();%n", new Object[0]);
                DaoGenerator.this.iprint("%1$s __result = new %1$s(__counts, __query.getEntities());%n", m.getReturnMeta().getTypeName());
            } else {
                DaoGenerator.this.iprint("%1$s __result = __command.execute();%n", m.getReturnMeta().getTypeName());
                DaoGenerator.this.iprint("__query.complete();%n", new Object[0]);
            }
            DaoGenerator.this.iprint("exiting(\"%1$s\", \"%2$s\", __result);%n", DaoGenerator.this.canonicalName, m.getName());
            DaoGenerator.this.iprint("return __result;%n", new Object[0]);
            this.printThrowingStatements(m);
            return null;
        }

        @Override
        public Void visitSqlFileBatchModifyQueryMeta(SqlFileBatchModifyQueryMeta m, String methodName) {
            Boolean suppressOptimisticLockException;
            List<String> exclude;
            List<String> include;
            Boolean ignoreVersion;
            this.printEnteringStatements(m);
            this.printPrerequisiteStatements(m);
            DaoGenerator.this.iprint("%1$s<%2$s> __query = getQueryImplementors().create%4$s(%5$s, %3$s.class);%n", m.getQueryClass().getName(), m.getElementCtType().getBoxedTypeName(), m.getElementCtType().getQualifiedName(), m.getQueryClass().getSimpleName(), methodName);
            DaoGenerator.this.iprint("__query.setMethod(%1$s);%n", methodName);
            DaoGenerator.this.iprint("__query.setConfig(__config);%n", new Object[0]);
            DaoGenerator.this.iprint("__query.setElements(%1$s);%n", m.getElementsParameterName());
            DaoGenerator.this.iprint("__query.setSqlFilePath(\"%1$s\");%n", SqlFileUtil.buildPath(DaoGenerator.this.daoMeta.getDaoElement().getQualifiedName().toString(), m.getName()));
            DaoGenerator.this.iprint("__query.setParameterName(\"%1$s\");%n", m.getElementsParameterName());
            DaoGenerator.this.iprint("__query.setCallerClassName(\"%1$s\");%n", DaoGenerator.this.canonicalName);
            DaoGenerator.this.iprint("__query.setCallerMethodName(\"%1$s\");%n", m.getName());
            DaoGenerator.this.iprint("__query.setQueryTimeout(%1$s);%n", m.getQueryTimeout());
            DaoGenerator.this.iprint("__query.setBatchSize(%1$s);%n", m.getBatchSize());
            DaoGenerator.this.iprint("__query.setSqlLogType(%1$s.%2$s);%n", new Object[]{((Object)((Object)m.getSqlLogType())).getClass().getName(), m.getSqlLogType()});
            if (m.getEntityType() != null) {
                DaoGenerator.this.iprint("__query.setEntityType(%1$s.getSingletonInternal());%n", m.getEntityType().getMetaTypeName());
            }
            if ((ignoreVersion = m.getIgnoreVersion()) != null) {
                DaoGenerator.this.iprint("__query.setVersionIgnored(%1$s);%n", ignoreVersion);
            }
            if ((include = m.getInclude()) != null) {
                DaoGenerator.this.iprint("__query.setIncludedPropertyNames(%1$s);%n", DaoGenerator.this.toCSVFormat(include));
            }
            if ((exclude = m.getExclude()) != null) {
                DaoGenerator.this.iprint("__query.setExcludedPropertyNames(%1$s);%n", DaoGenerator.this.toCSVFormat(exclude));
            }
            if ((suppressOptimisticLockException = m.getSuppressOptimisticLockException()) != null) {
                DaoGenerator.this.iprint("__query.setOptimisticLockExceptionSuppressed(%1$s);%n", suppressOptimisticLockException);
            }
            DaoGenerator.this.iprint("__query.prepare();%n", new Object[0]);
            DaoGenerator.this.iprint("%1$s __command = getCommandImplementors().create%2$s(%3$s, __query);%n", m.getCommandClass().getName(), m.getCommandClass().getSimpleName(), methodName);
            EntityCtType entityCtType = m.getEntityType();
            if (entityCtType != null && entityCtType.isImmutable()) {
                DaoGenerator.this.iprint("int[] __counts = __command.execute();%n", new Object[0]);
                DaoGenerator.this.iprint("__query.complete();%n", new Object[0]);
                DaoGenerator.this.iprint("%1$s __result = new %1$s(__counts, __query.getEntities());%n", m.getReturnMeta().getTypeName());
            } else {
                DaoGenerator.this.iprint("%1$s __result = __command.execute();%n", m.getReturnMeta().getTypeName());
                DaoGenerator.this.iprint("__query.complete();%n", new Object[0]);
            }
            DaoGenerator.this.iprint("exiting(\"%1$s\", \"%2$s\", __result);%n", DaoGenerator.this.canonicalName, m.getName());
            DaoGenerator.this.iprint("return __result;%n", new Object[0]);
            this.printThrowingStatements(m);
            return null;
        }

        @Override
        public Void visitAutoFunctionQueryMeta(AutoFunctionQueryMeta m, String methodName) {
            this.printEnteringStatements(m);
            this.printPrerequisiteStatements(m);
            QueryReturnMeta returnMeta = m.getReturnMeta();
            DaoGenerator.this.iprint("%1$s<%2$s> __query = getQueryImplementors().create%3$s(%4$s);%n", m.getQueryClass().getName(), returnMeta.getBoxedTypeName(), m.getQueryClass().getSimpleName(), methodName);
            DaoGenerator.this.iprint("__query.setMethod(%1$s);%n", methodName);
            DaoGenerator.this.iprint("__query.setConfig(__config);%n", new Object[0]);
            DaoGenerator.this.iprint("__query.setCatalogName(\"%1$s\");%n", m.getCatalogName());
            DaoGenerator.this.iprint("__query.setSchemaName(\"%1$s\");%n", m.getSchemaName());
            DaoGenerator.this.iprint("__query.setFunctionName(\"%1$s\");%n", m.getFunctionName());
            DaoGenerator.this.iprint("__query.setQuoteRequired(%1$s);%n", m.isQuoteRequired());
            CallableSqlParameterStatementGenerator parameterGenerator = new CallableSqlParameterStatementGenerator();
            m.getResultParameterMeta().accept(parameterGenerator, m);
            for (CallableSqlParameterMeta parameterMeta : m.getCallableSqlParameterMetas()) {
                parameterMeta.accept(parameterGenerator, m);
            }
            DaoGenerator.this.iprint("__query.setCallerClassName(\"%1$s\");%n", DaoGenerator.this.canonicalName);
            DaoGenerator.this.iprint("__query.setCallerMethodName(\"%1$s\");%n", m.getName());
            DaoGenerator.this.iprint("__query.setQueryTimeout(%1$s);%n", m.getQueryTimeout());
            DaoGenerator.this.iprint("__query.setSqlLogType(%1$s.%2$s);%n", new Object[]{((Object)((Object)m.getSqlLogType())).getClass().getName(), m.getSqlLogType()});
            DaoGenerator.this.iprint("__query.prepare();%n", new Object[0]);
            DaoGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%3$s(%4$s, __query);%n", m.getCommandClass().getName(), returnMeta.getBoxedTypeName(), m.getCommandClass().getSimpleName(), methodName);
            DaoGenerator.this.iprint("%1$s __result = __command.execute();%n", returnMeta.getTypeName());
            DaoGenerator.this.iprint("__query.complete();%n", new Object[0]);
            DaoGenerator.this.iprint("exiting(\"%1$s\", \"%2$s\", __result);%n", DaoGenerator.this.canonicalName, m.getName());
            DaoGenerator.this.iprint("return __result;%n", new Object[0]);
            this.printThrowingStatements(m);
            return null;
        }

        @Override
        public Void visitAutoProcedureQueryMeta(AutoProcedureQueryMeta m, String methodName) {
            this.printEnteringStatements(m);
            this.printPrerequisiteStatements(m);
            DaoGenerator.this.iprint("%1$s __query = getQueryImplementors().create%2$s(%3$s);%n", m.getQueryClass().getName(), m.getQueryClass().getSimpleName(), methodName);
            DaoGenerator.this.iprint("__query.setMethod(%1$s);%n", methodName);
            DaoGenerator.this.iprint("__query.setConfig(__config);%n", new Object[0]);
            DaoGenerator.this.iprint("__query.setCatalogName(\"%1$s\");%n", m.getCatalogName());
            DaoGenerator.this.iprint("__query.setSchemaName(\"%1$s\");%n", m.getSchemaName());
            DaoGenerator.this.iprint("__query.setProcedureName(\"%1$s\");%n", m.getProcedureName());
            DaoGenerator.this.iprint("__query.setQuoteRequired(%1$s);%n", m.isQuoteRequired());
            CallableSqlParameterStatementGenerator parameterGenerator = new CallableSqlParameterStatementGenerator();
            for (CallableSqlParameterMeta parameterMeta : m.getCallableSqlParameterMetas()) {
                parameterMeta.accept(parameterGenerator, m);
            }
            DaoGenerator.this.iprint("__query.setCallerClassName(\"%1$s\");%n", DaoGenerator.this.canonicalName);
            DaoGenerator.this.iprint("__query.setCallerMethodName(\"%1$s\");%n", m.getName());
            DaoGenerator.this.iprint("__query.setQueryTimeout(%1$s);%n", m.getQueryTimeout());
            DaoGenerator.this.iprint("__query.setSqlLogType(%1$s.%2$s);%n", new Object[]{((Object)((Object)m.getSqlLogType())).getClass().getName(), m.getSqlLogType()});
            DaoGenerator.this.iprint("__query.prepare();%n", new Object[0]);
            DaoGenerator.this.iprint("%1$s __command = getCommandImplementors().create%2$s(%3$s, __query);%n", m.getCommandClass().getName(), m.getCommandClass().getSimpleName(), methodName);
            DaoGenerator.this.iprint("__command.execute();%n", new Object[0]);
            DaoGenerator.this.iprint("__query.complete();%n", new Object[0]);
            DaoGenerator.this.iprint("exiting(\"%1$s\", \"%2$s\", null);%n", DaoGenerator.this.canonicalName, m.getName());
            this.printThrowingStatements(m);
            return null;
        }

        @Override
        public Void visitAbstractCreateQueryMeta(AbstractCreateQueryMeta m, String methodName) {
            this.printEnteringStatements(m);
            this.printPrerequisiteStatements(m);
            QueryReturnMeta resultMeta = m.getReturnMeta();
            DaoGenerator.this.iprint("%1$s __query = getQueryImplementors().create%2$s(%3$s);%n", m.getQueryClass().getName(), m.getQueryClass().getSimpleName(), methodName);
            DaoGenerator.this.iprint("__query.setMethod(%1$s);%n", methodName);
            DaoGenerator.this.iprint("__query.setConfig(__config);%n", new Object[0]);
            DaoGenerator.this.iprint("__query.setCallerClassName(\"%1$s\");%n", DaoGenerator.this.canonicalName);
            DaoGenerator.this.iprint("__query.setCallerMethodName(\"%1$s\");%n", m.getName());
            DaoGenerator.this.iprint("__query.prepare();%n", new Object[0]);
            DaoGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%3$s(%4$s, __query);%n", m.getCommandClass().getName(), resultMeta.getTypeName(), m.getCommandClass().getSimpleName(), methodName);
            DaoGenerator.this.iprint("%1$s __result = __command.execute();%n", resultMeta.getTypeName());
            DaoGenerator.this.iprint("__query.complete();%n", new Object[0]);
            DaoGenerator.this.iprint("exiting(\"%1$s\", \"%2$s\", __result);%n", DaoGenerator.this.canonicalName, m.getName());
            DaoGenerator.this.iprint("return __result;%n", new Object[0]);
            this.printThrowingStatements(m);
            return null;
        }

        @Override
        public Void visitArrayCreateQueryMeta(ArrayCreateQueryMeta m, String methodName) {
            this.printArrayCreateEnteringStatements(m);
            this.printPrerequisiteStatements(m);
            QueryReturnMeta resultMeta = m.getReturnMeta();
            DaoGenerator.this.iprint("%1$s __query = getQueryImplementors().create%2$s(%3$s);%n", m.getQueryClass().getName(), m.getQueryClass().getSimpleName(), methodName);
            DaoGenerator.this.iprint("__query.setMethod(%1$s);%n", methodName);
            DaoGenerator.this.iprint("__query.setConfig(__config);%n", new Object[0]);
            DaoGenerator.this.iprint("__query.setCallerClassName(\"%1$s\");%n", DaoGenerator.this.canonicalName);
            DaoGenerator.this.iprint("__query.setCallerMethodName(\"%1$s\");%n", m.getName());
            DaoGenerator.this.iprint("__query.setTypeName(\"%1$s\");%n", m.getArrayTypeName());
            DaoGenerator.this.iprint("__query.setElements(%1$s);%n", m.getParameterName());
            DaoGenerator.this.iprint("__query.prepare();%n", new Object[0]);
            DaoGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%3$s(%4$s, __query);%n", m.getCommandClass().getName(), resultMeta.getBoxedTypeName(), m.getCommandClass().getSimpleName(), methodName);
            DaoGenerator.this.iprint("%1$s __result = __command.execute();%n", resultMeta.getTypeName());
            DaoGenerator.this.iprint("__query.complete();%n", new Object[0]);
            DaoGenerator.this.iprint("exiting(\"%1$s\", \"%2$s\", __result);%n", DaoGenerator.this.canonicalName, m.getName());
            DaoGenerator.this.iprint("return __result;%n", new Object[0]);
            this.printThrowingStatements(m);
            return null;
        }

        @Override
        public Void visitDefaultQueryMeta(DefaultQueryMeta m, String methodName) {
            this.printEnteringStatements(m);
            QueryReturnMeta resultMeta = m.getReturnMeta();
            if ("void".equals(resultMeta.getTypeName())) {
                DaoGenerator.this.iprint("Object __result = null;%n", new Object[0]);
                DaoGenerator.this.iprint("", new Object[0]);
            } else {
                DaoGenerator.this.iprint("%1$s __result = ", resultMeta.getTypeName());
            }
            DaoGenerator.this.print("%1$s.super.%2$s(", DaoGenerator.this.daoMeta.getDaoElement().getQualifiedName(), m.getName());
            Iterator<QueryParameterMeta> it = m.getParameterMetas().iterator();
            while (it.hasNext()) {
                QueryParameterMeta parameterMeta = it.next();
                DaoGenerator.this.print("%1$s", parameterMeta.getName());
                if (!it.hasNext()) continue;
                DaoGenerator.this.print(", ", new Object[0]);
            }
            DaoGenerator.this.print(");%n", new Object[0]);
            DaoGenerator.this.iprint("exiting(\"%1$s\", \"%2$s\", __result);%n", DaoGenerator.this.canonicalName, m.getName());
            if (!"void".equals(resultMeta.getTypeName())) {
                DaoGenerator.this.iprint("return __result;%n", new Object[0]);
            }
            this.printThrowingStatements(m);
            return null;
        }

        @Override
        public Void visitSqlProcessorQueryMeta(SqlProcessorQueryMeta m, String methodName) {
            this.printEnteringStatements(m);
            this.printPrerequisiteStatements(m);
            DaoGenerator.this.iprint("%1$s __query = getQueryImplementors().create%2$s(%3$s);%n", m.getQueryClass().getName(), m.getQueryClass().getSimpleName(), methodName);
            DaoGenerator.this.iprint("__query.setMethod(%1$s);%n", methodName);
            DaoGenerator.this.iprint("__query.setConfig(__config);%n", new Object[0]);
            DaoGenerator.this.iprint("__query.setSqlFilePath(\"%1$s\");%n", SqlFileUtil.buildPath(DaoGenerator.this.daoMeta.getDaoElement().getQualifiedName().toString(), m.getName()));
            this.printAddParameterStatements(m.getParameterMetas());
            DaoGenerator.this.iprint("__query.setCallerClassName(\"%1$s\");%n", DaoGenerator.this.canonicalName);
            DaoGenerator.this.iprint("__query.setCallerMethodName(\"%1$s\");%n", m.getName());
            DaoGenerator.this.iprint("__query.prepare();%n", new Object[0]);
            QueryReturnMeta returnMeta = m.getReturnMeta();
            DaoGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%3$s(%4$s, __query, %5$s);%n", m.getCommandClass().getName(), m.getBiFunctionCtType().getResultCtType().getBoxedTypeName(), m.getCommandClass().getSimpleName(), methodName, m.getBiFunctionParameterName());
            if ("void".equals(returnMeta.getTypeName())) {
                DaoGenerator.this.iprint("__command.execute();%n", new Object[0]);
                DaoGenerator.this.iprint("__query.complete();%n", new Object[0]);
                DaoGenerator.this.iprint("exiting(\"%1$s\", \"%2$s\", null);%n", DaoGenerator.this.canonicalName, m.getName());
            } else {
                DaoGenerator.this.iprint("%1$s __result = __command.execute();%n", returnMeta.getTypeName());
                DaoGenerator.this.iprint("__query.complete();%n", new Object[0]);
                DaoGenerator.this.iprint("exiting(\"%1$s\", \"%2$s\", __result);%n", DaoGenerator.this.canonicalName, m.getName());
                DaoGenerator.this.iprint("return __result;%n", new Object[0]);
            }
            this.printThrowingStatements(m);
            return null;
        }

        protected void printEnteringStatements(QueryMeta m) {
            DaoGenerator.this.iprint("entering(\"%1$s\", \"%2$s\"", DaoGenerator.this.canonicalName, m.getName());
            for (QueryParameterMeta parameterMeta : m.getParameterMetas()) {
                DaoGenerator.this.print(", %1$s", parameterMeta.getName());
            }
            DaoGenerator.this.print(");%n", new Object[0]);
            DaoGenerator.this.iprint("try {%n", new Object[0]);
            DaoGenerator.this.indent();
        }

        protected void printArrayCreateEnteringStatements(ArrayCreateQueryMeta m) {
            DaoGenerator.this.iprint("entering(\"%1$s\", \"%2$s\", (Object)%3$s);%n", DaoGenerator.this.canonicalName, m.getName(), m.getParameterName());
            DaoGenerator.this.iprint("try {%n", new Object[0]);
            DaoGenerator.this.indent();
        }

        protected void printThrowingStatements(QueryMeta m) {
            DaoGenerator.this.unindent();
            DaoGenerator.this.iprint("} catch (%1$s __e) {%n", RuntimeException.class.getName());
            DaoGenerator.this.indent();
            DaoGenerator.this.iprint("throwing(\"%1$s\", \"%2$s\", __e);%n", DaoGenerator.this.canonicalName, m.getName());
            DaoGenerator.this.iprint("throw __e;%n", new Object[0]);
            DaoGenerator.this.unindent();
            DaoGenerator.this.iprint("}%n", new Object[0]);
        }

        protected void printPrerequisiteStatements(QueryMeta m) {
            for (QueryParameterMeta parameterMeta : m.getParameterMetas()) {
                if (parameterMeta.isNullable()) continue;
                String paramName = parameterMeta.getName();
                DaoGenerator.this.iprint("if (%1$s == null) {%n", paramName);
                DaoGenerator.this.iprint("    throw new %1$s(\"%2$s\");%n", DomaNullPointerException.class.getName(), paramName);
                DaoGenerator.this.iprint("}%n", new Object[0]);
            }
        }

        protected void printAddParameterStatements(List<QueryParameterMeta> ParameterMetas) {
            for (final QueryParameterMeta parameterMeta : ParameterMetas) {
                if (!parameterMeta.isBindable()) continue;
                CtType ctType = parameterMeta.getCtType();
                ctType.accept(new SimpleCtTypeVisitor<Void, Void, RuntimeException>(){

                    @Override
                    protected Void defaultAction(CtType ctType, Void p) throws RuntimeException {
                        DaoGenerator.this.iprint("__query.addParameter(\"%1$s\", %2$s.class, %1$s);%n", parameterMeta.getName(), ctType.getQualifiedName());
                        return null;
                    }

                    @Override
                    public Void visitOptionalCtType(OptionalCtType ctType, Void p) throws RuntimeException {
                        DaoGenerator.this.iprint("__query.addParameter(\"%1$s\", %2$s.class, %1$s.orElse(null));%n", parameterMeta.getName(), ctType.getElementCtType().getQualifiedName());
                        return null;
                    }

                    @Override
                    public Void visitOptionalIntCtType(OptionalIntCtType ctType, Void p) throws RuntimeException {
                        DaoGenerator.this.iprint("__query.addParameter(\"%1$s\", %2$s.class, %1$s.isPresent() ? %1$s.getAsInt() : null);%n", parameterMeta.getName(), Integer.class.getName());
                        return null;
                    }

                    @Override
                    public Void visitOptionalLongCtType(OptionalLongCtType ctType, Void p) throws RuntimeException {
                        DaoGenerator.this.iprint("__query.addParameter(\"%1$s\", %2$s.class, %1$s.isPresent() ? %1$s.getAsLong() : null);%n", parameterMeta.getName(), Long.class.getName());
                        return null;
                    }

                    @Override
                    public Void visitOptionalDoubleCtType(OptionalDoubleCtType ctType, Void p) throws RuntimeException {
                        DaoGenerator.this.iprint("__query.addParameter(\"%1$s\", %2$s.class, %1$s.isPresent() ? %1$s.getAsDouble() : null);%n", parameterMeta.getName(), Double.class.getName());
                        return null;
                    }
                }, null);
            }
        }
    }
}

