/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import java.util.LinkedHashMap;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.seasar.doma.Suppress;
import org.seasar.doma.internal.apt.Notifier;
import org.seasar.doma.internal.apt.SqlValidator;
import org.seasar.doma.internal.jdbc.sql.node.EmbeddedVariableNode;
import org.seasar.doma.internal.jdbc.sql.node.ForNode;
import org.seasar.doma.internal.jdbc.sql.node.IfNode;
import org.seasar.doma.message.Message;

public class BatchSqlValidator
extends SqlValidator {
    protected boolean embeddedVariableWarningNotified;
    protected boolean ifWarningNotified;
    protected boolean forWarningNotified;
    protected Suppress suppress;

    public BatchSqlValidator(ProcessingEnvironment env, ExecutableElement methodElement, LinkedHashMap<String, TypeMirror> parameterTypeMap, String path, boolean expandable, boolean populatable) {
        super(env, methodElement, parameterTypeMap, path, expandable, populatable);
        this.suppress = methodElement.getAnnotation(Suppress.class);
    }

    @Override
    public Void visitEmbeddedVariableNode(EmbeddedVariableNode node, Void p) {
        if (!this.isSuppressed(Message.DOMA4181) && !this.embeddedVariableWarningNotified) {
            Notifier.notify(this.env, Diagnostic.Kind.WARNING, Message.DOMA4181, this.methodElement, new Object[]{this.path});
            this.embeddedVariableWarningNotified = true;
        }
        return super.visitEmbeddedVariableNode(node, p);
    }

    @Override
    public Void visitIfNode(IfNode node, Void p) {
        if (!this.isSuppressed(Message.DOMA4182) && !this.ifWarningNotified) {
            Notifier.notify(this.env, Diagnostic.Kind.WARNING, Message.DOMA4182, this.methodElement, new Object[]{this.path});
            this.ifWarningNotified = true;
        }
        return super.visitIfNode(node, p);
    }

    @Override
    public Void visitForNode(ForNode node, Void p) {
        if (!this.isSuppressed(Message.DOMA4183) && !this.forWarningNotified) {
            Notifier.notify(this.env, Diagnostic.Kind.WARNING, Message.DOMA4183, this.methodElement, new Object[]{this.path});
            this.forWarningNotified = true;
        }
        return super.visitForNode(node, p);
    }

    protected boolean isSuppressed(Message message) {
        if (this.suppress != null) {
            for (Message suppressMessage : this.suppress.messages()) {
                if (suppressMessage != message) continue;
                return true;
            }
        }
        return false;
    }
}

