/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import java.lang.annotation.Annotation;
import java.util.function.Consumer;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.AptIllegalOptionException;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.AptTypeHandleException;
import org.seasar.doma.internal.apt.Notifier;
import org.seasar.doma.internal.apt.Options;
import org.seasar.doma.message.Message;

public abstract class AbstractProcessor
extends javax.annotation.processing.AbstractProcessor {
    protected Class<? extends Annotation> supportedAnnotationType;

    protected AbstractProcessor(Class<? extends Annotation> supportedAnnotationType) {
        this.supportedAnnotationType = supportedAnnotationType;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    protected void handleTypeElement(TypeElement typeElement, Consumer<TypeElement> handler) {
        Annotation annotation = typeElement.getAnnotation(this.supportedAnnotationType);
        if (annotation == null) {
            return;
        }
        if (Options.isDebugEnabled(this.processingEnv)) {
            Notifier.debug(this.processingEnv, Message.DOMA4090, new Object[]{this.getClass().getName(), typeElement.getQualifiedName()});
        }
        try {
            handler.accept(typeElement);
        }
        catch (AptException e) {
            Notifier.notify(this.processingEnv, e);
        }
        catch (AptIllegalOptionException e) {
            Notifier.notify(this.processingEnv, Diagnostic.Kind.ERROR, e.getMessage(), typeElement);
            throw new AptTypeHandleException(typeElement, (Throwable)e);
        }
        catch (AptIllegalStateException e) {
            Notifier.notify(this.processingEnv, Diagnostic.Kind.ERROR, Message.DOMA4039, typeElement, new Object[0]);
            throw new AptTypeHandleException(typeElement, (Throwable)e);
        }
        catch (RuntimeException e) {
            Notifier.notify(this.processingEnv, Diagnostic.Kind.ERROR, Message.DOMA4016, typeElement, new Object[0]);
            throw new AptTypeHandleException(typeElement, (Throwable)e);
        }
        if (Options.isDebugEnabled(this.processingEnv)) {
            Notifier.debug(this.processingEnv, Message.DOMA4091, new Object[]{this.getClass().getName(), typeElement.getQualifiedName()});
        }
    }
}

