/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Formatter;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.JavaFileObject;
import org.seasar.doma.internal.Artifact;
import org.seasar.doma.internal.Conventions;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.Generator;
import org.seasar.doma.internal.apt.Options;
import org.seasar.doma.internal.apt.util.ElementUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.internal.util.ClassUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public abstract class AbstractGenerator
implements Generator {
    protected static final String INDENT_SPACE = "    ";
    protected final ProcessingEnvironment env;
    protected final TypeElement typeElement;
    protected final String canonicalName;
    protected final String packageName;
    protected final String simpleName;
    protected final String fullpackage;
    protected final String subpackage;
    protected final String prefix;
    protected final String suffix;
    protected final Formatter formatter;
    protected final StringBuilder indentBuffer = new StringBuilder();

    protected AbstractGenerator(ProcessingEnvironment env, TypeElement typeElement, String fullpackage, String subpackage, String prefix, String suffix) throws IOException {
        AssertionUtil.assertNotNull((Object)env, (Object)typeElement, (Object)prefix, (Object)suffix);
        this.env = env;
        this.typeElement = typeElement;
        this.fullpackage = fullpackage;
        this.subpackage = subpackage;
        this.prefix = prefix;
        this.suffix = suffix;
        this.canonicalName = this.createCanonicalName(env, typeElement, fullpackage, subpackage, prefix, suffix);
        this.packageName = ClassUtil.getPackageName(this.canonicalName);
        this.simpleName = ClassUtil.getSimpleName(this.canonicalName);
        Filer filer = env.getFiler();
        JavaFileObject file = filer.createSourceFile(this.canonicalName, typeElement);
        this.formatter = new Formatter(new BufferedWriter(file.openWriter()));
    }

    protected String createCanonicalName(ProcessingEnvironment env, TypeElement typeElement, String fullpackage, String subpackage, String prefix, String suffix) {
        String qualifiedNamePrefix = this.getQualifiedNamePrefix(env, typeElement, fullpackage, subpackage);
        String binaryName = Conventions.normalizeBinaryName(ElementUtil.getBinaryName(typeElement, env));
        String infix = ClassUtil.getSimpleName(binaryName);
        return qualifiedNamePrefix + prefix + infix + suffix;
    }

    protected String getQualifiedNamePrefix(ProcessingEnvironment env, TypeElement typeElement, String fullpackage, String subpackage) {
        if (fullpackage != null) {
            return fullpackage + ".";
        }
        String packageName = ElementUtil.getPackageName(typeElement, env);
        String base = "";
        if (packageName != null && packageName.length() > 0) {
            base = packageName + ".";
        }
        if (subpackage != null) {
            return base + subpackage + ".";
        }
        return base;
    }

    protected void printGenerated() {
        String annotationElements = String.format("value = { \"%s\", \"%s\" }, date = \"%tFT%<tT.%<tL%<tz\"", Artifact.getName(), Options.getVersion(this.env), Options.getDate(this.env));
        TypeMirror generatedTypeMirror = this.getGeneratedTypeMirror();
        if (generatedTypeMirror == null) {
            this.iprint("// %s%n", annotationElements);
        }
        this.iprint("@%s(%s)%n", generatedTypeMirror, annotationElements);
    }

    protected void printValidateVersionStaticInitializer() {
        if (Options.getVersionValidation(this.env)) {
            this.iprint("static {%n", new Object[0]);
            this.iprint("    %1$s.validateVersion(\"%2$s\");%n", Artifact.class.getName(), Options.getVersion(this.env));
            this.iprint("}%n", new Object[0]);
            this.print("%n", new Object[0]);
        }
    }

    protected void iprint(String format, Object ... args) {
        this.formatter.format(this.indentBuffer.toString(), new Object[0]);
        this.throwExceptionIfNecessary();
        this.formatter.format(format, args);
        this.throwExceptionIfNecessary();
    }

    protected void print(String format, Object ... args) {
        this.formatter.format(format, args);
        this.throwExceptionIfNecessary();
    }

    protected void throwExceptionIfNecessary() {
        IOException ioException = this.formatter.ioException();
        if (ioException != null) {
            this.formatter.close();
            throw new AptException((MessageResource)Message.DOMA4079, this.env, (Element)this.typeElement, ioException, new Object[]{this.canonicalName, ioException});
        }
    }

    protected void indent() {
        this.indentBuffer.append(INDENT_SPACE);
    }

    protected void unindent() {
        if (this.indentBuffer.length() >= INDENT_SPACE.length()) {
            this.indentBuffer.setLength(this.indentBuffer.length() - INDENT_SPACE.length());
        }
    }

    @Override
    public void close() {
        if (this.formatter != null) {
            this.formatter.close();
        }
    }

    private TypeMirror getGeneratedTypeMirror() {
        Elements elements = this.env.getElementUtils();
        TypeElement java8 = elements.getTypeElement("javax.annotation.Generated");
        if (java8 != null) {
            return java8.asType();
        }
        TypeElement java9 = elements.getTypeElement("javax.annotation.processing.Generated");
        if (java9 != null) {
            return java9.asType();
        }
        return null;
    }
}

