/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.seasar.doma.internal.apt.AbstractProcessor;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.Generator;
import org.seasar.doma.internal.apt.meta.TypeElementMeta;
import org.seasar.doma.internal.apt.meta.TypeElementMetaFactory;
import org.seasar.doma.internal.util.IOUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public abstract class AbstractGeneratingProcessor<M extends TypeElementMeta>
extends AbstractProcessor {
    protected AbstractGeneratingProcessor(Class<? extends Annotation> supportedAnnotationType) {
        super(supportedAnnotationType);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return true;
        }
        for (TypeElement typeElement : annotations) {
            TypeElementMetaFactory<M> factory = this.createTypeElementMetaFactory();
            for (TypeElement typeElement2 : ElementFilter.typesIn(roundEnv.getElementsAnnotatedWith(typeElement))) {
                this.handleTypeElement(typeElement2, t -> {
                    Object meta = factory.createTypeElementMeta(typeElement2);
                    if (!meta.isError()) {
                        this.generate(typeElement2, meta);
                    }
                });
            }
        }
        return true;
    }

    protected abstract TypeElementMetaFactory<M> createTypeElementMetaFactory();

    protected void generate(TypeElement typeElement, M meta) {
        Generator generator = null;
        try {
            generator = this.createGenerator(typeElement, meta);
            generator.generate();
        }
        catch (IOException e) {
            try {
                throw new AptException((MessageResource)Message.DOMA4011, this.processingEnv, (Element)typeElement, e, new Object[]{typeElement.getQualifiedName(), e});
            }
            catch (Throwable throwable) {
                IOUtil.close(generator);
                throw throwable;
            }
        }
        IOUtil.close(generator);
    }

    protected abstract Generator createGenerator(TypeElement var1, M var2) throws IOException;
}

