/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal;

import java.util.List;
import java.util.stream.Collectors;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.internal.util.ClassUtil;

public class Conventions {
    public static String normalizeBinaryName(String binaryName) {
        AssertionUtil.assertNotNull(binaryName);
        String packageName = ClassUtil.getPackageName(binaryName);
        List<String> enclosingNames = ClassUtil.getEnclosingNames(binaryName);
        String simpleName = ClassUtil.getSimpleName(binaryName);
        String base = "";
        if (packageName != null && packageName.length() > 0) {
            base = packageName + ".";
        }
        return base + enclosingNames.stream().map(n -> n + "__").collect(Collectors.joining()) + simpleName;
    }

    public static String toFullMetaName(String originalBinaryName) {
        AssertionUtil.assertNotNull(originalBinaryName);
        String binaryName = Conventions.normalizeBinaryName(originalBinaryName);
        String packageName = ClassUtil.getPackageName(binaryName);
        String simpleName = ClassUtil.getSimpleName(binaryName);
        String base = "";
        if (packageName != null && packageName.length() > 0) {
            base = packageName + ".";
        }
        return base + Conventions.createSimpleMetaName(simpleName);
    }

    public static String toSimpleMetaName(String originalBinaryName) {
        AssertionUtil.assertNotNull(originalBinaryName);
        String binaryName = Conventions.normalizeBinaryName(originalBinaryName);
        String simpleName = ClassUtil.getSimpleName(binaryName);
        return Conventions.createSimpleMetaName(simpleName);
    }

    private static String createSimpleMetaName(String originalSimpleName) {
        return "_" + originalSimpleName;
    }
}

