/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.tx;

import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.tx.LocalTransactionalConnection;

final class LocalTransactionContext {
    private final LocalTransactionalConnection connection;
    private int transactionIsolationLevel = 0;
    private final List<String> savepointNames = new ArrayList<String>();
    private final Map<String, Savepoint> savepointMap = new HashMap<String, Savepoint>();
    private String id;

    LocalTransactionContext(LocalTransactionalConnection connection) {
        AssertionUtil.assertNotNull(connection);
        this.connection = connection;
    }

    LocalTransactionalConnection getConnection() {
        return this.connection;
    }

    int getTransactionIsolationLevel() {
        return this.transactionIsolationLevel;
    }

    void setTransactionIsolationLevel(int transactionIsolationLevel) {
        this.transactionIsolationLevel = transactionIsolationLevel;
    }

    Savepoint getSavepoint(String savepointName) {
        AssertionUtil.assertNotNull(savepointName);
        return this.savepointMap.get(savepointName);
    }

    void addSavepoint(String savepointName, Savepoint savepoint) {
        AssertionUtil.assertNotNull((Object)savepointName, (Object)savepoint);
        this.savepointNames.add(savepointName);
        this.savepointMap.put(savepointName, savepoint);
    }

    Savepoint releaseAndGetSavepoint(String savepointName) {
        AssertionUtil.assertNotNull(savepointName);
        Savepoint result = this.savepointMap.get(savepointName);
        if (result == null) {
            return null;
        }
        int pos = this.savepointNames.lastIndexOf(savepointName);
        if (pos > -1) {
            List<String> subList = this.savepointNames.subList(pos, this.savepointNames.size());
            for (String name : subList) {
                this.savepointMap.remove(name);
            }
            subList.clear();
        }
        return result;
    }

    String getId() {
        return this.id;
    }

    void setId(String id) {
        this.id = id;
    }
}

