/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.tx;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import javax.sql.DataSource;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.internal.jdbc.util.JdbcUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.jdbc.JdbcLogger;
import org.seasar.doma.jdbc.tx.LocalTransactionAlreadyBegunException;
import org.seasar.doma.jdbc.tx.LocalTransactionContext;
import org.seasar.doma.jdbc.tx.LocalTransactionNotYetBegunException;
import org.seasar.doma.jdbc.tx.LocalTransactionalConnection;
import org.seasar.doma.jdbc.tx.SavepointAleadyExistsException;
import org.seasar.doma.jdbc.tx.SavepointNotFoundException;
import org.seasar.doma.jdbc.tx.TransactionIsolationLevel;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class LocalTransaction {
    protected final DataSource dataSource;
    protected final ThreadLocal<LocalTransactionContext> localTxContextHolder;
    protected final JdbcLogger jdbcLogger;
    protected final TransactionIsolationLevel defaultTransactionIsolationLevel;
    protected final String className;

    protected LocalTransaction(DataSource dataSource, ThreadLocal<LocalTransactionContext> localTxContextHolder, JdbcLogger jdbcLogger) {
        this(dataSource, localTxContextHolder, jdbcLogger, null);
    }

    protected LocalTransaction(DataSource dataSource, ThreadLocal<LocalTransactionContext> localTxContextHolder, JdbcLogger jdbcLogger, TransactionIsolationLevel defaultTransactionIsolationLevel) {
        AssertionUtil.assertNotNull((Object)dataSource, localTxContextHolder, (Object)jdbcLogger);
        this.dataSource = dataSource;
        this.localTxContextHolder = localTxContextHolder;
        this.jdbcLogger = jdbcLogger;
        this.defaultTransactionIsolationLevel = defaultTransactionIsolationLevel;
        this.className = this.getClass().getName();
    }

    public void begin() {
        this.beginInternal(this.defaultTransactionIsolationLevel, "begin");
    }

    public void begin(TransactionIsolationLevel transactionIsolationLevel) {
        if (transactionIsolationLevel == null) {
            throw new DomaNullPointerException("transactionIsolationLevel");
        }
        this.beginInternal(transactionIsolationLevel, "begin");
    }

    protected void beginInternal(TransactionIsolationLevel transactionIsolationLevel, String callerMethodName) {
        int level;
        AssertionUtil.assertNotNull(callerMethodName);
        LocalTransactionContext context = this.localTxContextHolder.get();
        if (this.isActiveInternal(context)) {
            String id = context.getId();
            this.rollbackInternal(callerMethodName);
            throw new LocalTransactionAlreadyBegunException(id);
        }
        context = this.createLocalTransactionContext();
        LocalTransactionalConnection connection = context.getConnection();
        try {
            level = connection.getTransactionIsolation();
            context.setTransactionIsolationLevel(level);
        }
        catch (SQLException e) {
            this.release(context, callerMethodName);
            throw new JdbcException((MessageResource)Message.DOMA2056, (Throwable)e, e);
        }
        if (transactionIsolationLevel != null) {
            level = transactionIsolationLevel.getLevel();
            try {
                connection.setTransactionIsolation(level);
            }
            catch (SQLException e) {
                this.release(context, callerMethodName);
                throw new JdbcException((MessageResource)Message.DOMA2055, (Throwable)e, transactionIsolationLevel.name(), e);
            }
        }
        try {
            connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            this.release(context, callerMethodName);
            throw new JdbcException((MessageResource)Message.DOMA2041, (Throwable)e, e);
        }
        int id = System.identityHashCode(new Object());
        context.setId(String.valueOf(id));
        this.jdbcLogger.logLocalTransactionBegun(this.className, callerMethodName, context.getId());
    }

    protected LocalTransactionContext createLocalTransactionContext() {
        Connection originalConnection = JdbcUtil.getConnection(this.dataSource);
        LocalTransactionalConnection connection = new LocalTransactionalConnection(originalConnection);
        LocalTransactionContext context = new LocalTransactionContext(connection);
        this.localTxContextHolder.set(context);
        return context;
    }

    public void commit() {
        LocalTransactionContext context = this.localTxContextHolder.get();
        if (!this.isActiveInternal(context)) {
            throw new LocalTransactionNotYetBegunException(Message.DOMA2046, new Object[0]);
        }
        LocalTransactionalConnection connection = context.getConnection();
        try {
            connection.commit();
            this.jdbcLogger.logLocalTransactionCommitted(this.className, "commit", context.getId());
        }
        catch (SQLException e) {
            this.rollbackInternal("commit");
            throw new JdbcException((MessageResource)Message.DOMA2043, (Throwable)e, e);
        }
        finally {
            this.end("commit");
        }
    }

    public void rollback() {
        this.rollbackInternal("rollback");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rollbackInternal(String callerMethodName) {
        AssertionUtil.assertNotNull(callerMethodName);
        LocalTransactionContext context = this.localTxContextHolder.get();
        if (!this.isActiveInternal(context)) {
            return;
        }
        LocalTransactionalConnection connection = context.getConnection();
        String id = context.getId();
        try {
            connection.rollback();
            this.jdbcLogger.logLocalTransactionRolledback(this.className, callerMethodName, id);
        }
        catch (SQLException ignored) {
            this.jdbcLogger.logLocalTransactionRollbackFailure(this.className, callerMethodName, id, ignored);
        }
        finally {
            this.end(callerMethodName);
        }
    }

    public void setSavepoint(String savepointName) {
        if (savepointName == null) {
            this.rollbackInternal("setSavepoint");
            throw new DomaNullPointerException("savepointName");
        }
        LocalTransactionContext context = this.localTxContextHolder.get();
        if (!this.isActiveInternal(context)) {
            throw new LocalTransactionNotYetBegunException(Message.DOMA2053, savepointName);
        }
        String id = context.getId();
        Savepoint savepoint = context.getSavepoint(savepointName);
        if (savepoint != null) {
            this.rollbackInternal("setSavepoint");
            throw new SavepointAleadyExistsException(savepointName);
        }
        LocalTransactionalConnection connection = context.getConnection();
        try {
            savepoint = connection.setSavepoint(savepointName);
        }
        catch (SQLException e) {
            this.rollbackInternal("setSavepoint");
            throw new JdbcException((MessageResource)Message.DOMA2051, (Throwable)e, savepointName, e);
        }
        context.addSavepoint(savepointName, savepoint);
        this.jdbcLogger.logLocalTransactionSavepointCreated(this.className, "setSavepoint", id, savepointName);
    }

    public boolean hasSavepoint(String savepointName) {
        if (savepointName == null) {
            this.rollbackInternal("hasSavepoint");
            throw new DomaNullPointerException("savepointName");
        }
        LocalTransactionContext context = this.localTxContextHolder.get();
        if (!this.isActiveInternal(context)) {
            throw new LocalTransactionNotYetBegunException(Message.DOMA2057, savepointName);
        }
        return context.getSavepoint(savepointName) != null;
    }

    public void releaseSavepoint(String savepointName) {
        if (savepointName == null) {
            this.rollbackInternal("releaseSavepoint");
            throw new DomaNullPointerException("savepointName");
        }
        LocalTransactionContext context = this.localTxContextHolder.get();
        if (!this.isActiveInternal(context)) {
            throw new LocalTransactionNotYetBegunException(Message.DOMA2061, savepointName);
        }
        String id = context.getId();
        Savepoint savepoint = context.releaseAndGetSavepoint(savepointName);
        if (savepoint == null) {
            this.rollbackInternal("releaseSavepoint");
            throw new SavepointNotFoundException(savepointName);
        }
        LocalTransactionalConnection connection = context.getConnection();
        try {
            connection.releaseSavepoint(savepoint);
        }
        catch (SQLException e) {
            this.rollbackInternal("releaseSavepoint");
            throw new JdbcException((MessageResource)Message.DOMA2060, (Throwable)e, savepointName, e);
        }
        this.jdbcLogger.logLocalTransactionSavepointReleased(this.className, "releaseSavepoint", id, savepointName);
    }

    public void rollback(String savepointName) {
        if (savepointName == null) {
            this.rollbackInternal("rollback");
            throw new DomaNullPointerException("savepointName");
        }
        LocalTransactionContext context = this.localTxContextHolder.get();
        if (!this.isActiveInternal(context)) {
            throw new LocalTransactionNotYetBegunException(Message.DOMA2062, savepointName);
        }
        String id = context.getId();
        Savepoint savepoint = context.getSavepoint(savepointName);
        if (savepoint == null) {
            this.rollbackInternal("rollback");
            throw new SavepointNotFoundException(savepointName);
        }
        LocalTransactionalConnection connection = context.getConnection();
        try {
            connection.rollback(savepoint);
        }
        catch (SQLException e) {
            this.rollbackInternal("rollback");
            throw new JdbcException((MessageResource)Message.DOMA2052, (Throwable)e, savepointName, e);
        }
        this.jdbcLogger.logLocalTransactionSavepointRolledback(this.className, "rollback", id, savepointName);
    }

    protected void end(String callerMethodName) {
        AssertionUtil.assertNotNull(callerMethodName);
        LocalTransactionContext context = this.localTxContextHolder.get();
        if (!this.isActiveInternal(context)) {
            return;
        }
        this.endInternal(context, callerMethodName);
    }

    protected void endInternal(LocalTransactionContext context, String callerMethodName) {
        this.release(context, callerMethodName);
        this.jdbcLogger.logLocalTransactionEnded(this.className, callerMethodName, context.getId());
    }

    protected void release(LocalTransactionContext context, String callerMethodName) {
        AssertionUtil.assertNotNull((Object)context, (Object)callerMethodName);
        this.localTxContextHolder.set(null);
        LocalTransactionalConnection connection = context.getConnection();
        int isolationLevel = context.getTransactionIsolationLevel();
        if (isolationLevel != 0) {
            try {
                connection.setTransactionIsolation(isolationLevel);
            }
            catch (SQLException ignored) {
                this.jdbcLogger.logTransactionIsolationSettingFailuer(this.className, callerMethodName, isolationLevel, ignored);
            }
        }
        try {
            connection.setAutoCommit(true);
        }
        catch (SQLException ignored) {
            this.jdbcLogger.logAutoCommitEnablingFailure(this.className, callerMethodName, ignored);
        }
        JdbcUtil.close(connection.getWrappedConnection(), this.jdbcLogger);
    }

    public String toString() {
        LocalTransactionContext context = this.localTxContextHolder.get();
        String transactionId = context != null ? context.getId() : "null";
        return "{LocalTransaction transactionId=" + transactionId + "}";
    }

    public boolean isActive() {
        LocalTransactionContext context = this.localTxContextHolder.get();
        return this.isActiveInternal(context);
    }

    protected boolean isActiveInternal(LocalTransactionContext context) {
        return context != null;
    }
}

