/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.id;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.seasar.doma.GenerationType;
import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.jdbc.Sql;
import org.seasar.doma.jdbc.id.AbstractIdGenerator;
import org.seasar.doma.jdbc.id.IdGenerationConfig;
import org.seasar.doma.jdbc.id.IdentityIdGenerator;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class BuiltinIdentityIdGenerator
extends AbstractIdGenerator
implements IdentityIdGenerator {
    @Override
    public boolean supportsBatch(IdGenerationConfig config) {
        return false;
    }

    @Override
    public boolean includesIdentityColumn(IdGenerationConfig config) {
        return config.getDialect().includesIdentityColumn();
    }

    @Override
    public boolean supportsAutoGeneratedKeys(IdGenerationConfig config) {
        return config.getDialect().supportsAutoGeneratedKeys();
    }

    @Override
    public Long generatePreInsert(IdGenerationConfig config) {
        return null;
    }

    @Override
    public Long generatePostInsert(IdGenerationConfig config, Statement statement) {
        if (config.getDialect().supportsAutoGeneratedKeys()) {
            return this.getGeneratedValue(config, statement);
        }
        return this.getGeneratedValue(config);
    }

    protected long getGeneratedValue(IdGenerationConfig config, Statement statement) {
        try {
            ResultSet resultSet = statement.getGeneratedKeys();
            return this.getGeneratedValue(config, resultSet);
        }
        catch (SQLException e) {
            throw new JdbcException((MessageResource)Message.DOMA2018, (Throwable)e, config.getEntityType().getName(), e);
        }
    }

    protected long getGeneratedValue(IdGenerationConfig config) {
        String qualifiedTableName = config.getQualifiedTableName();
        String idColumnName = config.getIdColumnName();
        Sql<?> sql = config.getDialect().getIdentitySelectSql(qualifiedTableName, idColumnName);
        return this.getGeneratedValue(config, sql);
    }

    @Override
    public GenerationType getGenerationType() {
        return GenerationType.IDENTITY;
    }
}

