/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.entity;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Map;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.internal.WrapException;
import org.seasar.doma.internal.jdbc.criteria.CriterionVisitor;
import org.seasar.doma.internal.util.ClassUtil;
import org.seasar.doma.internal.util.ConstructorUtil;
import org.seasar.doma.internal.util.FieldUtil;
import org.seasar.doma.jdbc.domain.DomainType;
import org.seasar.doma.jdbc.entity.EntityPropertyAccessException;
import org.seasar.doma.jdbc.entity.EntityPropertyNotFoundException;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityPropertyTypeVisitor;
import org.seasar.doma.jdbc.entity.WrapperConstructorNotFoundException;
import org.seasar.doma.jdbc.entity.WrapperInstantiationException;
import org.seasar.doma.wrapper.Accessor;
import org.seasar.doma.wrapper.EnumWrapper;
import org.seasar.doma.wrapper.Wrapper;

public class BasicPropertyType<PE, E extends PE, V, D>
implements EntityPropertyType<E, V> {
    protected final Class<E> entityClass;
    protected final Class<V> entityPropertyClass;
    protected final Class<?> wrapperClass;
    protected final EntityPropertyType<PE, V> parentEntityPropertyType;
    protected final DomainType<V, D> domainType;
    protected final String name;
    protected final String columnName;
    protected final boolean insertable;
    protected final boolean updatable;
    protected final Field field;
    protected final WrapperFactory<V> wrapperFactory;
    protected final AccessorFactory<E, V> accessorFactory;
    protected final MapAccessorFactory<V> mapAccessorFactory;

    public BasicPropertyType(Class<E> entityClass, Class<V> entityPropertyClass, Class<?> wrapperClass, EntityPropertyType<PE, V> parentEntityPropertyType, DomainType<V, D> domainType, String name, String columnName, boolean insertable, boolean updatable) {
        if (entityClass == null) {
            throw new DomaNullPointerException("entityClass");
        }
        if (entityPropertyClass == null) {
            throw new DomaNullPointerException("entityPropertyClass");
        }
        if (wrapperClass == null) {
            throw new DomaNullPointerException("wrapperClass");
        }
        if (name == null) {
            throw new DomaNullPointerException("name");
        }
        if (columnName == null) {
            throw new DomaNullPointerException("columnName");
        }
        this.entityClass = entityClass;
        this.entityPropertyClass = entityPropertyClass;
        this.wrapperClass = wrapperClass;
        this.parentEntityPropertyType = parentEntityPropertyType;
        this.domainType = domainType;
        this.name = name;
        this.columnName = columnName;
        this.insertable = insertable;
        this.updatable = updatable;
        this.field = parentEntityPropertyType == null ? this.getField() : null;
        this.wrapperFactory = this.createWrapperFactory();
        this.accessorFactory = this.createAccessorFactory(this.field);
        this.mapAccessorFactory = this.createMapAccessorFactory(this.field);
    }

    private WrapperFactory<V> createWrapperFactory() {
        if (this.entityPropertyClass.isEnum()) {
            return new EnumWrapperFactory<V>(this.entityPropertyClass);
        }
        return new SimpleWrapperFactory(this.wrapperClass);
    }

    private AccessorFactory<E, V> createAccessorFactory(Field field) {
        if (this.parentEntityPropertyType != null) {
            return new ParentValueAccessorFactory(this.parentEntityPropertyType);
        }
        if (this.domainType != null) {
            return new DomainAccessorFactory(this.entityClass.getName(), this.name, field, this.domainType);
        }
        return new ValueAccessorFactory(this.entityClass.getName(), this.name, field);
    }

    private MapAccessorFactory<V> createMapAccessorFactory(Field field) {
        if (this.parentEntityPropertyType != null) {
            return new ParentValueMapAccessorFactory(this.parentEntityPropertyType);
        }
        if (this.domainType != null) {
            return new DomainMapAccessorFactory<V, D>(this.entityClass.getName(), this.name, field, this.domainType);
        }
        return new ValueMapAccessorFactory(this.entityClass.getName(), this.name, field);
    }

    private Field getField() {
        Field field;
        try {
            field = ClassUtil.getDeclaredField(this.entityClass, this.name);
        }
        catch (WrapException wrapException) {
            throw new EntityPropertyNotFoundException(wrapException.getCause(), this.entityClass.getName(), this.name);
        }
        if (!FieldUtil.isPublic(field)) {
            try {
                FieldUtil.setAccessible(field, true);
            }
            catch (WrapException wrapException) {
                throw new EntityPropertyAccessException(wrapException.getCause(), this.entityClass.getName(), this.name);
            }
        }
        return field;
    }

    @Override
    public Object getCopy(E entity) {
        Wrapper<V> wrapper = this.getWrapper(entity);
        V value = wrapper.getCopy();
        if (this.domainType != null) {
            return this.domainType.newDomain(value);
        }
        return value;
    }

    @Override
    public Wrapper<V> getWrapper(E entity) {
        Wrapper<V> wrapper = this.wrapperFactory.getWrapper();
        Accessor<V> accessor = this.accessorFactory.getAccessor(entity, wrapper);
        wrapper.setAccessor(accessor);
        return wrapper;
    }

    @Override
    public Wrapper<V> getWrapper(Map<String, Object> properties) {
        Wrapper<V> wrapper = this.wrapperFactory.getWrapper();
        Accessor<V> accessor = this.mapAccessorFactory.getAccessor(properties, wrapper);
        wrapper.setAccessor(accessor);
        return wrapper;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public boolean isId() {
        return false;
    }

    @Override
    public boolean isVersion() {
        return false;
    }

    @Override
    public boolean isInsertable() {
        return this.insertable;
    }

    @Override
    public boolean isUpdatable() {
        return this.updatable;
    }

    @Override
    public Class<V> getType() {
        return this.entityPropertyClass;
    }

    @Override
    public <R, P, TH extends Throwable> R accept(CriterionVisitor<R, P, TH> visitor, P p) throws TH {
        if (visitor == null) {
            throw new DomaNullPointerException("visitor");
        }
        if (visitor instanceof EntityPropertyTypeVisitor) {
            EntityPropertyTypeVisitor v = (EntityPropertyTypeVisitor)visitor;
            return v.visitEntityPropertyType(this, p);
        }
        return visitor.visitUnknownExpression(this, p);
    }

    protected static class EnumWrapperFactory<V>
    implements WrapperFactory<V> {
        protected final Class<V> enumClass;
        protected final Constructor<EnumWrapper> constructor;

        protected EnumWrapperFactory(Class<V> enumClass) {
            if (enumClass == null) {
                throw new DomaNullPointerException("enumClass");
            }
            this.enumClass = enumClass;
            try {
                this.constructor = ClassUtil.getConstructor(EnumWrapper.class, Class.class);
            }
            catch (WrapException wrapException) {
                throw new WrapperConstructorNotFoundException(wrapException.getCause(), EnumWrapper.class.getName());
            }
        }

        @Override
        public Wrapper<V> getWrapper() {
            try {
                return ConstructorUtil.newInstance(this.constructor, this.enumClass);
            }
            catch (WrapException wrapException) {
                throw new WrapperInstantiationException(wrapException.getCause(), EnumWrapper.class.getName());
            }
        }
    }

    protected static class SimpleWrapperFactory<V>
    implements WrapperFactory<V> {
        protected final Class<?> wrapperClass;
        protected final Constructor<? extends Wrapper<V>> constructor;

        protected SimpleWrapperFactory(Class<?> wrapperClass) {
            if (wrapperClass == null) {
                throw new DomaNullPointerException("wrapperClass");
            }
            this.wrapperClass = wrapperClass;
            try {
                this.constructor = ClassUtil.getConstructor(wrapperClass, new Class[0]);
            }
            catch (WrapException wrapException) {
                throw new WrapperConstructorNotFoundException(wrapException.getCause(), wrapperClass.getName());
            }
        }

        @Override
        public Wrapper<V> getWrapper() {
            try {
                return ConstructorUtil.newInstance(this.constructor, new Object[0]);
            }
            catch (WrapException wrapException) {
                throw new WrapperInstantiationException(wrapException.getCause(), this.wrapperClass.getName());
            }
        }
    }

    protected static interface WrapperFactory<V> {
        public Wrapper<V> getWrapper();
    }

    protected static class DomainMapAccessorFactory<V, D>
    implements MapAccessorFactory<V> {
        protected final String entityClassName;
        protected final String entityPropertyName;
        protected final Field field;
        protected final boolean primitive;
        protected final DomainType<V, D> domainType;

        protected DomainMapAccessorFactory(String entityClassName, String entityPropertyName, Field field, DomainType<V, D> domainType) {
            if (entityClassName == null) {
                throw new DomaNullPointerException("entityClassName");
            }
            if (entityPropertyName == null) {
                throw new DomaNullPointerException("entityPropertyName");
            }
            if (field == null) {
                throw new DomaNullPointerException("field");
            }
            if (domainType == null) {
                throw new DomaNullPointerException("domainType");
            }
            this.entityClassName = entityClassName;
            this.entityPropertyName = entityPropertyName;
            this.field = field;
            this.primitive = field.getType().isPrimitive();
            this.domainType = domainType;
        }

        @Override
        public Accessor<V> getAccessor(final Map<String, Object> properties, final Wrapper<V> wrapper) {
            if (properties == null) {
                throw new DomaNullPointerException("properties");
            }
            if (wrapper == null) {
                throw new DomaNullPointerException("wrapper");
            }
            return new Accessor<V>(){

                @Override
                public V get() {
                    Object domain = properties.get(DomainMapAccessorFactory.this.entityPropertyName);
                    return DomainMapAccessorFactory.this.domainType.getWrapper(domain).get();
                }

                @Override
                public void set(V value) {
                    Object actualValue = DomainMapAccessorFactory.this.primitive && value == null ? wrapper.getDefault() : value;
                    Object domain = DomainMapAccessorFactory.this.domainType.newDomain(actualValue);
                    properties.put(DomainMapAccessorFactory.this.entityPropertyName, domain);
                }
            };
        }
    }

    protected static class ParentValueMapAccessorFactory<PE, E extends PE, V>
    implements MapAccessorFactory<V> {
        protected final EntityPropertyType<PE, V> parentEntityPropertyType;

        protected ParentValueMapAccessorFactory(EntityPropertyType<PE, V> parentEntityPropertyType) {
            if (parentEntityPropertyType == null) {
                throw new DomaNullPointerException("parentEntityPropertyType");
            }
            this.parentEntityPropertyType = parentEntityPropertyType;
        }

        @Override
        public Accessor<V> getAccessor(final Map<String, Object> properties, Wrapper<V> wrapper) {
            if (properties == null) {
                throw new DomaNullPointerException("properties");
            }
            if (wrapper == null) {
                throw new DomaNullPointerException("wrapper");
            }
            return new Accessor<V>(){

                @Override
                public V get() {
                    return ParentValueMapAccessorFactory.this.parentEntityPropertyType.getWrapper(properties).get();
                }

                @Override
                public void set(V value) {
                    ParentValueMapAccessorFactory.this.parentEntityPropertyType.getWrapper(properties).set(value);
                }
            };
        }
    }

    protected static class ValueMapAccessorFactory<V>
    implements MapAccessorFactory<V> {
        protected final String entityClassName;
        protected final String entityPropertyName;
        protected final Field field;
        protected final boolean primitive;

        protected ValueMapAccessorFactory(String entityClassName, String entityPropertyName, Field field) {
            if (entityClassName == null) {
                throw new DomaNullPointerException("entityClassName");
            }
            if (entityPropertyName == null) {
                throw new DomaNullPointerException("entityPropertyName");
            }
            if (field == null) {
                throw new DomaNullPointerException("field");
            }
            this.entityClassName = entityClassName;
            this.entityPropertyName = entityPropertyName;
            this.field = field;
            this.primitive = field.getType().isPrimitive();
        }

        @Override
        public Accessor<V> getAccessor(final Map<String, Object> properties, final Wrapper<V> wrapper) {
            if (properties == null) {
                throw new DomaNullPointerException("properties");
            }
            if (wrapper == null) {
                throw new DomaNullPointerException("wrapper");
            }
            return new Accessor<V>(){

                @Override
                public V get() {
                    return properties.get(ValueMapAccessorFactory.this.entityPropertyName);
                }

                @Override
                public void set(V value) {
                    Object actualValue = ValueMapAccessorFactory.this.primitive && value == null ? wrapper.getDefault() : value;
                    properties.put(ValueMapAccessorFactory.this.entityPropertyName, actualValue);
                }
            };
        }
    }

    protected static class DomainAccessorFactory<E, V, D>
    implements AccessorFactory<E, V> {
        protected final String entityClassName;
        protected final String entityPropertyName;
        protected final Field field;
        protected final boolean primitive;
        protected final DomainType<V, D> domainType;

        protected DomainAccessorFactory(String entityClassName, String entityPropertyName, Field field, DomainType<V, D> domainType) {
            if (entityClassName == null) {
                throw new DomaNullPointerException("entityClassName");
            }
            if (entityPropertyName == null) {
                throw new DomaNullPointerException("entityPropertyName");
            }
            if (field == null) {
                throw new DomaNullPointerException("field");
            }
            if (domainType == null) {
                throw new DomaNullPointerException("domainType");
            }
            this.entityClassName = entityClassName;
            this.entityPropertyName = entityPropertyName;
            this.field = field;
            this.primitive = field.getType().isPrimitive();
            this.domainType = domainType;
        }

        @Override
        public Accessor<V> getAccessor(final E entity, final Wrapper<V> wrapper) {
            if (entity == null) {
                throw new DomaNullPointerException("entity");
            }
            if (wrapper == null) {
                throw new DomaNullPointerException("wrapper");
            }
            return new Accessor<V>(){

                @Override
                public V get() {
                    Object domain;
                    try {
                        domain = FieldUtil.get(DomainAccessorFactory.this.field, entity);
                    }
                    catch (WrapException wrapException) {
                        throw new EntityPropertyAccessException(wrapException.getCause(), DomainAccessorFactory.this.entityClassName, DomainAccessorFactory.this.entityPropertyName);
                    }
                    return DomainAccessorFactory.this.domainType.getWrapper(domain).get();
                }

                @Override
                public void set(V value) {
                    Object actualValue = DomainAccessorFactory.this.primitive && value == null ? wrapper.getDefault() : value;
                    Object domain = DomainAccessorFactory.this.domainType.newDomain(actualValue);
                    try {
                        FieldUtil.set(DomainAccessorFactory.this.field, entity, domain);
                    }
                    catch (WrapException wrapException) {
                        throw new EntityPropertyAccessException(wrapException.getCause(), DomainAccessorFactory.this.entityClassName, DomainAccessorFactory.this.entityPropertyName);
                    }
                }
            };
        }
    }

    protected static class ParentValueAccessorFactory<PE, E extends PE, V>
    implements AccessorFactory<E, V> {
        protected final EntityPropertyType<PE, V> parentEntityPropertyType;

        protected ParentValueAccessorFactory(EntityPropertyType<PE, V> parentEntityPropertyType) {
            if (parentEntityPropertyType == null) {
                throw new DomaNullPointerException("parentEntityPropertyType");
            }
            this.parentEntityPropertyType = parentEntityPropertyType;
        }

        @Override
        public Accessor<V> getAccessor(final E entity, Wrapper<V> wrapper) {
            if (entity == null) {
                throw new DomaNullPointerException("entity");
            }
            if (wrapper == null) {
                throw new DomaNullPointerException("wrapper");
            }
            return new Accessor<V>(){

                @Override
                public V get() {
                    return ParentValueAccessorFactory.this.parentEntityPropertyType.getWrapper(entity).get();
                }

                @Override
                public void set(V value) {
                    ParentValueAccessorFactory.this.parentEntityPropertyType.getWrapper(entity).set(value);
                }
            };
        }
    }

    protected static class ValueAccessorFactory<E, V>
    implements AccessorFactory<E, V> {
        protected final String entityClassName;
        protected final String entityPropertyName;
        protected final Field field;
        protected final boolean primitive;

        protected ValueAccessorFactory(String entityClassName, String entityPropertyName, Field field) {
            if (entityClassName == null) {
                throw new DomaNullPointerException("entityClassName");
            }
            if (entityPropertyName == null) {
                throw new DomaNullPointerException("entityPropertyName");
            }
            if (field == null) {
                throw new DomaNullPointerException("field");
            }
            this.entityClassName = entityClassName;
            this.entityPropertyName = entityPropertyName;
            this.field = field;
            this.primitive = field.getType().isPrimitive();
        }

        @Override
        public Accessor<V> getAccessor(final E entity, final Wrapper<V> wrapper) {
            if (entity == null) {
                throw new DomaNullPointerException("entity");
            }
            if (wrapper == null) {
                throw new DomaNullPointerException("wrapper");
            }
            return new Accessor<V>(){

                @Override
                public V get() {
                    try {
                        return FieldUtil.get(ValueAccessorFactory.this.field, entity);
                    }
                    catch (WrapException wrapException) {
                        throw new EntityPropertyAccessException(wrapException.getCause(), ValueAccessorFactory.this.entityClassName, ValueAccessorFactory.this.entityPropertyName);
                    }
                }

                @Override
                public void set(V value) {
                    Object actualValue = ValueAccessorFactory.this.primitive && value == null ? wrapper.getDefault() : value;
                    try {
                        FieldUtil.set(ValueAccessorFactory.this.field, entity, actualValue);
                    }
                    catch (WrapException wrapException) {
                        throw new EntityPropertyAccessException(wrapException.getCause(), ValueAccessorFactory.this.entityClassName, ValueAccessorFactory.this.entityPropertyName);
                    }
                }
            };
        }
    }

    protected static interface MapAccessorFactory<V> {
        public Accessor<V> getAccessor(Map<String, Object> var1, Wrapper<V> var2);
    }

    protected static interface AccessorFactory<E, V> {
        public Accessor<V> getAccessor(E var1, Wrapper<V> var2);
    }
}

