/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.builder;

import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.internal.jdbc.command.DeleteCommand;
import org.seasar.doma.internal.jdbc.query.SqlDeleteQuery;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.Sql;
import org.seasar.doma.jdbc.builder.BuildingHelper;
import org.seasar.doma.jdbc.builder.Param;
import org.seasar.doma.jdbc.builder.ParamIndex;

public class DeleteBuilder {
    private final BuildingHelper helper;
    private final SqlDeleteQuery query;
    private final ParamIndex paramIndex;

    private DeleteBuilder(Config config) {
        this.helper = new BuildingHelper();
        this.query = new SqlDeleteQuery();
        this.query.setConfig(config);
        this.query.setCallerClassName(this.getClass().getName());
        this.paramIndex = new ParamIndex();
    }

    private DeleteBuilder(BuildingHelper builder, SqlDeleteQuery query, ParamIndex parameterIndex) {
        this.helper = builder;
        this.query = query;
        this.paramIndex = parameterIndex;
    }

    public static DeleteBuilder newInstance(Config config) {
        if (config == null) {
            throw new DomaNullPointerException("config");
        }
        return new DeleteBuilder(config);
    }

    public DeleteBuilder sql(String sql) {
        if (sql == null) {
            throw new DomaNullPointerException("sql");
        }
        this.helper.appendSqlWithLineSeparator(sql);
        return new SubsequentDeleteBuilder(this.helper, this.query, this.paramIndex);
    }

    public DeleteBuilder removeLast() {
        this.helper.removeLast();
        return new SubsequentDeleteBuilder(this.helper, this.query, this.paramIndex);
    }

    public <P> DeleteBuilder param(Class<P> paramClass, P param) {
        if (paramClass == null) {
            throw new DomaNullPointerException("paramClass");
        }
        this.helper.appendParam(new Param(paramClass, param, this.paramIndex));
        this.paramIndex.increment();
        return new SubsequentDeleteBuilder(this.helper, this.query, this.paramIndex);
    }

    public int execute() {
        if (this.query.getMethodName() == null) {
            this.query.setCallerMethodName("execute");
        }
        for (Param p : this.helper.getParams()) {
            this.query.addParameter(p.name, p.paramClass, p.param);
        }
        this.query.setSqlNode(this.helper.getSqlNode());
        this.query.prepare();
        DeleteCommand command = new DeleteCommand(this.query);
        int result = command.execute();
        this.query.complete();
        return result;
    }

    public void queryTimeout(int queryTimeout) {
        this.query.setQueryTimeout(queryTimeout);
    }

    public void callerClassName(String className) {
        if (className == null) {
            throw new DomaNullPointerException("className");
        }
        this.query.setCallerClassName(className);
    }

    public void callerMethodName(String methodName) {
        if (methodName == null) {
            throw new DomaNullPointerException("methodName");
        }
        this.query.setCallerMethodName(methodName);
    }

    public Sql<?> getSql() {
        if (this.query.getMethodName() == null) {
            this.query.setCallerMethodName("getSql");
        }
        this.query.setSqlNode(this.helper.getSqlNode());
        this.query.prepare();
        return this.query.getSql();
    }

    private static class SubsequentDeleteBuilder
    extends DeleteBuilder {
        private SubsequentDeleteBuilder(BuildingHelper builder, SqlDeleteQuery query, ParamIndex parameterIndex) {
            super(builder, query, parameterIndex);
        }

        @Override
        public DeleteBuilder sql(String sql) {
            if (sql == null) {
                throw new DomaNullPointerException("sql");
            }
            ((DeleteBuilder)this).helper.appendSql(sql);
            return this;
        }
    }
}

