/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.sql;

import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.internal.util.StringUtil;

public enum SqlTokenType {
    QUOTE,
    OPENED_PARENS,
    CLOSED_PARENS,
    LINE_COMMENT,
    ELSEIF_LINE_COMMENT{

        @Override
        public String extract(String token) {
            AssertionUtil.assertNotNull(token);
            AssertionUtil.assertTrue(token.length() >= 10, new Object[0]);
            return token.substring(8, token.length() - 2);
        }
    }
    ,
    ELSE_LINE_COMMENT,
    BLOCK_COMMENT,
    BIND_VARIABLE_BLOCK_COMMENT{

        @Override
        public String extract(String token) {
            AssertionUtil.assertNotNull(token);
            AssertionUtil.assertTrue(token.length() >= 5, new Object[0]);
            String s = token.substring(2, token.length() - 2);
            return StringUtil.trimWhitespace(s);
        }
    }
    ,
    EMBEDDED_VARIABLE_BLOCK_COMMENT{

        @Override
        public String extract(String token) {
            AssertionUtil.assertNotNull(token);
            AssertionUtil.assertTrue(token.length() >= 5, new Object[0]);
            String s = token.substring(3, token.length() - 2);
            return StringUtil.trimWhitespace(s);
        }
    }
    ,
    IF_BLOCK_COMMENT{

        @Override
        public String extract(String token) {
            AssertionUtil.assertNotNull(token);
            AssertionUtil.assertTrue(token.length() >= 7, new Object[0]);
            return token.substring(5, token.length() - 2);
        }
    }
    ,
    ELSEIF_BLOCK_COMMENT{

        @Override
        public String extract(String token) {
            AssertionUtil.assertNotNull(token);
            AssertionUtil.assertTrue(token.length() >= 11, new Object[0]);
            return token.substring(9, token.length() - 2);
        }
    }
    ,
    ELSE_BLOCK_COMMENT,
    FOR_BLOCK_COMMENT{

        @Override
        public String extract(String token) {
            AssertionUtil.assertNotNull(token);
            AssertionUtil.assertTrue(token.length() >= 8, new Object[0]);
            return token.substring(6, token.length() - 2);
        }
    }
    ,
    END_BLOCK_COMMENT,
    DELIMITER,
    SELECT_WORD,
    WHERE_WORD,
    FROM_WORD,
    GROUP_BY_WORD,
    HAVING_WORD,
    ORDER_BY_WORD,
    FOR_UPDATE_WORD,
    AND_WORD,
    OR_WORD,
    UNION_WORD,
    MINUS_WORD,
    EXCEPT_WORD,
    INTERSECT_WORD,
    WORD,
    OTHER,
    WHITESPACE,
    EOL,
    EOF;


    public String extract(String token) {
        return token;
    }
}

