/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.query;

import java.lang.reflect.Method;
import org.seasar.doma.internal.jdbc.entity.AbstractPostUpdateContext;
import org.seasar.doma.internal.jdbc.entity.AbstractPreUpdateContext;
import org.seasar.doma.internal.jdbc.query.SqlFileModifyQuery;
import org.seasar.doma.internal.jdbc.query.UpdateQuery;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.entity.VersionPropertyType;

public class SqlFileUpdateQuery
extends SqlFileModifyQuery
implements UpdateQuery {
    protected EntityHandler<?> entityHandler;
    protected boolean versionIgnored;
    protected boolean optimisticLockExceptionSuppressed;

    public SqlFileUpdateQuery() {
        super(SqlKind.UPDATE);
    }

    @Override
    public void prepare() {
        AssertionUtil.assertNotNull((Object)this.method, (Object)this.config, (Object)this.sqlFilePath, (Object)this.callerClassName, (Object)this.callerMethodName);
        this.preUpdate();
        this.prepareOptimisticLock();
        this.prepareOptions();
        this.prepareSql();
        AssertionUtil.assertNotNull(this.sql);
    }

    protected void preUpdate() {
        if (this.entityHandler != null) {
            this.entityHandler.preUpdate();
        }
    }

    protected void prepareOptimisticLock() {
        if (this.entityHandler != null) {
            this.entityHandler.prepareOptimisticLock();
        }
    }

    @Override
    public void incrementVersion() {
        if (this.entityHandler != null) {
            this.entityHandler.incrementVersion();
        }
    }

    public <E> E getEntity(Class<E> entityType) {
        if (this.entityHandler != null) {
            return this.entityHandler.entity;
        }
        return null;
    }

    @Override
    public void complete() {
        if (this.entityHandler != null) {
            this.entityHandler.postUpdate();
        }
    }

    @Override
    public <E> void setEntityAndEntityType(String name, E entity, EntityType<E> entityType) {
        this.entityHandler = new EntityHandler<E>(name, entity, entityType);
    }

    public void setVersionIncluded(boolean versionIncluded) {
        this.versionIgnored |= versionIncluded;
    }

    public void setVersionIgnored(boolean versionIgnored) {
        this.versionIgnored |= versionIgnored;
    }

    public void setOptimisticLockExceptionSuppressed(boolean optimisticLockExceptionSuppressed) {
        this.optimisticLockExceptionSuppressed = optimisticLockExceptionSuppressed;
    }

    protected static class SqlFilePostUpdateContext<E>
    extends AbstractPostUpdateContext<E> {
        public SqlFilePostUpdateContext(EntityType<E> entityType, Method method, Config config) {
            super(entityType, method, config);
        }

        @Override
        public boolean isPropertyChanged(String propertyName) {
            this.validatePropertyDefined(propertyName);
            return true;
        }
    }

    protected static class SqlFilePreUpdateContext<E>
    extends AbstractPreUpdateContext<E> {
        public SqlFilePreUpdateContext(EntityType<E> entityType, Method method, Config config) {
            super(entityType, method, config);
        }

        @Override
        public boolean isEntityChanged() {
            return true;
        }

        @Override
        public boolean isPropertyChanged(String propertyName) {
            this.validatePropertyDefined(propertyName);
            return true;
        }
    }

    protected class EntityHandler<E> {
        protected String name;
        protected E entity;
        protected EntityType<E> entityType;
        protected VersionPropertyType<? super E, E, ?, ?> versionPropertyType;

        protected EntityHandler(String name, E entity, EntityType<E> entityType) {
            AssertionUtil.assertNotNull((Object)name, entity, entityType);
            this.name = name;
            this.entity = entity;
            this.entityType = entityType;
            this.versionPropertyType = entityType.getVersionPropertyType();
        }

        protected void preUpdate() {
            SqlFilePreUpdateContext<E> context = new SqlFilePreUpdateContext<E>(this.entityType, SqlFileUpdateQuery.this.method, SqlFileUpdateQuery.this.config);
            this.entityType.preUpdate(this.entity, context);
            if (context.getNewEntity() != null) {
                this.entity = context.getNewEntity();
                SqlFileUpdateQuery.this.addParameterInternal(this.name, this.entityType.getEntityClass(), this.entity);
            }
        }

        protected void postUpdate() {
            SqlFilePostUpdateContext<E> context = new SqlFilePostUpdateContext<E>(this.entityType, SqlFileUpdateQuery.this.method, SqlFileUpdateQuery.this.config);
            this.entityType.postUpdate(this.entity, context);
            if (context.getNewEntity() != null) {
                this.entity = context.getNewEntity();
            }
            this.entityType.saveCurrentStates(this.entity);
        }

        protected void prepareOptimisticLock() {
            if (this.versionPropertyType != null && !SqlFileUpdateQuery.this.versionIgnored && !SqlFileUpdateQuery.this.optimisticLockExceptionSuppressed) {
                SqlFileUpdateQuery.this.optimisticLockCheckRequired = true;
            }
        }

        protected void incrementVersion() {
            if (this.versionPropertyType != null && !SqlFileUpdateQuery.this.versionIgnored) {
                if (this.entityType.isImmutable()) {
                    this.entity = this.versionPropertyType.incrementAndNewEntity(this.entity, this.entityType);
                } else {
                    this.versionPropertyType.increment(this.entity);
                }
            }
        }
    }
}

