/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.query;

import java.lang.reflect.Method;
import org.seasar.doma.internal.jdbc.entity.AbstractPostUpdateContext;
import org.seasar.doma.internal.jdbc.entity.AbstractPreUpdateContext;
import org.seasar.doma.internal.jdbc.query.BatchUpdateQuery;
import org.seasar.doma.internal.jdbc.query.SqlFileBatchModifyQuery;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.entity.VersionPropertyType;

public class SqlFileBatchUpdateQuery<E>
extends SqlFileBatchModifyQuery<E>
implements BatchUpdateQuery {
    protected EntityHandler entityHandler;
    protected boolean versionIgnored;
    protected boolean optimisticLockExceptionSuppressed;

    public SqlFileBatchUpdateQuery(Class<E> elementClass) {
        super(elementClass, SqlKind.BATCH_UPDATE);
    }

    @Override
    public void prepare() {
        super.prepare();
        int size = this.elements.size();
        if (size == 0) {
            return;
        }
        this.executable = true;
        this.sqlExecutionSkipCause = null;
        this.currentEntity = this.elements.get(0);
        this.preUpdate();
        this.prepareSqlFile();
        this.prepareOptions();
        this.prepareOptimisticLock();
        this.prepareSql();
        this.elements.set(0, this.currentEntity);
        for (int i = 1; i < size; ++i) {
            this.currentEntity = this.elements.get(i);
            this.preUpdate();
            this.prepareSql();
            this.elements.set(i, this.currentEntity);
        }
        AssertionUtil.assertEquals(size, this.sqls.size());
    }

    protected void preUpdate() {
        if (this.entityHandler != null) {
            this.entityHandler.preUpdate();
        }
    }

    protected void prepareOptimisticLock() {
        if (this.entityHandler != null) {
            this.entityHandler.prepareOptimisticLock();
        }
    }

    @Override
    public void incrementVersions() {
        if (this.entityHandler != null) {
            this.entityHandler.incrementVersions();
        }
    }

    @Override
    public void complete() {
        if (this.entityHandler != null) {
            int len = this.elements.size();
            for (int i = 0; i < len; ++i) {
                this.currentEntity = this.elements.get(i);
                this.entityHandler.postUpdate();
                this.elements.set(i, this.currentEntity);
            }
        }
    }

    @Override
    public void setEntityType(EntityType<E> entityType) {
        this.entityHandler = new EntityHandler(entityType);
    }

    public void setVersionIncluded(boolean versionIncluded) {
        this.versionIgnored |= versionIncluded;
    }

    public void setVersionIgnored(boolean versionIgnored) {
        this.versionIgnored |= versionIgnored;
    }

    public void setOptimisticLockExceptionSuppressed(boolean optimisticLockExceptionSuppressed) {
        this.optimisticLockExceptionSuppressed = optimisticLockExceptionSuppressed;
    }

    protected static class SqlFileBatchPostUpdateContext<E>
    extends AbstractPostUpdateContext<E> {
        public SqlFileBatchPostUpdateContext(EntityType<E> entityType, Method method, Config config) {
            super(entityType, method, config);
        }

        @Override
        public boolean isPropertyChanged(String propertyName) {
            this.validatePropertyDefined(propertyName);
            return true;
        }
    }

    protected static class SqlFileBatchPreUpdateContext<E>
    extends AbstractPreUpdateContext<E> {
        public SqlFileBatchPreUpdateContext(EntityType<E> entityType, Method method, Config config) {
            super(entityType, method, config);
        }

        @Override
        public boolean isEntityChanged() {
            return true;
        }

        @Override
        public boolean isPropertyChanged(String propertyName) {
            this.validatePropertyDefined(propertyName);
            return true;
        }
    }

    protected class EntityHandler {
        protected EntityType<E> entityType;
        protected VersionPropertyType<? super E, E, ?, ?> versionPropertyType;

        protected EntityHandler(EntityType<E> entityType) {
            AssertionUtil.assertNotNull(entityType);
            this.entityType = entityType;
            this.versionPropertyType = entityType.getVersionPropertyType();
        }

        protected void preUpdate() {
            SqlFileBatchPreUpdateContext context = new SqlFileBatchPreUpdateContext(this.entityType, SqlFileBatchUpdateQuery.this.method, SqlFileBatchUpdateQuery.this.config);
            this.entityType.preUpdate(SqlFileBatchUpdateQuery.this.currentEntity, context);
            if (context.getNewEntity() != null) {
                SqlFileBatchUpdateQuery.this.currentEntity = context.getNewEntity();
            }
        }

        protected void postUpdate() {
            SqlFileBatchPostUpdateContext context = new SqlFileBatchPostUpdateContext(this.entityType, SqlFileBatchUpdateQuery.this.method, SqlFileBatchUpdateQuery.this.config);
            this.entityType.postUpdate(SqlFileBatchUpdateQuery.this.currentEntity, context);
            if (context.getNewEntity() != null) {
                SqlFileBatchUpdateQuery.this.currentEntity = context.getNewEntity();
            }
            this.entityType.saveCurrentStates(SqlFileBatchUpdateQuery.this.currentEntity);
        }

        protected void prepareOptimisticLock() {
            if (this.versionPropertyType != null && !SqlFileBatchUpdateQuery.this.versionIgnored && !SqlFileBatchUpdateQuery.this.optimisticLockExceptionSuppressed) {
                SqlFileBatchUpdateQuery.this.optimisticLockCheckRequired = true;
            }
        }

        protected void incrementVersions() {
            if (this.versionPropertyType != null && !SqlFileBatchUpdateQuery.this.versionIgnored) {
                boolean immutable = this.entityType.isImmutable();
                int size = SqlFileBatchUpdateQuery.this.elements.size();
                for (int i = 0; i < size; ++i) {
                    Object entity = SqlFileBatchUpdateQuery.this.elements.get(i);
                    if (immutable) {
                        Object newEntity = this.versionPropertyType.incrementAndNewEntity(entity, this.entityType);
                        SqlFileBatchUpdateQuery.this.elements.set(i, newEntity);
                        continue;
                    }
                    this.versionPropertyType.increment(entity);
                }
            }
        }
    }
}

