/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import org.seasar.doma.internal.jdbc.command.CallableSqlParameterBinder;
import org.seasar.doma.internal.jdbc.command.CallableSqlParameterFetcher;
import org.seasar.doma.internal.jdbc.command.Command;
import org.seasar.doma.internal.jdbc.query.ModuleQuery;
import org.seasar.doma.internal.jdbc.query.Query;
import org.seasar.doma.internal.jdbc.sql.CallableSql;
import org.seasar.doma.internal.jdbc.util.JdbcUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.JdbcLogger;
import org.seasar.doma.jdbc.SqlExecutionException;
import org.seasar.doma.jdbc.dialect.Dialect;

public abstract class ModuleCommand<R, Q extends ModuleQuery>
implements Command<R, Q> {
    protected final Q query;
    protected CallableSql sql;

    protected ModuleCommand(Q query) {
        AssertionUtil.assertNotNull(query);
        this.query = query;
        this.sql = query.getSql();
    }

    /*
     * Loose catch block
     */
    @Override
    public R execute() {
        Connection connection = JdbcUtil.getConnection(this.query.getConfig().getDataSource());
        try {
            R r;
            CallableStatement callableStatement = JdbcUtil.prepareCall(connection, this.sql);
            try {
                this.log();
                this.setupOptions(callableStatement);
                this.bindParameters(callableStatement);
                r = this.executeInternal(callableStatement);
            }
            catch (SQLException e) {
                Dialect dialect = this.query.getConfig().getDialect();
                throw new SqlExecutionException(this.query.getConfig().getExceptionSqlLogType(), this.sql, e, dialect.getRootCause(e));
            }
            finally {
                JdbcUtil.close(callableStatement, this.query.getConfig().getJdbcLogger());
            }
            return r;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            JdbcUtil.close(connection, this.query.getConfig().getJdbcLogger());
        }
    }

    protected abstract R executeInternal(CallableStatement var1) throws SQLException;

    protected void setupOptions(CallableStatement preparedStatement) throws SQLException {
        if (this.query.getQueryTimeout() > 0) {
            preparedStatement.setQueryTimeout(this.query.getQueryTimeout());
        }
    }

    protected void bindParameters(CallableStatement callableStatement) throws SQLException {
        CallableSqlParameterBinder binder = new CallableSqlParameterBinder((Query)this.query);
        binder.bind(callableStatement, this.sql.getParameters());
    }

    protected void fetchParameters(CallableStatement callableStatement) throws SQLException {
        CallableSqlParameterFetcher fetcher = new CallableSqlParameterFetcher((ModuleQuery)this.query);
        fetcher.fetch(callableStatement, this.sql.getParameters());
    }

    protected void log() {
        JdbcLogger logger = this.query.getConfig().getJdbcLogger();
        logger.logSql(this.query.getClassName(), this.query.getMethodName(), this.sql);
    }
}

