/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.seasar.doma.internal.jdbc.command.GetValueFunction;
import org.seasar.doma.internal.jdbc.query.Query;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.JdbcMappingVisitor;
import org.seasar.doma.jdbc.MappedPropertyNotFoundException;
import org.seasar.doma.jdbc.ResultMappingException;
import org.seasar.doma.jdbc.Sql;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.entity.NamingType;
import org.seasar.doma.wrapper.Wrapper;

public class EntityBuilder<E> {
    protected final Query query;
    protected final EntityType<E> entityType;
    protected final boolean resultMappingEnsured;
    protected Map<Integer, EntityPropertyType<E, ?>> indexMap;

    public EntityBuilder(Query query, EntityType<E> entityType, boolean resultMappingEnsured) {
        AssertionUtil.assertNotNull((Object)query, entityType);
        this.query = query;
        this.entityType = entityType;
        this.resultMappingEnsured = resultMappingEnsured;
    }

    public E build(ResultSet resultSet) throws SQLException {
        AssertionUtil.assertNotNull(resultSet);
        if (this.indexMap == null) {
            this.indexMap = this.createIndexMap(resultSet.getMetaData(), this.entityType);
        }
        JdbcMappingVisitor jdbcMappingVisitor = this.query.getConfig().getDialect().getJdbcMappingVisitor();
        if (this.entityType.isImmutable()) {
            HashMap<String, Object> properties = new HashMap<String, Object>(this.indexMap.size());
            for (Map.Entry<Integer, EntityPropertyType<E, ?>> entry : this.indexMap.entrySet()) {
                Integer index = entry.getKey();
                EntityPropertyType<E, ?> propertyType = entry.getValue();
                GetValueFunction function = new GetValueFunction(resultSet, index);
                Wrapper<?> wrapper = propertyType.getWrapper((Map<String, Object>)properties);
                wrapper.accept(jdbcMappingVisitor, function);
            }
            return this.entityType.newEntity(properties);
        }
        E entity = this.entityType.newEntity(Collections.<String, Object>emptyMap());
        for (Map.Entry<Integer, EntityPropertyType<E, ?>> entry : this.indexMap.entrySet()) {
            Integer index = entry.getKey();
            EntityPropertyType<E, ?> propertyType = entry.getValue();
            GetValueFunction function = new GetValueFunction(resultSet, index);
            Wrapper<?> wrapper = propertyType.getWrapper(entity);
            wrapper.accept(jdbcMappingVisitor, function);
        }
        this.entityType.saveCurrentStates(entity);
        return entity;
    }

    protected HashMap<Integer, EntityPropertyType<E, ?>> createIndexMap(ResultSetMetaData resultSetMeta, EntityType<E> entityType) throws SQLException {
        HashMap indexMap = new HashMap();
        HashMap<String, EntityPropertyType<E, ?>> columnNameMap = this.createColumnNameMap(entityType);
        HashSet unmappedPropertySet = this.resultMappingEnsured ? new HashSet(columnNameMap.values()) : Collections.emptySet();
        int count = resultSetMeta.getColumnCount();
        for (int i = 1; i < count + 1; ++i) {
            String columnName = resultSetMeta.getColumnLabel(i);
            String lowerCaseColumnName = columnName.toLowerCase();
            EntityPropertyType<E, ?> propertyType = columnNameMap.get(lowerCaseColumnName);
            if (propertyType == null) {
                if ("doma_rownumber_".equals(lowerCaseColumnName) || this.query.getConfig().ignoreUnknownColumn()) continue;
                this.throwMappedPropertyNotFoundException(columnName);
                continue;
            }
            unmappedPropertySet.remove(propertyType);
            indexMap.put(i, propertyType);
        }
        if (this.resultMappingEnsured && !unmappedPropertySet.isEmpty()) {
            this.throwResultMappingException(unmappedPropertySet);
        }
        return indexMap;
    }

    protected HashMap<String, EntityPropertyType<E, ?>> createColumnNameMap(EntityType<E> entityType) {
        List<EntityPropertyType<E, ?>> propertyTypes = entityType.getEntityPropertyTypes();
        HashMap result = new HashMap(propertyTypes.size());
        for (EntityPropertyType<E, ?> propertyType : propertyTypes) {
            String columnName = propertyType.getColumnName();
            result.put(columnName.toLowerCase(), propertyType);
        }
        return result;
    }

    protected void throwMappedPropertyNotFoundException(String columnName) {
        Sql<?> sql = this.query.getSql();
        NamingType namingType = this.entityType.getNamingType();
        throw new MappedPropertyNotFoundException(this.query.getConfig().getExceptionSqlLogType(), columnName, namingType.revert(columnName), this.entityType.getEntityClass().getName(), sql.getKind(), sql.getRawSql(), sql.getFormattedSql(), sql.getSqlFilePath());
    }

    protected void throwResultMappingException(Set<EntityPropertyType<E, ?>> unmappedPropertySet) {
        int size = unmappedPropertySet.size();
        ArrayList<String> unmappedPropertyNames = new ArrayList<String>(size);
        ArrayList<String> expectedColumnNames = new ArrayList<String>(size);
        for (EntityPropertyType<E, ?> propertyType : unmappedPropertySet) {
            unmappedPropertyNames.add(propertyType.getName());
            expectedColumnNames.add(propertyType.getColumnName());
        }
        Sql<?> sql = this.query.getSql();
        throw new ResultMappingException(this.query.getConfig().getExceptionSqlLogType(), this.entityType.getEntityClass().getName(), unmappedPropertyNames, expectedColumnNames, sql.getKind(), sql.getRawSql(), sql.getFormattedSql(), sql.getSqlFilePath());
    }
}

