/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.type;

import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.Domain;
import org.seasar.doma.EnumDomain;
import org.seasar.doma.internal.apt.AptIllegalOptionException;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.Options;
import org.seasar.doma.internal.apt.mirror.DomainConvertersMirror;
import org.seasar.doma.internal.apt.type.AbstractDataType;
import org.seasar.doma.internal.apt.type.BasicType;
import org.seasar.doma.internal.apt.type.DataTypeVisitor;
import org.seasar.doma.internal.apt.util.ElementUtil;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.domain.DomainConverter;
import org.seasar.doma.message.Message;

public class DomainType
extends AbstractDataType {
    protected final BasicType basicType;
    protected final boolean external;
    protected final String metaClassName;
    private final String typeParamDecl;
    private boolean isRawType;
    private boolean isWildcardType;

    public DomainType(TypeMirror domainType, ProcessingEnvironment env, BasicType basicType, boolean external) {
        super(domainType, env);
        AssertionUtil.assertNotNull(basicType);
        this.basicType = basicType;
        this.external = external;
        int pos = this.metaTypeName.indexOf(60);
        if (pos > -1) {
            this.metaClassName = this.metaTypeName.substring(0, pos);
            this.typeParamDecl = this.metaTypeName.substring(pos);
        } else {
            this.metaClassName = this.metaTypeName;
            this.typeParamDecl = "";
        }
        if (!this.typeElement.getTypeParameters().isEmpty()) {
            DeclaredType declaredType = TypeMirrorUtil.toDeclaredType(this.getTypeMirror(), env);
            if (declaredType == null) {
                throw new AptIllegalStateException(this.getTypeName());
            }
            if (declaredType.getTypeArguments().isEmpty()) {
                this.isRawType = true;
            }
            for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
                if (typeMirror.getKind() != TypeKind.WILDCARD && typeMirror.getKind() != TypeKind.TYPEVAR) continue;
                this.isWildcardType = true;
            }
        }
    }

    public BasicType getBasicType() {
        return this.basicType;
    }

    public boolean isRawType() {
        return this.isRawType;
    }

    public boolean isWildcardType() {
        return this.isWildcardType;
    }

    public String getInstantiationCommand() {
        return this.normalize(this.metaClassName) + "." + this.typeParamDecl + "getSingletonInternal()";
    }

    @Override
    public String getMetaTypeName() {
        return this.normalize(this.metaTypeName);
    }

    @Override
    public String getMetaTypeNameAsTypeParameter() {
        return this.normalize(this.metaTypeNameAsTypeParameter);
    }

    protected String normalize(String name) {
        if (this.external) {
            return "__." + name;
        }
        return name;
    }

    public static DomainType newInstance(TypeMirror type, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull((Object)type, (Object)env);
        TypeElement typeElement = TypeMirrorUtil.toTypeElement(type, env);
        if (typeElement == null) {
            return null;
        }
        DomainInfo info = DomainType.getDomainInfo(typeElement, env);
        if (info == null) {
            return null;
        }
        BasicType basicType = BasicType.newInstance(info.valueType, env);
        if (basicType == null) {
            return null;
        }
        return new DomainType(type, env, basicType, info.external);
    }

    protected static DomainInfo getDomainInfo(TypeElement typeElement, ProcessingEnvironment env) {
        Domain domain = typeElement.getAnnotation(Domain.class);
        if (domain != null) {
            return DomainType.getDomainInfo(typeElement, domain);
        }
        EnumDomain enumDomain = typeElement.getAnnotation(EnumDomain.class);
        if (enumDomain != null) {
            return DomainType.getEnumDomainInfo(typeElement, enumDomain);
        }
        return DomainType.getExternalDomainInfo(typeElement, env);
    }

    protected static DomainInfo getDomainInfo(TypeElement typeElement, Domain domain) {
        try {
            domain.valueType();
        }
        catch (MirroredTypeException e) {
            return new DomainInfo(e.getTypeMirror(), false);
        }
        throw new AptIllegalStateException("unreachable.");
    }

    protected static DomainInfo getEnumDomainInfo(TypeElement typeElement, EnumDomain enumDomain) {
        try {
            enumDomain.valueType();
        }
        catch (MirroredTypeException e) {
            return new DomainInfo(e.getTypeMirror(), false);
        }
        throw new AptIllegalStateException("unreachable.");
    }

    protected static DomainInfo getExternalDomainInfo(TypeElement typeElement, ProcessingEnvironment env) {
        String csv = Options.getDomainConverters(env);
        if (csv != null) {
            TypeMirror domainType = typeElement.asType();
            for (String value : csv.split(",")) {
                String className = value.trim();
                if (className.isEmpty()) continue;
                TypeElement convertersProviderElement = ElementUtil.getTypeElement(className, env);
                if (convertersProviderElement == null) {
                    throw new AptIllegalOptionException(Message.DOMA4200.getMessage(className));
                }
                DomainConvertersMirror convertersMirror = DomainConvertersMirror.newInstance(convertersProviderElement, env);
                if (convertersMirror == null) {
                    throw new AptIllegalOptionException(Message.DOMA4201.getMessage(className));
                }
                for (TypeMirror converterType : convertersMirror.getValueValue()) {
                    TypeMirror[] argTypes;
                    if ((converterType = DomainType.reloadTypeMirror(converterType, env)) == null || (argTypes = DomainType.getConverterArgTypes(converterType, env)) == null || !TypeMirrorUtil.isSameType(domainType, argTypes[0], env)) continue;
                    TypeMirror valueType = argTypes[1];
                    return new DomainInfo(valueType, true);
                }
            }
        }
        return null;
    }

    protected static TypeMirror reloadTypeMirror(TypeMirror typeMirror, ProcessingEnvironment env) {
        TypeElement typeElement = TypeMirrorUtil.toTypeElement(typeMirror, env);
        if (typeElement == null) {
            return null;
        }
        String binaryName = ElementUtil.getBinaryName(typeElement, env);
        if ((typeElement = ElementUtil.getTypeElement(binaryName, env)) == null) {
            return null;
        }
        return typeElement.asType();
    }

    protected static TypeMirror[] getConverterArgTypes(TypeMirror typeMirror, ProcessingEnvironment env) {
        for (TypeMirror typeMirror2 : env.getTypeUtils().directSupertypes(typeMirror)) {
            if (!TypeMirrorUtil.isAssignable(typeMirror2, DomainConverter.class, env)) continue;
            if (TypeMirrorUtil.isSameType(typeMirror2, DomainConverter.class, env)) {
                DeclaredType declaredType = TypeMirrorUtil.toDeclaredType(typeMirror2, env);
                AssertionUtil.assertNotNull(declaredType);
                List<? extends TypeMirror> args = declaredType.getTypeArguments();
                AssertionUtil.assertEquals(2, args.size());
                return new TypeMirror[]{args.get(0), args.get(1)};
            }
            TypeMirror[] argTypes = DomainType.getConverterArgTypes(typeMirror2, env);
            if (argTypes == null) continue;
            return argTypes;
        }
        return null;
    }

    @Override
    public <R, P, TH extends Throwable> R accept(DataTypeVisitor<R, P, TH> visitor, P p) throws TH {
        return visitor.visitDomainType(this, p);
    }

    private static class DomainInfo {
        private final TypeMirror valueType;
        private final boolean external;

        public DomainInfo(TypeMirror valueType, boolean external) {
            AssertionUtil.assertNotNull(valueType);
            this.valueType = valueType;
            this.external = external;
        }
    }
}

