/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.meta.AbstractSqlFileQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.DaoMeta;
import org.seasar.doma.internal.apt.meta.QueryKind;
import org.seasar.doma.internal.apt.meta.QueryMeta;
import org.seasar.doma.internal.apt.meta.QueryParameterMeta;
import org.seasar.doma.internal.apt.meta.QueryReturnMeta;
import org.seasar.doma.internal.apt.meta.SqlFileModifyQueryMeta;
import org.seasar.doma.internal.apt.mirror.DeleteMirror;
import org.seasar.doma.internal.apt.mirror.InsertMirror;
import org.seasar.doma.internal.apt.mirror.ModifyMirror;
import org.seasar.doma.internal.apt.mirror.UpdateMirror;
import org.seasar.doma.internal.apt.type.EntityType;
import org.seasar.doma.internal.apt.type.SimpleDataTypeVisitor;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class SqlFileModifyQueryMetaFactory
extends AbstractSqlFileQueryMetaFactory<SqlFileModifyQueryMeta> {
    public SqlFileModifyQueryMetaFactory(ProcessingEnvironment env) {
        super(env);
    }

    @Override
    public QueryMeta createQueryMeta(ExecutableElement method, DaoMeta daoMeta) {
        AssertionUtil.assertNotNull((Object)method, (Object)daoMeta);
        SqlFileModifyQueryMeta queryMeta = this.createSqlFileModifyQueryMeta(method, daoMeta);
        if (queryMeta == null) {
            return null;
        }
        this.doTypeParameters(queryMeta, method, daoMeta);
        this.doParameters(queryMeta, method, daoMeta);
        this.doReturnType(queryMeta, method, daoMeta);
        this.doThrowTypes(queryMeta, method, daoMeta);
        this.doSqlFiles(queryMeta, method, daoMeta);
        return queryMeta;
    }

    protected SqlFileModifyQueryMeta createSqlFileModifyQueryMeta(ExecutableElement method, DaoMeta daoMeta) {
        SqlFileModifyQueryMeta queryMeta = new SqlFileModifyQueryMeta(method);
        ModifyMirror modifyMirror = InsertMirror.newInstance(method, this.env);
        if (modifyMirror != null && modifyMirror.getSqlFileValue()) {
            queryMeta.setModifyMirror(modifyMirror);
            queryMeta.setQueryKind(QueryKind.SQLFILE_INSERT);
            return queryMeta;
        }
        modifyMirror = UpdateMirror.newInstance(method, this.env);
        if (modifyMirror != null && modifyMirror.getSqlFileValue()) {
            queryMeta.setModifyMirror(modifyMirror);
            queryMeta.setQueryKind(QueryKind.SQLFILE_UPDATE);
            return queryMeta;
        }
        modifyMirror = DeleteMirror.newInstance(method, this.env);
        if (modifyMirror != null && modifyMirror.getSqlFileValue()) {
            queryMeta.setModifyMirror(modifyMirror);
            queryMeta.setQueryKind(QueryKind.SQLFILE_DELETE);
            return queryMeta;
        }
        return null;
    }

    @Override
    protected void doReturnType(SqlFileModifyQueryMeta queryMeta, ExecutableElement method, DaoMeta daoMeta) {
        QueryReturnMeta returnMeta = this.createReturnMeta(method);
        EntityType entityType = queryMeta.getEntityType();
        if (entityType != null && entityType.isImmutable()) {
            if (!returnMeta.isResult(entityType)) {
                throw new AptException((MessageResource)Message.DOMA4222, this.env, (Element)returnMeta.getElement(), new Object[0]);
            }
        } else if (!returnMeta.isPrimitiveInt()) {
            throw new AptException((MessageResource)Message.DOMA4001, this.env, (Element)returnMeta.getElement(), new Object[0]);
        }
        queryMeta.setReturnMeta(returnMeta);
    }

    @Override
    protected void doParameters(final SqlFileModifyQueryMeta queryMeta, ExecutableElement method, DaoMeta daoMeta) {
        for (VariableElement variableElement : method.getParameters()) {
            final QueryParameterMeta parameterMeta = this.createParameterMeta(variableElement);
            queryMeta.addParameterMeta(parameterMeta);
            if (parameterMeta.isBindable()) {
                queryMeta.addBindableParameterType(parameterMeta.getName(), parameterMeta.getType());
            }
            if (queryMeta.getEntityType() != null) continue;
            parameterMeta.getDataType().accept(new SimpleDataTypeVisitor<Void, Void, RuntimeException>(){

                @Override
                public Void visitEntityType(EntityType dataType, Void p) throws RuntimeException {
                    queryMeta.setEntityType(dataType);
                    queryMeta.setEntityParameterName(parameterMeta.getName());
                    return null;
                }
            }, null);
        }
    }
}

