/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.meta.QueryKind;
import org.seasar.doma.internal.apt.meta.QueryMeta;
import org.seasar.doma.internal.apt.meta.QueryParameterMeta;
import org.seasar.doma.internal.apt.meta.QueryReturnMeta;
import org.seasar.doma.internal.jdbc.command.Command;
import org.seasar.doma.internal.jdbc.query.Query;
import org.seasar.doma.internal.util.AssertionUtil;

public abstract class AbstractQueryMeta
implements QueryMeta {
    protected String name;
    protected ExecutableElement executableElement;
    protected List<String> typeParameterNames = new ArrayList<String>();
    protected List<String> thrownTypeNames = new ArrayList<String>();
    protected QueryKind queryKind;
    protected Map<String, TypeMirror> bindableParameterTypeMap = new LinkedHashMap<String, TypeMirror>();
    protected QueryReturnMeta returnMeta;
    protected List<QueryParameterMeta> parameterMetas = new ArrayList<QueryParameterMeta>();
    protected List<String> fileNames = new ArrayList<String>();

    protected AbstractQueryMeta(ExecutableElement method) {
        AssertionUtil.assertNotNull(method);
        this.name = method.getSimpleName().toString();
        this.executableElement = method;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ExecutableElement getExecutableElement() {
        return this.executableElement;
    }

    public void addTypeParameterName(String typeParameterName) {
        this.typeParameterNames.add(typeParameterName);
    }

    @Override
    public List<String> getTypeParameterNames() {
        return this.typeParameterNames;
    }

    public void addThrownTypeName(String thrownTypeName) {
        this.thrownTypeNames.add(thrownTypeName);
    }

    @Override
    public List<String> getThrownTypeNames() {
        return this.thrownTypeNames;
    }

    public Class<? extends Query> getQueryClass() {
        if (this.queryKind == null) {
            return null;
        }
        return this.queryKind.getQueryClass();
    }

    public Class<? extends Command> getCommandClass() {
        if (this.queryKind == null) {
            return null;
        }
        return this.queryKind.getCommandClass();
    }

    public boolean isTrigger() {
        if (this.queryKind == null) {
            return false;
        }
        return this.queryKind.isTrigger();
    }

    @Override
    public QueryKind getQueryKind() {
        return this.queryKind;
    }

    public void setQueryKind(QueryKind queryKind) {
        this.queryKind = queryKind;
    }

    @Override
    public Map<String, TypeMirror> getBindableParameterTypeMap() {
        return this.bindableParameterTypeMap;
    }

    public void addBindableParameterType(String parameterName, TypeMirror bindableParameterTypeMap) {
        this.bindableParameterTypeMap.put(parameterName, bindableParameterTypeMap);
    }

    @Override
    public QueryReturnMeta getReturnMeta() {
        return this.returnMeta;
    }

    public void setReturnMeta(QueryReturnMeta returnMeta) {
        this.returnMeta = returnMeta;
    }

    @Override
    public List<QueryParameterMeta> getParameterMetas() {
        return this.parameterMetas;
    }

    public void addParameterMeta(QueryParameterMeta queryParameterMeta) {
        this.parameterMetas.add(queryParameterMeta);
    }

    @Override
    public List<String> getFileNames() {
        return this.fileNames;
    }

    public void addFileName(String fileName) {
        this.fileNames.add(fileName);
    }

    @Override
    public boolean isVarArgs() {
        return this.executableElement.isVarArgs();
    }
}

