/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.decl;

import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.decl.TypeDeclaration;
import org.seasar.doma.internal.apt.decl.TypeParameterDeclaration;
import org.seasar.doma.internal.util.AssertionUtil;

public class FieldDeclaration {
    protected VariableElement element;
    protected List<TypeParameterDeclaration> typeParameterDeclarations;
    protected ProcessingEnvironment env;

    public VariableElement getElement() {
        return this.element;
    }

    public TypeDeclaration getTypeDeclaration() {
        TypeMirror fieldType = this.resolveTypeParameter(this.element.asType());
        return TypeDeclaration.newTypeDeclaration(fieldType, this.env);
    }

    protected TypeMirror resolveTypeParameter(TypeMirror formalType) {
        for (TypeParameterDeclaration typeParameterDecl : this.typeParameterDeclarations) {
            if (!((Object)formalType).equals(typeParameterDecl.getFormalType())) continue;
            return typeParameterDecl.getActualType();
        }
        return formalType;
    }

    public static FieldDeclaration newInstance(VariableElement fieldElement, List<TypeParameterDeclaration> typeParameterDeclarations, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull((Object)fieldElement, typeParameterDeclarations, (Object)env);
        AssertionUtil.assertTrue(fieldElement.getKind() == ElementKind.FIELD || fieldElement.getKind() == ElementKind.ENUM_CONSTANT, fieldElement.getKind().toString());
        FieldDeclaration fieldDeclaration = new FieldDeclaration();
        fieldDeclaration.element = fieldElement;
        fieldDeclaration.typeParameterDeclarations = typeParameterDeclarations;
        fieldDeclaration.env = env;
        return fieldDeclaration;
    }
}

